<!DOCTYPE html>
<html lang="en">
    <!--begin::Head-->
    <head>
        <base href="../../../">
        <meta charset="utf-8" />
        <title><?= $this->config->item('company_title') . ' | Payment' ?></title>
        <meta name="description" content="" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <!--begin::Fonts-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
        <!--end::Fonts-->
        <!--begin::Global Theme Styles(used by all pages)-->
        <link href="<?php echo base_url() ?>public/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>public/plugins/custom/prismjs/prismjs.bundle.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/style.bundle_front.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/prepay.css" rel="stylesheet" type="text/css" />
        <!--end::Global Theme Styles-->
        <!--begin::Layout Themes(used by all pages)-->
        <link href="<?php echo base_url() ?>public/css/skins/header/base/light.css?v=7.0.4" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/header/menu/light.css?v=7.0.4" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/brand/dark.css?v=7.0.4" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/aside/dark.css?v=7.0.4" rel="stylesheet" type="text/css" />
        <!--end::Layout Themes-->
        <link rel="shortcut icon" href="assets/media/logos/favicon.ico" />
        <style>
            .mt-10{
                margin-top: 3.25rem !important;
            }
            .pt-1-2{
                padding-top: 1.2rem !important;
            }
            #Tamount{
                margin-top:-5px;font-weight: 600;
            }
            .amount_container{
                text-align: left !important;
            }
            .pay_btn_conatiner{
                text-align: right !important;
            }
            .rtl .amount_container{
                text-align: right !important;
            }
            .rtl .pay_btn_conatiner{
                text-align: left !important;
            }
            @media (max-width: 600px) {
                #Tamount{
                    margin-top:5px;font-weight: 600;
                }
                .amount_container,.pay_btn_conatiner{
                    text-align: center !important;
                }
                .mr-5 {
                    margin-right: 0rem !important;
                }
            }
        </style>
    </head>
    <!--end::Head-->
    <!--begin::Body-->
    <body id="kt_body" class="page-header-fixed page-container-bg-solid <?= $this->session->userdata('language') == 'arabic' ? 'rtl' : '' ?>" style="background-color: rgb(231, 236, 241);">

        <div class="container">
            <div class="d-flex flex-row mt-10">
                <div class="col-md-3 col-sm-1 col-0"></div>
                <div class="col-md-6 col-sm-10 col-11">
                    <!--begin::Profile Card-->
                    <div class="card card-custom card-stretch">
                        <!--begin::Body-->
                        <div class="card-body pt-4">
                            <div class="amount_container">
                                <button class="btn btn-outline-primary mb-1" onclick="language('<?= $this->session->userdata('language') == 'arabic' ? 'english' : 'arabic' ?>')" ><?= $this->session->userdata('language') == 'arabic' ? 'English' : 'عربى' ?></button>
                            </div>
                            <!--begin::User-->
                            <div class="text-center">
                                <div class="symbol symbol-60 symbol-xxl-100 mr-5 align-self-start align-self-xxl-center">
                                    <div class="symbol-label" style="background-image:url('<?= base_url('public/upload/userimage/' . $this->config->item('tab_logo')) ?>');margin:auto"></div>
                                    <h3><?php echo $this->config->item('company_title') ?></h3>
                                    <div class="mt-10">
                                        <p><?= $this->lang->line('invoice_num') ?> : INV <?= str_pad($order->id, 6, "0", STR_PAD_LEFT); ?></p>
                                    </div>
                                    <!--<i class="symbol-badge bg-success"></i>-->
                                </div>
                            </div>
                            <div class="amount_container">
                                <hr/>
                                <br/>
                                <p><?= $this->lang->line('amount') ?> : <span class="btn btn-circle blue btn-sm" id="Tamount"><?= round($order->total_amount, 3) . ' ' . $sett->inv_currency ?></span></p>
                                <br/>
                                <div class="form-group" id="divTermsConditionsOrders" >
                                    <label for="mt-checkbox mt-checkbox-outline ">
                                        <input id="chktermscondOrders" type="checkbox">
                                        <a class="terms-link" style="text-decoration:underline;cursor: pointer" onclick="ShowTermsNconditns();"><?= $this->lang->line('agree_terms_conditions') ?></a>
                                    </label>
                                </div>
                            </div>

                            <div class="pay_btn_conatiner">
                                <hr/>
                                <?php if ($this->payment_method == 'tap') { ?>
                                    <button class="btn btn-success" id="pay" disabled onclick="goSell.openPaymentPage()"><?= $this->lang->line('pay') ?>  &nbsp;<i class="far <?= $this->session->userdata('language') == 'english' ? 'fa-arrow-alt-circle-right' : 'fa-arrow-alt-circle-left' ?>"></i></button>
                                <?php } else { ?>
                                    <a class="btn btn-success" id="pay" disabled href="<?= base_url() ?>Payment/knet_pay/<?= $order->total_amount ?>/<?= $order->id ?>/<?= isset($order_details) ? 0 : 1 ?>" ><?= $this->lang->line('pay') ?>  &nbsp;<i class="far <?= $this->session->userdata('language') == 'english' ? 'fa-arrow-alt-circle-right' : 'fa-arrow-alt-circle-left' ?>"></i></a>
                                <?php } ?>
<!--<h4 class="font-primary" style="text-transform:uppercase;font-size:14px;"><?//= $this->lang->line('choose_payment_method') ?></h4>-->
                                <!--                                <div class="row">
                                                                    <div class="col-md-12 col-xs-12">
                                                                        <div class="table-scrollable table-scrollable-borderless">
                                                                            <table class="table table-hover table-light">
                                                                                <thead>
                                                                                    <tr></tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    <tr class="payment-channel-table" onclick="return PayOrder('KWKNETDC', '20');">
                                                                                        <td class="payment-logos"><img class="user-pic rounded pchannel-logo" src="<?//= base_url() ?>public/knet.png" style="width:40px !important;"></td>
                                                                                        <td class="pt-1-2"><span class="og-title-secondary">KNET-KW</span></td>
                                
                                                                                        <td class="og-pc-fontbold text-right pt-1-2"><?//= $order->total_amount . ' ' . $sett->inv_currency ?></td>
                                                                                        <td class="crncycode font-primary">KWD</td>
                                                                                        <td><a class="btn btn-icon btn-primary btn-circle btn-sm"><?//= $this->lang->line('pay') ?></a></td>
                                                                                    </tr>
                                                                                    <tr class="payment-channel-table" onclick="return PayOrder('KWKFHMPGSCCKWD', '20.51');">
                                                                                        <td class="payment-logos"><img class="user-pic rounded pchannel-logo" src="<?//= base_url() ?>public/visamastercard.png" style="width:40px !important;"></td>
                                                                                        <td class="pt-1-2"><span class="og-title-secondary">VISA/MASTER KWD</span></td>
                                
                                                                                        <td class="og-pc-fontbold text-right pt-1-2"><?//= $order->total_amount . ' ' . $sett->inv_currency ?></td>
                                                                                        <td class="crncycode font-primary">KWD</td>
                                                                                        <td><a class="btn btn-icon btn-primary btn-circle btn-sm"><?//= $this->lang->line('pay') ?></a></td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                </div>-->
                            </div>
                            <!--end::User-->


                        </div>
                        <!--end::Body-->
                    </div>
                    <!--end::Profile Card-->
                </div>
                <div class="col-md-3 col-sm-1 col-0"></div>
            </div>
        </div>


        <div class="modal fade" id="terms_conditions" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><?= $this->lang->line('terms-and-conditions') ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="fa fa-lg">×</i></button>
                    </div>

                    <div class="modal-body text-left">
                        <?= $this->session->userdata('language') == 'arabic' ? $sett->terms_conditions_payment_page_ar : $sett->terms_conditions_payment_page ?>
                    </div>
                </div>
            </div>
        </div>

        <script>var KTAppSettings = {"breakpoints": {"sm": 576, "md": 768, "lg": 992, "xl": 1200, "xxl": 1200}, "colors": {"theme": {"base": {"white": "#ffffff", "primary": "#3699FF", "secondary": "#E5EAEE", "success": "#1BC5BD", "info": "#8950FC", "warning": "#FFA800", "danger": "#F64E60", "light": "#F3F6F9", "dark": "#212121"}, "light": {"white": "#ffffff", "primary": "#E1F0FF", "secondary": "#ECF0F3", "success": "#C9F7F5", "info": "#EEE5FF", "warning": "#FFF4DE", "danger": "#FFE2E5", "light": "#F3F6F9", "dark": "#D6D6E0"}, "inverse": {"white": "#ffffff", "primary": "#ffffff", "secondary": "#212121", "success": "#ffffff", "info": "#ffffff", "warning": "#ffffff", "danger": "#ffffff", "light": "#464E5F", "dark": "#ffffff"}}, "gray": {"gray-100": "#F3F6F9", "gray-200": "#ECF0F3", "gray-300": "#E5EAEE", "gray-400": "#D6D6E0", "gray-500": "#B5B5C3", "gray-600": "#80808F", "gray-700": "#464E5F", "gray-800": "#1B283F", "gray-900": "#212121"}}, "font-family": "Poppins"};
            var KTAppOptions = {"colors": {"state": {"brand": "#5d78ff", "dark": "#282a3c", "light": "#ffffff", "primary": "#5867dd", "success": "#34bfa3", "info": "#36a3f7", "warning": "#ffb822", "danger": "#fd3995"}, "base": {"label": ["#c5cbe3", "#a1a8c3", "#3d4465", "#3e4466"], "shape": ["#f0f3ff", "#d9dffa", "#afb4d4", "#646c9a"]}}};</script>
        <!--end::Global Config-->
        <!--begin::Global Theme Bundle(used by all pages)-->
        <script src="<?php echo base_url() ?>public/plugins/global/plugins.bundle.js?v=7.0.4"></script>
        <script src="<?php echo base_url() ?>public/plugins/custom/prismjs/prismjs.bundle.js?v=7.0.4"></script>
        <script src="<?php echo base_url() ?>public/js/scripts.bundle.js?v=7.0.4"></script>
        <?php if ($this->payment_method == 'tap') { ?>
            <script type="text/javascript" src="https://goSellJSLib.b-cdn.net/v1.6.0/js/gosell.js"></script>
        <?php } ?>
        <!--end::Global Theme Bundle-->
        <script>
            function ShowTermsNconditns() {
            $("#terms_conditions").modal('show');
            }
            function language(new_lang) {
            var new_lang;
            $.ajax({
            method: "POST",
                    url: "<?php echo base_url() ?>language/lang/" + new_lang,
                    data: {'lang': new_lang},
                    success: function (e) {
                    location.reload();
                    }
            });
            }
            $("#chktermscondOrders").change(function () {
            if ($(this).prop('checked')) {
            $("#pay").prop('disabled', false);
            } else {
            $("#pay").prop('disabled', true);
            }
            });
        </script>
        <?php if ($this->payment_method == 'tap') { ?>
            <script>
                goSell.config({
                gateway: {
                publicKey: "<?= $payment_sett->tap_public_key ?>",
                        merchantId: '<?= $payment_sett->tap_merchant_id ?>',
                        language: "en",
                        contactInfo: true,
                        supportedCurrencies: "all",
                        supportedPaymentMethods: "all",
                        saveCardOption: false,
                        customerCards: true,
                        notifications: 'standard',
                        callback: "<?= base_url('payment/post_pay') ?>",
                        onClose: "<?= base_url('payment/post_pay') ?>",
                },
                        customer: {
                        id: '<?= isset($order->customer_id) ? $order->customer_id : 0 ?>',
                                first_name: '<?= $order->username ?>',
                                email: '<?= isset($order->email) ? $order->email : NULL ?>',
                                phone: {
                                country_code: "<?= $order->phone_code ?>",
                                        number: "<?= $order->phone ?>"
                                }
                        },
                        order: {
                        amount: <?= $order->total_amount ?>,
                                currency: '<?= $sett->inv_currency ?>',
    <?php
    if (isset($order_details)) {
        foreach ($order_details as $value) {
            ?>
                                items: [{
                                id: <?= $value->id ?>,
                                        name: "<?= $value->name_order ?>",
                                        description: "<?= $value->details_eng ?>",
                                        quantity: "<?= $value->quantity ?>",
                                        amount_per_unit: "<?= $value->item_price ?>",
                                        discount: {
                                        type: "<?= $value->discount_type == 0 ? 'a' : 'P' ?>",
                                                value: "<?= $value->discount ?> <?= $value->discount_type == 0 ? '' : '%' ?>",
                                                                    },
                                                                    total_amount: "<?= $value->discount_remainder ?>",
                                                            }],
            <?php
        }
    }
    ?>
                                                    shipping: null,
                                                            taxes: null
                                                    },
                                                    transaction: {
                                                    mode: "charge",
                                                            charge: {
                                                            saveCard: false,
                                                                    threeDSecure: true,
                                                                    description: "<?= isset($order_details) ? 'Invoice' : $order->desc ?>",
                                                                    statement_descriptor: "<?= isset($order_details) ? 'Invoice' : $order->desc ?>",
                                                                    reference: {
                                                                    // transaction: "txn_0001",
                                                                    order: "<?= $order->id ?>",
                                                                    },
                                                                    hashstring: "",
                                                                    metadata: {},
                                                                    receipt: {
                                                                    email: false,
                                                                            sms: false,
                                                                    },
                                                                    redirect: "<?= base_url('payment/post_pay') ?>",
                                                                    post: null,
                                                            },
                                                    }
                                            });
            </script>
        <?php } ?>
    </body>
    <!--end::Body-->
</html>