<?php $this->load->view('site/layout'); ?>

<?php
if ($this->session->userdata('language') == "english") {
    $language_set = "arabic";
} else {
    $language_set = "english";
}
if ($language_set == "english") {
    ?>
    <link href="<?php echo base_url() ?>public/plugins/custom/fullcalendar/fullcalendar.bundle.rtl.css" rel="stylesheet" type="text/css" />
<?php } else { ?>
    <link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />


<?php } ?>
<link href="<?php echo base_url() ?>public/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
<style>
    .add_icon{
        float: right;
        padding-right: 15px;
        cursor: pointer;
    }
    #invoice_items tr{
        margin-bottom: 10px;
    }
    .total_price{
        background-color: #eaedf2;
        height: calc(1.5em + 1.3rem + 2px);
    }
    .delete_item{
        margin-top: 26px;
    }
    .select2{
        width: 100% !important;
    }
    .num_width{
        width: 10%;
    }
    .comment_width{
        width: 25%;
    }
    .price{
        height: 38px;
    }
    .inv_total{
        background-color: #eaedf2;
    }
</style>
<?php $this->load->view('site/navbar'); ?>
<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-hidden"></span>
                <div class="kt-subheader__breadcrumbs">
                    <a href="#" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
                    <span class="kt-subheader__breadcrumbs-separator"></span>
                    <a href="<?= base_url('orders/') ?>" class="kt-subheader__breadcrumbs-link">
                        <?= $call_center ? $this->lang->line('orders') : $this->lang->line('invoices') ?> </a>
                    <span class="kt-subheader__breadcrumbs-separator"></span>
                </div>

            </div>
        </div>
    </div>
    <div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <h3 class="kt-portlet__head-title">
                    <?= $call_center ? $this->lang->line('edit_order') : $this->lang->line('modify-an-invoice') ?>
                </h3>
            </div>
        </div>
        <table style="display:none">
            <tr id="first" style="display:none">
                <td><label class="form-label"><?= $this->lang->line('product') ?></label><select class="form-control product" name="id_producer[]" >
                        <option value><?= $this->lang->line('select') ?></option>
                        <?php foreach ($bills_producer as $row) { ?>
                            <option  value="<?= $row['id']; ?>"><?= $row['name']; ?></option>
                        <?php } ?>
                    </select>
                    <div class="product_additions">

                    </div>
                </td>

                <td class="num_width"><label class="form-label"><?= $this->lang->line('the-amount') ?></label>
                    <input type="hidden" class="product_price" />
                    <?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                        <input type="text" name="amount[]" class="form-control price" placeholder="<?= $this->lang->line('the-amount') ?>" />
                    <?php } else { ?>
                        <input type="hidden" name="amount[]" class="price_hidden" />
                        <span class="form-control price" style="width:100%" ><?= $this->lang->line('the-amount') ?></span>
                    <?php } ?>
                </td>
                <td class="num_width"><div class="quantity_container"><label class="form-label"><?= $this->lang->line('quantity') ?></label>
                        <input type="text" name="quantity[]" class="form-control quantity" placeholder="<?= $this->lang->line('quantity') ?>" /></div></td>
                <td class="num_width"><label class="form-label"><?= $this->lang->line('discount') ?></label>
                    <input type="text" name="discount[]" class="form-control discount" placeholder="<?= $this->lang->line('discount') ?>" /></td>
                <td class="total_price_container num_width"><label class="form-label"><?= $this->lang->line('total_price') ?></label>
                    <span class="form-control total_price" ></span></td>
                <td class="datepicker_container"><label class="form-label"><?= $this->lang->line('start-date') ?></label>
                    <input type="text" name="start_date[]" class="form-control datepicker" placeholder="<?= $this->lang->line('start-date') ?>" /></td>
                <td class="datepicker_container"><label class="form-label"><?= $this->lang->line('end-date') ?></label>
                    <input type="text" name="end_date[]" class="form-control datepicker" placeholder="<?= $this->lang->line('end-date') ?>" /></td>
                <td class="comment_width"><label class="form-label"><?= $this->lang->line('comment') ?></label>
                    <textarea rows="1" name="comment[]" class="form-control" placeholder="<?= $this->lang->line('comment') ?>" ></textarea></td>
                <td>
                    &nbsp;&nbsp;
                    <i class="fas fa-calendar-plus text-primary fa-2x additions_btn" title="<?= $this->lang->line('additions') ?>" style="cursor: pointer"></i>
                    &nbsp;&nbsp;
                    <i class="fas fa-window-close text-danger fa-2x delete_item" title="Delete Item" style="cursor: pointer"></i>
                    <div class="additions"></div>
                </td>
            </tr>
        </table>
        <?php echo form_open_multipart(base_url('' . $thispage . '/edit_invoice/' . $order_id . '/' . $call_center), array('id' => 'my_form')); ?>
        <!-- <form class="kt-form kt-form--label-right"> -->
        <div class="kt-portlet__body">
            <?php if ($this->session->flashdata('msg') || validation_errors() !== '' || isset($msg) || $error_msg != ''): ?>
                <div class="form-group form-group-last">
                    <div class="alert alert-danger" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-brand"></i></div>
                        <div class="alert-text">
                            <?= validation_errors(); ?>
                            <?= isset($msg) ? $msg : ''; ?>
                            <?= $this->session->flashdata('msg') ?>
                            <?= $error_msg ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="form-group row">
<!--                          <label for="example-text-input" class="col-3 col-form-label"><?php //echo $this->lang->line('products')                                                                                                                            ?></label>
<div class="col-9">
<select class="form-control " name="id_producer[]"  multiple="multiple" required>
                <?php //$count=0; foreach($bills_producer as $row){ ?>
<option  value="<?//= $row['id']; ?>"><?//= $row['name']; ?></option>

                <?php //} ?>
</select>
</div>-->
            </div>
            <div class="form-group row">
                <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('the-students') ?></label>
                <div class="col-8">
                    <?= $order_items[0]->name ?>
                </div>

            </div>
            <div class="form-group row">
                <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('address') ?></label>
                <div class="col-8">
                    <?php
                    $address = '';
                    if ($order->region != '') {
                        $address .= $this->lang->line('region') . ': ' . $order->region . ', ';
                    }
                    if ($order->blocks != '') {
                        $address .= $this->lang->line('block_address') . ': ' . $order->blocks . ', ';
                    }
                    if ($order->street != '') {
                        $address .= $this->lang->line('street') . ': ' . $order->street . ', ';
                    }
                    if ($order->jadah != '') {
                        $address .= $this->lang->line('jadah') . ': ' . $order->jadah . ', ';
                    }
                    if ($order->building_num != '') {
                        $address .= $this->lang->line('building_num') . ': ' . $order->building_num . ', ';
                    }
                    if ($order->floor != '') {
                        $address .= $this->lang->line('floor') . ': ' . $order->floor . ', ';
                    }
                    if ($order->door_no != '') {
                        $address .= $this->lang->line('door_no') . ': ' . $order->door_no . ', ';
                    }
                    echo $address ? $address : '---';
                    ?>
                </div>
            </div>
            <?php if ($call_center) { ?>
                <div class="form-group row">
                    <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('delivery_type') ?></label>
                    <div class="col-8">
                        <?= $order->discount_type == 0 ? $this->lang->line('direct_recieve') : $this->lang->line('home_delivery') ?>
                    </div>
                </div>
            <?php } ?>
            <br/>
            <hr/>
            <h2><strong><?= $this->lang->line('products') ?></strong></h2>
            <input type="hidden" name="products_count" id="products_count" value="1" />
            <table id="invoice_items">

                <?php
                if (!$this->input->post()) {
                    foreach ($order_items as $item) {
                        ?>
                        <tr >
                            <td><label><?= $this->lang->line('product') ?></label><select class="form-control product" name="id_producer[]" >
                                    <option value><?= $this->lang->line('select') ?></option>
                                    <?php
                                    foreach ($bills_producer as $row) {
                                        ?>
                                        <option <?= $item->id_producer == $row['id'] ? 'selected' : '' ?> value="<?= $row['id']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                                <div class="product_additions">
                                    <?= $item->additions ?>
                                </div>
                            </td>

                            <td class="num_width"><label class="form-label"><?= $this->lang->line('the-amount') ?></label>
                                <input type="hidden" class="product_price" value="<?= $item->item_price ?>" />
                                <?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                                    <input type="text" name="amount[]" class="form-control price" value="<?= $item->item_price + $item->addition_price ?>" placeholder="<?= $this->lang->line('the-amount') ?>" />
                                <?php } else { ?>
                                    <input type="hidden" name="amount[]" class="price_hidden" value="<?= $item->item_price + $item->addition_price ?>" />
                                    <span class="form-control price" style="width:100%" ><?= $item->item_price + $item->addition_price ?></span>
                                <?php } ?>
                            </td>
                            <td class="num_width"><?php if (!$item->expiry_date && !$item->start_date) { ?>
                                    <div class="quantity_container"><label class="form-label"><?= $this->lang->line('quantity') ?></label>
                                        <input type="text" name="quantity[]" class="form-control quantity" value=<?= $item->quantity ?> placeholder="<?= $this->lang->line('quantity') ?>" /></div>
                                <?php } ?>
                            </td>
                            <td class="num_width"><label class="form-label"><?= $this->lang->line('discount') ?></label>
                                <input type="text" name="discount[]" class="form-control discount" value="<?= $item->discount ?>" placeholder="<?= $this->lang->line('discount') ?>" /></td>
                            <td class="datepicker_container" style="<?= $item->start_date ? '' : 'display:none' ?>"><?php if ($item->start_date) { ?>
                                    <label class="form-label"><?= $this->lang->line('start-date') ?></label>
                                    <input type="text" name="start_date[]" class="form-control datepicker" value="<?= $item->start_date ?>" placeholder="<?= $this->lang->line('start-date') ?>" />
                                <?php } ?>
                            </td>
                            <td class="datepicker_container" style="<?= $item->start_date ? '' : 'display:none' ?>"><?php if ($item->expiry_date) { ?>
                                    <label class="form-label"><?= $this->lang->line('end-date') ?></label>
                                    <input type="text" name="end_date[]" class="form-control datepicker" value="<?= $item->expiry_date ?>" placeholder="<?= $this->lang->line('end-date') ?>" />
                                <?php } ?>
                            </td>
                            <td class="num_width total_price_container"><?php if (!$item->expiry_date && !$item->start_date) { ?>
                                    <label class="form-label"><?= $this->lang->line('total_price') ?></label>
                                    <span class="form-control total_price" ><?= $item->discount_remainder ?></span>
                                <?php } ?></td>
                            <td class="comment_width"><label class="form-label"><?= $this->lang->line('comment') ?></label>
                                <textarea rows="1" name="comment[]" class="form-control" placeholder="<?= $this->lang->line('comment') ?>" ><?= $item->comment ?></textarea></td>
                            <td>
                                &nbsp;&nbsp;
                                <i class="fas fa-calendar-plus text-primary fa-2x additions_btn" title="<?= $this->lang->line('additions') ?>" style="cursor: pointer"></i>
                                &nbsp;&nbsp;
                                <i class="fas fa-window-close text-danger fa-2x delete_item" title="Delete Item" style="cursor: pointer"></i>
                                <div class="additions">
                                    <?php foreach ($item->additions_arr as $add) { ?>
                                        <input type="hidden" name="addition_id[<?= $item->id_producer ?>][]" value="<?= $add['product_addition_id'] ?>" class="addition_id" />
                                        <input type="hidden" name="choice[<?= $item->id_producer ?>][]" value="<?= $add['choice'] ?>" class="choice" />
                                    <?php } ?>
                                    <input type="hidden" name="addition_txt[<?= $item->id_producer ?>]" value="<?= $item->additions ?>" class="addition_txt" />
                                </div>
                            </td>

                        </tr>
                        <?php
                    }
                }
                ?>
                <?php
                if ((empty($order_items) && !$this->input->post()) ||
                        ($this->input->post())) {
                    ?>
                    <tr>
                        <td><label><?= $this->lang->line('product') ?></label><select class="form-control product" name="id_producer[]" >
                                <option value><?= $this->lang->line('select') ?></option>
                                <?php
                                foreach ($bills_producer as $row) {
                                    $selected = '';
                                    if ($this->input->post() && is_array($this->input->post('id_producer')) && $this->input->post('id_producer')[0] == $row['id']) {
                                        $selected = 'selected';
                                    }
                                    ?>
                                    <option <?= $selected ?> value="<?= $row['id']; ?>"><?= $row['name']; ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                            <span class="post_data"></span>
                            <div class="product_additions">
                                <?php
                                if ($this->input->post('addition_txt[' . $this->input->post('id_producer')[0] . ']') && $this->input->post('addition_txt[' . $this->input->post('id_producer')[0] . ']') != '') {
                                    echo $this->input->post('addition_txt[' . $this->input->post('id_producer')[0] . ']');
                                }
                                ?>
                            </div>
                        </td>

                        <td class="num_width"><label class="form-label"><?= $this->lang->line('amount') ?></label>
                            <input type="hidden" class="product_price" />
                            <?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                                <input type="text" name="amount[]" class="form-control price" value="<?= isset(set_value('amount')[0]) ? set_value('amount')[0] : '' ?>" placeholder="<?= $this->lang->line('the-amount') ?>" />
                            <?php } else { ?>
                                <input type="hidden" name="amount[]" class="price_hidden" value="<?= isset(set_value('amount')[0]) ? set_value('amount')[0] : '' ?>" />
                                <span class="form-control price" style="width:100%" ><?= $this->lang->line('the-amount') ?></span>
                            <?php } ?>
                        </td>
                        <td class="num_width"><div class="quantity_container"><label class="form-label"><?= $this->lang->line('quantity') ?></label>
                                <input type="text" name="quantity[]" class="form-control quantity" placeholder="<?= $this->lang->line('quantity') ?>" value="<?= isset(set_value('quantity')[0]) ? set_value('quantity')[0] : '' ?>" /></div></td>
                        <td class="num_width"><label class="form-label"><?= $this->lang->line('discount') ?></label>
                            <input type="text" name="discount[]" class="form-control discount" placeholder="<?= $this->lang->line('discount') ?>" value="<?= isset(set_value('discount')[0]) ? set_value('discount')[0] : '' ?>" /></td>
                        <td class="datepicker_container"><label class="form-label"><?= $this->lang->line('start-date') ?></label>
                            <input type="text" name="start_date[]" class="form-control datepicker" placeholder="<?= $this->lang->line('start-date') ?>" value="<?= isset(set_value('start_date')[0]) ? set_value('start_date')[0] : '' ?>" /></td>
                        <td class="datepicker_container"><label class="form-label"><?= $this->lang->line('end-date') ?></label>
                            <input type="text" name="end_date[]" class="form-control datepicker" placeholder="<?= $this->lang->line('end-date') ?>" value="<?= isset(set_value('end_date')[0]) ? set_value('end_date')[0] : '' ?>" /></td>
                        <td class="num_width"><label class="form-label"><?= $this->lang->line('total_price') ?></label>
                            <span class="form-control total_price" ></span></td>
                        <td class="comment_width"><label class="form-label"><?= $this->lang->line('comment') ?></label>
                            <textarea rows="1" name="comment[]" class="form-control" placeholder="<?= $this->lang->line('comment') ?>" ><?= isset(set_value('comment')[0]) ? set_value('comment')[0] : '' ?></textarea></td>
                        <td>
                            &nbsp;&nbsp;
                            <i class="fas fa-calendar-plus text-primary fa-2x additions_btn" title="<?= $this->lang->line('additions') ?>" style="cursor: pointer"></i>
                            &nbsp;&nbsp;
                            <i class="fas fa-window-close text-danger fa-2x delete_item" title="Delete Item" style="cursor: pointer"></i>
                            <div class="additions">
                                <?php
                                if ($this->input->post() && is_array($this->input->post('addition_id[' . $this->input->post('id_producer')[0] . ']'))) {
                                    for ($j = 0; $j < count($this->input->post('addition_id[' . $this->input->post('id_producer')[0] . ']')); $j++) {
                                        ?>
                                        <input type="hidden" name="addition_id[<?= $this->input->post('id_producer')[0] ?>][]" value="<?= $this->input->post('addition_id[' . $this->input->post('id_producer')[0] . '][' . $j . ']') ?>" class="addition_id" />
                                        <input type="hidden" name="choice[<?= $this->input->post('id_producer')[0] ?>][]" value="<?= $this->input->post('choice[' . $this->input->post('id_producer')[0] . '][' . $j . ']') ?>" class="choice"  />
                                    <?php } ?>
                                    <input type="hidden" name="addition_txt[<?= $this->input->post('id_producer')[0] ?>]" value="<?= $this->input->post('addition_txt[' . $this->input->post('id_producer')[0] . ']') ?>" class="addition_txt" />
                                <?php }
                                ?>
                            </div>
                        </td>
                    </tr>
                <?php } ?>
            </table>
            <br/>
            <br/>
            <div>
                <i class="fa fa-plus text-primary fa-3x add_icon"></i>
            </div>
            <div class="inv_total_container row">
                <div class="col-md-8"></div>
                <div class="col-md-2">
                    <hr style="margin-top: 0px"/>
                    <label class="form-label"><?= $this->lang->line('total_price') ?></label>
                    <span class="form-control inv_total"></span>
                </div>
                <div class="col-md-2"></div>
            </div>
            <br/>
            <br/>

            <div class="form-group row">
                <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('the_type') ?></label>
                <div class="col-9">
                    <div class="radio">
                        <input type="radio" name="type"  value="0"  class="type" <?= set_value('type', $order->type) == 0 ? 'checked' : '' ?>>
                        <label>   &nbsp;&nbsp;<?php echo $this->lang->line('order') ?>
                        </label>
                    </div>
                    <div class="radio">
                        <input type="radio" name="type"  value="1" class="type" <?= set_value('type', $order->type) == 1 ? 'checked' : '' ?>>
                        <label>   &nbsp;&nbsp;<?php echo $this->lang->line('reservation') ?>
                        </label>
                    </div>
                </div>
            </div>



            <div id="order_data">
                <div class="form-group row">
                    <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('discount_type') ?></label>
                    <div class="col-9">
                        <select name="discount_type" class="form-control" id="discount_type">
                            <option value="0" <?= set_value('discount_type', $order->discount_type) == 0 ? 'selected' : '' ?> ><?php echo $this->lang->line('amount') ?></option>
                            <option value="1" <?= set_value('discount_type', $order->discount_type) == 1 ? 'selected' : '' ?> ><?php echo $this->lang->line('percentage') ?></option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('delivery_type') ?></label>
                    <div class="col-9">
                        <select name="delivery_type" class="form-control" id="delivery_type">
                            <option value="0" <?= set_value('delivery_type', $order->delivery_type) == 0 ? 'selected' : '' ?> ><?php echo $this->lang->line('direct_recieve') ?></option>
                            <option value="1" <?= set_value('delivery_type', $order->delivery_type) == 1 ? 'selected' : '' ?> ><?php echo $this->lang->line('home_delivery') ?></option>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></label>
                    <div class="col-9">
                        <select name="paid" class="form-control">
                            <option value="1" <?= set_value('paid', $order_items[0]->paid) == 1 ? 'selected' : '' ?> ><?php echo $this->lang->line('payment-is-made') ?></option>
                            <option value="2" <?= set_value('paid', $order_items[0]->paid) == 2 ? 'selected' : '' ?> ><?php echo $this->lang->line('not-paid') ?></option>
                        </select>
                        <!--                    <div class="radio">
                                                <input type="radio" name="paid"  value="1"  <?//= $order_items[0]->paid == 1 ? 'checked' : '' ?> required>
                                                <label>   <?php //echo $this->lang->line('payment-is-made')                                                                                                  ?>
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <input type="radio" name="paid" value="2" <?//= $order_items[0]->paid == 2 ? 'checked' : '' ?>>
                                                <label>   <?php //echo $this->lang->line('not-paid')                                                                                                  ?>
                                                </label>
                                            </div>-->
                        <!--                    <div class="radio">
                                                <input type="radio" name="paid"  value="3" <?//= $order_items[0]->paid == 3 ? 'checked' : '' ?>>
                                                <label>  <?php //echo $this->lang->line('complimentary')                                                                                                             ?> 
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <input type="radio" name="paid"  value="4" <?//= $order_items[0]->paid == 4 ? 'checked' : '' ?>>
                                                <label> <?php //echo $this->lang->line('retriever')                                                                                                             ?>
                                                </label>
                                            </div> -->
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3 col-form-label"><?= $this->lang->line('payment_method') ?></label>
                    <?php $payment_method = array('cash', 'Knit', 'Visa/Master', 'link') ?>
                    <div class="col-9">
                        <select name="payment_method" class="form-control">
                            <?php foreach ($payment_method as $key => $value) { ?>
                                <option <?= $key == set_value('payment_method', $order->payment_method) ? 'selected' : '' ?> value="<?= $key ?>"><?= $this->lang->line($value) ? $this->lang->line($value) : $value ?></option>  
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <!--            <div class="form-group row">
                                <label class="col-3 col-form-label"><?//= $this->lang->line('delivery_status') ?></label>
                <?php //$delivery_status = array('not_shipped', 'in_the_way', 'delivered')          ?>
                                <div class="col-9">
                                    <select name="delivery_status" class="form-control">
                <?php //foreach ($delivery_status as $key => $value) {       ?>
                                            <option <?//= $key == $order->delivery_status ? 'selected' : '' ?> value="<?//= $key ?>"><?//= $this->lang->line($value) ?></option>  
                <?php //}            ?>
                                    </select>
                                </div>
                            </div>-->

                <!--            <div class="form-group row">
                                <label class="col-3 col-form-label"><?//= $this->lang->line('expected_delivery_time') ?></label>
                                <div class="col-9">
                                    <input type="text" name="expected_delivery_time" class="form-control datetimepicker" value="<?= $order->expected_delivery_time ?>" />
                                </div>
                            </div>-->

                <!--            <div class="form-group row">
                                <label class="col-3 col-form-label"><?//= $this->lang->line('delivery_details') ?></label>
                                <div class="col-9">
                                    <textarea class="form-control" rows="3" placeholder="<?php //echo $this->lang->line('delivery_details')                                                                                                             ?>" name="delivery_details"><?= $order->delivery_details ?></textarea>
                                </div>
                            </div>-->


                <div class="form-group row">
                    <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('the-reason-for-the-discount') ?></label>
                    <div class="col-9">
                        <textarea class="form-control" rows="3" placeholder="<?php echo $this->lang->line('describe') ?>..." name="discount_why"><?= set_value('discount_why', $order_items[0]->discount_why) ?></textarea>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('note') ?></label>
                <div class="col-9">
                    <textarea class="form-control" rows="3" placeholder="<?php echo $this->lang->line('describe') ?>.." name="note"><?= set_value('note', $order_items[0]->note) ?></textarea>
                </div>
            </div>


            <!--            <div class="form-group row">
                            <label class="col-3 col-form-label"><?//= $this->lang->line('order_status') ?></label>
            <?php //$order_status = array('waiting', 'preparing', 'delivering', 'delivered', 'canceled')          ?>
                            <div class="col-9">
                                <select name="order_status" class="form-control">
            <?php //foreach ($order_status as $key => $value) {       ?>
                                        <option <?//= $key == $order->order_status ? 'selected' : '' ?> value="<?//= $key ?>"><?//= $this->lang->line($value) ?></option>  
            <?php //}            ?>
                                </select>
                            </div>
                        </div>-->

        </div>
        <div class="kt-portlet__foot">
            <div class="kt-form__actions">
                <div class="row">
                    <div class="col-10">
                        <button type="submit" class="btn btn-primary" name="submit" value="pl"><?php echo $this->lang->line('save') ?></button>
                        <?php if ($call_center) { ?>
                            <button type="submit" class="btn btn-success" name="submit" value="edit_status"><?php echo $this->lang->line('save_and_edit_order') ?></button>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        </form>
    </div>

    <div class="modal fade" id="additions_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?= $this->lang->line('additions') ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i aria-hidden="true" class="ki ki-close"></i>
                    </button>
                </div>


<!--                <form action="<?= base_url('orders/add_address') ?>" method="post" id="add_address_form" >-->
                <div class="modal-body">
                    <div id="modal_addition_error"></div>
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" id="modal_product_id" />
                            <input type="hidden" id="modal_order" />
                            <div id="modal_inputs">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                    <a class="btn btn-primary font-weight-bold submit_add_addition" style="color: #fff"><?= $this->lang->line('add') ?></a>
                </div> 
                <!--</form>-->
            </div>
        </div>
    </div>


    <?php $this->load->view('site/footer_2'); ?>
    <script>
        function update_total_price() {
            var total = 0;
            $('.total_price').each(function () {
                if ($(this).text() != '') {
                    total += parseFloat($(this).text());
                }
            });
            $('.price').each(function () {
                if ($(this).text() != '' && $.isNumeric($(this).text())) {
                    if (!$(this).closest('tr').find('.total_price_container').is(":visible")) {
                        total += parseFloat($(this).text());
                    }
                }
            });
            $(".inv_total").text(total);
        }
        update_total_price();
<?php if ($this->session->flashdata('error')) : ?>
            $("#add_student").modal('show');
<?php endif; ?>

<?php //if (!get_ap('edit_price_in_inv', $this->operator_id)) {                                                                                                        ?>
        // $(".price").attr('readonly', 'true');
<?php //}                                                                                                        ?>
        $(".product").select2();
<?php if ($this->input->post() && empty($this->input->post('id_producer'))) { ?>
            $(".datepicker_container").hide();
<?php } ?>
        $('.type').change(function () {
            if ($('.type:checked').val() == 1) {
                $('#order_data').hide();
            } else {
                $('#order_data').show();
            }
        });
        $('.type').change();
        $(".price").each(function () {
            $(this).change();
        });
        $(".datepicker").datepicker({
            format: "yyyy-mm-dd",
            todayHighlight: true
        });
        $(".datetimepicker").datetimepicker({
            format: "yyyy-mm-dd H:i:s",
            todayHighlight: true
        });


        $(document).on("click", ".additions_btn", function () {
            var order = $(this).closest("tr").find(".product").index(".product");
            var product_id = $(this).closest("tr").find(".product").val();
            $.ajax({
                type: "POST",
                url: "<?php echo base_url() ?>Orders/get_product_additions",
                data: {'product_id': product_id},
                dataType: 'JSON',
                success: function (result) {
                    $("#modal_addition_error").html('');
                    $("#modal_product_id").val(product_id);
                    $("#modal_order").val(order);
                    var html = '';

                    for (var i = 0; i < result.length; i++) {

                        var input_type = 'checkbox';
                        if (result[i].choice_type == 0) {
                            var input_type = 'radio';
                        }
                        var star = '';
                        if (result[i].required == 1) {
                            star = '*';
                        }
                        html += '<div class="form-group row">\n\
            <label for="example-text-input" class="col-3 col-form-label">' + result[i].qu + star + '</label>\n\
            <div class="col-9" style="margin-top:10px">';
                        for (var j = 0; j < result[i].options.length; j++) {
                            var checked = '';
                            if (typeof $('.addition_id[value="' + result[i].id + '"]').next('.choice').val() != "undefined") {
                                var choice_val = $('.addition_id[value="' + result[i].id + '"]').next('.choice').val().split(',');
                                if ($.inArray(result[i].options[j][1], choice_val) !== -1) {
                                    checked = 'checked';
                                }
                            }
                            html += '<input ' + checked + ' type="' + input_type + '" data-addition_id="' + result[i].id + '" data-price="' + result[i].options[j][2] + '" data-required="' + result[i].required + '" name="modal_add_' + result[i].id + '[]" value="' + result[i].options[j][1] + '" />&nbsp;&nbsp;<label>' + result[i].options[j][0] + '</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                        }

                        html += '</div></div>';
                    }
                    $("#modal_inputs").html(html);
                    $("#additions_modal").modal('show');
                }
            });
        });

        $(".submit_add_addition").click(function () {
            var order = $("#modal_order").val();
            $(".additions:eq(" + order + ")").html('');
            $(".product_additions:eq(" + order + ")").html('');
            $("#modal_addition_error").html('');
            var error = 0;
            var product_price = parseFloat($("tr:eq(" + order + ")").find(".product_price").val());
            var product_id = $("#modal_product_id").val();
            $("#modal_inputs .col-9").each(function () {
                var input_name = $(this).children('input:first').attr('name');
                //var choice = $('input[name="' + input_name + '"]:checked').val();
                var arr = $('input[name="' + input_name + '"]:checked').map(function () {
                    return this.value; // $(this).val()
                }).get();
                var choice = arr.join(',');
                var required = $('input[name="' + input_name + '"]:first').data('required');
                if (required == 1 && $('input[name="' + input_name + '"]:checked').length == 0) {
                    error = 1;
                    $("#modal_addition_error").append('<div class="alert alert-danger alert-dismissible">\n\
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>\n\
            <h4><i class="icon fa-warning"></i> ERROR!</h4><?= $this->lang->line('have_to_choose') ?> ' + $(this).parent('.form-group').find(".col-form-label").html() + '\n\
            </div>');
                } else {
                    var addition_id = $('input[name="' + input_name + '"]:first').data('addition_id');

                    var choice_txt = $('input[name="' + input_name + '"]:checked').map(function () {
                        return $(this).next('label:first').html() + ' -- ' + $(this).data('price'); // $(this).val()
                    }).get();
                    // var choice_txt = $('input[name="' + input_name + '"]:checked').next('label:first').html();
                    var price = 0;
                    $('input[name="' + input_name + '"]:checked').each(function () {
                        price += parseFloat($(this).data('price')); // $(this).val()
                    });
                    // var price = $('input[name="' + input_name + '"]:checked').data('price');

                    if ($('input[name="' + input_name + '"]:checked').length > 0) {
                        $(".additions:eq(" + order + ")").append('<input type="hidden" name="addition_id[' + product_id + '][]" value="' + addition_id + '" class="addition_id" />\n\
                    <input type="hidden" name="choice[' + product_id + '][]" class="choice" value="' + choice + '" />');

                        $(".product_additions:eq(" + order + ")").append(choice_txt + '<br/>');

                        product_price += price;
<?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                            $("tr:eq(" + order + ")").find(".price").val(product_price);
                            $("tr:eq(" + order + ")").find(".price").change();
<?php } else { ?>
                            $("tr:eq(" + order + ")").find(".price").text(product_price);
                            $("tr:eq(" + order + ")").find(".price_hidden").val(product_price);
                            $("tr:eq(" + order + ")").find(".price").change();
<?php } ?>
                    }

                }
            });
            if (error == 0) {
                $("#additions_modal").modal('hide');
            }
            var text = $(".product_additions:eq(" + order + ")").html();
            $(".additions:eq(" + order + ")").append('<input type="hidden" name="addition_txt[' + product_id + ']" value="' + text + '" />');

        });




        $(".add_icon").click(function () {

            var count = parseInt($("#products_count").val());
            var product = '';
            $(".product").select2('destroy');
            $("#invoice_items").append('<tr>' + $("#first").html() + '</tr>');
            $("#invoice_items").find('tr:last-child').find(".datepicker_container").hide();
            $("#invoice_items").find('tr:last-child').find(".total_price").text('');
            $("#invoice_items").find('tr:last-child').find(".form-label").hide();
            $("#invoice_items").find('tr:last-child').find(".price").text('');
            $(".datepicker").datepicker({
                format: "yyyy-mm-dd",
                todayHighlight: true
            });
            if (typeof post_inputs !== "undefined") {
                product = post_inputs['id_producer'][count];
                $(".price:last").val(post_inputs['amount'][count]);
                $(".discount:last").val(post_inputs['discount'][count]);
                $(".quantity:last").val(post_inputs['quantity'][count]);
                $("input[name='comment[]']:last").val(post_inputs['comment'][count]);
                $("input[name='start_date[]']:last").val(post_inputs['start_date'][count]);
                $("input[name='end_date[]']:last").val(post_inputs['end_date'][count]);
            }
            if (product != '') {
                $(".product:last").val(product);
            }
            $(".product").select2();
            $("#products_count").val(parseInt($("#products_count").val()) + 1);
        });



        $(document).on("click", ".delete_item", function () {
            $(this).closest('tr').remove();
            $("#products_count").val(parseInt($("#products_count").val()) - 1);
        });

        $(document).on("change", ".product", function () {
            var ele = $(this);
            $.ajax({
                type: "POST",
                url: "<?php echo base_url() ?>Orders/get_product_price",
                data: {'product_id': $(this).val()},
                dataType: 'JSON',
                success: function (price) {
                    if (!price) {
                        ele.closest("tr").find(".price").val(0);
                        return;
                    }

                    if (ele.closest("tr").find('td:first').find(".post_data").length == 0) {
                        ele.closest("tr").find(".additions").html('');
                        ele.closest("tr").find(".product_additions").html('');
                    } else {
                        ele.closest("tr").find('td:first').find(".post_data").remove();
                    }
                    ele.closest("tr").find(".product_price").val(0);
                    if (price.type == 2) {
                        ele.closest("tr").find(".datepicker_container").show();
                        ele.closest("tr").find(".quantity_container").hide();
                        ele.closest("tr").find(".total_price_container").hide();
                    } else {
                        ele.closest("tr").find(".datepicker_container").hide();
                        ele.closest("tr").find(".quantity_container").show();
                        ele.closest("tr").find(".total_price_container").show();
                    }
<?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                        ele.closest("tr").find(".price").val(parseFloat(price.valuess));
<?php } else { ?>
                        ele.closest("tr").find(".price").text(parseFloat(price.valuess));
                        ele.closest("tr").find(".price_hidden").val(parseFloat(price.valuess));
<?php } ?>
                    ele.closest("tr").find(".product_price").val(parseFloat(price.valuess));
                    ele.closest("tr").find(".quantity").change();
                }
            });
        });

<?php if ($this->input->post()) { ?>
            $(".product:last").change();
            post_inputs = '<?= json_encode($this->input->post()) ?>';
            post_inputs = JSON.parse(post_inputs);
    <?php for ($i = 1; $i < $this->input->post('products_count'); $i++) { ?>
                $(".add_icon").click();
                $(".product:last").closest("td").append('<span class="post_data"></span>');
                $(".product:last").change();
        <?php if ($this->input->post() && $this->input->post('id_producer')[$i] != '' && is_array($this->input->post('addition_id[' . $this->input->post('id_producer')[$i] . ']'))) { ?>
                    $(".product:last").closest("tr").find(".additions").html('');
            <?php for ($j = 0; $j < count($this->input->post('addition_id[' . $this->input->post('id_producer')[$i] . ']')); $j++) {
                ?>
                        $(".product:last").closest("tr").find(".additions").append('<input type="hidden" name="addition_id[<?= $this->input->post('id_producer')[$i] ?>][]" value="<?= $this->input->post('addition_id[' . $this->input->post('id_producer')[$i] . '][' . $j . ']') ?>" class="addition_id" />\n\
                                                                                                                    <input type="hidden" name="choice[<?= $this->input->post('id_producer')[$i] ?>][]" value="<?= $this->input->post('choice[' . $this->input->post('id_producer')[$i] . '][' . $j . ']') ?>" class="choice" />');
            <?php }
            ?>
                    $(".product:last").closest("tr").find(".additions").append('<input type="hidden" name="addition_txt[<?= $this->input->post('id_producer')[$i] ?>]" value="<?= $this->input->post('addition_txt[' . $this->input->post('id_producer')[$i] . ']') ?>" class="addition_txt" />');
                    $(".product:last").closest("tr").find(".product_additions").html('<?= $this->input->post('addition_txt[' . $this->input->post('id_producer')[$i] . ']') ?>');

        <?php }
        ?>
        <?php
    }
}
?>

        $(document).on("change", ".quantity", function () {
<?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                var price = parseFloat($(this).closest('tr').find('.price').val());
<?php } else { ?>
                var price = parseFloat($(this).closest('tr').find('.price').text());
<?php } ?>
            var qu = $(this).val();
            var discount = $(this).closest('tr').find('.discount').val();
            if ($("#discount_type").val() == 1) {
                discount = (qu * price * discount) / 100;
            }
            $(this).closest('tr').find('.total_price').text(((qu * price) - discount).toFixed(2));
            update_total_price();
        });

        $(document).on("change", ".price", function () {
            var qu = $(this).closest('tr').find('.quantity').val();
<?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                var price = parseFloat($(this).closest('tr').find('.price').val());
<?php } else { ?>
                var price = parseFloat($(this).closest('tr').find('.price').text());
<?php } ?>
            var discount = $(this).closest('tr').find('.discount').val();
            if ($("#discount_type").val() == 1) {
                discount = (qu * price * discount) / 100;
            }

            $(this).closest('tr').find('.total_price').text(((qu * price) - discount).toFixed(2));
            update_total_price();
        });

        $(document).on("change", ".discount", function () {
            var qu = $(this).closest('tr').find('.quantity').val();
<?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                var price = $(this).closest('tr').find('.price').val();
<?php } else { ?>
                var price = $(this).closest('tr').find('.price').text();
<?php } ?>
            var discount = parseFloat($(this).val());
            if ($("#discount_type").val() == 1) {
                discount = (qu * price * discount) / 100;
            }

            $(this).closest('tr').find('.total_price').text(((qu * price) - discount).toFixed(2));
            update_total_price();
        });

        $("#discount_type").change(function () {
            $('.total_price').each(function () {
                var qu = $(this).closest('tr').find('.quantity').val();
<?php if (get_ap('edit_price_in_inv', $this->operator_id)) { ?>
                    var price = $(this).closest('tr').find('.price').val();
<?php } else { ?>
                    var price = $(this).closest('tr').find('.price').text();
<?php } ?>
                var discount = $(this).closest('tr').find('.discount').val();
                if ($("#discount_type").val() == 1) {
                    discount = (qu * price * discount) / 100;
                }

                $(this).closest('tr').find('.total_price').text(((qu * price) - discount).toFixed(2));
                update_total_price();
            });
        });
    </script>
