
<?php $this->load->view('site/layout'); ?>
<link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<style>
    .bg-blue{
        background-color: #e3f1ff;
    }
    .border-right {
        border-right: 1px solid #ECF0F3 !important;
    }
    a {
        color: #3699FF;
        text-decoration: none;
        background-color: transparent;
    }
    h3, .h3 {
        font-size: 1.5rem;
    }
    .label.label-danger {
        color: #ffffff;
        background-color: #F64E60;
    }
    #list_table tr td{
        text-align: center !important;
    }
    .label {
        padding: 0;
        margin: 0;
        display: -webkit-inline-box;
        display: -ms-inline-flexbox;
        display: inline-flex;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        justify-content: center;
        -webkit-box-align: center;
        -ms-flex-align: center;
        align-items: center;
        height: 20px;
        width: 20px;
        border-radius: 50%;
        font-size: 0.8rem;
        background-color: #ECF0F3;
        color: #464E5F;
        font-weight: 400;
        height: 20px;
        width: 20px;
        font-size: 0.8rem;
    }
    .label.label-inline {
        width: auto;
        padding: 1.15rem 0.75rem;
        border-radius: 0.42rem;
    }
    .label.label-inline {
        width: auto;
    }
    .label.label-pill {
        border-radius: 2rem;
    }
    .label.label-success {
        color: #ffffff;
        background-color: #1BC5BD;
    }
    @media (min-width: 768px){
        .col-md-2 {
            max-width: 13.66667%;
        }
    }
    .rtl div.dataTables_wrapper div.dataTables_length label{
        float: left;
    }
    div.dataTables_wrapper div.dataTables_filter label{
        margin-top: 20px;
    }
</style>
<?php $this->load->view('site/navbar'); ?>

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?= $this->call_center ? $this->lang->line('orders') : $this->lang->line('invoices') ?></span>
            </div>

        </div>
    </div>
</div>

<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
    <button class="btn btn-primary mb-3" onclick="toggle_filter()"><?= $this->lang->line('show_hide_filter') ?></button>
    <div class="alert alert-light alert-elevate" role="alert" id="filter_container">
        <div class="alert-text">

            <form class="kt-form kt-form--label-right" method="post" action=""> 
                <div class="kt-portlet__body">
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('date') ?></label>
                        <div class="col-9">
                            <input type="text" name="start_expiry" id="start_expiry" class="form-control" value="<?= set_value('start_expiry') ?>"> 
                        </div>
                        <div class="col-1" style="padding-left: 0px">
                            <a onclick="clear_date()" class="btn btn-light btn-text-primary btn-hover-text-primary font-weight-bold"><?= $this->lang->line('clear') ?></a>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('products') ?></label>
                        <div class="col-9">
                            <select multiple name="products[]" class="topnav form-control select2_plug" >
                                <?php
                                foreach ($products as $value) {
                                    $selected = '';
                                    if (!empty($this->input->post('products'))) {
                                        if (in_array($value->name, $this->input->post('products'))) {
                                            $selected = 'selected';
                                        }
                                    }
                                    ?>
                                    <option <?= $selected ?> value="<?php echo $value->name ?>"><?php echo $value->name ?></option>
                                <?php } ?>
                            </select> 
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('students') ?></label>
                        <div class="col-9">
                            <select multiple name="username[]" class="topnav form-control select2_plug" >
                                <?php
                                foreach ($username as $value) {
                                    $selected = '';
                                    if (!empty($this->input->post('username'))) {
                                        if (in_array($value->username, $this->input->post('username'))) {
                                            $selected = 'selected';
                                        }
                                    }
                                    ?>
                                    <option <?= $selected ?> value="<?php echo $value->username ?>"><?php echo $value->username ?></option>
                                <?php } ?>
                            </select> 
                        </div>
                    </div>
                    <?php $order_status = array('waiting', 'preparing', 'ready_for_deliver', 'delivering', 'delivered', 'canceled');
//if (get_license_per('order_status')) { ?>
<!--                        <div class="form-group row">
                            <label for="example-text-input" class="col-2 col-form-label"><?php //echo $this->lang->line('order_status') ?></label>
                            <div class="col-9">
                                <select multiple name="order_status[]" id="order_status" class="topnav form-control" style="width: 100%">
                                    <?php
//                                    $order_status = array('waiting', 'preparing', 'ready_for_deliver', 'delivering', 'delivered', 'canceled');
//                                    foreach ($order_status as $key => $value) {
//                                        $selected = '';
//                                        if ($this->input->post('order_status')) {
//                                            if (in_array($key, $this->input->post('order_status'))) {
//                                                $selected = 'selected';
//                                            }
//                                        } 
                                        ?>
                                        <option <?//= $selected ?> value="<?php //echo $key ?>"><?php //echo $this->lang->line($value) ?></option>
                                    <?php //} ?>
                                </select> 
                            </div>
                        </div>-->
                    <?php //} ?>
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('added_by') ?></label>
                        <div class="col-9">
                            <select multiple name="admins[]" class="topnav form-control select2_plug" style="width: 100%">
                                <?php
                                foreach ($admins as $admin) {
                                    $selected = '';
                                    if (!empty($this->input->post('admins'))) {
                                        if (in_array($key, $this->input->post('admins'))) {
                                            $selected = 'selected';
                                        }
                                    }
                                    ?>
                                    <option <?= $selected ?>  value="<?= $admin->id ?>"><?= $admin->name ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></label>
                        <div class="col-9">
                            <select name="payment_status" class="topnav form-control select2_plug" style="width: 100%">
                                <option value="0" ><?= $this->lang->line('all') ?></option>
                                <option value="1" <?= set_value('payment_status') == 1 ? 'selected' : '' ?> ><?php echo $this->lang->line('payment-is-made') ?></option>
                                <option value="2" <?= set_value('payment_status') == 2 ? 'selected' : '' ?> ><?php echo $this->lang->line('not-paid') ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">

                        <button  class="btn btn-brand btn-elevate btn-icon-sm mr-5">
                            <?php echo $this->lang->line('submit') ?>
                        </button>

                    </div>
                </div>
            </form>          
        </div>
    </div>
</div>



<div class="kt-portlet kt-portlet--mobile">
    <?php if ($this->session->flashdata('msg')): ?>
        <br/>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">✕</button>
            <h4><i class="icon fa-warning"></i> Success!</h4>&nbsp;
            <?= $this->lang->line('op_success'); ?>
        </div>
    <?php endif; ?> 
        <?php if ($this->session->flashdata('error')): ?>
        <br/>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">✕</button>
            <h4><i class="icon fa-warning"></i> Error!</h4>&nbsp;
            <?= $this->session->flashdata('error'); ?>
        </div>
    <?php endif; ?> 
    <div class="kt-portlet__head kt-portlet__head--lg">
        <div class="kt-portlet__head-label">
            <span class="kt-portlet__head-icon">
                <i class="kt-font-brand flaticon2-line-chart"></i>
            </span>
            <h3 class="kt-portlet__head-title">
                <?= $this->call_center ? $this->lang->line('orders') : $this->lang->line('invoices'); ?>
            </h3>
        </div>
        <div class="kt-portlet__head-toolbar">
            <div class="kt-portlet__head-wrapper">
                <div class="kt-portlet__head-actions">
                    <div class="dropdown dropdown-inline">
                      <!-- <a href="<?= base_url() ?>/<?= $this->thispage ?>/report/"><button  class="btn btn-default btn-icon-sm dropdown-toggle"  aria-haspopup="true" aria-expanded="false">
                        <i class="la la-download"></i> <?php //echo $this->lang->line('report')                                                                                                         ?>
                      </button></a>  -->
                    </div>
                    &nbsp;
                    <?php if (get_ap('invoice_add', $this->operator_id) == 1) { ?>
                        <a href="<?= base_url() ?>/<?= $this->thispage ?>/add/<?= $this->call_center ?>" class="btn btn-brand btn-elevate btn-icon-sm">
                            <i class="la la-plus"></i>
                            <?= $this->call_center ? $this->lang->line('add_order') : $this->lang->line('add-an-invoice') ?>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">

        <?php if ($this->type == 0 && get_license_per('order_status')) { ?>
            <div class="row">
                <?php
                $colors = array('text-danger', 'text-primary', 'text-dark', 'text-success', 'text-warning', 'text-info');
                foreach ($order_status as $key => $value) {
                    ?>
                    <div class="col-md-2 col-xs-6 mbot15 border-right text-center">
                        <a href="<?= base_url() ?>orders/index/1/<?= $this->call_center ?>/<?= $this->type ?>/<?= $key ?>" >
                            <h3 class="bold" id="<?= $value ?>"><!--<?//= $order_status_counts->$value ? $order_status_counts->$value : 0 ?>--></h3>
                            <span class="<?= $colors[$key] ?>">
                                <?= $this->lang->line($value) ?>      </span>
                        </a>
                    </div>
                <?php } ?>
                <div class="col-md-2 col-xs-6 mbot15 border-right text-center">
                    <a href="<?= base_url() ?>orders/index/1/<?= $this->call_center ?>/<?= $this->type ?>/-1" >
                        <h3 class="bold" id="all"><!--<?//= $order_status_counts->all_data ?>--></h3>
                        <span class="text-info">
                            <?= $this->lang->line('all') ?>      </span>
                    </a>
                </div>

            </div>
            <br/>
            <br/>
        <?php } ?>


        <!--begin: Datatable -->
        <table class="table table-striped- table-bordered table-hover table-checkable dataTable no-footer dir-inline" id="list_table">
            <thead>
                <tr>
                    <th><?php echo $this->lang->line('sno') ?></th>
                    <th class="text-center"><?php echo $this->lang->line('date-added') ?></th>
                    <?php if ($this->type == 0) { ?>
                        <th class="text-center"><?php echo $this->lang->line('invoice-number') ?></th>
                    <?php } ?>
                    <th class="text-center"><?php echo $this->lang->line('the-name') ?></th>


      <!--<th ><?php //echo $this->lang->line('the-product')                                                                                                         ?></th>-->
       <!--<th ><?php //echo $this->lang->line('the-beginning')                                                                                                         ?></th>-->
       <!--<th ><?php //echo $this->lang->line('end')                                                                                                         ?></th>-->
                    <th class="text-center"> <?php echo $this->lang->line('fees') ?></th>
                    <th class="text-center"> <?php echo $this->lang->line('region') ?></th>
                    <?php if ($this->call_center) { ?>
                        <th class="text-center"><?= $this->lang->line('delivery_type') . '<br/>' . $this->lang->line('expected_delivery_time') ?></th>
                    <?php } ?>
                    <?php if ($this->type == 0) { ?>
                        <th class="text-center"><?php echo $this->lang->line('payment') ?></th>
                    <?php } ?>
                    <?php if ($this->call_center && $this->type == 0 && get_license_per('order_status')) { ?>
                        <th ><?php echo $this->lang->line('status') ?></th>
                    <?php } ?>
                    <th class="text-center"><?= $this->lang->line('added_by') ?></th>
                    <th style="width: 18%;"><?php echo $this->lang->line('action') ?></th>
                          <!-- <th><?php echo $this->lang->line('edit') ?></th>
                          <th><?php echo $this->lang->line('delete') ?></th> -->
                </tr>
            </thead>
            <tbody>
                    <!--<tr class="<?//= $this->call_center && $row['order_status'] == 0 ? 'bg-blue' : '' ?>">-->
            </tbody>
        </table>

        <!--end: Datatable -->
    </div>
</div><!-- /.row -->

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?= $this->lang->line('payment_link') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i aria-hidden="true" class="ki ki-close"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group row">
                    <label for="example-email-input" class="col-2 col-form-label"><?= $this->lang->line('payment_link') ?></label>
                    <div class="col-9 mt-3">
                        <p id="payment_link"></p>  
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                <button class="btn btn-primary font-weight-bold" onclick="copyToClipboard()"><?= $this->lang->line('copy') ?></button>
            </div> 
        </div>
    </div>
</div>

<?php $this->load->view('site/footer_2'); ?>



<script>function clear_date() {
        $("#start_expiry").val('');
    }
    function show_payment_link(order_id_encoded) {
        $("#payment_link").text('<?= base_url() ?>' + 'payment/pay/' + order_id_encoded);
        $("#myModal").modal('show');
    }
    function copyToClipboard() {
        var $temp = $("<div>");
        $("body").append($temp);
        $temp.attr("contenteditable", true)
                .html($("#payment_link").text()).select()
                .on("focus", function () {
                    document.execCommand('selectAll', false, null);
                })
                .focus();
        document.execCommand("copy");
        $temp.remove();
        $("#myModal").modal('hide');
        alert('Copied to the clipboard');
    }
</script>
<script>function alert_box(id) {
        var result = confirm("Are You Confirm!")
        if (result) {
            window.location.href = "<?= base_url('' . $this->thispage . '/del/') ?>" + id + "/<?= $this->call_center ?>";

        }

    }
    function toggle_filter() {
        $("#filter_container").toggle();
        $(".select2_plug").select2();
    }

    function newexportaction(e, dt, button, config) {
        var self = this;
        var oldStart = dt.settings()[0]._iDisplayStart;
        dt.one('preXhr', function (e, s, data) {
            // Just this once, load all data from the server...
            data.start = 0;
            data.length = 2147483647;
            dt.one('preDraw', function (e, settings) {
                // Call the original action function
                if (button[0].className.indexOf('buttons-copy') >= 0) {
                    $.fn.dataTable.ext.buttons.copyHtml5.action.call(self, e, dt, button, config);
                } else if (button[0].className.indexOf('buttons-excel') >= 0) {
                    $.fn.dataTable.ext.buttons.excelHtml5.available(dt, config) ?
                            $.fn.dataTable.ext.buttons.excelHtml5.action.call(self, e, dt, button, config) :
                            $.fn.dataTable.ext.buttons.excelFlash.action.call(self, e, dt, button, config);
                } else if (button[0].className.indexOf('buttons-csv') >= 0) {
                    $.fn.dataTable.ext.buttons.csvHtml5.available(dt, config) ?
                            $.fn.dataTable.ext.buttons.csvHtml5.action.call(self, e, dt, button, config) :
                            $.fn.dataTable.ext.buttons.csvFlash.action.call(self, e, dt, button, config);
                } else if (button[0].className.indexOf('buttons-pdf') >= 0) {
                    $.fn.dataTable.ext.buttons.pdfHtml5.available(dt, config) ?
                            $.fn.dataTable.ext.buttons.pdfHtml5.action.call(self, e, dt, button, config) :
                            $.fn.dataTable.ext.buttons.pdfFlash.action.call(self, e, dt, button, config);
                } else if (button[0].className.indexOf('buttons-print') >= 0) {
                    $.fn.dataTable.ext.buttons.print.action(e, dt, button, config);
                }
                dt.one('preXhr', function (e, s, data) {
                    // DataTables thinks the first item displayed is index 0, but we're not drawing that.
                    // Set the property to what it was before exporting.
                    settings._iDisplayStart = oldStart;
                    data.start = oldStart;
                });
                // Reload the grid with the original page. Otherwise, API functions like table.cell(this) don't work properly.
                setTimeout(dt.ajax.reload, 0);
                // Prevent rendering of the full data to the DOM
                return false;
            });
        });
        // Requery the server with the new one-time export settings
        dt.ajax.reload();
    }

    $(function () {
        $("#filter_container").hide();
        $("#order_status").select2();
        $(".select2_plug").select2();
        $("#list_table").DataTable({dom: 'Blfrtip', //was Bfrtip
                // Processing indicator
                "processing": true,
                // DataTables server-side processing mode
                "serverSide": true,
                // Initial no order.
                "pageLength": 50,
                // Load data from an Ajax source
                "ajax": {
                "url": "<?= base_url() ?>Orders/getOrder/<?= $this->call_center ?>/<?= $this->type ?>/<?= $this->order_status ?>",
                                        "type": "POST",
                                        "data": {data:'<?= json_encode($this->input->post()) ?>'}
                                },
                                //Set column definition initialisation properties
                                "columnDefs": [{
<?php if ($this->call_center) { ?>
                                    "targets": [0, 5, 6, 7, 8, 9],
<?php } else { ?>
                                    "targets": [0, 5, 6, 7],
<?php } ?>
                                "orderable": false
                                }],
                                buttons: [
                                {
                                extend: 'excel',
                                        titleAttr: 'Excel',
                                        action: newexportaction
                                },
//                                {
//                                extend: 'excelHtml5',
//                                        charset: 'UTF-16LE',
//                                        fieldSeparator: '\t',
//                                        bom: true,
//                                        action: newexportaction
//                                },
                                {
                                extend: 'csvHtml5',
                                        charset: 'UTF-16LE',
                                        fieldSeparator: '\t',
                                        titleAttr: 'CSV',
                                        bom: true,
                                        action: newexportaction
                                },
                                {
                                extend: 'pdfHtml5',
                                        charset: 'UTF-16LE',
                                        fieldSeparator: '\t',
                                        bom: true,
                                        action: newexportaction
                                },
                                {
                                extend: 'print',
                                        autoPrint: false,
                                        footer: true,
                                        action: newexportaction
                                }

                                ]
                        }
                        );
//            buttons: [
//                'copyHtml5',
//                'excelHtml5',
//                'csvHtml5',
//                'pdfHtml5'
//            ]
<?php if (get_license_per('order_status')) { ?>
                            var order_status = ['waiting', 'preparing', 'ready_for_deliver', 'delivering', 'delivered', 'canceled'];
                            $.ajax({
                                type: "POST",
                                url: "<?php echo base_url() ?>Orders/get_order_status_counts/<?= $this->call_center ?>",
                                            dataType: 'JSON',
                                            data: {data: '<?= json_encode($this->input->post()) ?>'},
                                            success: function (data) {
                                                for (var i = 0; i < order_status.length; i++) {
                                                    var count = data[order_status[i]];
                                                    if (count == null) {
                                                        count = 0;
                                                    }
                                                    $("#" + order_status[i]).text(count);
                                                }
                                                $("#all").text(data['all_data']);
                                            }
                                        });
                                    });
<?php } ?>

</script>
