<?php

class Payment_model extends CI_Model {

    function get_order($order_id) {
        $this->db->select("orders.*,sum(bills_orders.discount_remainder) as total_amount,bills_user.username,bills_user.id as customer_id,bills_user.phone,bills_user.phone_code,bills_user.email,avg(bills_orders.paid) as paid");
        $this->db->join('bills_orders', 'bills_orders.id_orders = orders.id');
        $this->db->join('bills_user', 'bills_user.id = bills_orders.id_user');
        $this->db->group_by('bills_orders.id_orders');
        return $this->db->get_where('orders', array('orders.id' => $order_id))->row();
    }

    function get_pay_orders() {
        $this->db->order_by('created_at', 'DESC');
        return $this->db->get('payment_orders')->result_array();
    }

    function get_pay_order($pay_id) {
        return $this->db->get_where('payment_orders', array('id' => $pay_id))->row();
    }

    function get_payment_order($pay_id) {
        $this->db->select('id,amount as total_amount,phone_code,phone,client_name as username,desc,payment_time');
        return $this->db->get_where('payment_orders', array('id' => $pay_id))->row();
    }

    function get_order_details($id) {
        $this->db->select('bills_orders.id,bills_producer.name as name_order,quantity,item_price,discount,discount_remainder,orders.discount_type,bills_producer.details_eng');
        $this->db->join('orders', 'orders.id = bills_orders.id_orders');
        $this->db->join('bills_producer', 'bills_producer.id = bills_orders.id_producer');
        return $this->db->get_where('bills_orders', array('id_orders' => $id))->result();
    }
    
    function get_payment_sett() {
        return $this->db->get('payment_settings')->row();
    }
    
    function get_payment_order_details($order_id) {

        $this->db->select('*,amount as total_amount,id,payment_details,payment_time');
        $order = $this->db->get_where('payment_orders', array('id' => $order_id))->row();
        if ($order) {
            if ($order->payment_details) {
                $tries = explode('/', $order->payment_details);

                $success_payment = $tries[count($tries) - 1];
                $pay_details = json_decode($success_payment);
                $order->ref_id = $pay_details->REFERENCE_ID;
                $order->trans_id = $pay_details->TRANSACTION_ID;
                $order->payment_id = $pay_details->PAYMENT_ID;
                $order->payment_status = $pay_details->PAYMENT_STATUS;
                $order->payment_gateway = 'Knet';
            }
            return $order;
        }
        return FALSE;
    }

}
