<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//error_reporting('E_ALL ^ E_NOTICE'); 
class Update extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->operator_id = $this->session->userdata("operator_id");

        //if(get_ap('task_plugin',$this->operator_id) ==1) { } else { redirect("","refresh");}
        //$this->load->model("Tag_Model");
    }

    // no longer used once we move the update section to the setting page (we use setting/index)
    function index() {
        if (!get_ap('update', $this->operator_id) == 1) {
            redirect("", "refresh");
        }
        /* if($this->input->server("REQUEST_METHOD")=="POST"){
          ini_get("upload_max_filesize");
          // pr($_FILES);die;
          if(!empty($_FILES['plugin']['name'])){
          // Set preference
          $config['upload_path'] = 'plugin_data/';
          $config['allowed_types'] = 'zip';
          $config['max_size'] = '100000120'; // max_size in kb (5 MB)
          $config['file_name'] = $_FILES['plugin']['name'];

          // Load upload library
          $this->load->library('upload',$config);

          // File upload
          if($this->upload->do_upload('plugin')){
          // Get data about the file
          $uploadData = $this->upload->data();
          $filename = $uploadData['file_name'];

          ## Extract the zip file ---- start
          $zip = new ZipArchive;
          $res = $zip->open("plugin_data/".$filename);
          if ($res === TRUE) {

          // Unzip path
          $extractpath = FCPATH;

          // Extract file
          $zip->extractTo($extractpath);
          $zip->close();
          $this->load->helper("file");
          delete_files("plugin_data/".$filename);
          $this->session->set_flashdata('message', 'Upload & Extract successfully.');
          } else {
          $this->session->set_flashdata('error', 'Failed to extract.');
          }
          redirect('plugin', 'refresh');
          }else{
          pr($errors = $this->upload->display_errors());
          $this->session->set_flashdata('error', 'Failed to upload');
          redirect('plugin', 'refresh');
          }
          }

          } */
        $data['new'] = $this->check();
        $data['title'] = "Update";
        $this->db->select("new_version,desc_version");
        $data['setting'] = $this->db->get('setting')->row();
        //pr($data['result']);die;
        $this->load->view("site/update/index", $data);
    }

    function update() {
        $token = $this->input->post('token');
        if ($token == $this->config->item('update_token')) {
            if ($this->check()) {
                $this->update_now(1);
            } else {
                echo json_encode(array('status' => 'error', 'msg' => 'system is up to date'));
            }
        } else {
            echo json_encode(array('status' => 'error', 'msg' => 'not authorized'));
        }
    }

    public function update_now($external = 0) {

        if (!file_exists('uploads/updates/')) {
            mkdir('uploads/updates/', 0777, true);
        }
        if (!file_exists('attachment/files/')) {
            mkdir('attachment/files/', 0777, true);
        }
        $this->db->select("new_version,desc_version");
        $setting = $this->db->get('setting')->row();
        $file_name = "bills-version-" . $setting->new_version . ".zip";
        $desgination_path = 'uploads/updates/' . $file_name;
        if (!file_exists($desgination_path)) {
            $file = file_get_contents("http://alolfa.org/bills/up/" . $file_name);
            file_put_contents('uploads/updates/' . $file_name, $file);
            //die;
        }
        $zip = new ZipArchive;
        $res = $zip->open($desgination_path);
        if ($res === TRUE) {

            // Unzip path
            $extractpath = FCPATH;

            // Extract file
            $zip->extractTo($extractpath);
            $zip->close();
            $this->load->helper("file");
            delete_files('uploads/updates');

            $data = array('current_version' => $setting->new_version);

            $this->db->update('setting', $data);
            //$this->Setting_Model->update($data);
            //$this->import();
            $this->update_language(0);
            //$this->import();
            $this->session->set_flashdata('message', 'Upload & Extract successfully.');
            if ($external) {
                $this->import();
                echo json_encode(array('status' => 'success', 'ver' => $setting->new_version));
            } else {
                redirect("update/import/2");
            }
            //redirect('admin/update', 'refresh');
        }
    }

    // no longer used once we move the update section to the setting page (we use setting/check_update)
    function check() {
        $this->db->select("new_version,desc_version,current_version");
        $setting = $this->db->get('setting')->row();
        $current_version = $setting->current_version;
        $file = file_get_contents("http://alolfa.org/bills/up/version.json");
        $array = json_decode($file);
        //pr($array);
        //$current_version."----".$array->version;
        if ($current_version != $array->version) {
            $next_version = $this->get_next_version($current_version);
            $data = array('new_version' => $next_version, 'desc_version' => $array->description);
            $this->db->update('setting', $data);
            return true;
        }
        return false;
    }

    function get_next_version($current_ver) {
        if (is_numeric($current_ver)) {
            return ++$current_ver;
        }
        $arr = explode('.', $current_ver);
        $n_ver = ++$arr[count($arr) - 1];
        $ver = '';
        for ($i = 0; $i < count($arr) - 1; $i++) {
            $ver .= $arr[$i] . '.';
        }
        $ver .= $n_ver;
        return $ver;
    }

    function show_json() {
        echo json_encode(array('version' => '0.0.0'));
    }

    function checking() {
        $data_array = array(
            'status' => 0
        );
        $this->db->select("new_version,desc_version,current_version");
        $setting = $this->db->get('setting')->row();
        $current_version = $setting->current_version;
        $file = file_get_contents("http://alolfa.org/bills/up/version.json");
        $array = json_decode($file);
        //pr($array);
        //$current_version."----".$array->version;
        if ($current_version != $array->version) {
            $data = array('new_version' => $array->version, 'desc_version' => $array->description);
            $this->db->update('setting', $data);
            $data_array = array(
                'version' => $array->version,
                'status' => 1,
                'description' => $array->description
            );
        }
        echo json_encode($data_array);
    }

    function import($yes = "") { // $yes =3 for external API
        $this->load->dbforge();

        //`department_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
        /* $this->dbforge->add_field($column,TRUE);
          $this->dbforge->create_table('department_3',TRUE);
          die; */
        /*
          $this->dbforge->add_field($column);
          $this->dbforge->add_key('id', TRUE);
          $this->dbforge->add_field("`department_update` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP");
          $this->dbforge->create_table('department_2'); */
        // pr($table);
        // $this->db->query('ALTER TABLE `bills_user` CHANGE `blocks` `blocks` VARCHAR(250) CHARACTER SET utf16 COLLATE utf16_general_ci NULL, CHANGE `sex` `sex` text CHARACTER SET utf16 COLLATE utf16_general_ci NULL, CHANGE `street` `street` VARCHAR(250) CHARACTER SET utf16 COLLATE utf16_general_ci NULL, CHANGE `jadah` `jadah` TEXT CHARACTER SET utf16 COLLATE utf16_general_ci NULL, CHANGE `floor` `floor` VARCHAR(50) CHARACTER SET utf16 COLLATE utf16_general_ci NULL, CHANGE `door_no` `door_no` INT(11) NULL, CHANGE `address_link` `address_link` VARCHAR(250) CHARACTER SET utf16 COLLATE utf16_general_ci NULL, CHANGE `create_on` `create_on` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP, CHANGE `pass` `pass` VARCHAR(130) CHARACTER SET utf8 COLLATE utf8_general_ci NULL, CHANGE `approve_status` `approve_status` TINYINT(1) NULL, CHANGE `block` `block` TINYINT(1) NULL, CHANGE `block_reason` `block_reason` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL, CHANGE `father_job` `father_job` VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL, CHANGE `mother_job` `mother_job` VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL, CHANGE `social_status` `social_status` VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL, CHANGE `total_points` `total_points` INT(11) NULL, CHANGE `total_balance` `total_balance` INT(11) NULL, CHANGE `student_tags` `student_tags` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL');
        //$this->db->query("ALTER TABLE `bills_producer` CHANGE `valuess` `valuess` FLOAT NULL DEFAULT '0'");

        $setting = array(
            'admin_default_lang' => array('type' => 'VARCHAR', 'constraint' => '10', 'after' => 'desc_version'),
            'student_default_lang' => array('type' => 'VARCHAR', 'constraint' => '10', 'after' => 'admin_default_lang'),
            'inv_footer' => array('type' => 'text', 'after' => 'student_default_lang'),
            'inv_footer_ar' => array('type' => 'text', 'after' => 'inv_footer'),
            'inv_footer_thermal' => array('type' => 'text', 'after' => 'inv_footer_ar'),
            'inv_footer_thermal_ar' => array('type' => 'text', 'after' => 'inv_footer_thermal'),
            'student_profile_customer_fields' => array('type' => 'text', 'after' => 'inv_footer_thermal_ar'),
            'inv_currency' => array('type' => 'VARCHAR', 'constraint' => '45', 'after' => 'student_profile_customer_fields'),
            'show_customer_fields' => array('type' => 'text', 'after' => 'inv_currency'),
            'student_can_edit_customer_fields' => array('type' => 'text', 'after' => 'show_customer_fields'),
            'sms_token' => array('type' => 'VARCHAR', 'constraint' => '20', 'after' => 'student_can_edit_customer_fields'),
            'sms_on_new_order' => array('type' => 'int', 'null' => FALSE, 'after' => 'sms_token'),
            'sms_on_in_delivery' => array('type' => 'int', 'null' => FALSE, 'after' => 'sms_on_new_order'),
            'sms_on_order_canceled' => array('type' => 'int', 'null' => FALSE, 'after' => 'sms_on_in_delivery'),
            'new_order_sms_content' => array('type' => 'text', 'null' => FALSE, 'after' => 'sms_on_order_canceled'),
            'in_delivery_sms_content' => array('type' => 'text', 'null' => FALSE, 'after' => 'new_order_sms_content'),
            'order_canceled_sms_content' => array('type' => 'text', 'null' => FALSE, 'after' => 'in_delivery_sms_content'),
            'driver_fields_show' => array('type' => 'text', 'null' => FALSE, 'after' => 'order_canceled_sms_content'),
            'driver_fields_edit' => array('type' => 'text', 'null' => FALSE, 'after' => 'driver_fields_show'),
            'expire_date' => array('type' => 'DATE', 'null' => true, 'after' => 'driver_fields_edit'),
            'inv_type' => array('type' => 'INT', 'after' => 'expire_date', 'comment' => '0->normal,1->thermal'),
            'inv_lang' => array('type' => 'INT', 'after' => 'inv_type', 'comment' => '0->eng,1->ar'),
            'system_status' => array('type' => 'INT', 'after' => 'inv_lang'),
            'payment_msg_sms_content' => array('type' => 'text', 'after' => 'order_canceled_sms_content'),
            'sms_on_payment_msg' => array('type' => 'int', 'after' => 'sms_on_order_canceled'),
            'terms_conditions_payment_page' => array('type' => 'text', 'after' => 'system_status'),
            'terms_conditions_payment_page_ar' => array('type' => 'text', 'after' => 'terms_conditions_payment_page'),
            'sms_on_pay_orders' => array('type' => 'int', 'after' => 'sms_on_payment_msg'),
            'pay_orders_sms_content' => array('type' => 'text', 'after' => 'sms_on_payment_msg'),
            'timezone' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'terms_conditions_payment_page_ar'),
            'sms_on_preparing' => array('type' => 'int', 'after' => 'sms_on_order_canceled'),
            'sms_on_delivered' => array('type' => 'int', 'after' => 'sms_on_preparing'),
            'preparing_sms_content' => array('type' => 'text', 'after' => 'order_canceled_sms_content'),
            'delivered_sms_content' => array('type' => 'text', 'after' => 'preparing_sms_content')
        );

        $kw_parent_categories = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'name' => array('type' => 'VARCHAR', 'constraint' => '255', 'after' => 'id'),
            'title' => array('type' => 'VARCHAR', 'constraint' => '255', 'after' => 'name'),
            'privacy_type' => array('type' => "enum('عام', 'كلمة مرور', 'مستخدمين', 'مجموعات')", 'after' => 'title'),
            'privacy_data' => array('type' => 'text', 'after' => 'privacy_type'),
            'primary_dalel' => array('type' => "enum('نعم', 'لا')", 'after' => 'privacy_data'),
            'created_at' => array('type' => 'timestamp', 'after' => 'primary_dalel')
        );

        $logs = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'action' => array('type' => 'text', 'after' => 'id'),
            'user_id' => array('type' => 'int', 'after' => 'action'),
            'date' => array('type' => 'timestamp', 'after' => 'user_id'),
            'user_type' => array('type' => 'int', 'after' => 'user_id', 'comment' => '0-> admin, 1-> driver'),
            'order_id' => array('type' => 'int', 'after' => 'user_type'),
            'new_status' => array('type' => 'int', 'after' => 'order_id')
        );

        $payment_orders = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'client_name' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'id'),
            'phone' => array('type' => 'VARCHAR', 'constraint' => '30', 'after' => 'client_name'),
            'amount' => array('type' => 'float', 'after' => 'phone'),
            'desc' => array('type' => 'text', 'after' => 'amount'),
            'payment_time' => array('type' => 'timestamp', 'after' => 'desc', 'null' => TRUE, 'default' => NULL),
            'created_at' => array('type' => 'TIMESTAMP', 'after' => 'payment_time'),
            'phone_code' => array('type' => 'VARCHAR', 'constraint' => 5, 'after' => 'client_name'),
            'payment_method' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'payment_time'),
            'TRACKING_ID' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'payment_method'),
            'payment_details' => array('type' => 'text', 'after' => 'TRACKING_ID'),
//            'STATUS' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'TRACKING_ID'),
//            'PAYMENT_STATUS' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'STATUS'),
//            'DESCRIPTION' => array('type' => 'TEXT', 'after' => 'PAYMENT_STATUS'),
//            'PAYMENT_ID' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'DESCRIPTION'),
//            'TRANSACTION_ID' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'PAYMENT_ID'),
//            'AMOUNT_FROM_GATEAWY' => array('type' => 'VARCHAR', 'constraint' => 45, 'after' => 'TRANSACTION_ID'),
//            'REFERENCE_ID' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'AMOUNT_FROM_GATEAWY'),
//            'AUTHORIZATION_ID' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'REFERENCE_ID'),
        );

        $kw_categories = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'name' => array('type' => 'VARCHAR', 'constraint' => '200', 'after' => 'id'),
            'parent_id' => array('type' => 'int', 'default' => '0', 'after' => 'name'),
            'category_order' => array('type' => 'int', 'after' => 'parent_id'),
            'created_at' => array('type' => 'timestamp', 'after' => 'category_order'),
        );

        $kw_articles = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'title' => array('type' => 'VARCHAR', 'constraint' => '200', 'after' => 'id'),
            'text' => array('type' => 'text', 'after' => 'title'),
            'creator_id' => array('type' => 'int', 'after' => 'text'),
            'category_id' => array('type' => 'int', 'after' => 'creator_id'),
            'created_at' => array('type' => 'timestamp', 'after' => 'category_id'),
            'check_comment' => array('type' => "enum('بلا تعليقات', 'تعليقات', 'تعليقات وردود')", 'after' => 'created_at'),
            'check_rate' => array('type' => "	enum('بلا تقييم', 'تقييم')", 'after' => 'check_comment'),
            'article_order' => array('type' => 'int', 'after' => 'check_rate'),
            'check_homepage' => array('type' => "enum('لا', 'نعم')", 'default' => 'لا', 'after' => 'article_order'),
            'yes_rate' => array('type' => 'int', 'after' => 'check_homepage'),
            'no_rate' => array('type' => 'int', 'after' => 'yes_rate')
        );

        $kw_article_rate = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'article_id' => array('type' => 'int', 'after' => 'id'),
            'user_id' => array('type' => 'int', 'after' => 'article_id'),
            'rate' => array('type' => "enum('نعم', 'لا')", 'after' => 'user_id'),
        );

        $kw_article_comments = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'article_id' => array('type' => 'int', 'after' => 'id'),
            'comment_text' => array('type' => 'text', 'after' => 'article_id'),
            'c_date' => array('type' => "date", 'after' => 'comment_text'),
            'user_type' => array('type' => "enum('logged', 'nonlogged')", 'after' => 'c_date'),
            'user_id' => array('type' => "int", 'after' => 'user_type'),
            'user_name' => array('type' => 'VARCHAR', 'constraint' => '255', 'after' => 'user_id'),
            'user_email' => array('type' => 'VARCHAR', 'constraint' => '255', 'after' => 'user_name'),
            'comment_status' => array('type' => "enum('معلق', 'منشور')", 'after' => 'user_email'),
        );

        $kw_article_reply = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'article_id' => array('type' => 'int', 'after' => 'id'),
            'comment_id' => array('type' => 'int', 'after' => 'article_id'),
            'reply_text' => array('type' => 'text', 'after' => 'comment_id'),
            'r_date' => array('type' => "date", 'after' => 'reply_text'),
            'user_type' => array('type' => "enum('logged', 'nonlogged')", 'after' => 'r_date'),
            'user_id' => array('type' => "int", 'after' => 'user_type'),
            'user_name' => array('type' => 'VARCHAR', 'constraint' => '255', 'after' => 'user_id'),
            'user_email' => array('type' => 'VARCHAR', 'constraint' => '255', 'after' => 'user_name'),
            'reply_status' => array('type' => "enum('معلق', 'منشور')", 'after' => 'user_email'),
        );

        $drivers = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'name' => array('type' => 'VARCHAR', 'constraint' => '70', 'after' => 'id'),
            'email' => array('type' => 'VARCHAR', 'constraint' => '45', 'after' => 'name'),
            'phone' => array('type' => 'VARCHAR', 'constraint' => '20', 'after' => 'email'),
            'country' => array('type' => 'int', 'after' => 'phone'),
            'status' => array('type' => 'int', 'after' => 'country'),
            'password' => array('type' => 'VARCHAR', 'constraint' => '45', 'after' => 'status'));

        $addresses = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'user_id' => array('type' => 'int', 'after' => 'id'),
            'region' => array('type' => 'text', 'after' => 'user_id'),
            'blocks' => array('type' => 'VARCHAR', 'constraint' => '250', 'after' => 'region'),
            'street' => array('type' => 'VARCHAR', 'constraint' => '250', 'after' => 'blocks'),
            'jadah' => array('type' => 'text', 'after' => 'street'),
            'building_num' => array('type' => 'VARCHAR', 'constraint' => '10', 'after' => 'jadah'),
            'floor' => array('type' => 'VARCHAR', 'constraint' => '50', 'after' => 'building_num'),
            'door_no' => array('type' => 'VARCHAR', 'constraint' => '50', 'after' => 'floor'),
            'address_link' => array('type' => 'text', 'after' => 'door_no'));

        $teachers = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'name' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'id'),
            'email' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'name'),
            'phone' => array('type' => 'VARCHAR', 'constraint' => '20', 'after' => 'email'),
            'nationality' => array('type' => 'VARCHAR', 'constraint' => '70', 'after' => 'phone'),
            'date_of_birth' => array('type' => 'date', 'null' => TRUE, 'default' => NULL, 'after' => 'nationality'),
            'pass' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'date_of_birth'),
            'files' => array('type' => 'text', 'after' => 'pass'),
            'notes' => array('type' => 'text', 'after' => 'files'),
            'approve_status' => array('type' => 'tinyint', 'after' => 'notes'),
            'student_tags' => array('type' => 'text', 'after' => 'approve_status'),
        );

        $tickets = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'title' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'id'),
            'desc' => array('type' => 'text', 'after' => 'title'),
            'priority' => array('type' => 'int', 'after' => 'desc', 'comment' => '0->high,1->medium,2->low'),
            'client_id' => array('type' => 'int', 'after' => 'priority'),
            'dept_id' => array('type' => 'int', 'after' => 'client_id'),
            'type' => array('type' => 'int', 'after' => 'dept_id', 'comment' => '0->inquiry,1->complaint,2->suggestion'),
            'status' => array('type' => 'int', 'after' => 'type', 'comment' => '0->open,1->in progress,2->answered,3->on hold,4->closed'),
            'created_by' => array('type' => 'int', 'after' => 'status'),
            'created_at' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'after' => 'created_by'),
            'last_reply_time' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'after' => 'created_at'));

        $tickets_reply = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'created_by' => array('type' => 'int', 'after' => 'id'),
            'created_at' => array('type' => 'timestamp', 'null' => FALSE, 'after' => 'created_by'),
            'reply' => array('type' => 'text', 'after' => 'created_at'),
            'ticket_id' => array('type' => 'int', 'after' => 'reply'));

        $pts_tags = array(
            'tag_id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'user_type' => array('type' => 'INT', 'after' => 'tag_id'),
            'user_id' => array('type' => 'INT', 'after' => 'user_type'),
            'tag_name' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'user_id'),
            'tagupdated_at' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'default' => 'CURRENT_TIMESTAMP', 'after' => 'tag_name')
        );

        $pts_barcode = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'student_point' => array('type' => 'bigint', 'after' => 'id'),
            'scan_code' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'user_type'),
            'notes_id' => array('type' => 'INT', 'after' => 'scan_code'),
            'student_code' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'notes_id'),
            'category_id' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'student_code'),
            'discount_reason' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'category_id'),
            'barcode' => array('type' => 'VARCHAR', 'constraint' => '500', 'after' => 'discount_reason'),
            'student_id' => array('type' => 'INT', 'after' => 'barcode', 'null' => TRUE, 'default' => NULL,),
            'member_id' => array('type' => 'INT', 'after' => 'student_id', 'null' => TRUE, 'default' => NULL,),
            'barcode_status' => array('type' => 'INT', 'after' => 'member_id'),
            'credit_date' => array('type' => 'date', 'after' => 'barcode_status'),
            'time' => array('type' => 'datetime', 'null' => FALSE, 'default' => 'CURRENT_TIMESTAMP', 'after' => 'credit_date'),
        );

        $bills_user = array(
            'total_points' => array('type' => 'INT', 'after' => 'social_status'),
            'total_balance' => array('type' => 'INT', 'after' => 'total_points'),
            'student_tags' => array('type' => 'TEXT', 'after' => 'total_balance'),
            'building_num' => array('type' => 'VARCHAR', 'constraint' => '10', 'after' => 'jadah'),
            'name' => array('type' => 'VARCHAR', 'constraint' => '300', 'after' => 'username'),
            'phone_code' => array('type' => 'VARCHAR', 'constraint' => 5, 'after' => 'cid_user')
        );

        $pts_award_history = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'member_id' => array('type' => 'INT', 'after' => 'id'),
            'user_id' => array('type' => 'INT', 'after' => 'member_id'),
            'award_id' => array('type' => 'INT', 'after' => 'user_id'),
            'award_history_point' => array('type' => 'INT', 'after' => 'award_id'),
            'memo' => array('type' => 'text', 'after' => 'award_history_point'),
            'award_status' => array('type' => 'INT', 'after' => 'memo'),
            'h_update_on' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'default' => 'CURRENT_TIMESTAMP', 'after' => 'award_status')
        );

        $pts_student_history = array(
            'history_id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'stud_id' => array('type' => 'INT', 'after' => 'history_id'),
            'type' => array('type' => 'INT', 'after' => 'stud_id'),
            'points' => array('type' => 'INT', 'after' => 'type'),
            'balance' => array('type' => 'INT', 'after' => 'points'),
            'category' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'balance'),
            'notes' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'category'),
            'discount' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'notes'),
            'award_id' => array('type' => 'INT', 'after' => 'discount'),
            'barcode_id' => array('type' => 'INT', 'after' => 'award_id'),
            'member_id' => array('type' => 'INT', 'after' => 'barcode_id'),
            'memo_notes' => array('type' => 'TEXT', 'after' => 'member_id'),
            'upload_filename' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'memo_notes'),
            'update_on' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'default' => 'CURRENT_TIMESTAMP', 'after' => 'upload_filename')
        );

        $pts_award = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'award_name' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'id'),
            'award_point' => array('type' => 'INT', 'after' => 'award_name'),
            'award_point_type' => array('type' => 'INT', 'NULL' => TRUE, 'after' => 'award_point'),
            'award_status' => array('type' => 'INT', 'after' => 'award_point_type'),
            'aupdated_on' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'default' => 'CURRENT_TIMESTAMP', 'after' => 'award_status')
        );

        $pts_category = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'category_name' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'id'),
            'category_type' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'category_name'),
            'points' => array('type' => 'INT', 'NULL' => TRUE, 'after' => 'category_type'),
            'points_for' => array('type' => 'INT', 'NULL' => TRUE, 'after' => 'points'),
            'category_slug' => array('type' => 'VARCHAR', 'constraint' => '256', 'after' => 'points_for'),
            'category_status' => array('type' => 'INT', 'after' => 'category_slug'),
            'category_update' => array('type' => 'TIMESTAMP', 'null' => FALSE, 'default' => 'CURRENT_TIMESTAMP', 'after' => 'award_status')
        );

        $quran_tsme3 = array(
            'notes' => array('type' => 'TEXT', 'after' => 'lines_count')
        );

        $quraan_sessions = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'title' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'id')
        );

        $quraan_session_students = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'session_id' => array('type' => 'INT', 'after' => 'id'),
            'student_id' => array('type' => 'INT', 'after' => 'session_id'),
            'created_at' => array('type' => 'TIMESTAMP', 'after' => 'student_id')
        );

        $quraan_session_teachers = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'session_id' => array('type' => 'INT', 'after' => 'id'),
            'teacher_id' => array('type' => 'INT', 'after' => 'session_id'),
        );

        $quraan_sessions_plans = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'quraan_session_students_id' => array('type' => 'INT', 'after' => 'id'),
            'type' => array('type' => 'INT', 'after' => 'quraan_session_students_id'),
            'date_from' => array('type' => 'date', 'after' => 'type'),
            'date_to' => array('type' => 'date', 'after' => 'date_from'),
            'sessions_count_per_week' => array('type' => 'int', 'after' => 'date_to'),
            'lines_count_per_session' => array('type' => 'float', 'after' => 'sessions_count_per_week'),
            'expected_lines_count' => array('type' => 'int', 'after' => 'lines_count_per_session'),
            'expected_page_count' => array('type' => 'float', 'after' => 'expected_lines_count'),
            'sessions_count' => array('type' => 'int', 'after' => 'expected_page_count'),
            'from_surah' => array('type' => 'int', 'after' => 'sessions_count'),
            'from_ayah' => array('type' => 'int', 'after' => 'from_surah'),
            'to_surah' => array('type' => 'int', 'after' => 'from_ayah'),
            'to_ayah' => array('type' => 'int', 'after' => 'to_surah'));

        $additions = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'name_en' => array('type' => 'varchar', 'constraint' => 100, 'after' => 'id'),
            'name_ar' => array('type' => 'varchar', 'constraint' => 100, 'after' => 'name_en'),
            'price' => array('type' => 'float', 'after' => 'name_ar'),
            'group_name' => array('type' => 'varchar', 'constraint' => 300, 'after' => 'price'),
            'active' => array('type' => 'int', 'after' => 'group_name'));

        $product_additions = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'product_id' => array('type' => 'INT', 'after' => 'id'),
            'title_en' => array('type' => 'varchar', 'constraint' => 100, 'after' => 'product_id'),
            'title_ar' => array('type' => 'varchar', 'constraint' => 100, 'after' => 'title_en'),
            'choice_type' => array('type' => 'int', 'after' => 'title_ar'),
            'required' => array('type' => 'int', 'after' => 'choice_type'),
            'options' => array('type' => 'text', 'after' => 'required'));

        $order_products_additions = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'order_product_id' => array('type' => 'INT', 'after' => 'id'),
            'product_addition_id' => array('type' => 'INT', 'after' => 'order_product_id'),
            'choice_id' => array('type' => 'varchar', 'constraint' => 300, 'after' => 'product_addition_id')
        );

        $orders = array(
            'order_status' => array('type' => 'int', 'null' => FALSE, 'default' => 0, 'after' => 'timestamp', 'comment' => '0-> waiting,1->preparing,2->delivering,3->delivered,4->canceled'),
            'call_center' => array('type' => 'int', 'null' => FALSE, 'default' => 0, 'after' => 'order_status'),
            'payment_method' => array('type' => 'int', 'null' => FALSE, 'default' => 0, 'after' => 'call_center', 'comment' => '0->cash,1->knet,2->visa/master,3->link'),
            'delivery_status' => array('type' => 'int', 'null' => FALSE, 'default' => 0, 'after' => 'payment_method'),
            'expected_delivery_time' => array('type' => 'timestamp', 'null' => TRUE, 'Default' => NULL, 'after' => 'delivery_status'),
            'delivery_details' => array('type' => 'text', 'after' => 'expected_delivery_time'),
            'driver' => array('type' => 'int', 'null' => FALSE, 'after' => 'delivery_details'),
            'created_by' => array('type' => 'int', 'after' => 'call_center'),
            'type' => array('type' => 'int', 'after' => 'timestamp', 'COMMENT' => '0 -> order , 1->reservation'),
            'address_id' => array('type' => 'int', 'after' => 'driver'),
            'discount_type' => array('type' => 'int', 'after' => 'address_id'),
            'delivery_type' => array('type' => 'int', 'after' => 'created_by'),
            'payment_time' => array('type' => 'TIMESTAMP', 'null' => TRUE, 'DEFAULT' => NULL, 'after' => 'payment_method'),
            'TRACKING_ID' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'payment_time'),
            'payment_details' => array('type' => 'text', 'after' => 'TRACKING_ID'),
//            'STATUS' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'TRACKING_ID'),
//            'PAYMENT_STATUS' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'STATUS'),
//            'DESCRIPTION' => array('type' => 'TEXT', 'after' => 'PAYMENT_STATUS'),
//            'PAYMENT_ID' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'DESCRIPTION'),
//            'TRANSACTION_ID' => array('type' => 'VARCHAR', 'constraint' => 200, 'after' => 'PAYMENT_ID'),
//            'AMOUNT_FROM_GATEAWY' => array('type' => 'VARCHAR', 'constraint' => 45, 'after' => 'TRANSACTION_ID'),
//            'REFERENCE_ID' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'AMOUNT_FROM_GATEAWY'),
//            'AUTHORIZATION_ID' => array('type' => 'VARCHAR', 'constraint' => 100, 'after' => 'REFERENCE_ID'),
        );

        $setting_permission = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'permission_name' => array('type' => 'VARCHAR', 'constraint' => '100', 'after' => 'id'),
            'permission_status' => array('type' => 'int', 'after' => 'permission_name'),
            'permission_limit' => array('type' => 'int', 'after' => 'permission_status')
        );

        $bills_orders = array(
            'comment' => array('type' => 'text', 'after' => 'quantity'),
            'item_price' => array('type' => 'float', 'after' => 'date_now'));

        $bills_producer = array(
            'arabic_name' => array('type' => 'varchar', 'constraint' => '300', 'after' => 'name'),
            'details_eng' => array('type' => 'text', 'after' => 'arabic_name'),
            'details_ar' => array('type' => 'text', 'after' => 'details_eng'),
            'brand' => array('type' => 'varchar', 'constraint' => '300', 'after' => 'teacher_id'),
            'code' => array('type' => 'varchar', 'constraint' => '20', 'after' => 'brand'),
            'barcode_symbology' => array('type' => 'varchar', 'constraint' => '55', 'after' => 'code')
        );

        $payment_settings = array(
            'id' => array('type' => 'INT', 'unsigned' => TRUE, 'auto_increment' => TRUE, 'first' => TRUE),
            'status' => array('type' => 'INT', 'constraint' => '100', 'after' => 'id'),
            'type' => array('type' => 'INT', 'constraint' => '100', 'after' => 'status'),
            'tap_public_key' => array('type' => 'varchar', 'constraint' => '200', 'after' => 'type'),
            'tap_merchant_id' => array('type' => 'varchar', 'constraint' => '100', 'after' => 'tap_public_key'),
            'knet_transportal_id' => array('type' => 'varchar', 'constraint' => 20, 'after' => 'tap_merchant_id'),
            'knet_transportal_password' => array('type' => 'varchar', 'constraint' => 20, 'after' => 'knet_transportal_id'),
            'knet_terminal_resource_key' => array('type' => 'varchar', 'constraint' => 30, 'after' => 'knet_transportal_password'),
            'knet_testing_env' => array('type' => 'INT', 'after' => 'knet_terminal_resource_key')
        );

        $table = array('setting' => $setting,
            'teachers' => $teachers,
            'pts_tags' => $pts_tags,
            'bills_user' => $bills_user,
            'pts_student_history' => $pts_student_history,
            'pts_award' => $pts_award,
            'pts_category' => $pts_category,
            'pts_award_history' => $pts_award_history,
            'pts_barcode' => $pts_barcode,
            'quran_tsme3' => $quran_tsme3,
            'quraan_sessions' => $quraan_sessions,
            'quraan_session_students' => $quraan_session_students,
            'quraan_session_teachers' => $quraan_session_teachers,
            'quraan_sessions_plans' => $quraan_sessions_plans,
            'orders' => $orders,
            'tickets' => $tickets,
            'tickets_reply' => $tickets_reply,
            'drivers' => $drivers,
            'addresses' => $addresses,
            'bills_producer' => $bills_producer,
            'bills_orders' => $bills_orders,
            'kw_parent_categories' => $kw_parent_categories,
            'kw_categories' => $kw_categories,
            'kw_articles' => $kw_articles,
            'kw_article_rate' => $kw_article_rate,
            'kw_article_comments' => $kw_article_comments,
            'kw_article_reply' => $kw_article_reply,
            'setting_permission' => $setting_permission,
            'payment_orders' => $payment_orders,
            'payment_settings' => $payment_settings,
            'logs' => $logs,
            'additions' => $additions,
            'product_additions' => $product_additions,
            'order_products_additions' => $order_products_additions);



        foreach ($table as $key => $column_arr) {
            /* echo $key;
              echo "<br>"; */
            if ($this->db->table_exists($key)) {
                foreach ($column_arr as $key2 => $value2) {
                    if (!$this->db->field_exists($key2, $key)) {

                        $new_arr = array($key2 => $value2);
                        //pr($new_arr);
                        $this->dbforge->add_column($key, $new_arr);
                    }
                }
            } else {
                $this->dbforge->add_field('id');
                $this->dbforge->add_field($column_arr, FALSE);
                $this->dbforge->create_table($key);

                if ($key == "setting_permission") {

                    $sql = "INSERT INTO `$key` (`id`, `permission_name`, `permission_status`, `permission_limit`) VALUES
                    (1, 'sales', 1, 0),
(2, 'products', 1, 0),
(3, 'call_center', 1, 0),
(4, 'drivers', 1, 0),
(5, 'support', 1, 0),
(6, 'attendance', 1, 0),
(7, 'points', 1, 0),
(8, 'quraan_sessions', 1, 0),
(9, 'accountant', 1, 0),
(10, 'language', 1, 0),
(11, 'data_managment', 1, 0),
(12, 'advs_msgs', 1, 0),
(13, 'knowledge_base', 1, 0),
(14, 'order_status', 1, 0)";
                    $this->db->query($sql);
                    //  $this->db->update('setting', array('system_status' => 1));
                }
            }
        }
        $order_status_exist = $this->db->get_where('setting_permission', array('permission_name' => 'order_status'))->row();
        if (!$order_status_exist) {
            $this->db->insert('setting_permission', array('permission_name' => 'order_status', 'permission_status' => 1, 'permission_limit' => 0));
        }
        if ($yes == 1) {
            $this->session->set_flashdata('message', 'Successfully Imported ');
            redirect('Dashboard/update', 'refresh');
        }
        if ($yes == 2) {
            $this->session->set_flashdata('message', 'Upload & Extract successfully.');
            redirect('update', 'refresh');
        }
        if ($yes == 3) {
            echo json_encode(array('status' => 'success'));
        }
        return true;
        /* $this->session->set_flashdata('message', 'Successfully Imported ');
          redirect('setting', 'refresh'); */
        /* if (!$this->db->field_exists('multi_user', 'department'))
          {
          echo "-------";
          } */
    }

    public function update_language($yes = 1) {
        $json = file_get_contents("http://alolfa.org/bills/update/get_language");
        $array = json_decode($json);

        if ($array) {
            $data_arr = array();
            foreach ($array as $key => $value) {
                //echo $value->label;die;
                $this->db->where('label', $value->label);
                $num_rows = $this->db->get('language')->num_rows();
                //1echo $num_rows;echo "<br>";
                if ($num_rows == 0) {
                    $data_arr[] = array(
                        'english' => $value->english,
                        'arabic' => $value->arabic,
                        'label' => $value->label,
                            // 'page' => $value->page
                    );
                }
            }
            if ($data_arr)
                $this->db->insert_batch('language', $data_arr);
            if ($yes == 1) {
                $this->session->set_flashdata('message', 'Successfully Imported ');
                redirect('update', 'refresh');
            }
        }
    }

    function get_language() {
        $lang = $this->db->get('language')->result();
        echo json_encode($lang);
    }

}
