<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Group extends MY_Controller {

    var $cats;
    var $thispage;

    public function __construct() {
        parent::__construct();
        $this->load->model('booking');
        $this->load->model('Language_Model');
        $this->thispage = "group";
        $this->operator_id = $this->session->userdata("operator_id");
        if (get_ap('group', $this->operator_id) == 1) {
            
        } else {
            redirect("", "refresh");
        }
    }

    function lang($lang) {
        $this->session->set_userdata("language", $lang);
        redirect("", "refresh");
    }

    public function index($cats = 1) {
        if (!get_ap('group', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->cats = $cats;
        $this->all($cats, 1);
    }

    public function all() {

        // $this->db->from('groups');
        $this->db->order_by('id', 'asc');
        $data['result'] = $this->db->get('groups')->result();
        $data['title'] = $this->lang->line('group');
        // $data['view'] = '../controllers/views/' . $this->thispage . '/all';
        $data['thispage'] = $this->thispage;
        $this->load->view('site/' . $this->thispage . '/all', $data);
    }

    public function add() {
        if (!get_ap('group_add', $this->operator_id)) {
            redirect("", "refresh");
        }
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('group', 'group', 'trim|required');
            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $add = TRUE;
                $data = array(
                    'groups' => $this->input->post('group'),
                    'create_on' => date("Y-m-d h:m:sa"),
                );

                $result = $this->db->insert('groups', $data);
                if ($result) {
                    $this->session->set_flashdata('msg', 'success');
                    redirect(base_url('' . $this->thispage . '/all/'));
                }
            }
        }
        if (!$add) {
            $data['title'] = 'group';
            $data['thispage'] = 'group';
            // $data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/' . $this->thispage . '/add', $data);
        }
    }

    public function edit($id = "") {
        if (!get_ap('group_edit', $this->operator_id)) {
            redirect("", "refresh");
        }
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $data = $this->input->post();
            $data['last_update'] = date('Y-m-d h:m:sa');
            $data['groups'] = $this->input->post('group');
            unset($data['group']);

            $this->db->where('id', $id);
            $result = $this->db->update('groups', $data);
            // echo $this->db->last_query();die();
            if ($result) {
                $this->session->set_flashdata('msg', 'change successfully');
                redirect(base_url('' . $this->thispage . '/all/'));
            }
        }
        $this->db->from('groups');
        $this->db->where('id', $id);
        $data['result'] = $this->db->get()->row();
        $data['title'] = 'edit';
        $data['thispage'] = 'groups';
        // $data['view'] = '../controllers/views/' . $this->thispage . '/edit';
        $this->load->view('site/' . $this->thispage . '/edit', $data);
    }

    public function permission($id) {
        if (!get_ap('group_permission', $this->operator_id)) {
            redirect("", "refresh");
        }
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $data_array = $this->input->post();
            foreach ($data_array as $key => $value) {
                $array[] = array(
                    'operator_id' => $id,
                    'permission_name' => $key,
                    'permission_status' => $value
                );
            }
            // $data['last_update'] = date('Y-m-d h:m:sa');
            $this->db->where('operator_id', $id);
            $this->db->delete('permission');
            $result = $this->db->insert_batch('permission', $array);
            if ($result) {
                $this->session->set_flashdata('msg', 'change successfully');
                redirect(base_url('' . $this->thispage . '/permission/' . $id));
            }
        }
        $this->db->from('groups');
        $this->db->where('id', $id);
        $data['result'] = $this->db->get('')->result();
        $data['title'] = $this->lang->line('permission');
        $data['thispage'] = 'groups';
        // $data['view'] = '../controllers/views/' . $this->thispage . '/permission';
        // $this->load->view('../controllers/views/layout', $data);
        $this->load->view('site/' . $this->thispage . '/permission', $data);
    }

    public function delete($id = "") {
        if (!get_ap('group_del', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->db->where('id', $id);
        $result = $this->db->delete('groups');
        if ($result) {
            $this->session->set_flashdata('msg', 'delete successfully');
            redirect(base_url('' . $this->thispage . '/all/'));
        }
    }

}

?>