ClassicEditor
    .create(document.querySelector('#editor'), {

        toolbar: {
            items: [
                'heading',
                '|',
                'bold',
                'italic',
                'underline',
                'link',
                'bulletedList',
                'numberedList',
                'fontColor',
                'highlight',
                'fontBackgroundColor',
                'fontSize',
                'fontFamily',
                '|',
                'indent',
                'outdent',
                'alignment',
                'codeBlock',
                'code',
                'horizontalLine',
                'pageBreak',
                '|',
                'imageUpload',
                'blockQuote',
                'insertTable',
                'mediaEmbed',
                'undo',
                'redo'
            ]
        },
        language: 'ar',
        image: {
            toolbar: [
                'imageTextAlternative',
                'imageStyle:full',
                'imageStyle:side'
            ]
        },
        table: {
            contentToolbar: [
                'tableColumn',
                'tableRow',
                'mergeTableCells',
                'tableCellProperties',
                'tableProperties'
            ]
        },
        cloudServices: {
            uploadUrl: 'http://almukaimi.site/assets/uploads/'
        },
        licenseKey: '',

    })
    .then(editor => {
        window.editor = editor;
    })
    .catch(error => {
        console.error('Oops, something went wrong!');
        console.error('Please, report the following error on https://github.com/ckeditor/ckeditor5/issues with the build id and the error stack trace:');
        console.warn('Build id: aveedjdm4wi7-ecw5ykx9glj6');
        console.error(error);
    });