<!DOCTYPE html>
<html lang="en">
    <!-- begin::Head -->
    <head>
        <base href="">
        <meta charset="utf-8" />
        <title><?php echo $title; ?></title>
        <meta name="description" content="Updates and statistics">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">

        <?php
        if ($this->session->userdata('language') == "english") {
            $language_set = "arabic";
        } else {
            $language_set = "english";
        } if ($language_set == "english") {
            ?>
        <?php } else { ?>
            <link href="<?php echo base_url() ?>public/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
            <link href="<?php echo base_url() ?>public/css/style.bundle.css" rel="stylesheet" type="text/css" />
            <link href="<?php echo base_url() ?>public/css/skins/header/base/light.css" rel="stylesheet" type="text/css" />
            <link href="<?php echo base_url() ?>public/css/skins/header/menu/light.css" rel="stylesheet" type="text/css" />
            <link href="<?php echo base_url() ?>public/css/skins/brand/dark.css" rel="stylesheet" type="text/css" />
            <link href="<?php echo base_url() ?>public/css/skins/aside/dark.css" rel="stylesheet" type="text/css" />
            <?php
        } $this->load->view('site/layout');
        $this->load->view('site/navbar');
        ?>
    <div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

        <!-- begin:: Subheader -->
        <div class="kt-subheader   kt-grid__item" id="kt_subheader">
            <div class="kt-container  kt-container--fluid ">
                <div class="kt-subheader__main">
                    <h3 class="kt-subheader__title">
                        <a href="<?php echo base_url() ?>Dashboard">	<?php echo $this->lang->line('dashboard') ?> </a></h3>
                    <span class="kt-subheader__separator kt-hidden"></span>
                    <div class="kt-subheader__breadcrumbs">
                        <a href="#" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
                        <span class="kt-subheader__breadcrumbs-separator"></span>
                        <a href="" class="kt-subheader__breadcrumbs-link">
                            <?php echo $this->lang->line('add-attendance') ?> </a>
                        <span class="kt-subheader__breadcrumbs-separator"></span>
                    </div>
                </div>
            </div>
        </div>
        <!-- end:: Subheader -->
        <!-- begin:: Content -->
        <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
            <div class="row">
                <div class="col-md-12">



                    <!--begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">	<?php echo $this->lang->line('add') ?> 	<?php echo $this->lang->line('absent') ?></h3>
                            </div>
                            <?php if (get_ap('show_attendance', $this->operator_id)) { ?>
                                <div class="kt-portlet__head-toolbar">
                                    <div class="kt-portlet__head-wrapper">
                                        <div class="kt-portlet__head-actions">
                                                <a href="<?= base_url() ?>/user/absent_show" class="btn btn-brand btn-elevate btn-icon-sm">
                                                    <i class="la la-eye"></i>
                                                    <?php echo $this->lang->line('show_attendance') ?>
                                                </a>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="kt-portlet__body">

                            <?php if (isset($exist)) { ?>
                                <div class="alert alert-danger alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <h4><i class="icon fa-warning"></i> ERROR!  </h4>&nbsp;
                                    <?php
                                    echo $this->lang->line('repeated_names') . ': <br/>';
                                    foreach ($exist as $ele) {
                                        echo $ele . '<br/>';
                                    }
                                    ?>
                                </div>
                            <?php } ?>  


                            <?php if (validation_errors() !== ''): ?>
                                <div class="alert alert-danger alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <h4><i class="icon fa-warning"></i> Alert!</h4>&nbsp;
                                    <?= validation_errors(); ?>
                                </div>
                            <?php endif; ?>   

                            <?php if ($this->session->flashdata('success')): ?>
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <h4><i class="icon fa-warning"></i> Success!</h4>&nbsp;
                                    <?= $this->lang->line('op_success'); ?>
                                </div>
                            <?php endif; ?>   

                            <?php if (get_ap('attendance_add', $this->operator_id)) { ?>
                                <!--begin::Form-->
                                <form class="kt-form" method="post" action="">
                                    <div class="form-group row">
                                        <label class="col-3 col-form-label">	<?php echo $this->lang->line('date') ?></label>
                                        <input type="text" name="date" class="form-control datepicker_single col-9" id="datepicker" readonly >
                                    </div>


                                    <div class="form-group row">
                                        <label class="col-3 col-form-label">	<?php echo $this->lang->line('products') ?></label>
                                        <div class="col-9" style="padding-left: 0px">
                                            <select name="product" id="products" class="topnav form-control" >
                                                <option value><?= $this->lang->line('select') ?></option>
                                                <?php
                                                foreach ($products as $value) {
                                                    $selected = '';
                                                    if ($this->input->post() && $value->id == $this->input->post('product')) {
                                                        $selected = 'selected';
                                                    }
                                                    ?>
                                                    <option <?= $selected ?> value="<?= $value->id ?>"><?= $value->name ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <br/>
                                    <div id="students">

                                    </div>

                                    <div class="text-center">
                                        <table class="table table-bordered table-hover col-5" style="display: inline-table">
                                            <tr>
                                                <td><?= $this->lang->line('attendance') ?></td>
                                                <td id="count_1" class="counter">0</td>
                                            </tr>
                                            <tr>
                                                <td><?= $this->lang->line('absent') ?></td>
                                                <td id="count_0" class="counter">0</td>
                                            </tr>
                                            <tr>
                                                <td><?= $this->lang->line('late') ?></td>
                                                <td id="count_2" class="counter">0</td>
                                            </tr>
                                            <tr>
                                                <td><?= $this->lang->line('total') ?></td>
                                                <td id="count_total" class="counter">0</td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!--                                    <div class="form-group row">
                                                                            <label class="col-3 col-form-label"><?php echo $value->username; ?></label>
                                                                            <div class="col-5">
                                                                                <div class="kt-radio-inline ">
                                                                                    <label class="kt-radio kt-radio--success">
                                                                                        <input type="radio" name="absent[<?php echo $value->id; ?>]" value="1" ><?php echo $this->lang->line('present') ?>
                                                                                        <span></span>
                                                                                    </label>
                                                                                    <label class="kt-radio kt-radio--danger">
                                                                                        <input type="radio" name="absent[<?php echo $value->id; ?>]" value="0"> <?php echo $this->lang->line('absent') ?>
                                                                                        <span></span>
                                                                                    </label>
                                                                                    <label class="kt-radio kt-radio--brand">
                                                                                        <input type="radio" name="absent[<?php echo $value->id; ?>]" value="2"> <?php echo $this->lang->line('late') ?> <?php echo $this->lang->line('present') ?>
                                                                                        <span></span>
                                                                                    </label>
                                                                                </div>
                                                                                 <span class="form-text text-muted">Some help text goes here</span> 
                                                                            </div>		
                                    
                                                                        </div>-->


                                </form>
                            <?php } ?>
                            <!--end::Form-->
                        </div>
                    </div>

                    <!--end::Portlet-->

                </div>

            </div>
        </div>

        <!-- end:: Content -->
    </div>

    <!-- begin:: Footer -->
    <?php $this->load->view('site/footer_2'); ?>
    <script>
        $(function () {
            $("#datepicker").datepicker({format: 'yyyy-mm-dd', todayHighlight: true, autoclose: true});

<?php
if (isset($exist)) {
    foreach ($exist as $ex) {
        ?>
                    $(".selected-label").each(function () {
                        if ($(this).text() == "<?= $ex ?>") {
                            $(this).parent('.selected-wrapper').css({'background-color': '#fcaba7'});
                        }
                    });
        <?php
    }
}
?>
            $("#products").change(function () {
                get_students();
            });
            $("#datepicker").change(function () {
                get_students();
            });

            $(document).on("change", "input[type='radio']", function () {
                $(".counter").text('0');
                $("input[type='radio']").each(function () {
                    if ($(this).prop('checked')) {
                        var target = parseInt($("#count_" + $(this).val()).text());
                        var total = parseInt($("#count_total").text());
                        $("#count_" + $(this).val()).text(++target);
                        $("#count_total").text(++total);
                    }
                });
            });
        });

        function get_students() {
            if ($("#datepicker").val() == '' || $("#products").val() == '') {
                return;
            }
            $.ajax({
                type: "POST",
                url: "<?php echo base_url() ?>user/get_active_users",
                data: {'product': $("#products").val(), 'date': $("#datepicker").val()},
                dataType: 'JSON',
                success: function (data) {
                    $("#students").html('');
                    for (var i = 0; i < data.length; i++) {
                        $("#students").append('<div class="form-group row">\n\
                                                <label class="col-3 col-form-label">' + data[i].name + '</label>\n\
                                                <div class="col-5">\n\
                                                    <div class="kt-radio-inline ">\n\
                                                        <label class="kt-radio kt-radio--success">\n\
                                                            <input type="radio" name="absent[' + data[i].id_user + ']" value="1" ><?php echo $this->lang->line('present') ?>\n\
                                                            <span></span>\n\
                                                        </label>\n\
                                                        <label class="kt-radio kt-radio--danger">\n\
                                                            <input type="radio" name="absent[' + data[i].id_user + ']" value="0"> <?php echo $this->lang->line('absent') ?>\n\
                                                            <span></span>\n\
                                                        </label>\n\
                                                        <label class="kt-radio kt-radio--brand">\n\
                                                            <input type="radio" name="absent[' + data[i].id_user + ']" value="2"> <?php echo $this->lang->line('late') ?> <?php echo $this->lang->line('present') ?>\n\
                                                            <span></span>\n\
                                                        </label>\n\
                                                    </div>\n\
                                                </div>\n\
                                            </div>');
                    }
                    $("#students").append('<div class="kt-portlet__foot">\n\
                                    <div class="kt-form__actions">\n\
                                        <button type="submit" class="btn btn-primary"><?php echo $this->lang->line('submit') ?></button>\n\
                                    </div>\n\
                                </div>');
                }
            });
        }
    </script>			

