<?php $this->load->view('site/layout'); ?>
<?php $this->load->view('site/navbar'); ?>

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><a href="<?= base_url('support/tickets') ?>"><?php echo $this->lang->line('support') ?></a></span>
            </div>
        </div>
    </div>
    <?php if (isset($msg) || validation_errors() !== ''): ?>
        <div class="alert alert-warning alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4><i class="icon fa-warning"></i> Alert!</h4>
            <?= validation_errors(); ?>
            <?= isset($msg) ? $msg : ''; ?>
        </div>
    <?php endif; ?> 
    <div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <h3 class="kt-portlet__head-title">
                    <?php echo $this->lang->line('edit_ticket') ?>
                </h3>
            </div>
        </div>
        <!--begin::Form-->
        <!-- <?php echo form_open_multipart(base_url('support/' . $thispage . '/add/')); ?> -->
        <form class="kt-form kt-form--label-right" method="post" action="">
            <div class="kt-portlet__body">
                <div class="form-group row">
                    <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('title') ?></label>
                    <div class="col-10">
                        <input type="text" class="form-control" id="exampleInputEmail1" value="<?= $ticket->title ?>" placeholder="<?php echo $this->lang->line('title') ?> " name="title" />
                    </div>
                </div>
                <div class="form-group row">
                    <label for="example-search-input" class="col-2 col-form-label"> <?php echo $this->lang->line('student') ?></label>
                    <div class="col-10">
                        <select name="client_id" class="form-control" id="client_id" data-search="true" >
                            <?php
                            foreach ($students as $student) {
                                $selected = '';
                                if ($ticket->client_id == $student->id) {
                                    $selected = 'selected';
                                }
                                ?>
                                <option <?= $selected ?> value="<?= $student->id ?>"><?= $student->username . ' - ' . $student->phone ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="example-search-input" class="col-2 col-form-label"> <?php echo $this->lang->line('department') ?></label>
                    <div class="col-10">
                        <select name="dept_id" class="form-control" >
                            <?php
                            foreach ($depts as $dept) {
                                $selected = '';
                                if ($ticket->dept_id == $dept->id) {
                                    $selected = 'selected';
                                }
                                ?>
                                <option <?= $selected ?> value="<?= $dept->id ?>"><?= $this->session->userdata('language') == 'english' ? $dept->english : $dept->arabic ?></option>
<?php } ?>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="example-email-input" class="col-2 col-form-label"><?php echo $this->lang->line('priority') ?></label>
                    <div class="col-10">
                        <select name="priority" class="form-control" >
                            <?php
                            $prio_arr = array('high', 'medium', 'low');
                            foreach ($prio_arr as $key => $value) {
                                $selected = '';
                                if ($ticket->priority == $key) {
                                    $selected = 'selected';
                                }
                                ?>
                                <option <?= $selected ?> value="<?= $key ?>"><?= $this->lang->line($value) ?></option>
<?php } ?>
                        </select>
                    </div>
                </div> 
                <div class="form-group row">
                    <label for="example-email-input" class="col-2 col-form-label"> <?php echo $this->lang->line('the_type') ?></label>
                    <div class="col-10">

                        <select name="type" class="form-control" >
                            <?php
                            $types_arr = array('inquiry', 'complaint', 'suggestion', 'other');
                            foreach ($types_arr as $key => $value) {
                                $selected = '';
                                if ($ticket->type == $key) {
                                    $selected = 'selected';
                                }
                                ?>
                                <option <?= $selected ?> value="<?= $key ?>"><?= $this->lang->line($value) ?></option>
<?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label for="example-email-input" class="col-2 col-form-label"> <?php echo $this->lang->line('status') ?></label>
                    <div class="col-10">

                        <select name="status" class="form-control" >
                            <?php
                            $status_arr = array('ticket_open', 'in_progress', 'answered', 'on_hold', 'closed');
                            foreach ($status_arr as $key => $value) {
                                $selected = '';
                                if ($ticket->status == $key) {
                                    $selected = 'selected';
                                }
                                ?>
                                <option <?= $selected ?> value="<?= $key ?>"><?= $this->lang->line($value) ?></option>
<?php } ?>
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="example-url-input" class="col-2 col-form-label"><?php echo $this->lang->line('the-description') ?></label>
                    <div class="col-10">
                        <textarea name="desc" rows="8" class="form-control"><?= $ticket->desc ?></textarea>
                    </div>
                </div>


            </div>
            <div class="kt-portlet__foot">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-2">
                        </div>
                        <div class="col-10">
                            <button type="submit" class="btn btn-primary" name="submit" value="pl"><?php echo $this->lang->line('edit') ?></button>
                            <button type="reset" class="btn btn-secondary">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
<?php $this->load->view('site/footer_2'); ?>
    <script>
        $(function () {
            $("#client_id").select2();
        });
    </script>