<?php $this->load->view('site/students/profile_header') ?>
<!--begin::Content-->
<style>
    .mt-10px{
        margin-top: 10px;
    }
</style>

<div class="flex-row-fluid ml-lg-8">
    <!--begin::Card-->
    <div class="card card-custom card-stretch">
        <!--begin::Header-->
        <?php echo form_open_multipart(base_url('' . $thispage . '/update_personal_info/')); ?>
        <?php if ($this->session->flashdata('error') != ''): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <div>
                    <h4><i class="icon fa-danger"></i> <?= $this->lang->line('error') ?>!</h4>&nbsp;
                    <?= $this->session->flashdata('error'); ?>
                </div>
            </div>
        <?php endif; ?>
        <?php if ($this->session->flashdata('success') != ''): ?>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <div>
                    <h4><i class="icon fa-success"></i> </h4>&nbsp;
                    <?= $this->lang->line('op_success'); ?>
                </div>
            </div>
        <?php endif; ?>
        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $this->lang->line('personal_info') ?></h3>
                <span class="text-muted font-weight-bold font-size-sm mt-1"><?= $this->lang->line('update_personal_info') ?></span>
            </div>
            <div class="card-toolbar" style="float: right">
                <button type="submit" class="btn btn-success mr-2"><?= $this->lang->line('save') ?></button>
                <!--<button type="reset" class="btn btn-secondary">Cancel</button>-->
            </div>
            <div class="clearfix"></div>
        </div>
        <!--end::Header-->
        <!--begin::Form-->

        <!--begin::Body-->
        <div class="card-body" style="overflow: scroll">
            <div class="row">
                <label class="col-xl-3"></label>
                <div class="col-lg-9 col-xl-6">
                    <h5 class="font-weight-bold mb-6"><?= $this->lang->line('customer_info') ?></h5>
                </div>
            </div>

            <?php
            $fields_arr = array('username' => $this->lang->line('name'),
               // 'name' => $this->lang->line('name'),
                'cid_user' => $this->lang->line('civil-no'), 'email' => $this->lang->line('e-mail'), 'password' => $this->lang->line('password'),
                'phone' => $this->lang->line('students') . ' ' . $this->lang->line('mobile'),
                'phone_father' => $this->lang->line('guardian') . ' ' . $this->lang->line('mobile'), 'country' => $this->lang->line('nationality'),
                'city' => $this->lang->line('region'), 'blocks' => $this->lang->line('block'), 'street' => $this->lang->line('street'), 'jadah' => $this->lang->line('jadah'),
                'building_num' => $this->lang->line('building_num'), 'floor' => $this->lang->line('floor'), 'door_no' => $this->lang->line('door-number'), 'address_link' => $this->lang->line('address-link'), 'title' => $this->lang->line('title'),
                'age' => $this->lang->line('date-of-birth'), 'sex' => $this->lang->line('sex'), 'father_work' => $this->lang->line('father_work'), 'mother_work' => $this->lang->line('mother_work'),
                'social_status' => $this->lang->line('social_status'), 'note' => $this->lang->line('note'),
                'profile' => $this->lang->line('customer-image'), 'imageuser' => $this->lang->line('other_attachments'));

            foreach ($student_profile_customer_fields as $key) {
                $val = $fields_arr[$key];
                if ($key == 'profile' && in_array($key, $editable)) {
                    ?>
                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('avatar') ?></label>
                        <div class="col-lg-9 col-xl-6">
                            <div class="image-input image-input-outline" id="kt_profile_avatar" style="background-image: url(assets/media/users/blank.png)">
                                <div class="image-input-wrapper" style="background-image: url(<?= base_url() ?>public/upload/userimage/<?= $one->image ?>)"></div>
                                <label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
                                    <i class="fa fa-pen icon-sm text-muted"></i>
                                    <input type="file" name="profile_avatar" accept=".png, .jpg, .jpeg" />
                                    <input type="hidden" name="profile_avatar_remove" />
                                </label>
                                <span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="Cancel avatar">
                                    <i class="ki ki-bold-close icon-xs text-muted"></i>
                                </span>
        <!--                                                            <span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="remove" data-toggle="tooltip" title="Remove avatar">
                                    <i class="ki ki-bold-close icon-xs text-muted"></i>
                                </span>-->
                            </div>
                            <span class="form-text text-muted"><?= $this->lang->line('allowed_types') ?>: png, jpg, jpeg.</span>
                        </div>
                    </div>
                    <?php
                    continue;
                }
                if ($key != 'password') {
                    if (!in_array($key, $editable)) {
                        if ($key == 'imageuser') {
                            $imgs = $this->db->get_where('user_image', array('user_id' => $this->session->userdata('student_id')))->result();
                            foreach ($imgs as $img) {
                                ?>
                                <img src="<?= base_url() ?>public\upload\userimage<?= $img->image ?>" width="100" /> 
                                <?php
                            }
                            continue;
                        }
                        if ($key == 'profile') {
                            continue;
                        }
                        $attr_name = $key == 'city' ? $one->region : $one->$key;
                        $attr_name = $key == 'country' ? $one->nationality : $attr_name;
                        ?>
                        <div class="form-group row">
                            <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $val ?></label>
                            <div class="col-lg-9 col-xl-6 mt-10px"> <?= $attr_name ?> </div>
                        </div>
                        <?php
                        continue;
                    }
                    ?>

                    <div class="form-group row">
                        <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $val ?></label>
                        <div class="col-lg-9 col-xl-6">
                            <div class="input-group input-group-lg input-group-solid">
                                <!--                        <div class="input-group-prepend">
                                                            <span class="input-group-text">
                                                                <i class="la la-phone"></i>
                                                            </span>
                                                        </div>-->
                                <?php if ($key == 'city') { ?>
                                    <select name="city" class="form-control">
                                        <option  value=""><?php echo $this->lang->line('select'); ?>
                                            <?php
                                            foreach ($region as $key => $value) {
                                                $selected = '';
                                                if ($one->region == $value->english) {
                                                    $selected = 'selected';
                                                }
                                                ?>
                                            <option <?= $selected ?> value="<?php echo $value->english; ?>"><?php echo $value->english; ?></option>
                                        <?php }
                                        ?>
                                    </select>
                                <?php } else if ($key == 'country') { ?>
                                    <select name="country" class="form-control">
                                        <option  value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php foreach ($nationality as $key => $value) { ?>
                                            <?php if ($lang == 'english') { ?><option value="<?php echo $value->english; ?>" <?= $one->nationality == $value->english ? 'selected' : '' ?>><?php echo $value->english; ?></option> <?php } else { ?>
                                                <option  value="<?php echo $value->arabic; ?>" <?= $one->nationality == $value->arabic ? 'selected' : '' ?>><?php echo $value->arabic; ?></option>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                <?php } else if ($key == 'sex') { ?>
                                    <div class="radio">

                                        <input type="radio" name="sex"  value="male"  checked="">
                                        <label>     <?php echo $this->lang->line('male') ?>
                                        </label>
                                    </div>
                                    <div class="radio">

                                        <input type="radio" name="sex"  value="female">
                                        <label>  <?php echo $this->lang->line('female') ?>
                                        </label>
                                    </div>
                                    <?php
                                } else if ($key == 'imageuser') {
                                    $imgs = $this->db->get_where('user_image', array('user_id' => $this->session->userdata('student_id')))->result();
                                    foreach ($imgs as $img) {
                                        $images = explode(',', $img->image);
                                        foreach ($images as $img) { ?>
                                            <img src="<?= base_url() ?>public/upload/userimage/<?= $img ?>" width="100" />
                                        <?php } ?>
                                    <?php } ?>
                                    <div class="row">
                                        <input type="file" name="imageuser[]" class="form-control" />
                                    </div>
                                <?php } else { ?>
                                    <input type="text" class="form-control form-control-lg form-control-solid" value="<?= $one->$key ?>" name="<?= $key ?>" placeholder="<?= $val ?>" />
                                <?php } ?>
                            </div>
                            <span class="form-text text-muted"><?= $this->lang->line('never_share_ur_data') ?></span>
                        </div>
                    </div>
                    <?php
                }
            }
            ?>


            <div class="form-group row">
                <label class="col-xl-3 col-lg-3"></label>
                <div class="col-lg-9 col-xl-6">
                    <a onclick="show_password()" style="cursor: pointer;color: blue"><?= $this->lang->line('change_password') ?> </a>
                </div>
            </div>
            <div class="form-group row" id="new_pass">
                <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('new_password') ?></label>
                <div class="col-lg-9 col-xl-6">
                    <input type="password" class="form-control form-control-lg form-control-solid" value="" name="new_password" placeholder="<?= $this->lang->line('enter') . ' ' . $this->lang->line('new_password') ?>" />
                </div>
            </div>

        </div>
        <!--end::Body-->
        <?php echo form_close(); ?>
        <!--end::Form-->
    </div>
</div>
<!--end::Content-->
<?php $this->load->view('site/students/profile_footer') ?>


