<?php $this->load->view('site/students/profile_header') ?>

<div class="flex-row-fluid ml-lg-8">
    <div class="card card-custom card-stretch">
        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $title ?></h3>
                <!--<span class="text-muted font-weight-bold font-size-sm mt-1"><?//= $this->lang->line('check_your') . ' ' . $this->lang->line('invoices') ?></span>-->
            </div>
            <div class="clearfix"></div>
        </div>
        <div class="card-body" style="overflow: scroll">

            <?php if (validation_errors()) { ?>

                <div class="m-alert m-alert--outline alert alert-success alert-dismissible fade show" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
                    <?php echo validation_errors(); ?>
                </div>
            <?php }
            ?>

            <?php if ($this->session->flashdata('message')) { ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('message'); ?>
                </div>
            <?php } ?>

            <?php if ($this->session->flashdata('error')) { ?>
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
            <?php } ?>

            <form method="post" enctype="multipart/form-data" > 


                <?php
                if (isset($results)) {
                    foreach ($results as $key => $result) {
                        ?>
                        <div class="input-box">
                            <div class="row">
                                <label class="col-md-3"><?php echo $this->lang->line('student_name'); ?></label>
                                <div class="col-md-7">
                                    <input type="hidden" name="stud_id[]" class="form-control" value="<?php echo $result->id ?>" readonly >
                                    <input type="text" class="form-control" value="<?php echo $result->name ?> - <?php echo $result->student_id; ?>" readonly >

                                </div>
                            </div>
                        </div>

                    <?php }
                }
                ?>



                <div class="form-group row">
                    <label class="col-md-3"><?php echo $this->lang->line('award'); ?></label>
                    <div class="col-md-7">
                        <select name="award_id" class="form-control" required="">
                            <option value=""><?php echo $this->lang->line('award'); ?></option>
                            <?php
                            if ($award) {
                                foreach ($award as $key => $award_value) {
                                    ?>
                                    <option value="<?php echo $award_value->id; ?>"><?php echo $award_value->award_name; ?></option>
                                    <?php
                                }
                            }
                            ?> 
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                        <label class="col-md-3"><?php echo $this->lang->line('notes'); ?></label>
                        <div class="col-md-7">
                            <textarea class="form-control" rows="4" name="memo"></textarea>
                        </div>
                </div>

                <div class="offset-md-4">
                    <button class="btn btn-success"><span><?php echo $this->lang->line('submit'); ?></span></button>
                    <a href="<?php echo base_url('points/user/award');?>" class="btn btn-danger"><span><?php echo $this->lang->line('cancel');?></span></a>
                </div>

            </form>
        </div>
    </div>
</div>

<?php $this->load->view('site/students/profile_footer') ?>

</body>
</html>