<?php $this->load->view('site/students/profile_header') ?>
<style>
    .label{
        width: 50%;
    }
</style>
<div class="flex-row-fluid ml-lg-8">
    <div class="card card-custom card-stretch">
        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $title ?></h3>
                <!--<span class="text-muted font-weight-bold font-size-sm mt-1"><?//= $this->lang->line('check_your') . ' ' . $this->lang->line('invoices') ?></span>-->
            </div>
            <div class="card-toolbar" style="float: right">
                <a href="<?= base_url() ?>points/user/award_request" class="btn btn-success mr-2"><?= $this->lang->line('request_award') ?></a>
                <!--<button type="reset" class="btn btn-secondary">Cancel</button>-->
            </div>
        </div>
        <div class="card-body" style="overflow: scroll">
            <div class="table-responsive">




                <?php if (validation_errors()) { ?>

                    <div class="m-alert m-alert--outline alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
                        <?php echo validation_errors(); ?>
                    </div>
                <?php }
                ?>

                <?php if ($this->session->flashdata('message')) { ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <?php echo $this->session->flashdata('message'); ?>
                    </div>
                <?php } ?>

                <?php if ($this->session->flashdata('error')) { ?>
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php } ?>
                
                <h3 class='mb-5'><?= $this->lang->line('my_points') ?> : <?= $one->total_balance ?></h3>

                <table class=" table table-striped table-bordered main-table" id="datatable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo $this->lang->line('award'); ?></th>
                            <th><?php echo $this->lang->line('points'); ?></th>
                            <th><?php echo $this->lang->line('notes'); ?></th>
                            <th><?php echo $this->lang->line('status'); ?></th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($award) {
                            $s = 1;
                            foreach ($award as $award_value) {

                                if ($award_value->award_status == 0) {
                                    $status_btn = 'warning';
                                    $award_status = "pending";
                                }
                                if ($award_value->award_status == 1) {
                                    $status_btn = 'success';
                                    $award_status = "accepted";
                                }
                                if ($award_value->award_status == 2) {
                                    $status_btn = 'danger';
                                    $award_status = "rejected";
                                }
                                ?>
                                <tr>
                                    <td><?php echo $s++; ?></td>
                                    <td><?php echo $award_value->award_name; ?> </td>
                                    <td><?php echo $award_value->award_history_point; ?> </td>
                                    <td><?php echo $award_value->memo; ?> </td>
                                    <td><span class='label label-rounded label-<?php echo $status_btn; ?>'><?php echo $this->lang->line($award_status); ?></span></td>

                                </tr>
                            <?php }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<?php $this->load->view('site/students/profile_footer') ?>

</body>
</html>