<?php $this->load->view('site/students/profile_header') ?>

<div class="flex-row-fluid ml-lg-8">
    <!--begin::Card-->
    <div class="card card-custom card-stretch">
        <?php echo form_open_multipart(base_url('' . $thispage . '/attendance/')); ?>
        <?php if ($this->session->flashdata('error') != ''): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <div>
                    <h4><i class="icon fa-danger"></i> <?= $this->lang->line('error') ?>!</h4>&nbsp;
                    <?= $this->session->flashdata('error'); ?>
                </div>
            </div>
        <?php endif; ?>
        <?php if ($this->session->flashdata('success') != ''): ?>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <div>
                    <h4><i class="icon fa-success"></i> Success!</h4>&nbsp;
                    <?= $this->lang->line('op_success'); ?>
                </div>
            </div>
        <?php endif; ?>
        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column" >
                <h3 class="card-label font-weight-bolder text-dark"><?= $this->lang->line('attendance') ?></h3>
                <span class="text-muted font-weight-bold font-size-sm mt-1"><?= $this->lang->line('check_your'). ' ' .$this->lang->line('attendance') ?></span>
            </div>
            <div class="clearfix"></div>
        </div>
        <div class="card-body" style="overflow: scroll">
            <h3><?= $this->lang->line('filters') ?></h3>
            <div class="form-group row">
                <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('date') ?></label>
                <div class="col-9">
                    <input type="text" name="start_expiry" id="start_expiry" class="form-control" value="<?= set_value('start_expiry') ?>"> 
                </div>
                <div class="col-1" style="padding-left: 0px">
                    <a onclick="clear_date()" class="btn btn-light btn-text-primary btn-hover-text-primary font-weight-bold"><?= $this->lang->line('clear') ?></a>
                </div>
            </div>
            <div class="form-group row">
                <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('products') ?></label>
                <div class="col-9">
                    <select class="form-control select2" name="products[]" multiple="multiple">
                   <!--<select multiple data-multi-select-plugin name="products[]" class="topnav form-control" >-->
                        <?php
                        foreach ($products as $value) {
                            $selected = '';
                            if (!empty($this->input->post('products'))) {
                                if (in_array($value->name, $this->input->post('products'))) {
                                    $selected = 'selected';
                                }
                            }
                            ?>
                            <option <?= $selected ?> value="<?php echo $value->name ?>"><?php echo $value->name ?></option>
                        <?php } ?>
                    </select> 
                </div>
            </div>

            <div class="form-group row">
                <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('attend_status') ?></label>
                <div class="col-9">
                    <select class="form-control select2" name="attend_status[]" multiple="multiple">
                    <!--<select multiple data-multi-select-plugin name="attend_status[]" class="topnav form-control" >-->
                        <?php
                        $selected1 = $selected2 = $selected3 = '';
                        if (!empty($this->input->post('attend_status'))) {
                            if (in_array($this->lang->line('present'), $this->input->post('attend_status'))) {
                                $selected1 = 'selected';
                            }
                            if (in_array($this->lang->line('absent'), $this->input->post('attend_status'))) {
                                $selected2 = 'selected';
                            }
                            if (in_array($this->lang->line('late'), $this->input->post('attend_status'))) {
                                $selected3 = 'selected';
                            }
                        }
                        ?>
                        <option <?= $selected1 ?> value="<?php echo $this->lang->line('present') ?>"><?php echo $this->lang->line('present') ?></option>
                        <option <?= $selected2 ?> value="<?php echo $this->lang->line('absent') ?>"><?php echo $this->lang->line('absent') ?></option>
                        <option <?= $selected3 ?> value="<?php echo $this->lang->line('late') ?>"><?php echo $this->lang->line('late') ?></option>
                    </select> 
                </div>
            </div>

            <button type="submit" class="btn btn-primary pull-right"><?php echo $this->lang->line('submit') ?></button>
        </div>
        </form>          
        <br/>

        <div class="kt-portlet__body" style="padding: 20px">

            <!--begin: Datatable -->
            <table class="table table-bordered table-hover " id="list_table" >
                <thead>
                    <tr> 
                        <th><?php echo $this->lang->line('sno') ?></th>
                        <!--<th><?php //echo $this->lang->line('the-name') ?></th>-->
                        <th><?php echo $this->lang->line('products') ?></th>
                        <th><?php echo $this->lang->line('date') ?></th>
                        <th><?php echo $this->lang->line('attendance') ?></th>

                    </tr>
                </thead>
                <tbody>

                    <?php
                    $count = 1;
                    foreach ($all_groups as $row) {
                        ?>
                        <tr>
                            <td><?php echo $count++; ?></td>
                            
                            <?php
                            $this->db->where('id', $row->product_id);
                            $product = $this->db->get('bills_producer')->row();
                            ?>
                            <td><?php echo @$product->name; ?></td>
                            <td><?php echo @$row->date; ?></td>
                            <td><?php
                                if ($row->present == '2')
                                    echo '<span class="btn btn-sm btn-warning" style="border-radius: 2rem;padding: 0.15rem 5px; color: #fff;!important">' . $this->lang->line('late') . ' ' . $this->lang->line('present') . '</span>';
                                if ($row->present == '1')
                                    echo '<span class="btn btn-sm btn-success" style="border-radius: 2rem;padding: 0.15rem 5px; color: #fff;!important">' . $this->lang->line('present') . '</span>';
                                if ($row->present == '0')
                                    echo '<span class="btn btn-sm btn-danger" style="border-radius: 2rem;padding: 0.15rem 5px; color: #fff;!important">' . $this->lang->line('absent') . '</span>';
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <!--end: Datatable -->
        </div>

    </div>
</div>
<?php $this->load->view('site/students/profile_footer') ?>

<?php $this->load->view('site/footer_2'); ?> 
<script >
    function absent_reports() {
        // var search[] = <?php //echo $all_groups        ?>;
        // alert('dad');
        $.ajax({
            type: "POST",
            url: "<?php echo base_url() ?>producer/absent_report",
            data: JSON.stringify({'data': 'search'}),
            // success: function() {
            // var dd =  obj = JSON.parse(e)
            // $(".new-select").html(dd);
            // }
        });
    }
</script>
<script>
    function clear_date() {
        $("#start_expiry").val('');
    }
    $(function () {
        $('.select2').select2({
            placeholder: "<?= $this->lang->line('select') ?>"
        });
        $("#list_table").DataTable({dom: 'Bfrtip',
            destroy: true,
            buttons: [
                {
                    extend: 'excelHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'csvHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'pdfHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'print',
                    autoPrint: false,
                    footer: true
                }

            ]
        });
//            buttons: [
//                'copyHtml5',
//                'excelHtml5',
//                'csvHtml5',
//                'pdfHtml5'
//            ]
    });
</script>