<?php $this->load->view('site/layout'); ?>
<?php
if ($this->session->userdata('language') == "english") {
    $language_set = "arabic";
} else {
    $language_set = "english";
}
if ($language_set == "english") {
    ?>
    <link href="<?php echo base_url() ?>public/plugins/custom/fullcalendar/fullcalendar.bundle.rtl.css" rel="stylesheet" type="text/css" />
<?php } else { ?>
    <link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />


<?php } ?>
<style>
    .nav-tabs{
        padding-left: 25px;
    }
    .rtl .nav-tabs{
        padding-right: 25px;
        padding-left: 0px;
    }
    .add_icon{
        cursor: pointer;
    }
    .add_div{
        border: 1px solid #ccc;
        padding: 10px;
    }
</style>
<?php $this->load->view('site/navbar'); ?>
<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><a href="<?= base_url('producer/') ?>"><?php echo $this->lang->line('products') ?></a></span>
            </div>

        </div>
    </div>
    <div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <h3 class="kt-portlet__head-title">
                    <?php echo $this->lang->line('add') ?> <?php echo $this->lang->line('products') ?>
                </h3>
            </div>
        </div>



        <ul class="nav nav-tabs nav-tabs-line mb-10">
            <li class="nav-item ">
                <a class="nav-link active" data-toggle="tab" href="#kt_tab_pane_1"> <span class="nav-icon"> 
                        <i class="far fa-list-alt"></i>
                    </span> <span class="nav-text"><?= $this->lang->line('data') ?></span>
                </a>
            </li>
            <?php if (get_ap('product_additions', $this->operator_id)) { ?>
                <li class="nav-item">
                    <a class="nav-link" data-toggle="tab" href="#kt_tab_pane_2"> <span class="nav-icon"> 
                            <i class="far fa-plus-square"></i>
                        </span> <span class="nav-text"><?= $this->lang->line('additions') ?></span>
                    </a>
                </li>
            <?php } ?>
        </ul>
        <!--begin: Datatable -->
        <?php echo form_open_multipart(base_url('' . $thispage . '/add/')); ?>
        <div class="kt-portlet__body">
            <div class="tab-content" id="myTabContent">
                <div id="kt_tab_pane_1" class="tab-pane fade show active">



                    <!-- <form class="kt-form kt-form--label-right"> -->

                    <?php if (isset($msg) || validation_errors() !== ''): ?>
                        <div class="form-group form-group-last">
                            <div class="alert alert-secondary" role="alert">
                                <div class="alert-icon"><i class="flaticon-warning kt-font-brand"></i></div>
                                <div class="alert-text">
                                    <?= validation_errors(); ?>
                                    <?= isset($msg) ? $msg : ''; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('english_name') ?></label>
                        <div class="col-10">
                            <ul class="nav nav-tabs mb-10" style="padding: 0px;margin: 0px">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#eng_name_tab"> <span class="nav-icon"> 
                                            <i class="fab fa-etsy"></i>
                                        </span> <span class="nav-text"><?= $this->lang->line('english_name') ?></span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#ar_name_tab"> <span class="nav-icon"> 
                                            <i>ع</i>
                                        </span> <span class="nav-text"><?= $this->lang->line('arabic_name') ?></span>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div id="eng_name_tab" class="tab-pane fade show active">
                                    <input type="text" class="form-control" id="exampleInputEmail1" placeholder="<?php echo $this->lang->line('enter') ?> <?php echo $this->lang->line('english_name') ?>" value="<?= set_value('name') ?>" name="name"  autofocus >
                                </div>
                                <div id="ar_name_tab" class="tab-pane fade">
                                    <input type="text" class="form-control" id="exampleInputEmail1" placeholder="<?php echo $this->lang->line('enter') ?> <?php echo $this->lang->line('arabic_name') ?>" name="arabic_name" value="<?= set_value('arabic_name') ?>"  >
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('details_eng') ?></label>
                        <div class="col-10">
                            <ul class="nav nav-tabs mb-10" style="padding: 0px;margin: 0px">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#eng_details_tab"> <span class="nav-icon"> 
                                            <i class="fab fa-etsy"></i>
                                        </span> <span class="nav-text"><?= $this->lang->line('details_eng') ?></span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#ar_details_tab"> <span class="nav-icon"> 
                                            <i>ع</i>
                                        </span> <span class="nav-text"><?= $this->lang->line('details_ar') ?></span>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div id="eng_details_tab" class="tab-pane fade show active">
                                    <textarea name="details_eng" class="form-control"rows="5" placeholder="<?php echo $this->lang->line('enter') ?> <?php echo $this->lang->line('details_eng') ?>"><?= set_value('details_eng') ?></textarea>
                                </div>
                                <div id="ar_details_tab" class="tab-pane fade">
                                    <textarea name="details_ar" class="form-control" rows="5" placeholder="<?php echo $this->lang->line('enter') ?> <?php echo $this->lang->line('details_ar') ?>"><?= set_value('details_ar') ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?= $this->lang->line('product_code') ?></label>
                        <div class="col-10">
                            <div class="input-group">
                                <input type="text" name="code" class="form-control" id="code" />
                                <div class="input-group-append">
                                    <span class="input-group-text pointer" id="random_num" title="<?= $this->lang->line('generate') ?>"><i class="fa fa-random"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?= $this->lang->line('barcode_symbology') ?></label>
                        <div class="col-10">
                            <?php
                            $bs = ['code25' => 'Code25', 'code39' => 'Code39', 'code128' => 'Code128', 'ean8' => 'EAN8', 'ean13' => 'EAN13', 'upca' => 'UPC-A', 'upce' => 'UPC-E'];
                            echo form_dropdown('barcode_symbology', $bs,  'code128', 'class="form-control select_plug2" id="barcode_symbology" required="required" style="width:100%;"');
                            ?>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('category') ?></label>
                        <div class="col-10">
                            <select class="form-control select_plug2" name="category" >
                                <?php
                                foreach ($cats as $cat) {
                                    $selected = '';
                                    if ($this->input->post() && $this->input->post('category') == $cat->id) {
                                        $selected = 'selected';
                                    }
                                    ?>
                                    <option <?= $selected ?> value="<?= $cat->id ?>"><?= $cat->name ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-search-input" class="col-2 col-form-label"><?php echo $this->lang->line('the-value') ?></label>
                        <div class="col-10">
                            <input type="text" class="form-control" id="exampleInputPassword1" placeholder="<?php echo $this->lang->line('the-value') ?>" name="valuess" value="<?= set_value('valuess') ?>" >
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('brand') ?></label>
                        <div class="col-10">
                            <select class="form-control" name="brand" id="brand" >
                                <option value><?= $this->lang->line('select') ?></option>
                                <?php
                                foreach ($brands as $brand) {
                                    if ($brand->brand != '') {
                                        $selected = '';
                                        if ($this->input->post() && $this->input->post('brand') == $brand->brand) {
                                            $selected = 'selected';
                                        }
                                        ?>
                                        <option <?= $selected ?> value="<?= $brand->brand ?>"><?= $brand->brand ?></option>
                                        <?php
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-email-input" class="col-2 col-form-label"><?php echo $this->lang->line('status') ?></label>
                        <div class="col-2">
                            <div class="radio">
                                <input type="radio" name="active"  value="1" <?= $this->input->post('active') && $this->input->post('active') == 1 ? 'checked' : '' ?> >
                                <label>     <?php echo $this->lang->line('open') ?>
                                </label>
                            </div>
                        </div>   
                        <div class="col-2">  <div class="radio">
                                <input type="radio" name="active"  value="2" <?= $this->input->post('active') && $this->input->post('active') == 2 ? 'checked' : '' ?> >
                                <label><?php echo $this->lang->line('closed') ?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-email-input" class="col-2 col-form-label"><?php echo $this->lang->line('type') ?></label>
                        <div class="col-2">
                            <div class="radio">
                                <input type="radio" checked name="type"  value="1" <?= $this->input->post('type') && $this->input->post('type') == 1 ? 'checked' : '' ?> >
                                <label>     <?php echo $this->lang->line('product') ?>
                                </label>
                            </div>
                        </div>   
                        <div class="col-2">  <div class="radio">
                                <input type="radio" name="type"  value="2" <?= $this->input->post('type') && $this->input->post('type') == 2 ? 'checked' : '' ?> >
                                <label><?php echo $this->lang->line('subscription') ?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-url-input" class="col-2 col-form-label"><?php echo $this->lang->line('note') ?></label>
                        <div class="col-10">
                            <textarea class="form-control" rows="3" placeholder="<?php echo $this->lang->line('describe') ?>..." name="note"><?= set_value('note') ?></textarea>
                        </div>
                    </div>

                </div>

                <?php if (get_ap('product_additions', $this->operator_id)) { ?>
                    <div id="kt_tab_pane_2" class="tab-pane fade">
                        <div id="adds_container">
                            <div id="adds">
                                <div class="mb-3 add_div">
                                    <i class="fas fa-window-close text-danger fa-2x delete_item float-right mb-3" title="Delete Item" style="cursor: pointer"></i>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('eng_title') ?></label>
                                        <div class="col-10">
                                            <input type="text" class="form-control" id="exampleInputEmail1" placeholder="<?php echo $this->lang->line('enter') ?> <?php echo $this->lang->line('eng_title') ?>" name="eng_title[]"  >
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('ar_title') ?></label>
                                        <div class="col-10">
                                            <input type="text" class="form-control" id="exampleInputEmail1" placeholder="<?php echo $this->lang->line('enter') ?> <?php echo $this->lang->line('ar_title') ?>" name="ar_title[]" >
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('choice_type') ?></label>
                                        <div class="col-10">
                                            <select name="choice_type[]" class="form-control add_select">
                                                <option value="0"><?= $this->lang->line('single_choice') ?></option>
                                                <option value="1"><?= $this->lang->line('multiple_choice') ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('required') ?></label>
                                        <div class="col-10">
                                            <select name="required[]" class="form-control add_select">
                                                <option value="1"><?= $this->lang->line('yes') ?></option>
                                                <option value="0"><?= $this->lang->line('no') ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('filter_by') ?> <?php echo $this->lang->line('group_name') ?></label>
                                        <div class="col-10">
                                            <select name="group_name[]" class="form-control add_select group_name">
                                                <option value="all"><?= $this->lang->line('all') ?></option>
                                                <?php foreach ($group_name as $value) { ?>
                                                    <option value="<?= $value->group_name ?>"><?= $value->group_name ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('options') ?></label>
                                        <div class="col-10">
                                            <select name="options[0][]" data-counter="0" class="form-control add_select options" multiple style="width: 100%">
                                                <?php foreach ($adds as $value) { ?>
                                                    <option value="<?= $value->id ?>"><?= $this->session->userdata('language') == 'english' ? $value->name_en : $value->name_ar ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="text-center">
                            <i class="fa fa-plus text-primary fa-3x add_icon" title="<?= $this->lang->line('add') . ' ' . $this->lang->line('product_additions') ?>"></i>
                        </div>

                    </div>
                <?php } ?>
            </div>
        </div>

        <div class="kt-portlet__foot">
            <div class="kt-form__actions">
                <div class="row">
                    <div class="col-2">
                    </div>
                    <div class="col-10">
                        <button type="submit" class="btn btn-primary" name="submit" value="pl"><?php echo $this->lang->line('addition') ?></button>
                    </div>
                </div>
            </div>
        </div>
        </form>
    </div>
    <?php $this->load->view('site/footer_2'); ?>
    <script>
        $("#brand").select2({
            tags: true
        });
        $('.select_plug2').select2();
        $('.add_select').select2();
        $(document).on('change', '.group_name', function () {
            var ele = $(this).closest('.add_div').find(".options");
            $.ajax({
                type: "POST",
                url: "<?php echo base_url() ?>producer/filter_additions_by_group_name",
                data: {group_name: $(this).val()},
                dataType: 'JSON',
                success: function (result) {

                    ele.html('');
                    for (var i = 0; i < result.length; i++) {
                        var name = result[i].name_en;
<?php if ($this->session->userdata('language') == 'arabic') { ?>
                            name = result[i].name_ar;
<?php } ?>
                        ele.append('<option value="' + result[i].id + '">' + name + '</option>');
                    }
                }
            });
        });
        // counter = 0;
        $(".add_icon").click(function () {
            var counter = $(".options:last").data('counter');
            $(".add_select").select2('destroy');
            $("#adds_container").append($("#adds").html());
            $(".add_select").select2();
            $(".group_name:last").change();
            counter++;
            $(".options:last").prop('name', 'options[' + counter + '][]');
            $(".options:last").data('counter', counter);
        });
        $(document).on('click', '.delete_item', function () {
            // to not delete the first div
            if ($(this).closest('#adds').length == 0) {
                $(this).closest('.add_div').remove();
                //    counter--;
            }
        });
        $('#random_num').click(function () {
            var code = generateCardNo(8);
            $(this).closest('.input-group').children('input').val(code);
        });
        function generateCardNo(x) {
            if (!x) {
                x = 16;
            }
            chars = '1234567890';
            no = '';
            for (var i = 0; i < x; i++) {
                var rnum = Math.floor(Math.random() * chars.length);
                no += chars.substring(rnum, rnum + 1);
            }
            return no;
        }
    </script>