<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <link rel="stylesheet" href="<?= base_url() ?>public/css/thermal_bill.css">
        <title><?= $title ?></title>
    </head>
    <body class="<?= $sett->inv_lang == 1 ? 'rtl' : '' ?>">
        <div class="ticket">
            <!--<div class="centered">-->
            <img src="<?= base_url() ?>public/upload/userimage/<?= $this->config->item('invoice_logo') ?>" alt="Logo">
            <p class="comp_title"><?= $this->config->item('company_title') ?></p>
            <!--</div>-->
            <div class="clearfix"></div>

            <p><span><?= $sett->inv_lang == 0 ? 'Invoice num.: ' : 'رقم الفاتورة :' ?></span> <?= str_pad($show['id_orders'], 6, "0", STR_PAD_LEFT); ?></p>
            <p class="m-0"><span><?= $sett->inv_lang == 0 ? 'Name: ' : ' الاسم :' ?></span> <?= $show['username'] ?></p>
            <p class="m-0"><span><?= $sett->inv_lang == 0 ? 'Phone num.: ' : ' رقم الهاتف :' ?></span> <?= $show['phone'] ?></p>
            <p class="m-0"><span><?= $sett->inv_lang == 0 ? 'Date: ' : '  التاريخ :' ?></span> <?= date('Y/m/d H:i', strtotime($show['date'])) ?></p>
            <table id="address">
                <thead>
                    <tr>
                        <?php if ($show['region']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Region' : '  المنطقة ' ?></th>
                        <?php } ?>
                        <?php if ($show['blocks']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Block' : '  قطعة ' ?></th>
                        <?php } ?>
                        <?php if ($show['street']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Street' : ' شارع ' ?></th>
                        <?php } ?>
                        <?php if ($show['jadah']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Jadah' : '  جدة ' ?></th>
                        <?php } ?>
                        <?php if ($show['floor']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Floor num' : '  ارضية ' ?></th>
                        <?php } ?>
                        <?php if ($show['building_num']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Building num' : '  رقم المبنى ' ?></th>
                        <?php } ?>
                        <?php if ($show['door_no']) { ?>
                            <th><?= $sett->inv_lang == 0 ? 'Door num' : '  رقم الباب ' ?></th>
                        <?php } ?>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <?php if ($show['region']) { ?>
                            <td><?= $show['region'] ?></td>
                        <?php } ?>
                        <?php if ($show['blocks']) { ?>
                            <td><?= $show['blocks'] ?></td>
                        <?php } ?>
                        <?php if ($show['street']) { ?>
                            <td><?= $show['street'] ?></td>
                        <?php } ?>
                        <?php if ($show['jadah']) { ?>
                            <td><?= $show['jadah'] ?></td>
                        <?php } ?>
                        <?php if ($show['floor']) { ?>
                            <td><?= $show['floor'] ?></td>
                        <?php } ?>
                        <?php if ($show['building_num']) { ?>
                            <td><?= $show['building_num'] ?></td>
                        <?php } ?>
                        <?php if ($show['door_no']) { ?>
                            <td><?= $show['door_no'] ?></td>
                        <?php } ?>
                    </tr>
                </tbody>
            </table>

            <table id="products">
                <thead>
                    <tr>

                        <th class="description"><?= $sett->inv_lang == 0 ? 'Product' : 'الصنف' ?></th>
                        <th class="number"><?= $sett->inv_lang == 0 ? 'quantity' : 'الكمية' ?></th>
                        <th class="number"><?= $sett->inv_lang == 0 ? 'Price' : 'السعر' ?></th>
                        <th class="number"><?= $sett->inv_lang == 0 ? 'Amount' : 'القيمة' ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $total = $discount = $after_discount = 0;
                    foreach ($producer as $value) {
                        ?>
                        <tr>
                            <td class="description"><?= $sett->inv_lang == 0 ? $value->prod_name_en : $value->prod_name_ar ?>
                                <br/>
                                <?= isset($value->additions) ? $value->additions : '' ?>
                            </td>
                            <td class="number"><?= $value->quantity ?></td>
                            <td class="number"><?= round($value->item_price, 2) ?><?= $sett->inv_currency ?></td>
                            <td class="number"><?= $value->payment ?><?= $sett->inv_currency ?></td>
                        </tr>
                        <?php
                        $total += $value->payment;
                        $discount += $value->discount;
                        $after_discount += $value->discount_remainder;
                    }
                    ?>
                </tbody>
            </table>
            <table id="calculations">
                <tr>
                    <td><?= $sett->inv_lang == 0 ? 'Total' : 'الاجمالى' ?></td>
                    <td><?= $total ?></td>
                </tr>
                <tr>
                    <td><?= $sett->inv_lang == 0 ? 'Discount' : 'الخصم' ?></td>
                    <td><?= $discount ?></td>
                </tr>
                <tr>
                    <td><?= $sett->inv_lang == 0 ? 'Amount' : 'الصافى' ?></td>
                    <td><?= $after_discount ?></td>
                </tr>
            </table>
            <hr/>
            <div class="centered">
                <p><?= $sett->inv_lang == 0 ? $sett->inv_footer_thermal : $sett->inv_footer_thermal_ar ?></p>
            </div>
        </div>
        <?php $this->load->view('site/footer_2') ?>
        <script>
<?php if ($print) { ?>
                $(function () {
                    setTimeout(function () {
                        var headstr = "<html><head><title>Booking Details</title></head><body>";
                        var footstr = "</body>";
                        var newstr = $(".ticket").html();
                        var oldstr = document.body.innerHTML;
                        document.body.innerHTML = headstr + newstr + footstr;
                        window.print();
                        document.body.innerHTML = oldstr;
                        window.close();
                    }
                    , 2000);
                    //                        setTimeout(function () {
                    //                            window.print();
                    //                            window.close();
                    //                        }
                    //                        , 2000);
                });
<?php } ?>
        </script>
    </body>
</html>