
<?php $this->load->view('site/layout'); ?>
<link href="<?php echo base_url() ?>public/css/style.bundle_front.css" rel="stylesheet" type="text/css" />
<link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<style>
    .rtl .kt-portlet__head-title{
        text-align: right; 
    }
    .rtl .btn{
        float: right; 
    }
    .alert.alert-light{
        background: #FFF;
        border-color: #FFF;
    }
    .text-muted{
        color: #000 !important;
    }
    .font-size-sm {
        font-size: 1rem;
    }
    .text-dark-75{
        color:#6e6e6e !important;
    }
    .card-body{
        text-align: left;
    }
    .rtl .card-body{
        text-align: right;
    }
    .card-stretch{
        background-position: right top;
    }
    .rtl .card-stretch{
        background-position: left top;
    }
</style>

<?php $this->load->view('site/navbar'); ?>



<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?php echo $this->lang->line('sales_report'); ?></span>
            </div>

        </div>
    </div>
</div>



<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
    <h3 class="kt-portlet__head-title mb-3">
        <?php echo $this->lang->line('sales_report'); ?>
    </h3>
    <button class="btn btn-primary mb-3" onclick="toggle_filter()"><?= $this->lang->line('show_hide_filter') ?></button>
    <div class="clearfix"></div>
    <div class="alert alert-light alert-elevate" role="alert" id="filter_container">
        <div class="alert-text">

            <form class="kt-form kt-form--label-right" method="post" action=""> 
                <div class="kt-portlet__body">
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('date') ?></label>
                        <div class="col-9">
                            <input type="text" name="start_expiry" id="start_expiry" class="form-control" value="<?= set_value('start_expiry') ?>"> 
                        </div>
                        <div class="col-1" style="padding-left: 0px">
                            <a onclick="clear_date()" class="btn btn-light btn-text-primary btn-hover-text-primary font-weight-bold"><?= $this->lang->line('clear') ?></a>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('added_by') ?></label>
                        <div class="col-9">
                            <select multiple name="admins[]" class="topnav form-control select2_plug" style="width: 100%">
                                <?php foreach ($admins as $admin) { ?>
                                    <option <?= set_value('admins') && is_array(set_value('admins')) && in_array($admin->id, set_value('admins')) ? 'selected' : '' ?> value="<?= $admin->id ?>"><?= $admin->name ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">

                        <button  class="btn btn-primary btn-elevate btn-icon-sm mr-5 ml-5">
                            <?php echo $this->lang->line('submit') ?>
                        </button>

                    </div>
                </div>
            </form>          
        </div>
    </div>

    <div class="row">
        <div class="col-xl-4">
            <div class="card card-custom bgi-no-repeat card-stretch gutter-b" style="background-size: 30% auto; background-image: url(../assets/media/svg/shapes/abstract-1.svg)">
                <!--begin::Body-->
                <div class="card-body">
                    <i class="fas fa-calculator icon-3x text-info"></i>
                    <span class="card-title font-weight-bolder text-dark-75 font-size-h2 mb-0 mt-6 d-block"><?= $sett && $total_sales_amount ? $sett->inv_currency : '' ?> <?= $total_sales_amount ? number_format($total_sales_amount->total_amount, 2) . ' (' . $total_sales_amount->total_count . ')' : '' ?> </span>
                    <span class="font-weight-bold text-muted font-size-sm"><?= $this->lang->line('total_sales') ?></span>
                </div>
            </div>
        </div>

        <div class="col-xl-4">
            <div class="card card-custom bgi-no-repeat card-stretch gutter-b" style="background-size: 30% auto; background-image: url(../assets/media/svg/shapes/abstract-1.svg)">
                <!--begin::Body-->
                <div class="card-body">
                    <i class="fas fa-hand-holding-usd icon-3x text-warning"></i>
                    <span class="card-title font-weight-bolder text-dark-75 font-size-h2 mb-0 mt-6 d-block"><?= $sett && $total_sales_amount ? $sett->inv_currency : '' ?> <?= $total_sales_amount && $total_sales_amount->total_count != 0 ? number_format($total_sales_amount->total_amount / $total_sales_amount->total_count, 2) : '' ?> </span>
                    <span class="font-weight-bold text-muted font-size-sm"><?= $this->lang->line('average_order_amount') ?></span>
                </div>
            </div>
        </div>

        <?php
        $payment_method = array('cash', 'knet', 'visa', 'link');
        $icons = array('far fa-money-bill-alt', 'far fa-credit-card', 'fab fa-cc-visa', 'fas fa-link');
        $colors = array('text-primary', 'text-success', 'text-dark', 'text-info');
        $i = 0;
        foreach ($payment_method as $method) {
            if ($payment_type_amounts && $payment_type_amounts->$method) {
                ?>
                <div class="col-xl-4">
                    <div class="card card-custom bgi-no-repeat card-stretch gutter-b" style="background-size: 30% auto; background-image: url(../assets/media/svg/shapes/abstract-1.svg)">
                        <!--begin::Body-->
                        <div class="card-body">
                            <i class="<?= $icons[$i] ?> icon-3x <?= $colors[$i] ?>"></i>
                            <span class="card-title font-weight-bolder text-dark-75 font-size-h2 mb-0 mt-6 d-block"><?= $sett ? $sett->inv_currency : '' ?> <?= number_format($payment_type_amounts->$method, 2) ?> </span>
                            <span class="font-weight-bold text-muted font-size-sm"><?= $this->lang->line($method) ? $this->lang->line($method) : 'Visa / Master card' ?></span>
                        </div>
                    </div>
                </div>
                <?php
            }
            $i++;
        }
        ?>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="kt-portlet kt-portlet--mobile ml-0 mr-0">
                <div class="kt-portlet__head kt-portlet__head--lg">
                    <div class="kt-portlet__head-label">
                        <span class="kt-portlet__head-icon">
                            <i class="fas fa-award"></i>
                        </span>
                        <h3 class="kt-portlet__head-title">
                            <?php echo $this->lang->line('best_selling_products'); ?>
                        </h3>
                    </div>
                </div>
                <div class="kt-portlet__body">
                    <table class="table table-bordered table-hover list_table">
                        <thead>
                            <tr>
                                <th><?= $this->lang->line('product') ?></th>
                                <th><?= $this->lang->line('total_sales') ?></th>
                                <th><?= $this->lang->line('total_sales_amount') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($best_selling_products as $product) { ?>
                                <tr>
                                    <td><?= $product->name_order ?></td>
                                    <td><?= number_format($product->total_amount, 3) ?></td>
                                    <td><?= $product->total_count ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="kt-portlet kt-portlet--mobile ml-0 mr-0">
                <div class="kt-portlet__head kt-portlet__head--lg">
                    <div class="kt-portlet__head-label">
                        <span class="kt-portlet__head-icon">
                            <i class="fas fa-users"></i>
                        </span>
                        <h3 class="kt-portlet__head-title">
                            <?php echo $this->lang->line('shop_clients'); ?>
                        </h3>
                    </div>
                </div>
                <div class="kt-portlet__body">
                    <table class="table table-bordered table-hover list_table">
                        <thead>
                            <tr>
                                <th><?= $this->lang->line('name') ?></th>
                                <th><?= $this->lang->line('phone') ?></th>
                                <th><?= $this->lang->line('email') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($clients as $client) { ?>
                                <tr>
                                    <td><?= $client->name ?></td>
                                    <td><?= $client->phone ?></td>
                                    <td><?= $client->email ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>




<?php $this->load->view('site/footer_2'); ?> 


<script src="<?php echo base_url() ?>public/js/pages/crud/datatables/basic/basic.js" type="text/javascript"></script>

<script>
                                $(".select2_plug").select2();
                                $("#filter_container").hide();
                                function alert_box(id) {
                                    var result = confirm("Are You Confirm!")
                                    if (result) {
                                        window.location.href = "<?= base_url('' . $this->thispage . '/del/') ?>" + id;
                                    }
                                }
                                function toggle_filter() {
                                    $("#filter_container").toggle();
                                    $(".select2_plug").select2();
                                }
                                function clear_date() {
                                    $("#start_expiry").val('');
                                }

                                $(".list_table").DataTable({dom: 'Bfrtip',
                                    destroy: true,
                                    buttons: [
                                        {
                                            extend: 'excelHtml5',
                                            charset: 'UTF-16LE',
                                            fieldSeparator: '\t',
                                            bom: true
                                        },
                                        {
                                            extend: 'csvHtml5',
                                            charset: 'UTF-16LE',
                                            fieldSeparator: '\t',
                                            bom: true
                                        },
                                        {
                                            extend: 'pdfHtml5',
                                            charset: 'UTF-16LE',
                                            fieldSeparator: '\t',
                                            bom: true
                                        },
                                        {
                                            extend: 'print',
                                            autoPrint: false,
                                            footer: true
                                        }

                                    ]
                                });
</script>