<?php $this->load->view('site/layout'); ?>

<?php
if ($this->session->userdata('language') == "english") {
    $language_set = "arabic";
} else {
    $language_set = "english";
}
if ($language_set == "english") {
    ?>
    <link href="<?php echo base_url() ?>public/plugins/custom/fullcalendar/fullcalendar.bundle.rtl.css" rel="stylesheet" type="text/css" />
<?php } else { ?>
    <link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />


<?php } ?>
<link href="<?php echo base_url() ?>public/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
<style>
    .add_icon{
        float: right;
        padding-right: 15px;
        cursor: pointer;
    }
    #invoice_items tr{
        margin-bottom: 10px;
    }
</style>
<?php $this->load->view('site/navbar'); ?>
<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-hidden"></span>
                <div class="kt-subheader__breadcrumbs">
                    <a href="#" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
                    <span class="kt-subheader__breadcrumbs-separator"></span>
                    <a href="<?= base_url('orders/') ?>" class="kt-subheader__breadcrumbs-link">
                        <?php echo $this->lang->line('invoices') ?> </a>
                    <span class="kt-subheader__breadcrumbs-separator"></span>
                </div>

            </div>
        </div>
    </div>
    <div class="kt-portlet">
        <div class="kt-portlet__head">
            <div class="kt-portlet__head-label">
                <h3 class="kt-portlet__head-title">
                    <?php echo $this->lang->line('edit_order_status') ?>
                </h3>
            </div>
        </div>

        <?php echo form_open_multipart(base_url('' . $thispage . '/edit_order_status/' . $order_id), array('id' => 'my_form')); ?>
        <!-- <form class="kt-form kt-form--label-right"> -->
        <div class="kt-portlet__body">
            <?php if ($this->session->flashdata('msg') || validation_errors() !== '' || isset($msg)): ?>
                <div class="form-group form-group-last">
                    <div class="alert alert-secondary" role="alert">
                        <div class="alert-icon"><i class="flaticon-warning kt-font-brand"></i></div>
                        <div class="alert-text">
                            <?= validation_errors(); ?>
                            <?= isset($msg) ? $msg : ''; ?>
                            <?= $this->session->flashdata('msg') ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php
            if (get_license_per('order_status')) {
                ?>
                <div class="form-group row">
                    <label class="col-3 col-form-label"><?= $this->lang->line('order_status') ?></label>
                    <?php $order_status = array('waiting', 'preparing', 'ready_for_deliver', 'delivering', 'delivered', 'canceled') ?>
                    <div class="col-9">
                        <?php if ($order->order_status != 4) { ?>
                            <select name="order_status" class="form-control">
                                <?php foreach ($order_status as $key => $value) { ?>
                                    <option <?= $key == $order->order_status ? 'selected' : '' ?> value="<?= $key ?>"><?= $this->lang->line($value) ?></option>  
                                <?php } ?>
                            </select>
                        <?php } else { ?>
                            <span><?= $this->lang->line('delivered') ?></span>  
                            <input type="hidden" name="order_status" value="4" />
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>


            <!--            <div class="form-group row">
                            <label class="col-3 col-form-label"><?//= $this->lang->line('delivery_status') ?></label>
            <?php //$delivery_status = array('not_shipped', 'delivering', 'delivered')    ?>
                            <div class="col-9">
                                <select name="delivery_status" class="form-control">
            <?php //foreach ($delivery_status as $key => $value) {  ?>
                                        <option <?//= $key == $order->delivery_status ? 'selected' : '' ?> value="<?//= $key ?>"><?//= $this->lang->line($value) ?></option>  
            <?php //}    ?>
                                </select>
                            </div>
                        </div>-->

            <?php
            $controller_path = dirname(__DIR__, 3);
            if (file_exists($controller_path . '/controllers/drivers')) {
                ?>
                <div class="form-group row">
                    <label class="col-3 col-form-label"><?= $this->lang->line('driver') ?></label>
                    <div class="col-9">
                        <select name="driver" class="form-control">
                            <option value="0"><?= $this->lang->line('not_assign') ?></option>
                            <?php foreach ($drivers as $driver) { ?>
                                <option <?= $driver->id == $order->driver ? 'selected' : '' ?> value="<?= $driver->id ?>"><?= $driver->name ?></option>  
                            <?php } ?>
                        </select>
                    </div>
                </div>
            <?php } ?>

            <div class="form-group row">
                <label class="col-3 col-form-label"><?= $this->lang->line('expected_delivery_time') ?></label>
                <div class="col-9">
                    <input type="text" name="expected_delivery_time" class="form-control datetimepicker" value="<?= $order->expected_delivery_time ?>" />
                </div>
            </div>

            <div class="form-group row">
                <label class="col-3 col-form-label"><?= $this->lang->line('delivery_details') ?></label>
                <div class="col-9">
                    <textarea class="form-control" rows="3" placeholder="<?php echo $this->lang->line('delivery_details') ?>" name="delivery_details"><?= $order->delivery_details ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-3 col-form-label"><?= $this->lang->line('payment_method') ?></label>
                <?php $payment_method = array('cash', 'Knit', 'Visa/Master', 'link') ?>
                <div class="col-9">
                    <?php if ($order_items[0]->paid == 1) { ?>
                        <span><?= $this->lang->line($payment_method[$order->payment_method]) ?></span>
                        <input type="hidden" name="payment_method" value="<?= $order->payment_method ?>" />
                    <?php } else { ?>
                        <select name="payment_method" class="form-control" id="payment_method">
                            <?php foreach ($payment_method as $key => $value) { ?>
                                <option <?= $key == $order->payment_method ? 'selected' : '' ?> value="<?= $key ?>"><?= $this->lang->line($value) ? $this->lang->line($value) : $value ?></option>  
                            <?php } ?>
                        </select>
                    <?php } ?>
                </div>
            </div>

            <div id="paid_select_container" style="display: none">
                <select name="paid" class="form-control" >
                    <option value="1" <?= $order_items[0]->paid == 1 ? 'selected' : '' ?> ><?php echo $this->lang->line('payment-is-made') ?></option>
                    <option value="2" <?= $order_items[0]->paid == 2 ? 'selected' : '' ?> ><?php echo $this->lang->line('not-paid') ?></option>
                </select>
            </div>

            <div class="form-group row">
                <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></label>
                <div class="col-9" id="paid">
                    <?php if ($order_items[0]->paid == 1) { ?>
                        <span><?= $this->lang->line('payment-is-made') ?></span>
                    <?php } ?>

                    <!--                    <div class="radio">
                                            <input type="radio" name="paid"  value="1"  <?//= $order_items[0]->paid == 1 ? 'checked' : '' ?> required>
                                            <label>   <?php //echo $this->lang->line('payment-is-made')                ?>
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <input type="radio" name="paid"  value="2" <?//= $order_items[0]->paid == 2 ? 'checked' : '' ?>>
                                            <label>   <?php //echo $this->lang->line('not-paid')                ?>
                                            </label>
                                        </div>-->
                    <!--                    <div class="radio">
                                            <input type="radio" name="paid"  value="3" <?//= $order_items[0]->paid == 3 ? 'checked' : '' ?>>
                                            <label>  <?php //echo $this->lang->line('complimentary')                   ?> 
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <input type="radio" name="paid"  value="4" <?//= $order_items[0]->paid == 4 ? 'checked' : '' ?>>
                                            <label> <?php //echo $this->lang->line('retriever')                   ?>
                                            </label>
                                        </div> -->
                </div>
            </div>

        </div>
        <div class="kt-portlet__foot">
            <div class="kt-form__actions">
                <div class="row">
                    <div class="col-10">
                        <button type="submit" class="btn btn-primary" name="submit" value="pl"><?php echo $this->lang->line('save') ?></button>
                    </div>
                </div>
            </div>
        </div>
        </form>
    </div>

    <?php
    $paid_status = '';
    if ($order_items[0]->paid == 1)
        $paid_status = $this->lang->line('payment-is-made');
    if ($order_items[0]->paid == 2)
        $paid_status = $this->lang->line('not-paid');
    ?>


    <?php $this->load->view('site/footer_2'); ?>
    <script>

        $(".datepicker").datepicker({
            format: "yyyy-mm-dd",
            todayHighlight: true
        });
        $(".datetimepicker").datetimepicker({
            format: "yyyy-mm-dd H:i:s",
            todayHighlight: true
        });
<?php if ($order_items[0]->paid != 1) { ?>
            $("#payment_method").change(function () {
                if ($(this).val() == 3) {
                    $('#paid').html('<span><?= $paid_status ?></span>');
                } else {
                    $('#paid').html($("#paid_select_container").html());
                }
            });
            $("#payment_method").change();
<?php } ?>
    </script>
