<?php $this->load->view('site/layout'); ?>
<link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<style>
    .btn i {
        padding-left: 0rem;
    }
</style>
<?php $this->load->view('site/navbar'); ?>

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?php echo $this->lang->line('replies'); ?></span>
            </div>

        </div>
    </div>
</div>


<div class="kt-portlet kt-portlet--mobile">
    <?php if ($this->session->flashdata('success')) { ?>
        <div class="alert alert-success">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
            <?= $this->session->flashdata('success') ?>
        </div>
    <?php } ?>

    <?php if ($this->session->flashdata('error')) { ?>
        <div class="alert alert-danger">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
            <?= $this->session->flashdata('error') ?>
        </div>
    <?php } ?>

    <div class="kt-portlet__head kt-portlet__head--lg">
        <div class="kt-portlet__head-label">
            <span class="kt-portlet__head-icon">
                <i class="kt-font-brand flaticon2-line-chart"></i>
            </span>
            <h3 class="kt-portlet__head-title">
                <?php echo $this->lang->line('replies'); ?>
            </h3>
        </div>

        <div class="kt-portlet__head-toolbar">
            <div class="kt-portlet__head-wrapper">
                <div class="kt-portlet__head-actions">
                    <a href="<?php echo base_url('knowledge_base/addreply/') . $comment[0]->id; ?>" class="btn btn-brand btn-elevate btn-icon-sm">
                        <i class="la la-plus"></i>
                        <?php echo $this->lang->line('add_reply') ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">

        <div class="panel-body">
            <div class="form-group row">
                <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('comment') ?></label>
                <div class="col-10 mt-2">
                   <?= $comment[0]->comment_text; ?>
                </div>
            </div>
            <hr/>
           
            <table id="dataTable" class="table table-striped table-bordered table-hover">

                <thead>
                    <tr>
                        <td>
                            #
                        </td>
                        <td>
                            <?= $this->lang->line('reply') ?>
                        </td>

                        <td>
                            <?= $this->lang->line('author_type') ?>
                        </td>

                        <td>
                            <?= $this->lang->line('date') ?>
                        </td>
                        <td>
                            <?= $this->lang->line('status') ?>
                        </td>
                        <td>
                            <?= $this->lang->line('action') ?>
                        </td>
                    </tr>
                </thead>

                <tbody>

                    <?php
                    if (isset($replies) && $replies != null) {
                        for ($i = 0; $i < count($replies); ++$i) {
                            //$yes_num = $cont->getRateNum($articles[$i]->article_id,'نعم') + $articles[$i]->yes_rate;
                            ?>

                            <tr>
                                <td>
                                    <?php echo $replies[$i]->id; ?>
                                </td>
                                <td>
                                    <?php echo '<p>' . mb_substr(strip_tags($replies[$i]->reply_text), 0, 10, 'utf-8') . "...</p>"; ?>
                                </td>

                                <td>
                                    <?php
                                    $user_type = $replies[$i]->user_type;
                                    if ($user_type == 'logged') {
                                        echo 'مسجّل';
                                    } else {
                                        echo 'غير مسجّل';
                                    }
                                    ?>
                                </td>

                                <td>
                                    <?php echo $replies[$i]->r_date; ?>
                                </td>

                                <td>
                                    <?= $replies[$i]->reply_status == 'منشور' ? $this->lang->line('shown') : $this->lang->line('hidden'); ?>
                                    <?php if ($replies[$i]->reply_status == "منشور") { ?>
                                        <?php echo form_open('knowledge_base/changeReplyStatus/0'); ?>
                                        <form>
                                            <input type="hidden" id="reply_id" name="reply_id" value='<?php echo $replies[$i]->id; ?>' />
                                            <input type="hidden" id="comment_id" name="comment_id" value='<?php echo $comment[0]->id; ?>' />
                                            <button type="submit" id="reply_btn" class="btn btn-info mt" ><?= $this->lang->line('hide') ?></button>
                                        </form>
                                    <?php } else { ?>
                                        <?php echo form_open('knowledge_base/changeReplyStatus/1'); ?>
                                        <form>
                                            <input type="hidden" id="reply_id" name="reply_id" value='<?php echo $replies[$i]->id; ?>' />
                                            <input type="hidden" id="comment_id" name="comment_id" value='<?php echo $comment[0]->id; ?>' />
                                            <button type="submit" id="reply_btn" class="btn btn-info mt" ><?= $this->lang->line('show') ?></button>
                                        </form>
                                    <?php } ?>
                                </td>

                                <td>

                                    <a href="<?php echo base_url("knowledge_base/editreply/") . $replies[$i]->id . '/' . $comment[0]->id; ?>" class="btn btn-small btn-primary" title="<?= $this->lang->line('edit') ?>">
                                        <i class="fa fa-edit"></i>
                                    </a>

                                    <a class="btn btn-danger btn-small" onclick="return confirm('are you sure?');" href="<?= base_url() ?>knowledge_base/deletereply/<?= $replies[$i]->id . '/' . $comment[0]->id ?>" title="<?= $this->lang->line('delete') ?>">
                                        <i class="fa fa-minus-circle"></i>
                                    </a>

                                </td>
                            </tr>
                            <?php
                        }
                    }
                    ?>

                </tbody>



            </table>

        </div>



    </div>



    <?php $this->load->view('site/footer_2'); ?>

    <script>
        $(document).ready(function () {
            $('#dataTable').DataTable();
            //        $('#dataTable').DataTable({
            //            dom: 'Bfrtip',
            //            buttons: [
            //                'copy', 'csv', 'excel', 'pdf', 'print'
            //            ],
            //            "language": {
            //                "emptyTable": "لا يوجد بيانات في الجدول"
            //            },
            //            rowReorder: {
            //                selector: 'tr'
            //            },
            //            columnDefs: [
            //                {targets: 0, visible: true}
            //            ]
            //        });
        });
    </script>