<?php $this->load->view('site/layout'); ?>
<link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<style>
    .btn i {
        padding-left: 0rem;
    }
</style>
<?php $this->load->view('site/navbar'); ?>

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?php echo $this->lang->line('comments'); ?></span>
            </div>

        </div>
    </div>
</div>
<div class="kt-portlet kt-portlet--mobile">
    <?php if ($this->session->flashdata('success')) { ?>
        <div class="alert alert-success">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
            <?= $this->session->flashdata('success') ?>
        </div>
    <?php } ?>

    <?php if ($this->session->flashdata('error')) { ?>
        <div class="alert alert-danger">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
            <?= $this->session->flashdata('error') ?>
        </div>
    <?php } ?>

    <div class="kt-portlet__head kt-portlet__head--lg">
        <div class="kt-portlet__head-label">
            <span class="kt-portlet__head-icon">
                <i class="kt-font-brand flaticon2-line-chart"></i>
            </span>
            <h3 class="kt-portlet__head-title">
                <?php echo $this->lang->line('comments'); ?> (<?= $article_title ?>)
            </h3>
        </div>

        <!--        <div class="kt-portlet__head-toolbar">
                    <div class="kt-portlet__head-wrapper">
                        <div class="kt-portlet__head-actions">
        
                            &nbsp;
        
                            <a href="<?//= base_url() ?>knowledge_base/addcomment/" class="btn btn-brand btn-elevate btn-icon-sm">
                                <i class="la la-plus"></i>
        <?php //echo $this->lang->line('add') . ' ' . $this->lang->line('comment') ?>
                            </a>
                        </div>
                    </div>
                </div>-->
    </div>
    <div class="kt-portlet__body">

        <table id="dataTable" class="table table-striped table-bordered table-hover">

            <thead>
                <tr>
                    <td>
                        #
                    </td>
                    <td>
                        <?= $this->lang->line('article') . ' ' . $this->lang->line('title') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('comment') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('author_type') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('date') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('status') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('action') ?>
                    </td>
                </tr>
            </thead>

            <tbody>



                <?php
                if (isset($comments) && $comments != null) {
                    for ($i = 0; $i < count($comments); ++$i) {
                        //$yes_num = $cont->getRateNum($articles[$i]->article_id,'نعم') + $articles[$i]->yes_rate;
                        ?>

                        <tr>
                            <td>
                                <?php echo $comments[$i]->comment_id; ?>
                            </td>
                            <td>
                                <?php echo $comments[$i]->title; ?>
                            </td>
                            <td>
                                <?php echo '<p>' . mb_substr(strip_tags($comments[$i]->comment_text), 0, 10, 'utf-8') . "...</p>"; ?>
                            </td>

                            <td>
                                <?php
                                $user_type = $comments[$i]->user_type;
                                if ($user_type == 'logged') {
                                    echo 'مسجّل';
                                } else {
                                    echo 'غير مسجّل';
                                }
                                ?>
                            </td>

                            <td>
                                <?php echo $comments[$i]->c_date; ?>
                            </td>

                            <td>
                                <?= $comments[$i]->comment_status == 'منشور' ? $this->lang->line('shown') : $this->lang->line('hidden'); ?>
                                <?php if ($comments[$i]->comment_status == "منشور") { ?>
                                    <?php echo form_open('knowledge_base/changeCommentStatus/0'); ?>
                                    <form>
                                        <input type="hidden" id="comment_id" name="comment_id" value='<?php echo $comments[$i]->comment_id; ?>' />
                                        <input type="hidden" id="article_id" name="article_id" value='<?php echo $article_id; ?>' />
                                        <button type="submit" id="comment_btn" class="btn btn-info mt" ><?= $this->lang->line('hide') ?></button>
                                    </form>
                                <?php } else { ?>
                                    <?php echo form_open('knowledge_base/changeCommentStatus/1'); ?>
                                    <form>
                                        <input type="hidden" id="comment_id" name="comment_id" value='<?php echo $comments[$i]->comment_id; ?>' />
                                        <input type="hidden" id="article_id" name="article_id" value='<?php echo $article_id; ?>' />
                                        <button type="submit" id="comment_btn" class="btn btn-info mt" ><?= $this->lang->line('show') ?></button>
                                    </form>
                                <?php } ?>
                            </td>

                            <td>

                <!--                                <a href="<?php //echo base_url("knowledge_base/editcomment/") . $comments[$i]->comment_id;   ?>" class="btn btn-small btn-success" title="<?//= $this->lang->line('edit') ?>">
                                                    <i class="fa fa-pencil-square-o"></i>
                                                </a>-->
                                <?php if (get_ap('kw_delete_comment', $this->operator_id)) { ?>
                                    <a class="btn btn-danger btn-small" onclick="return confirm('are you sure?');" href="<?= base_url() ?>knowledge_base/deletecomment/<?= $comments[$i]->comment_id ?>" title="<?= $this->lang->line('delete') ?>">
                                        <i class="fa fa-minus-circle"></i>
                                    </a>
                                <?php } ?>

                                <a href="<?php echo base_url() . "knowledge_base/commentreplies/" . $comments[$i]->comment_id; ?>" class="btn btn-small btn-info" title="<?= $this->lang->line('replies') ?>">
                                    <i class="fa fa-comment"></i>
                                </a>

                            </td>
                        </tr>
                        <?php
                    }
                }
                ?>

            </tbody>



        </table>

    </div>



</div>


<?php $this->load->view('site/footer_2'); ?>

<script>
    $(document).ready(function () {
        $('#dataTable').DataTable();
//        $('#dataTable').DataTable({
//            dom: 'Bfrtip',
//            buttons: [
//                'copy', 'csv', 'excel', 'pdf', 'print'
//            ],
//            "language": {
//                "emptyTable": "لا يوجد بيانات في الجدول"
//            },
//            rowReorder: {
//                selector: 'tr'
//            },
//            columnDefs: [
//                {targets: 0, visible: true}
//            ]
//        });
    });
</script>