<?php $this->load->view('site/layout'); ?>
<link href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<style>
    .btn i {
        padding-left: 0rem;
    }
</style>
<?php $this->load->view('site/navbar'); ?>

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?php echo $this->lang->line('articles'); ?></span>
            </div>

        </div>
    </div>
</div>

<div class="kt-portlet kt-portlet--mobile">
    <?php if ($this->session->flashdata('success')) { ?>
        <div class="alert alert-success">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
            <?= $this->session->flashdata('success') ?>
        </div>
    <?php } ?>

    <?php if ($this->session->flashdata('error')) { ?>
        <div class="alert alert-danger">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>
            <?= $this->session->flashdata('error') ?>
        </div>
    <?php } ?>

    <div class="kt-portlet__head kt-portlet__head--lg">
        <div class="kt-portlet__head-label">
            <span class="kt-portlet__head-icon">
                <i class="kt-font-brand flaticon2-line-chart"></i>
            </span>
            <h3 class="kt-portlet__head-title">
                <?php echo $this->lang->line('articles'); ?> (<?= $dalel_name ?>)
            </h3>
        </div>

        <div class="kt-portlet__head-toolbar">
            <div class="kt-portlet__head-wrapper">
                <div class="kt-portlet__head-actions">

                    &nbsp;
                    <?php if (get_ap('kw_add_article', $this->operator_id)) { ?>
                        <a href="<?= base_url() ?>knowledge_base/addarticle/<?= $dalel_id ?>" class="btn btn-brand btn-elevate btn-icon-sm">
                            <i class="la la-plus"></i>
                            <?php echo $this->lang->line('add') . ' ' . $this->lang->line('article') ?>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">

        <table id="dataTable" class="table table-striped table-bordered table-hover">

            <thead>
                <tr>
                    <td style="width: 10%">
                        <?= $this->lang->line('arrangement') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('title') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('article_text') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('author') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('category') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('guide') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('comments') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('rating') ?>
                    </td>

                    <td>
                        <?= $this->lang->line('created_at') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('no_rating_count') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('yes_rating_count') ?>
                    </td>
                    <td>
                        <?= $this->lang->line('action') ?>
                    </td>
                </tr>
            </thead>

            <tbody>



                <?php
                $order_arr = array();
                if (isset($articles) && $articles != null) {
                    for ($i = 0; $i < count($articles); ++$i) {
                        $yes_num = $cont->getRateNum($articles[$i]->article_id, 'نعم') + $articles[$i]->yes_rate;
                        $no_num = $cont->getRateNum($articles[$i]->article_id, 'لا') + $articles[$i]->no_rate;
                        ?>

                        <tr>
                            <td>
                                <input type="number" name="art_order" class="form-control" art_id="<?php echo $articles[$i]->article_id; ?>" value="<?php echo $articles[$i]->article_order; ?>"  />
                                <?php
                                $order_arr[$articles[$i]->article_id] = $articles[$i]->article_order;
                                ?>
                            </td>
                            <td>
                                <?php echo $articles[$i]->title; ?>
                            </td>
                            <td>
                                <?php echo '<p>' . mb_substr(strip_tags($articles[$i]->text), 0, 20, 'utf-8') . "...</p>"; ?>
                            </td>

                            <td>
                                <?php echo $articles[$i]->author; ?>
                            </td>

                            <td>
                                <?php
                                //echo $articles[$i]->name; 
                                echo $cont->getsinglecategory($articles[$i]->category_id);
                                ?>
                            </td>
                            <td>
                                <?php echo $cont->dalelofcat($articles[$i]->category_id);
                                ?>
                            </td>
                            <td>
                                <?php echo $articles[$i]->check_comment; ?>
                            </td>

                            <td>
                                <?php echo $articles[$i]->check_rate; ?>
                            </td>
                            <td>
                                <?php echo $articles[$i]->created_at; ?>
                            </td>
                            <td>
                                <?php echo $yes_num; ?>
                            </td>
                            <td>
                                <?php echo $no_num; ?>
                            </td>

                            <td>


                                <?php if (get_ap('kw_edit_article', $this->operator_id)) { ?>

                                    <a href="<?php echo base_url("knowledge_base/editarticle/") . $articles[$i]->article_id . '/' . $dalel_id; ?>" class="btn btn-small btn-primary" title="<?= $this->lang->line('edit') ?>">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                <?php } ?>
                                <?php if (get_ap('kw_delete_article', $this->operator_id)) { ?>
                                    <a class="btn btn-danger btn-small" onclick="return confirm('are you sure?');" href="<?= base_url('knowledge_base/deletearticle' . $articles[$i]->article_id . '/' . $dalel_id) ?>" title="<?= $this->lang->line('delete') ?>">
                                        <i class="fa fa-minus-circle"></i>
                                    </a>
                                <?php } ?>

                                <?php if (get_ap('kw_comments', $this->operator_id)) { ?>
                                    <a href="<?php echo base_url("knowledge_base/comments/") . $articles[$i]->article_id; ?>" class="btn btn-small btn-success" title="<?= $this->lang->line('comments') ?>">
                                        <i class="fa fa-comments"></i>
                                    </a>
                                <?php } ?>

                            </td>
                        </tr>
                        <?php
                    }
                }
                ?>

            </tbody>
        </table>

        <?php echo form_open('knowledge_base/reorderallarticles'); ?>
        <form>
            <input type="hidden" id="art_json" name="art_json" value='<?php echo json_encode($order_arr); ?>' />
            <input type="hidden" id="dalel_id" name="dalel_id" value='<?php echo $dalel_id; ?>' />
            <button type="submit" id="art_btn" class="btn btn-info art_btn mt" disabled="disabled"><?= $this->lang->line('save_order') ?></button>
        </form>
    </div>

</div>








<?php $this->load->view('site/footer_2'); ?>

<script>
    $("#dataTable").DataTable();
    function enable_art_btn(btn_id) {
        $("#" + btn_id).prop('disabled', false);
    }
//$(document).ready(function() {
    //$("input[name='art_order']").change(function() {
    $(document).on('change', 'input[name="art_order"]', function () {
        $("#art_btn").removeAttr("disabled");
        art_id = $(this).attr('art_id');
        art_order = $(this).val();
        new_json_string = '{';
        art_order_json = $("#art_json").val();
        art_order_string = art_order_json.replace('{', '');
        art_order_string = art_order_string.replace('}', '');
        art_order_string = art_order_string.replace(/\"/g, '');
        string_arr = art_order_string.split(',');
        for (i = 0; i < string_arr.length; i++) {
            string_item = string_arr[i];
            arr_item = string_item.split(':');
            if (arr_item[0] == art_id) {
                if (i == 0) {
                    new_json_string += '\"' + arr_item[0] + '\":\"' + art_order + '\"';
                } else {
                    new_json_string += ',\"' + arr_item[0] + '\":\"' + art_order + '\"';
                }
            } else {
                if (i == 0) {
                    new_json_string += '\"' + arr_item[0] + '\":\"' + arr_item[1] + '\"';
                } else {
                    new_json_string += ',\"' + arr_item[0] + '\":\"' + arr_item[1] + '\"';
                }
            }
        }
        new_json_string += '}'
        //$("#cattt").append(new_json_string);
        $("#art_json").val(new_json_string);
    });
//});
</script>