<?php $this->load->view('site/drivers/profile_header') ?>
<!--begin::Content-->
<style>
    .mt-10px{
        margin-top: 10px;
    }
    table.dataTable {
        max-width: 100% !important;
        overflow: scroll;
    }
</style>

<div class="flex-row-fluid ml-lg-8">
    <!--begin::Card-->
    <div class="card card-custom card-stretch">
        <!--begin::Header-->
        <?php echo form_open(); ?>

        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $this->lang->line('orders') ?></h3>
                <span class="text-muted font-weight-bold font-size-sm mt-1"><?= $this->lang->line('check_ur_order_details') ?></span>
            </div>

            <div class="clearfix"></div>
        </div>
        <!--end::Header-->
        <!--begin::Form-->

        <!--begin::Body-->
        <div class="card-body" style="overflow: scroll">

            <?php if ($this->session->flashdata('error') != '' || validation_errors() !== ''): ?>
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-danger"></i> <?= $this->lang->line('error') ?>!</h4>&nbsp;
                        <?= $this->session->flashdata('error'); ?>
                        <?= validation_errors(); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('success') != ''): ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-success"></i> </h4>&nbsp;
                        <?= $this->lang->line('op_success'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php echo form_open(); ?>
            <h3><?= $this->lang->line('filters') ?></h3>
            <div class="form-group row">
                <label for="example-text-input" class="col-2 col-form-label"><?php echo $this->lang->line('date') ?></label>
                <div class="col-8">
                    <input type="text" name="start_expiry" id="start_expiry" class="form-control" value="<?= set_value('start_expiry') ?>"> 
                </div>
                <div class="col-1" style="padding-left: 0px">
                    <a onclick="clear_date()" class="btn btn-light btn-text-primary btn-hover-text-primary font-weight-bold"><?= $this->lang->line('clear') ?></a>
                </div>
            </div>
            <button type="submit" class="btn btn-primary pull-right"><?php echo $this->lang->line('submit') ?></button>
        </div>
        </form>          
        <br/>

        <div class="kt-portlet__body" style="padding: 20px">
            <?php $order_status = array(2 => 'ready_for_deliver', 3 => 'delivering', 4 => 'delivered') ?>
            <ul class="nav nav-tabs nav-tabs-line mb-10">
                <li class="nav-item">
                    <a class="nav-link active" data-toggle="tab" href="#kt_tab_pane_1"> <span class="nav-icon"> 
                            <i class="fas fa-box"></i>
                        </span> <span class="nav-text"><?= $this->lang->line($order_status[2]) ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link " data-toggle="tab" href="#kt_tab_pane_2"> <span class="nav-icon"> 
                            <i class="fas fa-truck"></i>
                        </span> <span class="nav-text"><?= $this->lang->line($order_status[3]) ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-toggle="tab" href="#kt_tab_pane_3"> <span class="nav-icon"> 
                            <i class="far fa-handshake"></i>
                        </span> <span class="nav-text"><?= $this->lang->line($order_status[4]) ?></span>
                    </a>
                </li>
            </ul>
            <!--begin: Datatable -->
            <div class="tab-content" id="myTabContent">
                <div id="kt_tab_pane_1" class="tab-pane fade show active">
                    <table class="table table-bordered table-hover list_table w-100 d-block d-md-table" >
                        <thead>
                            <tr> 
                                <th><?php echo $this->lang->line('date') ?></th>
                                <th><?php echo $this->lang->line('customer') ?></th>
                                <th><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></th>
                                <th><?php echo $this->lang->line('payment_method') ?></th>
                                <th><?php echo $this->lang->line('total_amount') ?></th>
                                <th><?= $this->lang->line('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $payment_method = array('cash', 'Knit', 'Visa/Master', 'link');
                            foreach ($orders_before_delivery as $value) {
                                ?>
                                <tr>
                                    <td><?= $value->timestamp ?></td>
                                    <td><?= $value->client ?></td>
                                    <td><?= $this->lang->line($value->paid == 1 ? 'payment-is-made' : 'not-paid') ?></td>
                                    <td><?= $this->lang->line($payment_method[$value->payment_method]) ?></td>
                                    <td><?= round($value->total_amount, 3) ?></td>
                                    <td>
                                        <a href="<?= base_url('drivers/Drivers_login/show_order/' . $value->id) ?>"  class="btn btn-icon btn-warning" title="<?= $this->lang->line('show') ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <a href="<?= base_url('drivers/Drivers_login/edit_order/' . $value->id) ?>"  class="btn btn-icon btn-primary" title="<?= $this->lang->line('edit_order_status') ?>">
                                            <i class="la la-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                </div>

                <div id="kt_tab_pane_2" class="tab-pane fade">
                    <table class="table table-bordered table-hover list_table w-100 d-block d-md-table" >
                        <thead>
                            <tr> 
                                <th><?php echo $this->lang->line('date') ?></th>
                                <th><?php echo $this->lang->line('customer') ?></th>
                                <th><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></th>
                                <th><?php echo $this->lang->line('payment_method') ?></th>
                                <th><?php echo $this->lang->line('total_amount') ?></th>
                                <th><?= $this->lang->line('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $payment_method = array('cash', 'Knit', 'Visa/Master', 'link');
                            foreach ($orders_in_delivery as $value) {
                                ?>
                                <tr>
                                    <td><?= $value->timestamp ?></td>
                                    <td><?= $value->client ?></td>
                                    <td><?= $this->lang->line($value->paid == 1 ? 'payment-is-made' : 'not-paid') ?></td>
                                    <td><?= $this->lang->line($payment_method[$value->payment_method]) ?></td>
                                    <td><?= round($value->total_amount, 3) ?></td>
                                    <td>
                                        <a href="<?= base_url('drivers/Drivers_login/show_order/' . $value->id) ?>"  class="btn btn-icon btn-warning" title="<?= $this->lang->line('show') ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <a href="<?= base_url('drivers/Drivers_login/edit_order/' . $value->id) ?>"  class="btn btn-icon btn-primary" title="<?= $this->lang->line('edit_order_status') ?>">
                                            <i class="la la-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                </div>

                <div id="kt_tab_pane_3" class="tab-pane fade">
                    <table class="table table-bordered table-hover list_table w-100 d-block d-md-table"  >
                        <thead>
                            <tr> 
                                <th><?php echo $this->lang->line('date') ?></th>
                                <th><?php echo $this->lang->line('customer') ?></th>
                                <th><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></th>
                                <th><?php echo $this->lang->line('payment_method') ?></th>
                                <th><?php echo $this->lang->line('total_amount') ?></th>
                                <th><?= $this->lang->line('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $payment_method = array('cash', 'Knit', 'Visa/Master', 'link');
                            foreach ($orders_delivered as $value) {
                                ?>
                                <tr>
                                    <td><?= $value->timestamp ?></td>
                                    <td><?= $value->client ?></td>
                                    <td><?= $this->lang->line($value->paid == 1 ? 'payment-is-made' : 'not-paid') ?></td>
                                    <td><?= $this->lang->line($payment_method[$value->payment_method]) ?></td>
                                    <td><?= round($value->total_amount, 3) ?></td>
                                    <td>
                                        <a href="<?= base_url('drivers/Drivers_login/show_order/' . $value->id) ?>"  class="btn btn-icon btn-warning" title="<?= $this->lang->line('show') ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
    <!--                                        <a href="<?//= base_url('drivers/Drivers_login/edit_order/' . $value->id) ?>"  class="btn btn-icon btn-primary" title="<?//= $this->lang->line('edit_order_status') ?>">
                                            <i class="la la-edit"></i>
                                        </a>-->
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
        <!--end::Body-->
        <?php echo form_close(); ?>
        <!--end::Form-->
    </div>
</div>
<!--end::Content-->

<?php $this->load->view('site/drivers/profile_footer') ?>
<script src="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.js"></script>
<?php //$this->load->view('site/footer_2'); ?> 
<script>
                        $(function () {
                            $(".list_table").DataTable({dom: 'Bfrtip',
                                aaSorting: [],
                                destroy: true,
                                buttons: [
                                    {
                                        extend: 'excelHtml5',
                                        charset: 'UTF-16LE',
                                        fieldSeparator: '\t',
                                        bom: true
                                    },
                                    {
                                        extend: 'csvHtml5',
                                        charset: 'UTF-16LE',
                                        fieldSeparator: '\t',
                                        bom: true
                                    },
                                    {
                                        extend: 'pdfHtml5',
                                        charset: 'UTF-16LE',
                                        fieldSeparator: '\t',
                                        bom: true
                                    },
                                    {
                                        extend: 'print',
                                        autoPrint: false,
                                        footer: true
                                    }

                                ]
                            });
//            buttons: [
//                'copyHtml5',
//                'excelHtml5',
//                'csvHtml5',
//                'pdfHtml5'
//            ]
                        });

</script>
