<?php $this->load->view('site/drivers/profile_header') ?>
<!--begin::Content-->
<style>
    .mt-10px{
        margin-top: 10px;
    }
    table.dataTable {
        max-width: 100% !important;
        overflow: scroll;
    }
</style>

<div class="flex-row-fluid ml-lg-8">
    <!--begin::Card-->
    <div class="card card-custom card-stretch">
        <!--begin::Header-->
        <?php echo form_open(); ?>

        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $this->lang->line('orders') ?></h3>
                <span class="text-muted font-weight-bold font-size-sm mt-1"><?= $this->lang->line('check_ur_order_details') ?></span>
            </div>
            <?php if ($order->order_status != 4) { ?>
                <div class="card-toolbar" style="float: right">
                    <a href="<?= base_url('drivers/Drivers_login/edit_order/' . $order_id) ?>" class="btn btn-primary mr-2 mt-1" ><?= $this->lang->line('edit') ?></a>
                    <!--<button type="reset" class="btn btn-secondary">Cancel</button>-->
                </div>
            <?php } ?>

            <div class="clearfix"></div>
        </div>
        <!--end::Header-->
        <!--begin::Form-->

        <!--begin::Body-->
        <div class="card-body" style="overflow: scroll">

            <?php if ($this->session->flashdata('error') != '' || validation_errors() !== ''): ?>
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-danger"></i> <?= $this->lang->line('error') ?>!</h4>&nbsp;
                        <?= $this->session->flashdata('error'); ?>
                        <?= validation_errors(); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('success') != ''): ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-success"></i> </h4>&nbsp;
                        <?= $this->lang->line('op_success'); ?>
                    </div>
                </div>
            <?php endif; ?>



            <div class="kt-portlet__body" style="padding: 20px">
                <?php $delivery_status = array('not_shipped', 'delivering', 'delivered'); ?>

                <!--begin: Datatable -->
                <?php $payment_method = array('cash', 'Knit', 'Visa/Master', 'link'); ?>
                <?php $order_status = array('waiting', 'preparing', 'ready_for_deliver', 'delivering', 'delivered', 'canceled') ?>
                <table class="table table-bordered table-hover list_table w-100 d-block d-md-table" >
                    <tbody>
                        <tr>
                            <td colspan="8"><h3><i class="far fa-file-alt"></i>&nbsp;&nbsp;<strong><?= $this->lang->line('order') ?></strong></h3></td>
                        </tr>
                        <tr>
                            <td colspan="2"><?= $this->lang->line('total_amount') ?></td>
                            <td colspan="2"><?= $order->total_amount ?></td>
                            <td colspan="2"><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></td>
                            <td colspan="2"><?= $order->paid == 1 ? $this->lang->line('payment-is-made') : $this->lang->line('not-paid') ?></td>
                        </tr>
                        <tr>
                            <td colspan="2"><?= $this->lang->line('payment_method') ?></td>
                            <td colspan="2"><?= $payment_method[$order->payment_method] ?></td>
                            <td colspan="2"><?= $this->lang->line('order_status') ?></td>
                            <td colspan="2"><?= $this->lang->line($order_status[$order->order_status]) ?></td>
                        </tr>
                        <tr>
<!--                            <td colspan="2"><?//= $this->lang->line('delivery_status') ?></td>
                            <td colspan="2"><?//= $this->lang->line($delivery_status[$order->delivery_status]) ?></td>-->
                            <td colspan="2"><?= $this->lang->line('expected_delivery_time') ?></td>
                            <td colspan="6"><?= $order->expected_delivery_time ?></td>
                        </tr>
                        <tr>
                            <td colspan="2"><?= $this->lang->line('delivery_details') ?></td>
                            <td colspan="6"><?= $order->delivery_details ?></td>
                        </tr>
                        <tr>
                            <td colspan="8"><h3><i class="fas fa-user-alt"></i>&nbsp;&nbsp;<strong><?= $this->lang->line('customer') ?></strong></h3></td>
                        </tr>
                        <tr>
                            <td colspan="2"><?= $this->lang->line('customer') ?></td>
                            <td colspan="2"><?= $order->username ?></td>
                            <td colspan="2"><?= $this->lang->line('phone') ?></td>
                            <td colspan="2"><?= $order->phone ?></td>
                        </tr>
                        <tr>
                            <td colspan="8"><h3><i class="fas fa-map-marked-alt"></i>&nbsp;&nbsp;<strong><?= $this->lang->line('address') ?></strong></h3></td>
                        </tr>
                        <tr>
                            <td><?= $this->lang->line('nationality') ?></td>
                            <td><?= $order->nationality ?></td>
                            <td><?= $this->lang->line('region') ?></td>
                            <td><?= $order->region ?></td>
                            <td><?= $this->lang->line('block') ?></td>
                            <td><?= $order->blocks ?></td>
                            <td><?= $this->lang->line('street') ?></td>
                            <td><?= $order->street ?></td>

                        </tr>
                        <tr>
                            <td><?= $this->lang->line('jadah') ?></td>
                            <td><?= $order->jadah ?></td>
                            <td><?= $this->lang->line('building_num') ?></td>
                            <td><?= $order->building_num ?></td>
                            <td><?= $this->lang->line('floor') ?></td>
                            <td><?= $order->floor ?></td>
                            <td><?= $this->lang->line('door-number') ?></td>
                            <td><?= $order->door_no ?></td>

                        </tr>
                        <tr>
                            <td colspan="3"><?= $this->lang->line('address-link') ?></td>
                            <td colspan="5"><?= $order->address_link ? '<a href="' . $order->address_link . '">' . $this->lang->line("address") . '</a>' : '---' ?></td>
                        </tr>
                    </tbody>
                </table>



            </div>
            <!--end::Body-->
            <?php echo form_close(); ?>
            <!--end::Form-->
        </div>
    </div>
</div>
<!--end::Content-->

<?php $this->load->view('site/drivers/profile_footer') ?>

<?php //$this->load->view('site/footer_2'); ?> 
<script src="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.js"></script>
<script>
    $(function () {
        $(".list_table").DataTable({dom: 'Bfrtip',
            aaSorting: [],
            destroy: true,
            buttons: [
                {
                    extend: 'excelHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'csvHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'pdfHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'print',
                    autoPrint: false,
                    footer: true
                }

            ]
        });
//            buttons: [
//                'copyHtml5',
//                'excelHtml5',
//                'csvHtml5',
//                'pdfHtml5'
//            ]
    });

</script>
