<?php $this->load->view('site/drivers/profile_header') ?>
<!--begin::Content-->
<style>
    .mt-10px{
        margin-top: 10px;
    }
</style>

<div class="flex-row-fluid ml-lg-8">
    <!--begin::Card-->
    <div class="card card-custom card-stretch">
        <!--begin::Header-->
        <?php echo form_open(); ?>

        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $this->lang->line('orders') ?></h3>
                <span class="text-muted font-weight-bold font-size-sm mt-1"><?= $this->lang->line('check_ur_order_details') ?></span>
            </div>
            <div class="card-toolbar" style="float: right">
                <button type="submit" class="btn btn-success mr-2 mt-1"><?= $this->lang->line('save') ?></button>
                <!--<button type="reset" class="btn btn-secondary">Cancel</button>-->
            </div>
            <div class="clearfix"></div>
        </div>
        <!--end::Header-->
        <!--begin::Form-->

        <!--begin::Body-->
        <div class="card-body" style="overflow: scroll">

            <?php if ($this->session->flashdata('error') != '' || validation_errors() !== ''): ?>
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-danger"></i> <?= $this->lang->line('error') ?>!</h4>&nbsp;
                        <?= $this->session->flashdata('error'); ?>
                        <?= validation_errors(); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('success') != ''): ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-success"></i> </h4>&nbsp;
                        <?= $this->lang->line('op_success'); ?>
                    </div>
                </div>
            <?php endif; ?>



            <div class="kt-portlet__body" style="padding: 20px">


                <div class="form-group row">
                    <label class="col-3 col-form-label"><?= $this->lang->line('order_status') ?></label>
                    <?php $order_status = array(2 => 'ready_for_deliver', 3 => 'delivering', 4 => 'delivered') ?>
                    <div class="col-9">
                        <select name="order_status" class="form-control">
                            <?php foreach ($order_status as $key => $value) { ?>
                                <option <?= $key == $order->order_status ? 'selected' : '' ?> value="<?= $key ?>"><?= $this->lang->line($value) ?></option>  
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div id="paid_select_container" style="display: none">
                    <select name="paid" class="form-control">
                        <option value="1" <?= $order->paid == 1 ? 'selected' : '' ?> ><?php echo $this->lang->line('payment-is-made') ?></option>
                        <option value="2" <?= $order->paid == 2 ? 'selected' : '' ?> ><?php echo $this->lang->line('not-paid') ?></option>
                    </select>
                </div>

                <div class="form-group row">
                    <label for="example-search-input" class="col-3 col-form-label"><?php echo $this->lang->line('payment') ?> <?php echo $this->lang->line('status') ?></label>
                    <div class="col-9" id="paid">
                        <?php if ($order->paid != 1) { ?>

                        <?php } else { ?>
                        <span><?= $this->lang->line('payment-is-made') ?></span> 
                        <?php } ?>
                    </div>
                </div>


                <div class="form-group row">
                    <label class="col-3 col-form-label"><?= $this->lang->line('payment_method') ?></label>
                    <?php $payment_method = array('cash', 'Knit', 'Visa/Master', 'link') ?>
                    <div class="col-9">
                        <?php if ($order->paid != 1) { ?>
                            <select name="payment_method" class="form-control" id="payment_method">
                                <?php foreach ($payment_method as $key => $value) { ?>
                                    <option value="<?= $key ?>" <?= $order->payment_method == $key ? 'selected' : '' ?>><?= $this->lang->line($value) ? $this->lang->line($value) : $value ?></option>  
                                <?php } ?>
                            </select>
                        <?php } else { ?>
                            <span><?= $this->lang->line($payment_method[$order->payment_method]) ? $this->lang->line($payment_method[$order->payment_method]) : $payment_method[$order->payment_method] ?></span>
                        <?php } ?>
                    </div>
                </div>



            </div>
            <!--end::Body-->
            <?php echo form_close(); ?>
            <!--end::Form-->
        </div>
    </div>
</div>

<?php
$paid_status = '';
if ($order->paid == 1)
    $paid_status = $this->lang->line('payment-is-made');
if ($order->paid == 2)
    $paid_status = $this->lang->line('not-paid');
?>
<!--end::Content-->

<?php $this->load->view('site/drivers/profile_footer') ?>

<?php //$this->load->view('site/footer_2'); ?> 
<script>
    $(function () {

        $("#payment_method").change(function () {
            if ($(this).val() == 3) {
                $('#paid').html('<span class="mt-2 d-block"><?= $paid_status ?></span>');
            } else {
                $('#paid').html($("#paid_select_container").html());
            }
        });
        $("#payment_method").change();
    });

</script>
