
<!DOCTYPE html>
<!--
Template Name: Metronic - Bootstrap 4 HTML, React, Angular 9 & VueJS Admin Dashboard Theme
Author: KeenThemes
Website: http://www.keenthemes.com/
Contact: support@keenthemes.com
Follow: www.twitter.com/keenthemes
Dribbble: www.dribbble.com/keenthemes
Like: www.facebook.com/keenthemes
Purchase: https://1.envato.market/EA4JP
Renew Support: https://1.envato.market/EA4JP
License: You must have a valid license purchased only from themeforest(the above link) in order to legally use the theme for your project.
-->
<html lang="en">
    <!--begin::Head-->
    <head>
        <base href="../../../../">
        <meta charset="utf-8" />
        <title>Profile</title>
        <meta name="description"
              content="User profile personal information example" />
        <meta name="viewport"
              content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <!--begin::Fonts-->
        <link rel="stylesheet"
              href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
        <!--end::Fonts-->
        <!--begin::Global Theme Styles(used by all pages)-->
        <link
            href="<?= base_url() ?>public/plugins/global/plugins.bundle.css?v=7.0.4"
            rel="stylesheet" type="text/css" />
        <link
            href="<?= base_url() ?>public/plugins/custom/prismjs/prismjs.bundle.css?v=7.0.4"
            rel="stylesheet" type="text/css" />
        <link href="<?= base_url() ?>public/css/style.bundle_front.css?v=7.0.4"
              rel="stylesheet" type="text/css" />
        <!--end::Global Theme Styles-->
        <!--begin::Layout Themes(used by all pages)-->
        <link
            href="<?= base_url() ?>public/css/themes/layout/header/base/light.css?v=7.0.4"
            rel="stylesheet" type="text/css" />
        <link
            href="<?= base_url() ?>public/css/themes/layout/header/menu/light.css?v=7.0.4"
            rel="stylesheet" type="text/css" />
        <link
            href="<?= base_url() ?>public/css/themes/layout/brand/dark.css?v=7.0.4"
            rel="stylesheet" type="text/css" />
        <link
            href="<?= base_url() ?>public/css/themes/layout/aside/dark.css?v=7.0.4"
            rel="stylesheet" type="text/css" />
        <link
            href="<?php echo base_url() ?>public/plugins/custom/datatables/datatables.bundle.css"
            rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/student_custom.css"
              rel="stylesheet" type="text/css" />

        <!--end::Layout Themes-->
        <link rel="shortcut icon"
              href="<?= base_url() ?>public/media/logos/favicon.ico" />
        <style>
            #kt_subheader {
                top: 0px !important;
            }

            #kt_subheader {
                left: 0px !important;
            }

            .header-fixed.subheader-fixed.subheader-enabled .wrapper {
                padding-left: 0px !important;
                padding-top: 100px !important;
            }

            .flog {
                cursor: pointer;
                margin-right: 15px;
            }

            .rtl {
                direction: rtl;
            }

            .rtl .ml-lg-8, .mx-lg-8 {
                margin-right: 2rem !important;
            }

            .rtl .flog {
                margin-left: 15px;
            }

            .rtl .text-muted {
                margin-right: 15px;
            }

            .rtl .card-body, .rtl .card-body input {
                text-align: right;
            }

            .rtl .mr-5 {
                margin-left: 1.25rem !important;
                margin-right: 0px !important;
            }

            .card-header .card-title {
                float: left;
                margin-bottom: 0px;
            }

            .rtl .card-header .card-title {
                float: right;
                text-align: right;
            }
            ::-webkit-scrollbar {
                width: 0;  /* Remove scrollbar space */
                background: transparent;  /* Optional: just make scrollbar invisible */
            }
            ::-webkit-scrollbar-thumb {
                background: #E5EAEE;
            }
            .rtl .nav{
                padding-inline-start:0px;
            }
            .rtl .nav.nav-tabs.nav-tabs-line .nav-link{
                margin-right: 0px;
                margin-left: 1rem !important;
            }
            .rtl .nav-icon{
                text-align: right;
            }
        </style>
    </head>
    <!--end::Head-->
    <!--begin::Body-->
    <body id="kt_body"
          class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading <?= $this->session->userdata('language') == 'arabic' ? 'rtl' : '' ?>">
        <!--begin::Main-->
        <!--begin::Header Mobile-->
        <div id="kt_header_mobile"
             class="header-mobile align-items-center header-mobile-fixed">
            <!--begin::Logo-->
            <a href="index.html"> <span style="color: #fff"> </span>
            </a>
            <!--end::Logo-->
            <!--begin::Toolbar-->
            <!--		<div class="d-flex align-items-center">
                                    begin::Aside Mobile Toggle
                                    <button class="btn p-0 burger-icon burger-icon-left"
                                            id="kt_aside_mobile_toggle">
                                            <span></span>
                                    </button>
                                    end::Aside Mobile Toggle
                                    begin::Header Menu Mobile Toggle
                                    <button class="btn p-0 burger-icon ml-4" id="kt_header_mobile_toggle">
                                            <span></span>
                                    </button>
                                    end::Header Menu Mobile Toggle
                                    begin::Topbar Mobile Toggle
                                    <button class="btn btn-hover-text-primary p-0 ml-2"
                                            id="kt_header_mobile_topbar_toggle">
                                            <span class="svg-icon svg-icon-xl"> begin::Svg Icon | path:assets/media/svg/icons/General/User.svg
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                            xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                                            height="24px" viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none"
                                                                    fill-rule="evenodd">
                                    <polygon points="0 0 24 0 24 24 0 24" />
                                    <path
                                                                    d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z"
                                                                    fill="#000000" fill-rule="nonzero" opacity="0.3" />
                                    <path
                                                                    d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z"
                                                                    fill="#000000" fill-rule="nonzero" />
                                    </g>
                                    </svg> end::Svg Icon
                                            </span>
                                    </button>
                                    end::Topbar Mobile Toggle
                            </div>-->
            <!--end::Toolbar-->
        </div>
        <!--end::Header Mobile-->
        <div class="d-flex flex-column flex-root">
            <!--begin::Page-->
            <div class="d-flex flex-row flex-column-fluid page">

                <!--begin::Wrapper-->
                <div class="d-flex flex-column flex-row-fluid wrapper"
                     id="kt_wrapper">

                    <!--begin::Content-->
                    <div class="content d-flex flex-column flex-column-fluid"
                         id="kt_content" style="padding-bottom: 0px">
                        <!--begin::Subheader-->
                        <div class="subheader py-2 py-lg-4 subheader-solid"
                             id="kt_subheader">
                            <div
                                class="container-fluid d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
                                <!--begin::Info-->
                                <div class="d-flex align-items-center flex-wrap mr-1">
                                    <!--begin::Mobile Toggle-->
                                    <button
                                        class="burger-icon burger-icon-left mr-4 d-inline-block d-lg-none"
                                        id="kt_subheader_mobile_toggle">
                                        <span></span>
                                    </button>
                                    <!--end::Mobile Toggle-->
                                    <!--begin::Page Heading-->
                                    <div class="d-flex align-items-baseline mr-5">
                                        <!--begin::Page Title-->
                                        <h5 class="text-dark font-weight-bold my-2 mr-5"><?= $this->lang->line('drivers') ?></h5>
                                        <!--end::Page Title-->
                                        <!--begin::Breadcrumb-->
                                        <ul
                                            class="breadcrumb breadcrumb-transparent breadcrumb-dot font-weight-bold p-0 my-2 font-size-sm">
                                            <!--                                            <li class="breadcrumb-item">
            <a href="" class="text-muted">Apps</a>
        </li>-->
                                            <li class="breadcrumb-item"><a href="" class="text-muted"><?= $this->lang->line('profile') ?></a>
                                            </li>
                                            <!--                                            <li class="breadcrumb-item">
            <a href="" class="text-muted">Profile 1</a>
        </li>
        <li class="breadcrumb-item">
            <a href="" class="text-muted">Personal Information</a>
        </li>-->
                                        </ul>
                                        <!--end::Breadcrumb-->
                                    </div>
                                    <!--end::Page Heading-->
                                </div>
                                <!--end::Info-->
                                <?php
                                if ($this->session->userdata('language') == "english") {
                                    $language_set = "arabic";
                                } else {
                                    $language_set = "english";
                                }
                                ?>

                                <!--begin::Toolbar-->
                                <div class="d-flex align-items-center">
                                    <a title="<?= $this->lang->line('language') ?>"
                                       onclick="language('<?php echo $language_set; ?>')" class="flog"><img
                                            src="<?php echo base_url() ?>public/media/flags/<?php echo $language_set; ?>.png"
                                            width="35" height="35"></a>
                                    <!--begin::Actions-->
                                    <a href="<?= base_url('drivers/Drivers_login/logout') ?>"
                                       class="btn btn-light font-weight-bold btn-sm"><i
                                            class="fas fa-sign-out-alt"></i>&nbsp;&nbsp;<?= $this->lang->line('logout') ?></a>
                                    <!--end::Actions-->
                                    <!--begin::Dropdown-->

                                    <!--end::Dropdown-->
                                </div>
                                <!--end::Toolbar-->
                            </div>
                        </div>
                        <!--end::Subheader-->
                        <!--begin::Entry-->

                        <div class="d-flex flex-column-fluid">
                            <!--begin::Container-->
                            <div class="container" style="margin-bottom: 30px">
                                <!--begin::Profile Personal Information-->
                                <div class="d-flex flex-row">
                                    <!--begin::Aside-->
                                    <div class="flex-row-auto offcanvas-mobile w-250px w-xxl-350px"
                                         id="kt_profile_aside">
                                        <!--begin::Profile Card-->
                                        <div class="card card-custom card-stretch">
                                            <!--begin::Body-->
                                            <div class="card-body pt-4">
                                                <!--begin::Toolbar-->

                                                <!--end::Toolbar-->
                                                <!--begin::User-->
                                                <div class="d-flex align-items-center">
                                                    <!--                                                    <div
                                                                                                            class="symbol symbol-60 symbol-xxl-100 mr-5 align-self-start align-self-xxl-center">
                                                                                                            <div class="symbol-label" style="background-image:url('<?//= base_url() ?>public/upload/userimage/<?//= $one->image ?>')"></div>
                                                                                                            <i class="symbol-badge bg-success"></i>
                                                                                                        </div>-->
                                                    <div>
                                                        <a href="#"
                                                           class="font-weight-bolder font-size-h5 text-dark-75 text-hover-primary"><?= $one->name ?></a>
                                                        <div class="text-muted"><?= $this->session->userdata('language') == "english" ? $one->english : $one->arabic ?></div>
                                                        <div class="mt-2">
                                                            <!--                                                            <a href="#" class="btn btn-sm btn-primary font-weight-bold mr-2 py-2 px-3 px-xxl-5 my-1">Chat</a>
                                                                    <a href="#" class="btn btn-sm btn-success font-weight-bold py-2 px-3 px-xxl-5 my-1">Follow</a>-->
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end::User-->
                                                <!--begin::Contact-->
                                                <div class="py-9">
                                                    <div
                                                        class="d-flex align-items-center justify-content-between mb-2">
                                                        <span class="font-weight-bold mr-2"><?= $this->lang->line('email') ?>:</span>
                                                        <a href="#" class="text-muted text-hover-primary"><?= $one->email ?></a>
                                                    </div>
                                                    <div
                                                        class="d-flex align-items-center justify-content-between mb-2">
                                                        <span class="font-weight-bold mr-2"><?= $this->lang->line('phone') ?>:</span>
                                                        <span class="text-muted"><?= $one->phone ?></span>
                                                    </div>
                                                </div>
                                                <!--end::Contact-->
                                                <!--begin::Nav-->
                                                <div
                                                    class="navi navi-bold navi-hover navi-active navi-link-rounded">


                                                    <div class="navi-item mb-2">
                                                        <a href="<?= base_url() ?>drivers/Drivers_login/orders"
                                                           class="navi-link py-4 <?= $active == 'orders' ? 'active' : '' ?>">
                                                            <span class="navi-icon mr-2"> <span class="svg-icon"> <!--begin::Svg Icon | path:assets/media/svg/icons/Files/File.svg-->
                                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                                         xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                                                         height="24px" viewBox="0 0 24 24" version="1.1">
                                                                    <g
                                                                        stroke="none" stroke-width="1" fill="none"
                                                                        fill-rule="evenodd">
                                                                    <polygon
                                                                        points="0 0 24 0 24 24 0 24" />
                                                                    <path
                                                                        d="M5.85714286,2 L13.7364114,2 C14.0910962,2 14.4343066,2.12568431 14.7051108,2.35473959 L19.4686994,6.3839416 C19.8056532,6.66894833 20,7.08787823 20,7.52920201 L20,20.0833333 C20,21.8738751 19.9795521,22 18.1428571,22 L5.85714286,22 C4.02044787,22 4,21.8738751 4,20.0833333 L4,3.91666667 C4,2.12612489 4.02044787,2 5.85714286,2 Z"
                                                                        fill="#000000" fill-rule="nonzero" opacity="0.3" />
                                                                    <rect
                                                                        fill="#000000" x="6" y="11" width="9" height="2"
                                                                        rx="1" />
                                                                    <rect
                                                                        fill="#000000" x="6" y="15" width="5" height="2"
                                                                        rx="1" />
                                                                    </g>
                                                                    </svg>
                                                                    <!--end::Svg Icon-->
                                                                </span>
                                                            </span> <span class="navi-text font-size-lg"><?= $this->lang->line('orders') ?></span>
                                                        </a>
                                                    </div>


                                                    <div class="navi-item mb-2">
                                                        <a href="<?= base_url() ?>drivers/Drivers_login"
                                                           class="navi-link py-4 <?= $active == 'profile' ? 'active' : '' ?>">
                                                            <span class="navi-icon mr-2"> <span class="svg-icon"> <!--begin::Svg Icon | path:assets/media/svg/icons/General/User.svg-->
                                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                                         xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                                                         height="24px" viewBox="0 0 24 24" version="1.1">
                                                                    <g
                                                                        stroke="none" stroke-width="1" fill="none"
                                                                        fill-rule="evenodd">
                                                                    <polygon
                                                                        points="0 0 24 0 24 24 0 24" />
                                                                    <path
                                                                        d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z"
                                                                        fill="#000000" fill-rule="nonzero" opacity="0.3" />
                                                                    <path
                                                                        d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z"
                                                                        fill="#000000" fill-rule="nonzero" />
                                                                    </g>
                                                                    </svg>
                                                                    <!--end::Svg Icon-->
                                                                </span>
                                                            </span> <span class="navi-text font-size-lg"><?= $this->lang->line('edit') . ' ' . $this->lang->line('personal_info') ?></span>
                                                        </a>
                                                    </div>

                                                </div>
                                                <!--end::Nav-->
                                            </div>
                                            <!--end::Body-->
                                        </div>
                                        <!--end::Profile Card-->
                                    </div>
                                    <!--end::Aside-->