<?php $this->load->view('site/drivers/profile_header') ?>
<!--begin::Content-->
<style>
    .mt-10px{
        margin-top: 10px;
    }
</style>

<div class="flex-row-fluid ml-lg-8">
    <!--begin::Card-->
    <div class="card card-custom card-stretch">
        <!--begin::Header-->
        <?php echo form_open(); ?>

        <div class="card-header py-3">
            <div class="card-title align-items-start flex-column">
                <h3 class="card-label font-weight-bolder text-dark"><?= $this->lang->line('personal_info') ?></h3>
                <span class="text-muted font-weight-bold font-size-sm mt-1"><?= $this->lang->line('update_personal_info') ?></span>
            </div>
            <div class="card-toolbar" style="float: right">
                <button type="submit" class="btn btn-success mr-2"><?= $this->lang->line('save') ?></button>
                <!--<button type="reset" class="btn btn-secondary">Cancel</button>-->
            </div>
            <div class="clearfix"></div>
        </div>
        <!--end::Header-->
        <!--begin::Form-->

        <!--begin::Body-->
        <div class="card-body" style="overflow: scroll">

            <?php if ($this->session->flashdata('error') != '' || validation_errors() !== ''): ?>
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-danger"></i> <?= $this->lang->line('error') ?>!</h4>&nbsp;
                        <?= $this->session->flashdata('error'); ?>
                        <?= validation_errors(); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('success') != ''): ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <div>
                        <h4><i class="icon fa-success"></i> </h4>&nbsp;
                        <?= $this->lang->line('op_success'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php
            $old_show_arr = explode(',', $sett->driver_fields_show);
            $old_edit_arr = explode(',', $sett->driver_fields_edit);
            if (in_array('name', $old_show_arr)) {
                ?>
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('name') ?></label>
                    <div class="col-lg-9 col-xl-6">
                        <?php if (in_array('name', $old_edit_arr)) { ?>
                            <div class="input-group input-group-lg input-group-solid">
                                <input type="text" name="name" class="form-control" value="<?= $one->name ?>" />
                            </div>
                            <span class="form-text text-muted"><?= $this->lang->line('never_share_ur_data') ?></span>
                        <?php } else { ?>
                            <span class="d-block mt-3"><?= $one->name ?></span>
                        <?php } ?>

                    </div>
                </div>
            <?php } ?>

            <?php if (in_array('phone', $old_show_arr)) { ?>
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('phone') ?></label>
                    <div class="col-lg-9 col-xl-6">
                        <?php if (in_array('phone', $old_edit_arr)) { ?>
                            <div class="input-group input-group-lg input-group-solid">
                                <input type="text" name="phone" class="form-control" value="<?= $one->phone ?>" />
                            </div>
                            <span class="form-text text-muted"><?= $this->lang->line('never_share_ur_data') ?></span>
                        <?php } else { ?>
                            <span class="d-block mt-3"><?= $one->phone ?></span>
                        <?php } ?>

                    </div>
                </div>
            <?php } ?>

            <?php if (in_array('email', $old_show_arr)) { ?>
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('email') ?></label>
                    <div class="col-lg-9 col-xl-6">
                        <?php if (in_array('email', $old_edit_arr)) { ?>
                            <div class="input-group input-group-lg input-group-solid">
                                <input type="text" name="email" class="form-control" value="<?= $one->email ?>" />
                            </div>
                            <span class="form-text text-muted"><?= $this->lang->line('never_share_ur_data') ?></span>
                        <?php } else { ?>
                            <span class="d-block mt-3"><?= $one->email ?></span>
                        <?php } ?>

                    </div>
                </div>
            <?php } ?>

            <?php if (in_array('country', $old_show_arr)) { ?>
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('nationality') ?></label>
                    <div class="col-lg-9 col-xl-6">
                        <?php if (in_array('country', $old_edit_arr)) { ?>
                            <div class="input-group input-group-lg input-group-solid">
                                <select name="country" id="country" class="form-control" data-search="true" >
                                    <?php foreach ($countries as $country) { ?>
                                        <option <?= $country->id == $one->country ? 'selected' : '' ?> value="<?= $country->id ?>"><?= $this->session->userdata('language') == 'english' ? $country->english : $country->arabic ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <span class="form-text text-muted"><?= $this->lang->line('never_share_ur_data') ?></span>
                        <?php } else { ?>
                            <span class="d-block mt-3"><?= $this->session->userdata('language') == 'english' ? $one->english : $one->arabic ?></span>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>

            <?php if (in_array('password', $old_edit_arr)) { ?>
                <div class="form-group row">
                    <label class="col-xl-3 col-lg-3"></label>
                    <div class="col-lg-9 col-xl-6">
                        <a onclick="show_password()" style="cursor: pointer;color: blue"><?= $this->lang->line('change_password') ?> </a>
                    </div>
                </div>
                <div class="form-group row" id="new_pass">
                    <label class="col-xl-3 col-lg-3 col-form-label text-right"><?= $this->lang->line('new_password') ?></label>
                    <div class="col-lg-9 col-xl-6">
                        <input type="password" class="form-control form-control-lg form-control-solid" value="" name="new_password" placeholder="<?= $this->lang->line('enter') . ' ' . $this->lang->line('new_password') ?>" />
                    </div>
                </div>
            <?php } ?>

        </div>
        <!--end::Body-->
        <?php echo form_close(); ?>
        <!--end::Form-->
    </div>
</div>
<!--end::Content-->
<?php $this->load->view('site/drivers/profile_footer') ?>

<script>
    $(function () {
        $("#country").select2();
    });
</script>
