
<?php $this->load->view('site/layout'); ?>
<link href="<?php echo base_url() ?>public/css/style.bundle_front.css"
      rel="stylesheet" type="text/css" />

<?php $this->load->view('site/navbar'); ?>

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?php echo $this->lang->line('drivers'); ?></span>
            </div>

        </div>
    </div>
</div>
<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="kt-font-brand flaticon2-line-chart"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    <?php echo $this->lang->line('drivers'); ?>
                </h3>
            </div>
            <?php if (get_ap('add_driver', $this->operator_id) == 1) { ?> 
                <div class="kt-portlet__head-toolbar">
                    <div class="kt-portlet__head-wrapper">
                        <div class="kt-portlet__head-actions">
                            &nbsp;
                            <a href="<?= base_url() ?>drivers/<?= $this->thispage ?>/add/" class="btn btn-brand btn-primary btn-icon-sm">
                                <i class="la la-plus"></i>
                                <?php echo $this->lang->line('add-a-driver') ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php if ($this->session->flashdata('msg')): ?>
            <br/>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <h4><i class="icon fa-warning"></i> Success!</h4>&nbsp;
                <?= $this->lang->line('op_success'); ?>
            </div>
        <?php endif; ?> 
        <div class="kt-portlet__body">


            <!--begin: Datatable -->
            <table class="table table-bordered table-hover" id="list_table">
                <thead>
                    <tr>
                    <tr>
                        <th style="width: 10px"><?php echo $this->lang->line('arrangement') ?></th>
                        <th><?php echo $this->lang->line('name') ?></th>
                        <th><?php echo $this->lang->line('email') ?></th> 
                        <th><?php echo $this->lang->line('phone') ?></th>
                        <th><?php echo $this->lang->line('nationality') ?></th>
                        <th><?php echo $this->lang->line('status') ?></th>

                        <th class="text-center"><?php echo $this->lang->line('action'); ?></th>
                    </tr>
                </thead>
                <tbody>   <?php
                    $count = 0;
                    foreach ($drivers as $row) {
                        ?>
                        <tr>
                            <td><?php echo ++$count; ?></td>
                            <td><?= $row['name']; ?> </td>
                            <td><?= $row['email']; ?> </td> 
                            <td><?= $row['phone']; ?> </td> 
                            <td><?= $this->session->userdata('language') == 'english' ? $row['english'] : $row['arabic'] ?> </td>
                            <td>
                                <span class="switch switch-success">
                                    <label>
                                        <input type="checkbox" name="active" data-driver_id="<?= $row['id'] ?>" class="form-control approve_check" <?= $row['status'] == 1 ? 'checked="checked"' : '' ?> />
                                        <span></span>
                                    </label>
                                </span>
                            </td>

                            <td class="text-center">
                                
                                <?php if (get_ap('edit_driver', $this->operator_id) == 1) { ?>                          
                                    <a href="<?= base_url('drivers/' . $this->thispage . '/edit/' . $row['id']) ?>" class="btn btn-icon btn-primary btn-sm" title="Edit driver">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                <?php } ?>
                                <?php if (get_ap('delete_driver', $this->operator_id) == 1) { ?> 
                                    <a onclick="alert_box(<?php echo $row['id'] ?>)" class="btn btn-icon btn-danger btn-sm" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </a>
                                <?php } ?> 
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

            <!--end: Datatable -->
        </div>
    </div>
</div>
<?php $this->load->view('site/footer_2'); ?>  


<script>
    function alert_box(id) {
        var result = confirm("Are You Confirm!");
        if (result) {
            location.href = "<?= base_url('drivers/' . $this->thispage . '/del/') ?>" + id;
        }
    }


    $(function () {
        $(".approve_check").change(function () {
            var status = 0;
            if ($(this).prop('checked')) {
                var status = 1;
            }
            var id = $(this).data('driver_id');
            location.href = "<?= base_url('drivers/drivers/change_driver_status/') ?>" + id + '/' + status;
        });
        $("#list_table").DataTable({dom: 'Bfrtip',
            destroy: true,
            buttons: [
                {
                    extend: 'excelHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'csvHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'pdfHtml5',
                    charset: 'UTF-16LE',
                    fieldSeparator: '\t',
                    bom: true
                },
                {
                    extend: 'print',
                    autoPrint: false,
                    footer: true
                }

            ]
        });
//            buttons: [
//                'copyHtml5',
//                'excelHtml5',
//                'csvHtml5',
//                'pdfHtml5'
//            ]
    });


</script>
