<!DOCTYPE html>

<!--
Template Name: Metronic - Responsive Admin Dashboard Template build with Twitter Bootstrap 4 & Angular 8
Author: KeenThemes
Website: http://www.keenthemes.com/
Contact: support@keenthemes.com
Follow: www.twitter.com/keenthemes
Dribbble: www.dribbble.com/keenthemes
Like: www.facebook.com/keenthemes
Purchase: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
Renew Support: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
License: You must have a valid license purchased only from themeforest(the above link) in order to legally use the theme for your project.
-->
<html lang="en">

    <!-- begin::Head -->
    <head>
        <base href="../../../">
        <meta charset="utf-8" />
        <title><?php echo $this->lang->line('bills') ?></title>
        <meta name="description" content="Login page example">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">

        <!--end::Fonts -->

        <!--begin::Page Custom Styles(used by this page) -->
        <link href="<?php echo base_url() ?>public/css/pages/login/login-2.css" rel="stylesheet" type="text/css" />

        <!--end::Page Custom Styles -->

        <!--begin::Global Theme Styles(used by all pages) -->
        <link href="<?php echo base_url() ?>public/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/style.bundle.css" rel="stylesheet" type="text/css" />

        <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
        <link href="<?php echo base_url() ?>public/css/skins/header/base/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/header/menu/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/brand/dark.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/aside/dark.css" rel="stylesheet" type="text/css" />

        <!--end::Layout Skins -->
        <link rel="shortcut icon" href="<?php echo base_url() ?>public/media/logos/favicon.ico" />
        <style>
            .terms{
                background-color: #fff;
                color: #000;
                padding: 10px;
                height: 100px;
                overflow-y: scroll;
            }
            #terms_div{
                margin-top: 10px;
            }
        </style>
    </head>

    <!-- end::Head -->

    <!-- begin::Body -->
    <body class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--fixed kt-subheader--solid kt-aside--enabled kt-aside--fixed kt-page--loading">

        <!-- begin:: Page -->
        <div class="kt-grid kt-grid--ver kt-grid--root">
            <div class="kt-grid kt-grid--hor kt-grid--root kt-login kt-login--v2 kt-login--signin" id="kt_login">
                <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" style="background-image: url(<?php echo base_url() ?>public/media/bg/bg-1.jpg);background-repeat: no-repeat;background-attachment: fixed;">
                    <div class="kt-grid__item kt-grid__item--fluid kt-login__wrapper">
                        <div class="kt-login__container">
                            <div class="kt-login__logo">
                                <a href="#">
                                    <img src="<?php echo base_url() ?>public/media/logos/logo-mini-2-md.png">
                                </a>
                            </div>
                            <div class="kt-login__signin">
                                <div class="kt-login__head">
                                    <h3 class="kt-login__title"><?php echo $this->lang->line('student_signin'); ?></h3>
                                </div>

                                <?php if ($this->session->flashdata('error')): ?>
                                    <div class="alert alert-danger alert-dismissible">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                        <div>
                                            <h4><i class="icon fa-danger"></i> Alert!</h4>&nbsp;
                                            <?= $this->session->flashdata('error'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>   

                                <?php if ($this->session->flashdata('success')): ?>
                                    <div class="alert alert-success alert-dismissible">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                        <div>
                                            <h4><i class="icon fa-success"></i> Success!</h4>&nbsp;
                                            <?= $this->lang->line('success_wait_admin_approval'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>   

                                <form method="post" action=""  class=" kt-form">
                                    <div class="input-group">
                                        <input class="form-control" type="text" placeholder="<?php echo $this->lang->line('email/phone') ?>" required autofocus name="name" autocomplete="on">
                                    </div>
                                    <div class="input-group">
                                        <input class="form-control" type="password" placeholder="<?php echo $this->lang->line('password') ?>" required name="password">
                                    </div>
                                    <div class="row kt-login__extra">
                                        <div class="col">
                                            <label class="kt-checkbox">
                                                <input type="checkbox" name="remember"> <?php echo $this->lang->line('remember-me') ?>
                                                <span></span>
                                            </label>
                                        </div>
                                        <div class="col kt-align-right">
                                            <a href="javascript:;" id="kt_login_forgot" class="kt-link kt-login__link"><?php echo $this->lang->line('i-forgot-my-password') ?></a>
                                        </div>
                                    </div>
                                    <div class="kt-login__actions">
                                        <button id="" type="submit" class="btn btn-pill kt-login__btn-primary"><?php echo $this->lang->line('sign-in') ?></button>
                                    </div>
                                </form>
                            </div>
                            <div class="kt-login__signup">
                                <div class="kt-login__head">
                                    <h3 class="kt-login__title"><?php echo $this->lang->line('bills'); ?></h3>
                                    <div class="kt-login__desc"><?php echo $this->lang->line('student-register'); ?>:</div>
                                </div>
                                <form class="kt-login__form kt-form" action="<?php echo base_url() ?>Auth/register" method="post" enctype="multipart/form-data">
                                    <?php
                                    $fields_arr = array('username' => $this->lang->line('name'),
                                        'cid_user' => $this->lang->line('civil-no'), 'email' => $this->lang->line('e-mail'), 'password' => $this->lang->line('password'),
                                        'phone' => $this->lang->line('students') . ' ' . $this->lang->line('mobile'),
                                        'phone_father' => $this->lang->line('guardian') . ' ' . $this->lang->line('mobile'), 'country' => $this->lang->line('nationality'),
                                        'city' => $this->lang->line('region'), 'blocks' => $this->lang->line('block'), 'street' => $this->lang->line('street'), 'jadah' => $this->lang->line('jadah'),
                                        'building_num' => $this->lang->line('building_num'), 'floor' => $this->lang->line('floor'), 'door_no' => $this->lang->line('door-number'), 'address_link' => $this->lang->line('address-link'), 'title' => $this->lang->line('title'),
                                        'age' => $this->lang->line('date-of-birth'), 'sex' => $this->lang->line('sex'), 'father_work' => $this->lang->line('father_work'), 'mother_work' => $this->lang->line('mother_work'),
                                        'social_status' => $this->lang->line('social_status'), 'note' => $this->lang->line('note'),
                                        'profile' => $this->lang->line('customer-image'), 'imageuser' => $this->lang->line('other_attachments'));
                                    foreach ($required_fields as $key) {
                                        $val = $fields_arr[$key];
                                        ?>
                                        <div class="<?= $key == 'profile' || $key == 'imageuser' ? '' : 'input-group' ?>">
                                            <?php if ($key == 'city') { ?>
                                                <select name=city class="form-control">
                                                    <option  value=""><?php
                                                        echo $this->lang->line('select') . ' ' . $this->lang->line('region');
                                                        $this->db->where('lable', 'region');
                                                        $region = $this->db->get('datas')->result();
                                                        ?>
                                                        <?php foreach ($region as $key => $value) { ?>
                                                            <?php if ($this->session->userdata('language') == 'english') { ?><option value="<?php echo $value->english; ?>"><?php echo $value->english; ?></option> <?php } else { ?>
                                                            <option value="<?php echo $value->arabic; ?>"><?php echo $value->arabic; ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            <?php } else if ($key == 'country') { ?>
                                                <?php
                                                $this->db->where('lable', 'nationality');
                                                $nationality = $this->db->get('datas')->result();
                                                ?>
                                                <select class="form-control" name="country" required="required">
                                                    <option value=""><?php
                                                        echo $this->lang->line('select');
                                                        echo' ';
                                                        echo $this->lang->line('nationality');
                                                        ?></option>
                                                    <?php foreach ($nationality as $key) { ?>
                                                        <option value="<?php
                                                        if ($this->session->userdata('language') == 'english') {
                                                            echo $key->english;
                                                        } else {
                                                            echo $key->arabic;
                                                        }
                                                        ?>" ><?php
                                                                    if ($this->session->userdata('language') == 'english') {
                                                                        echo $key->english;
                                                                    } else {
                                                                        echo $key->arabic;
                                                                    }
                                                                    ?></option>
                                                    <?php } ?>
                                                </select>
                                            <?php } else if ($key == 'sex') { ?>
                                                <select class="form-control" name="sex" required="required">
                                                    <option><?php echo $this->lang->line('sex'); ?></option>
                                                    <option><?php echo $this->lang->line('male'); ?></option>
                                                    <option><?php echo $this->lang->line('female'); ?></option>
                                                </select>
                                            <?php } else if ($key == 'profile' || $key == 'imageuser') { ?>
                                                <br/>
                                                <label class="text-white"><?= $val ?></label>

                                                <input type="file" name="<?= $key == 'imageuser' ? 'imageuser[]' : $key ?>" class="form-control" />
                                            <?php } else { ?>
                                                <input class="form-control" type="text" placeholder="<?php echo $val ?>" name="<?= $key ?>" />
                                            <?php } ?>
                                        </div>
                                    <?php } ?>



                                    <div class="input-group">
                                        <input class="form-control" type="password" placeholder="<?php echo $this->lang->line('password') ?>" name="password" required="required">
                                    </div>
                                    <div class="row kt-login__extra">
                                        <div class="col kt-align-left">
                                            <!-- <label class="kt-checkbox">
                                              <input type="checkbox" name="agree">I Agree the <a href="#" class="kt-link kt-login__link kt-font-bold">terms and conditions</a>.
                                              <span></span>
                                            </label> -->
                                            <span class="form-text text-muted"></span>
                                        </div>
                                    </div>
                                    <div class="row kt-login__extra">
                                        <h3><?= $this->lang->line('terms-and-conditions') ?></h3>
                                        <div class="terms">
                                            <?= $this->lang->line('student-terms-and-conditions') ?>
                                        </div>
                                        <div id="terms_div">
                                            <input type="checkbox" name="terms" id="terms" /> &nbsp; <?= $this->lang->line('agree_terms_conditions') ?>
                                        </div>
                                    </div>
                                    <div class="kt-login__actions">
                                        <button type="submit"  class="btn btn-pill kt-login__btn-primary signup_btn" disabled="disabled">Sign Up</button>&nbsp;&nbsp;
                                        <a href="<?php echo base_url() ?>Auth/student_login" ><button id="kt_login_signup_cancel" class="btn btn-pill kt-login__btn-secondary">Cancel</button></a>
                                    </div>
                                </form>
                            </div>
                            <div class="kt-login__forgot">
                                <div class="kt-login__head">
                                    <h3 class="kt-login__title">Forgotten Password ?</h3>
                                    <div class="kt-login__desc">Enter your email to reset your password:</div>
                                </div>
                                <form class="kt-form" action="">
                                    <div class="input-group">
                                        <input class="form-control" type="text" placeholder="Email" name="email" id="kt_email" autocomplete="off">
                                    </div>
                                    <div class="kt-login__actions">
                                        <button id="kt_login_forgot_submit" class="btn btn-pill kt-login__btn-primary">Request</button>&nbsp;&nbsp;
                                        <button id="kt_login_forgot_cancel" class="btn btn-pill kt-login__btn-secondary">Cancel</button>
                                    </div>
                                </form>
                            </div>
                            <div class="kt-login__account">
                                <span class="kt-login__account-msg">
                                    <?php echo $this->lang->line('register-a-new-membership') ?>
                                </span>&nbsp;&nbsp;
                                <a href="javascript:;" id="kt_login_signup" class="kt-link kt-link--light kt-login__account-link"><?php echo $this->lang->line('sign-up') ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end:: Page -->
        <script type="text/javascript" src="https://code.jquery.com/jquery-1.11.3.min.js"></script>
        <!-- Include Date Range Picker -->
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>

        <script>
            $(document).ready(function () {
//                var date_input = $('input[name="age"]'); //our date input has the name "date"
//                var container = $('form').length > 0 ? $('.bootstrap-iso form').parent() : "body";
//                date_input.datepicker({
//                    format: 'dd/mm/yyyy',
//                    //container: container,
//                    todayHighlight: true,
//                    autoclose: true
//                });

                $("#terms").change(function () {
                    if ($("#terms").prop('checked')) {
                        $(".signup_btn").prop('disabled', false);
                    } else {
                        $(".signup_btn").prop('disabled', true);
                    }
                });
            });
        </script>
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {
                "colors": {
                    "state": {
                        "brand": "#5d78ff",
                        "dark": "#282a3c",
                        "light": "#ffffff",
                        "primary": "#5867dd",
                        "success": "#34bfa3",
                        "info": "#36a3f7",
                        "warning": "#ffb822",
                        "danger": "#fd3995"
                    },
                    "base": {
                        "label": [
                            "#c5cbe3",
                            "#a1a8c3",
                            "#3d4465",
                            "#3e4466"
                        ],
                        "shape": [
                            "#f0f3ff",
                            "#d9dffa",
                            "#afb4d4",
                            "#646c9a"
                        ]
                    }
                }
            };
//            $(function () {
//                $(".datepicker").datepicker({
//                    format: "yyyy-mm-dd",
//                    dateFormat: "yyyy-mm-dd"
//                    , duration: "fast"
//                });
//            });
        </script>

        <!-- end::Global Config -->

        <!--begin::Global Theme Bundle(used by all pages) -->
        <script src="<?php echo base_url() ?>public/plugins/global/plugins.bundle.js" type="text/javascript"></script>
        <script src="<?php echo base_url() ?>public/js/scripts.bundle.js" type="text/javascript"></script>

        <!--end::Global Theme Bundle -->

        <!--begin::Page Scripts(used by this page) -->
        <script src="<?php echo base_url() ?>public/js/pages/custom/login/login-general.js" type="text/javascript"></script>

        <!--end::Page Scripts -->
    </body>

    <!-- end::Body -->
</html>