<!DOCTYPE html>

<!--
Template Name: Metronic - Responsive Admin Dashboard Template build with Twitter Bootstrap 4 & Angular 8
Author: KeenThemes
Website: http://www.keenthemes.com/
Contact: support@keenthemes.com
Follow: www.twitter.com/keenthemes
Dribbble: www.dribbble.com/keenthemes
Like: www.facebook.com/keenthemes
Purchase: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
Renew Support: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
License: You must have a valid license purchased only from themeforest(the above link) in order to legally use the theme for your project.
-->
<html lang="en">

    <!-- begin::Head -->
    <head>
        <base href="../../../">
        <meta charset="utf-8" />
        <title><?php echo $this->lang->line('bills') ?></title>
        <meta name="description" content="Login page example">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">

        <!--end::Fonts -->

        <!--begin::Page Custom Styles(used by this page) -->
        <link href="<?php echo base_url() ?>public/css/pages/login/login-2.css" rel="stylesheet" type="text/css" />

        <!--end::Page Custom Styles -->

        <!--begin::Global Theme Styles(used by all pages) -->
        <link href="<?php echo base_url() ?>public/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/style.bundle.css" rel="stylesheet" type="text/css" />

        <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
        <link href="<?php echo base_url() ?>public/css/skins/header/base/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/header/menu/light.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/brand/dark.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo base_url() ?>public/css/skins/aside/dark.css" rel="stylesheet" type="text/css" />

        <!--end::Layout Skins -->
        <link rel="shortcut icon" href="<?php echo base_url() ?>public/media/logos/favicon.ico" />
        <style>
            .terms{
                background-color: #fff;
                color: #000;
                padding: 10px;
                height: 100px;
                overflow-y: scroll;
            }
            #terms_div{
                margin-top: 10px;
            }
        </style>
    </head>

    <!-- end::Head -->

    <!-- begin::Body -->
    <body class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--fixed kt-subheader--solid kt-aside--enabled kt-aside--fixed kt-page--loading">

        <!-- begin:: Page -->
        <div class="kt-grid kt-grid--ver kt-grid--root">
            <div class="kt-grid kt-grid--hor kt-grid--root kt-login kt-login--v2 kt-login--signin" id="kt_login">
                <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" style="background-image: url(<?php echo base_url() ?>public/media/bg/bg-1.jpg);background-repeat: no-repeat;background-attachment: fixed;">
                    <div class="kt-grid__item kt-grid__item--fluid kt-login__wrapper">
                        <div class="kt-login__container">
                            <div class="kt-login__logo">
                                <a href="#">
                                    <img src="<?php echo base_url() ?>public/media/logos/logo-mini-2-md.png">
                                </a>
                            </div>
                            <div class="kt-login__signin">
                                <div class="kt-login__head">
                                    <h3 class="kt-login__title"><?php echo $this->lang->line('drivers_signin'); ?></h3>
                                </div>

                                <?php if ($this->session->flashdata('error')): ?>
                                    <div class="alert alert-danger alert-dismissible">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                        <div>
                                            <h4><i class="icon fa-danger"></i> Alert!</h4>&nbsp;
                                            <?= $this->session->flashdata('error'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>   

                                <?php if ($this->session->flashdata('success')): ?>
                                    <div class="alert alert-success alert-dismissible">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                        <div>
                                            <h4><i class="icon fa-success"></i> Success!</h4>&nbsp;
                                            <?= $this->lang->line('success_wait_admin_approval'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>   

                                <form method="post" action=""  class=" kt-form">
                                    <div class="input-group">
                                        <input class="form-control" type="text" placeholder="<?php echo $this->lang->line('email/phone') ?>" required autofocus name="name" autocomplete="on">
                                    </div>
                                    <div class="input-group">
                                        <input class="form-control" type="password" placeholder="<?php echo $this->lang->line('password') ?>" required name="password">
                                    </div>
                                    <div class="row kt-login__extra">
                                        <div class="col">
                                            <label class="kt-checkbox">
                                                <input type="checkbox" name="remember"> <?php echo $this->lang->line('remember-me') ?>
                                                <span></span>
                                            </label>
                                        </div>
                                        <div class="col kt-align-right">
                                            <a href="javascript:;" id="kt_login_forgot" class="kt-link kt-login__link"><?php echo $this->lang->line('i-forgot-my-password') ?></a>
                                        </div>
                                    </div>
                                    <div class="kt-login__actions">
                                        <button id="" type="submit" class="btn btn-pill kt-login__btn-primary"><?php echo $this->lang->line('sign-in') ?></button>
                                    </div>
                                </form>
                            </div>
                         
                            <div class="kt-login__forgot">
                                <div class="kt-login__head">
                                    <h3 class="kt-login__title">Forgotten Password ?</h3>
                                    <div class="kt-login__desc">Enter your email to reset your password:</div>
                                </div>
                                <form class="kt-form" action="">
                                    <div class="input-group">
                                        <input class="form-control" type="text" placeholder="Email" name="email" id="kt_email" autocomplete="off">
                                    </div>
                                    <div class="kt-login__actions">
                                        <button id="kt_login_forgot_submit" class="btn btn-pill kt-login__btn-primary">Request</button>&nbsp;&nbsp;
                                        <button id="kt_login_forgot_cancel" class="btn btn-pill kt-login__btn-secondary">Cancel</button>
                                    </div>
                                </form>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end:: Page -->
        <script type="text/javascript" src="https://code.jquery.com/jquery-1.11.3.min.js"></script>
        <!-- Include Date Range Picker -->
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>

        <script>
            $(document).ready(function () {
//                var date_input = $('input[name="age"]'); //our date input has the name "date"
//                var container = $('form').length > 0 ? $('.bootstrap-iso form').parent() : "body";
//                date_input.datepicker({
//                    format: 'dd/mm/yyyy',
//                    //container: container,
//                    todayHighlight: true,
//                    autoclose: true
//                });

                $("#terms").change(function () {
                    if ($("#terms").prop('checked')) {
                        $(".signup_btn").prop('disabled', false);
                    } else {
                        $(".signup_btn").prop('disabled', true);
                    }
                });
            });
        </script>
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {
                "colors": {
                    "state": {
                        "brand": "#5d78ff",
                        "dark": "#282a3c",
                        "light": "#ffffff",
                        "primary": "#5867dd",
                        "success": "#34bfa3",
                        "info": "#36a3f7",
                        "warning": "#ffb822",
                        "danger": "#fd3995"
                    },
                    "base": {
                        "label": [
                            "#c5cbe3",
                            "#a1a8c3",
                            "#3d4465",
                            "#3e4466"
                        ],
                        "shape": [
                            "#f0f3ff",
                            "#d9dffa",
                            "#afb4d4",
                            "#646c9a"
                        ]
                    }
                }
            };
//            $(function () {
//                $(".datepicker").datepicker({
//                    format: "yyyy-mm-dd",
//                    dateFormat: "yyyy-mm-dd"
//                    , duration: "fast"
//                });
//            });
        </script>

        <!-- end::Global Config -->

        <!--begin::Global Theme Bundle(used by all pages) -->
        <script src="<?php echo base_url() ?>public/plugins/global/plugins.bundle.js" type="text/javascript"></script>
        <script src="<?php echo base_url() ?>public/js/scripts.bundle.js" type="text/javascript"></script>

        <!--end::Global Theme Bundle -->

        <!--begin::Page Scripts(used by this page) -->
        <script src="<?php echo base_url() ?>public/js/pages/custom/login/login-general.js" type="text/javascript"></script>

        <!--end::Page Scripts -->
    </body>

    <!-- end::Body -->
</html>