<?php $this->load->view('site/layout'); ?>
<?php $this->load->view('site/navbar'); ?>


<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
    <!-- begin:: Content Head -->
    <div class="kt-subheader  kt-grid__item" id="kt_subheader">
        <div class="kt-container  kt-container--fluid ">
            <div class="kt-subheader__main">
                <h3 class="kt-subheader__title"><a href="<?php echo base_url() ?>Dashboard/"><?php echo $this->lang->line('dashboard'); ?></a></h3>
                <span class="kt-subheader__separator kt-subheader__separator--v"></span>
                <span class="kt-subheader__desc"><?php echo $this->lang->line('points'); ?></span>
            </div>

        </div>
    </div>
    <div class="kt-portlet kt-portlet--mobile">
        <div class="kt-portlet__head kt-portlet__head--lg">
            <div class="kt-portlet__head-label">
                <span class="kt-portlet__head-icon">
                    <i class="kt-font-brand flaticon2-line-chart"></i>
                </span>
                <h3 class="kt-portlet__head-title">
                    <?php echo $title ?>
                </h3>
            </div>
        </div>
        <div class="kt-portlet__body">

            <?php if (validation_errors()) { ?>

                <div class="m-alert m-alert--outline alert alert-success alert-dismissible fade show" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"></button>
                    <?php echo validation_errors(); ?>
                </div>
            <?php }
            ?>
            <form method="post" action="" enctype="multipart/form-data" class="m-form m-form--label-align-right" >

                <div class="form-group m-form__group row">
                    <label class="col-md-3"><?php echo $this->lang->line('the_type'); ?></label>
                    <div class="col-md-7">
                        <select name="category_type" class="form-control " required="" readonly >
                            <option value=""><?php echo $this->lang->line('the_type'); ?></option>
                            <option value="category" <?php echo $category_type == "category" ? "selected" : "" ?> >Category</option>
                            <option value="notes" <?php echo $category_type == "notes" ? "selected" : "" ?> >Notes</option>
                            <option value="discount" <?php echo $category_type == "discount" ? "selected" : "" ?> >Discount</option>
                        </select>
                    </div>
                </div> 

                <div class="form-group m-form__group row">
                    <label class="col-md-3"><?php echo $this->lang->line('name'); ?><span class="text-danger" >*</span></label>
                    <div class="col-md-7">
                        <input type="text" name="category_name" class="form-control" required="">
                    </div>
                </div>               


                <?php if ($category_type == 'discount') { ?>
                    <div class="input-box">
                        <div class="row">
                            <label class="col-md-3"><?php echo $this->lang->line('points'); ?></label>
                            <div class="col-md-7">
                                <input type="text" name="points" class="form-control" required="">
                            </div>
                        </div>
                    </div> 


                    <div class="input-box">
                        <div class="row">
                            <label class="col-md-3"><?php echo $this->lang->line('points_discount_for'); ?></label>
                            <div class="col-md-7">
                                <select name="points_for" class="form-control">
                                    <option value="1"><?php echo $this->lang->line('balance'); ?></option>
                                    <option value="2"><?php echo $this->lang->line('balance_and_points'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <div class="offset-md-4">
                    <button class="btn btn-success"><span><?php echo $this->lang->line('submit'); ?></span></button>
                    <a href="<?php echo base_url('points/category/index/' . $category_type); ?>" class="btn btn-danger"><span><?php echo $this->lang->line('cancel'); ?></span></a>
                </div>

            </form>
        </div>
    </div>
</div>
<?php $this->load->view('site/footer_2'); ?>