<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function get_student($type = "") {
        $this->db->where('archive_status', $type);
        $query = $this->db->get('student');

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function get_all_student($tags = "") {
        if ($tags)
            $this->db->where_in('student_tags', $tags);
        $query = $this->db->get('bills_user');

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function get_student_id($id) {
        $this->db->select('student.*,group_concat(`tags`.`tag_name` separator ",") as tag_name2');
        $this->db->join('pts_tags tags', 'FIND_IN_SET(tags.tag_id, student.student_tags) > 0', 'left');
        $this->db->group_by('student.id');
        $this->db->where('student.id', $id);
        $query = $this->db->get('bills_user student');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return false;
        }
    }

    function get_student_ids($id) {
        $this->db->where_in('id', $id);
        $query = $this->db->get('bills_user');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function get_history_id($id) {
        $this->db->where_in('history_id', $id);
        $query = $this->db->get('student_history');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return false;
        }
    }

    function get_student_history_id($id, $from = "", $to = "") {
        if ($from) {
            $this->db->where("sh.update_on BETWEEN '$from' AND '$to'");
        }
        $this->db->select('sh.*,c.category_name as cname,n.category_name as notes_name,d.category_name as discount_name,a.award_name,group_concat(`tags`.`tag_name` separator ",") as tag_name2');
        $this->db->join('pts_category c', 'c.id = sh.category', 'left');
        $this->db->join('pts_category n', 'n.id = sh.notes', 'left');
        $this->db->join('pts_category d', 'd.id = sh.discount', 'left');
        $this->db->join('pts_award a', 'a.id = sh.award_id', 'left');
        $this->db->join('bills_user s', 's.id = sh.stud_id', 'left');
        $this->db->join('pts_tags tags', 'FIND_IN_SET(tags.tag_id, s.student_tags) > 0', 'LEFT');
        $this->db->where('stud_id', $id);
        $this->db->group_by('sh.history_id,s.id');
        $this->db->order_by('sh.history_id', 'desc');
        $query = $this->db->get('pts_student_history sh');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function get_transaction($action = "", $student_tags = "") {

        if (isset($action)) {
            //  pr($action);
            if (isset($action['student_id'])&&$action['student_id'] != "") {
                $this->db->where_in('stud_id', $action['student_id']);
            }

            if (isset($action['member_id'])&& $action['member_id']!= "") {
                $this->db->where_in('member_id', $action['member_id']);
            }

            if (isset($action['category_id']) &&$action['category_id'] != "") {
                $this->db->where_in('category', $action['category_id']);
            }

            if (isset($action['notes_id']) && $action['notes_id'] != "") {
                $this->db->where_in('notes', $action['notes_id']);
            }

            if (isset($action['discount_id']) && $action['discount_id'] != "") {
                $this->db->where_in('discount', $action['discount_id']);
            }
            if (isset($action['type']) && $action['type']  != "") {
                $this->db->where('type', $action['type']);
            }
            if (isset($action['student_tags']) && $action['student_tags'] != "") {
                $condtion = array();
                foreach ($action['student_tags'] as $key => $value) {
                    $condtion[] = 'find_in_set("' . $value . '",s.student_tags) <> 0';
                }
                $this->db->where("(" . implode(" OR ", $condtion) . ")");
            }

            if (isset($action['members_tags']) && $action['members_tags'] != "") {
                $condtion2 = array();
                foreach ($action['members_tags'] as $key => $value) {
                    $condtion2[] = 'find_in_set("' . $value . '",members_tags) <> 0';
                }
                $this->db->where("(" . implode(" OR ", $condtion2) . ")");
            }

            if (isset($action['date_from_to']) && $action['date_from_to'] != "") {
                $from = explode(" - ", $action['date_from_to'])[0];
                $to = explode(" - ", $action['date_from_to'])[1];
                $to = date('Y-m-d', strtotime($to . ' +1 day'));
                $this->db->where("sh.update_on BETWEEN '$from' AND '$to'");
            }
        }

        $this->db->select('sh.*,c.category_name as cname,n.category_name as notes_name,d.category_name as discount_name,s.username as name,a.name as firstname,aw.award_name,group_concat(`tags`.`tag_name` separator ",") as tag_name2');

        $this->db->join('pts_category c', 'c.id = sh.category', 'left');
        $this->db->join('pts_category n', 'n.id = sh.notes', 'left');
        $this->db->join('pts_category d', 'd.id = sh.discount', 'left');
        $this->db->join('bills_user s', 's.id = sh.stud_id', 'left');
        $this->db->join('pts_tags tags', 'FIND_IN_SET(tags.tag_id, s.student_tags) > 0', 'LEFT');
        $this->db->join('user a', 'a.id = sh.member_id', 'left');
        $this->db->join('pts_award aw', 'aw.id = sh.award_id', 'left');
        $this->db->group_by('sh.history_id,s.id');
        $this->db->order_by('sh.history_id', 'desc');
        $query = $this->db->get('pts_student_history sh');
        //echo $this->db->last_query();die;
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function save($data) {
        $query = $this->db->insert('student', $data);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    function update($id, $data) {
        $this->db->where('id', $id);
        $query = $this->db->update('student', $data);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    function delete($id) {
        $this->db->where('id', $id);
        $query = $this->db->delete('student');
        //echo $this->db->last_query();
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    function get_tables($tables, $where = "", $where_in = "") {
        if ($where) {
            foreach ($where as $key => $value) {
                $this->db->where($key, $value);
            }
        }
        if ($where_in) {
            foreach ($where_in as $key => $value) {
                $this->db->where_in($key, $value);
            }
        }
        $query = $this->db->get($tables);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

}
