<?php if(!defined('BASEPATH')) exit('No direct script access allowed');   
class Barcode_Model extends CI_Model {
    
    public function  __construct(){      
        parent::__construct();        
    }

    function  get_barcode($type="") {
        if($type >= 0 && $type  !="" ) $this->db->where('barcode_status',$type);
        $this->db->select('barcode.*,c.category_name as cname,n.category_name as notes_name,s.name');
        $this->db->join('category c', 'c.id = barcode.category_id','left');
        $this->db->join('category n', 'n.id = barcode.notes_id','left');
        $this->db->join('student s', 's.id = barcode.student_id','left');
        $query = $this->db->get('barcode');
        //echo $this->db->last_query();
        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function  get_barcode_id($id) {
        $this->db->where('id',$id);
        $query = $this->db->get('barcode');
        if($query->num_rows()>0) {
            return $query->row();
        } else {
            return false;
        }
    }

    function  get_barcode_ids($id) {
        $this->db->where_in('barcode.id',$id);
         $this->db->select('barcode.*,c.category_name as cname,n.category_name as notes_name,s.name');
        $this->db->join('category c', 'c.id = barcode.category_id','left');
        $this->db->join('category n', 'n.id = barcode.notes_id','left');
        $this->db->join('student s', 's.id = barcode.student_id','left');
        $query = $this->db->get('barcode');
        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function  get_category($type) {
        $this->db->where('category_type',$type);
        $this->db->where('category_status',1);
        $query = $this->db->get('pts_category');
        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function  get_award() {
        $query = $this->db->get('pts_award');
        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function  save($data) {
        $query = $this->db->insert('pts_barcode', $data); 
        if($query){ return true; } else { return false; }
    }

    function  update($id,$data) {
        $this->db->where('id', $id);
        $query = $this->db->update('barcode', $data); 
        if($query){
            return true;
        } else {
            return false;
        }
    }

    function  delete($id) {
        $this->db->where('id', $id);
        $query = $this->db->delete('pts_barcode'); 
        //echo $this->db->last_query();
        if($query){
            return true;
        } else {
            return false;
        }
    }

    function  get_tables($tables,$where="") {
        foreach ($where as $key => $value) {
            $this->db->where($key, $value); 
        }
        $query = $this->db->get($tables);

        if($query->num_rows()>0) {
            return $query->result();
        } else {
            return false;
        }
    }

}