<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Award_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function get_award() {
        $query = $this->db->get('pts_award');

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function get_history() {
        $this->db->select('aw.*,s.username as student_name,a.name as memeber_name,aa.award_name');
        $this->db->join('bills_user s', 's.id = aw.user_id', 'left');
        $this->db->join('pts_award aa', 'aa.id = aw.award_id', 'left');
        $this->db->join('user a', 'a.id = aw.member_id', 'left');
        $this->db->order_by('aw.id', 'desc');
        $query = $this->db->get('pts_award_history aw');

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    function get_history_id($id) {
        $this->db->where('aw.id', $id);
        /*         $this->db->select('aw.*,s.name as student_name');
          $this->db->join('student s','s.id = aw.user_id','left'); */
        $query = $this->db->get('pts_award_history aw');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return false;
        }
    }

    function get_award_id($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('pts_award');
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return false;
        }
    }

    function save($data) {
        $query = $this->db->insert('pts_award', $data);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    function update($id, $data) {
        $this->db->where('id', $id);
        $query = $this->db->update('pts_award', $data);
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

    function delete($id) {
        $this->db->where('id', $id);
        $query = $this->db->delete('pts_award');
        //echo $this->db->last_query();
        if ($query) {
            return true;
        } else {
            return false;
        }
    }

}
