<?php

class User_model extends CI_Model {

    public function add_user($data) {
        $this->db->insert('ci_users', $data);
        return true;
    }

    //---------------------------------------------------
    // get all users for server-side datatable processing (ajax based)
    public function get_all_users() {
        $wh = array();
        $SQL = 'SELECT * FROM ci_users';
        $wh[] = " is_admin = 0";
        if (count($wh) > 0) {
            $WHERE = implode(' and ', $wh);
            return $this->datatable->LoadJson($SQL, $WHERE);
        } else {
            return $this->datatable->LoadJson($SQL);
        }
    }

    //---------------------------------------------------
    // get all user records
    public function get_all_simple_users() {
        $this->db->where('is_admin', 0);
        $this->db->order_by('created_at', 'desc');
        $query = $this->db->get('ci_users');
        return $result = $query->result_array();
    }

    //---------------------------------------------------
    // Count total user for pagination
    public function count_all_users() {
        return $this->db->count_all('ci_users');
    }

    //---------------------------------------------------
    // Get all users for pagination
    public function get_all_users_for_pagination($limit, $offset) {
        $wh = array();
        $this->db->order_by('created_at', 'desc');
        $this->db->limit($limit, $offset);

        if (count($wh) > 0) {
            $WHERE = implode(' and ', $wh);
            $query = $this->db->get_where('ci_users', $WHERE);
        } else {
            $query = $this->db->get('ci_users');
        }
        return $query->result_array();
        //echo $this->db->last_query();
    }

    //---------------------------------------------------
    // get all users for server-side datatable with advanced search
    public function get_all_users_by_advance_search() {
        $wh = array();
        $SQL = 'SELECT * FROM ci_users';
        if ($this->session->userdata('user_search_type') != '')
            $wh[] = "is_active = '" . $this->session->userdata('user_search_type') . "'";
        if ($this->session->userdata('user_search_from') != '')
            $wh[] = " `created_at` >= '" . date('Y-m-d', strtotime($this->session->userdata('user_search_from'))) . "'";
        if ($this->session->userdata('user_search_to') != '')
            $wh[] = " `created_at` <= '" . date('Y-m-d', strtotime($this->session->userdata('user_search_to'))) . "'";

        $wh[] = " is_admin = 0";
        if (count($wh) > 0) {
            $WHERE = implode(' and ', $wh);
            return $this->datatable->LoadJson($SQL, $WHERE);
        } else {
            return $this->datatable->LoadJson($SQL);
        }
    }

    //---------------------------------------------------
    // Get user detial by ID
    public function get_user_by_id($id) {
        $query = $this->db->get_where('ci_users', array('id' => $id));
        return $result = $query->row_array();
    }

    //---------------------------------------------------
    // Edit user Record
    public function edit_user($data, $id) {
        $this->db->where('id', $id);
        $this->db->update('ci_users', $data);
        return true;
    }

    //---------------------------------------------------
    // Get User Role/Group
    public function get_user_groups() {
        $query = $this->db->get('ci_user_groups');
        return $result = $query->result_array();
    }

    public function send_sms($order_id, $msg_type) {
        $msg_content_row = $msg_type . '_sms_content';
        $open_to_send_row = 'sms_on_' . $msg_type;
        $this->db->select('sms_token');
        $this->db->select("$open_to_send_row,$msg_content_row");
        $sett = $this->db->get('setting')->row();
        $send_sms = FALSE;

        if ($sett->sms_token && $sett->$open_to_send_row && $sett->$msg_content_row != '') {
            $client_data = $this->get_token_data($sett->sms_token);
            if ($client_data->balance > 0) {
                if ($msg_type != 'pay_orders') {
                    $this->db->select('bills_user.phone,bills_user.phone_code,bills_user.username,bills_orders.id');
                    $this->db->join('bills_user', 'bills_user.id = bills_orders.id_user');
                    $user_row = $this->db->get_where('bills_orders', array('id_orders' => $order_id))->row();

                    $this->db->select('sum(discount_remainder) as total_amount');
                    $this->db->group_by('id_orders');
                    $price_row = $this->db->get_where('bills_orders', array('id_orders' => $order_id))->row();
                    if ($user_row) {
                        $send_sms = TRUE;
                        $msg_content = str_replace('{customer_name}', $user_row->username, $sett->$msg_content_row);
                        $msg_content = str_replace('{order_num}', $order_id, $msg_content);
                        $msg_content = str_replace('{order_price}', $price_row->total_amount, $msg_content);
                        $msg_content = str_replace('{order_url}', base_url('auth/show_invoice/' . $user_row->id), $msg_content);
                        $msg_content = str_replace('{store_name}', $client_data->id_name, $msg_content);
                        $payment_link = str_replace('http://www.', '', str_replace('https://www.', '', base_url('pay/' . urlencode(base64_encode($order_id)))));
                        $msg_content = str_replace('{payment_link}', $payment_link, $msg_content);
                    }
                } else {
                    $user_row = $this->db->get_where('payment_orders', array('id' => $order_id))->row();
                    if ($user_row) {
                        $send_sms = TRUE;
                        $msg_content = str_replace('{customer_name}', $user_row->client_name, $sett->$msg_content_row);
                        //$msg_content = str_replace('{order_num}', $order_id, $msg_content);
                        $msg_content = str_replace('{order_price}', $user_row->amount, $msg_content);
                        //$msg_content = str_replace('{order_url}', base_url('auth/show_invoice/' . $user_row->id), $msg_content);
                        $msg_content = str_replace('{store_name}', $client_data->id_name, $msg_content);
                        $payment_link = str_replace('http://www.', '', str_replace('https://www.', '', base_url('pay/' . urlencode(base64_encode($order_id)))));
                        $msg_content = str_replace('{payment_link}', $payment_link, $msg_content);
                    }
                }
                // Send Msg
                if ($send_sms) {
                    $data = array('token' => $sett->sms_token, 'message' => $msg_content, 'dst' => $user_row->phone_code . $user_row->phone);
                    send_request($this->config->item('sms_system_url') . '/api/main/sendSms', $data, 'post');
                }
            }
        }
    }

    function get_token_data($token) {
        $response = send_request($this->config->item('sms_system_url') . '/api/main/checkToken', array('token' => $token), 'post');
        if ($response) {
            return $response;
        }
        return FALSE;
    }

}

?>