<?php

class Tickets_model extends CI_Model {

    function get_tickets($status) {
        $this->db->select('t.*,datas.english as dept_name_eng,datas.arabic as dept_name_ar,bills_user.username as client_name,user.name as created_name');
        $this->db->join('bills_user', 'bills_user.id = t.client_id');
        $this->db->join('datas', 'datas.id = t.dept_id');
        $this->db->join('user', 'user.id=t.created_by');
        if ($status != -1) {
            $this->db->where('status', $status);
        }
        return $this->db->get('tickets t')->result_array();
    }

    function get_students() {
        $this->db->select('id,username,phone');
        return $this->db->get_where('bills_user', array('block !=' => 1))->result();
    }

    function get_depts() {
        return $this->db->get_where('datas', array('lable' => 'department'))->result();
    }

    function get_ticket($id) {
        return $this->db->get_where('tickets', array('id' => $id))->row();
    }

    function get_ticket_details($id) {
        $this->db->select('t.*,datas.english as dept_name_eng,datas.arabic as dept_name_ar,bills_user.username as client_name,user.name as created_name');
        $this->db->join('bills_user', 'bills_user.id = t.client_id');
        $this->db->join('datas', 'datas.id = t.dept_id');
        $this->db->join('user', 'user.id=t.created_by');
        return $this->db->get_where('tickets t', array('t.id' => $id))->row();
    }

    function get_status_count() {
        $this->db->select("SUM(CASE WHEN t.status = '0' THEN 1 ELSE 0 END) AS ticket_open");
        $this->db->select("SUM(CASE WHEN t.status = '1' THEN 1 ELSE 0 END) AS in_progress");
        $this->db->select("SUM(CASE WHEN t.status = '2' THEN 1 ELSE 0 END) AS answered");
        $this->db->select("SUM(CASE WHEN t.status = '3' THEN 1 ELSE 0 END) AS on_hold");
        $this->db->select("SUM(CASE WHEN t.status = '4' THEN 1 ELSE 0 END) AS closed");
        $this->db->select('count(*) as all_data');
        return $this->db->get('tickets t')->row();
    }

    function get_ticket_replies($ticket_id) {
        $this->db->select('user.name as created_name,t.*');
        $this->db->join('user', 'user.id=t.created_by');
        return $this->db->get_where('tickets_reply t', array('ticket_id' => $ticket_id))->result();
    }

}
