<?php

class Sessions_model extends CI_Model {

    function get_session_students($session_id) {
        $this->db->select('student_id');
        $students = $this->db->get_where('quraan_session_students', array('session_id' => $session_id))->result();
        $ids = array();
        foreach ($students as $student) {
            array_push($ids, $student->student_id);
        }
        return $ids;
    }

    function get_session_teachers($session_id) {
        $this->db->select('teacher_id');
        $teachers = $this->db->get_where('quraan_session_teachers', array('session_id' => $session_id))->result();
        $ids = array();
        foreach ($teachers as $teacher) {
            array_push($ids, $teacher->teacher_id);
        }
        return $ids;
    }

    function get_all_sessions() {
        $this->db->select('count(DISTINCT quraan_session_students.id) as total_students,quraan_sessions.id,quraan_sessions.title');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 0 THEN quran_tsme3.pages_count ELSE 0 END) AS hfz');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 1 THEN quran_tsme3.pages_count ELSE 0 END) AS mrg3a');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 2 THEN quran_tsme3.pages_count ELSE 0 END) AS srd');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 3 THEN quran_tsme3.pages_count ELSE 0 END) AS tlawa');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 4 THEN quran_tsme3.pages_count ELSE 0 END) AS tlken');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 5 THEN quran_tsme3.pages_count ELSE 0 END) AS test');

        $this->db->join('quraan_session_students', 'quraan_session_students.session_id = quraan_sessions.id', 'left');
        $this->db->join('quran_tsme3', 'quran_tsme3.product_id = quraan_sessions.id', 'left');
        $this->db->group_by('quraan_sessions.id,quraan_sessions.title');
        if ($this->session->userdata('teacher_id')) {
            $this->db->join('quraan_session_teachers', 'quraan_session_teachers.session_id = quraan_sessions.id and quraan_session_teachers.teacher_id=' . $this->session->userdata('teacher_id'));
        }
        $all_data = $this->db->get('quraan_sessions')->result();

        foreach ($all_data as $data) {

            $this->db->select('name');
            $this->db->join('teachers', 'teachers.id = quraan_session_teachers.teacher_id');
            $teachers = $this->db->get_where('quraan_session_teachers', array('session_id' => $data->id))->result();
            $teachers_name = array();
            foreach ($teachers as $teacher) {
                array_push($teachers_name, $teacher->name);
            }
            $data->teachers = new stdClass();
            $data->teachers = implode(',', $teachers_name);
        }
        return $all_data;
    }

    function get_sessions_plans($session_id, $student_id) {
        $this->db->select('u.username as student_name,p.*');
        if ($student_id) {
            $this->db->where('s.student_id', $student_id);
        }
        $this->db->where('s.session_id', $session_id);
        $this->db->join('quraan_session_students s', 's.id = p.quraan_session_students_id');
        $this->db->join('bills_user u', 'u.id = s.student_id');
        $plans = $this->db->get('quraan_sessions_plans p')->result();

        foreach ($plans as $plan) {
            $plan->target_percentage = $this->get_plan_target_percentage($plan->id);
        }
        return $plans;
    }

    function get_session_name($session_id) {
        $session = $this->db->get_where('quraan_sessions', array('id' => $session_id))->row();
        if ($session) {
            return $session->title;
        }
        return FALSE;
    }

    function get_session_students_with_name($session_id) {
        $this->db->select('bills_user.username as student_name,bills_user.id');
        $this->db->join('bills_user', 'bills_user.id = quraan_session_students.student_id');
        return $this->db->get_where('quraan_session_students', array(
                    'session_id' => $session_id
                ))->result();
    }

    function get_plan($plan_id) {
        return $this->db->get_where('quraan_sessions_plans', array('id' => $plan_id))->row();
    }

    function get_plan_with_student_name($plan_id) {
        $this->db->select('bills_user.username as student_name,from.arabic as from_surah_name,to.arabic as to_surah_name,quraan_sessions_plans.*');
        $this->db->join('quran_surah to', 'to.id = quraan_sessions_plans.to_surah');
        $this->db->join('quran_surah from', 'from.id = quraan_sessions_plans.from_surah');
        $this->db->join('quraan_session_students', 'quraan_session_students.id = quraan_sessions_plans.quraan_session_students_id');
        $this->db->join('bills_user', 'bills_user.id = quraan_session_students.student_id');
        return $this->db->get_where('quraan_sessions_plans', array('quraan_sessions_plans.id' => $plan_id))->row();
    }

    function get_plan_target_percentage($plan_id) {
        $this->db->select('s.student_id,s.session_id,p.*');
        $this->db->join('quraan_session_students s', 's.id = p.quraan_session_students_id');
        $plan_data = $this->db->get_where('quraan_sessions_plans p', array('p.id' => $plan_id))->row();

        $all_tsme3 = $this->db->get_where('quran_tsme3', array('student' => $plan_data->student_id, 'product_id' => $plan_data->session_id,
                    'type' => $plan_data->type, 'date(timestamp) >=' => $plan_data->date_from, 'date(timestamp) <=' => $plan_data->date_to))->result();

        $till_now_lines_count = $this->get_till_now_lines($plan_data);
        $already_sm3_line_count = 0;
        foreach ($all_tsme3 as $tsme3) {
            if (($tsme3->from_surah >= $plan_data->from_surah && $tsme3->from_surah <= $plan_data->to_surah) &&
                    ($tsme3->to_surah >= $plan_data->from_surah && $tsme3->to_surah <= $plan_data->to_surah) &&
                    ($tsme3->from_ayah >= $plan_data->from_ayah && $tsme3->from_ayah <= $plan_data->to_ayah) &&
                    ($tsme3->to_ayah >= $plan_data->from_ayah && $tsme3->to_ayah <= $plan_data->to_ayah)) {
                $already_sm3_line_count += $tsme3->lines_count;
            } else {
                return -1;
            }
        }
        return round(($already_sm3_line_count * 100) / $till_now_lines_count, 2);
    }

    function get_till_now_lines($plan_data) {
        
        if ($plan_data->date_to <= date('Y-m-d')) {
            return $plan_data->expected_lines_count;
        }
        $date_to = date('Y-m-d');
        $weeks_count = $this->Sessions_model->get_weeks_count($plan_data->date_from, $date_to);
        $sessions_count = floor($plan_data->sessions_count_per_week * $weeks_count);
        return $plan_data->lines_count_per_session * $sessions_count;
    }

    function get_weeks_count($start_date, $end_date) {
        $date1 = new DateTime($start_date);
        $date2 = new DateTime($end_date);
        $difference_in_weeks = $date1->diff($date2)->days / 7;
        return round($difference_in_weeks, 2);
    }

}
