<?php

class Knowledge_base_model extends CI_Model {

    function getRows($tbl) {
        $this->db->select('*');
        $this->db->from($tbl);
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function insertRow($table, $data) {
        if ($this->db->insert($table, $data))
            return $this->db->insert_id();
        else {
            return false;
        }
    }

    public function deleteRow($id, $table) {
        $this->db->where('id', $id);
        $this->db->delete($table);
    }

    function getDalel($id) {
        $this->db->select('*');
        $this->db->from('kw_parent_categories');
        $this->db->where('id', $id);
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function updateRow($id, $table, $data) {
        $this->db->where('id', $id);
        $query = $this->db->update($table, $data);
        return $query;
    }

    function getDalelbyName($name) {
        $this->db->select('*');
        $this->db->from('kw_parent_categories');
        $this->db->where('name', $name);
        $this->db->limit(1);
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getAllCategory($dalel_id) {
        $this->db->select('*');
        $this->db->order_by('category_order', 'asc');
        if ($dalel_id != 0) {
            $this->db->where('parent_id', $dalel_id);
        }
        $this->db->from('kw_categories');
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getCategory($id) {
        $this->db->select('*');
        $this->db->from('kw_categories');
        $this->db->where('id', $id);
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getAllDalelArticles($dalel_id) {
        $this->db->select('articles.id AS article_id, categories.id AS cat_id, articles.title, text, creator_id, category_id, articles.created_at, check_comment, check_rate, categories.name, yes_rate, no_rate, article_order,user.name as author');
        //$this->db->select('articles.id AS article_id, articles.title, text, creator_id, category_id, articles.created_at, check_comment, check_rate, yes_rate, no_rate, article_order');
        $this->db->join('kw_categories categories', 'categories.id = articles.category_id');
        $this->db->join('user', 'user.id = articles.creator_id');
        //$this->db->join('kw_parent_categories parent_categories', 'parent_categories.id = categories.parent_id');
        $this->db->order_by('article_order');
        if ($dalel_id != 0) {
            $this->db->where('categories.parent_id', $dalel_id);
        }
        $this->db->from('kw_articles articles');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getAllDalelCategories($dalel_id) {
        return $this->db->get_where('kw_categories', array('parent_id' => $dalel_id))->result();
    }

    function getArticleRateNum($article_id, $type) {
        $this->db->select('id');
        $this->db->where('rate', $type);
        $this->db->where('article_id', $article_id);
        $this->db->from('kw_article_rate');

        //Get All Data from Database
        $query = $this->db->get();
        return $query->num_rows();
    }

    function getDalelByCategory($id) {
        $this->db->select('parent_categories.name');
        $this->db->join('kw_categories categories', 'categories.parent_id = parent_categories.id', 'inner');
        $this->db->where('categories.id', $id);
        $this->db->from('kw_parent_categories parent_categories');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getArticle($article_id) {
        $this->db->select('articles.*,user.name');
        $this->db->where('articles.id', $article_id);
        $this->db->join('user', 'user.id = articles.creator_id');
        $this->db->from('kw_articles articles');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getArticleName($article_id) {
        $this->db->select('title');
        $this->db->where('id', $article_id);
        $this->db->from('kw_articles');

        //Get All Data from Database
        $row = $this->db->get()->row();
        if (!$row) {
            return '';
        } else {
            return $row->title;
        }
    }

    function getComments($article_id) {
        //$this->db->distinct();
        $this->db->select('article_comments.id AS comment_id, article_id, comment_text, c_date, user_type, title, comment_status');

        $this->db->join('kw_articles articles', 'articles.id = article_comments.article_id', 'inner');
        if ($article_id != 0) {
            $this->db->where('articles.id', $article_id);
        }
        $this->db->from('kw_article_comments article_comments');
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getComment($comment_id) {
        $this->db->select('*');
        $this->db->where('id', $comment_id);
        $this->db->from('kw_article_comments');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getAllCommentReply($comment_id) {
        $this->db->select('*');
        $this->db->where('comment_id', $comment_id);
        $this->db->from('kw_article_reply');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getReply($reply_id) {
        $this->db->select('*');
        $this->db->where('id', $reply_id);
        $this->db->from('kw_article_reply');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getHomepage($dalel_id) {
        $this->db->select('articles.id, articles.title, articles.text, articles.creator_id, articles.category_id, articles.created_at, articles.check_comment, articles.check_rate');
        $this->db->join('kw_categories categories', 'categories.id = articles.category_id', 'inner');
        $this->db->join('kw_parent_categories parent_categories', 'parent_categories.id = categories.parent_id', 'inner');
        $this->db->where('parent_categories.id', $dalel_id);
        //$this->db->where('check_homepage', 'نعم');
        $this->db->limit(1);
        $this->db->from('kw_articles articles');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getArticleComments($article_id) {
        $this->db->select('*');
        $this->db->where('article_id', $article_id);
        $this->db->where('comment_status', 'منشور');
        $this->db->from('kw_article_comments');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getUserArticleRate($user_id, $article_id) {
        $this->db->select('id, rate');
        $this->db->where('user_id', $user_id);
        $this->db->where('article_id', $article_id);
        $this->db->from('kw_article_rate');
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getDalelCategories($parent_id) {
        $this->db->select('*');
        $this->db->from('kw_categories');
        $this->db->where('parent_id', $parent_id);
        $this->db->order_by('category_order', 'asc');
        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getArticles($cat_id) {
        $this->db->select('*');
        $this->db->where('category_id', $cat_id);
        $this->db->order_by('article_order', 'asc');
        $this->db->from('kw_articles');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function getArticleDalel($id) {
        $this->db->select('parent_id AS dalel_id,parent_id AS id');
        $this->db->join('kw_categories categories', 'categories.id = articles.category_id', 'inner');
        $this->db->where('articles.id', $id);
        $this->db->from('kw_articles articles');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    public function deleteComment($id) {
        $this->db->where('id', $id);
        $query = $this->db->delete('kw_article_comments');
        return $query;
    }

    public function deleteReply($id) {
        $this->db->where('id', $id);
        $query = $this->db->delete('kw_article_reply');
        return $query;
    }

    function getCommentReply($comment_id) {
        $this->db->select('*');
        $this->db->where('reply_status', 'منشور');
        $this->db->where('comment_id', $comment_id);
        $this->db->from('kw_article_reply');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

    function updateUserArticleRate($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('kw_article_rate', $data);
    }

    public function search($word) {
        $this->db->select('*');
        $this->db->like('title', $word, 'both');
        $this->db->or_like('text', $word, 'both');
        $this->db->from('kw_articles');

        //Get All Data from Database
        $query = $this->db->get();
        if ($query->num_rows() == 0) {
            return false;
        } else {
            return $query->result();
        }
    }

}
