<?php

class Drivers_model extends CI_Model {

    function get_drivers() {
        $this->db->select('d.*,datas.english,datas.arabic');
        $this->db->join('datas', 'datas.id = d.country', 'left');
        return $this->db->get('drivers d')->result_array();
    }

    function get_active_drivers() {
        return $this->db->get_where('drivers', array('status' => 1))->result();
    }

    function get_countries() {
        return $this->db->get_where('datas', array('lable' => 'nationality'))->result();
    }

    function get_driver($id) {
        return $this->db->get_where('drivers', array('id' => $id))->row();
    }

    function get_driver_wiz_data($id) {
        $this->db->select('d.*,datas.english,datas.arabic');
        $this->db->join('datas', 'datas.id = d.country', 'left');
        return $this->db->get_where('drivers d', array('d.id' => $id))->row();
    }

    function get_drivers_report($from, $to) {
        if ($from != '' && $to != '') {
            $this->db->where(array('date(orders.timestamp) >=' => $from, 'date(orders.timestamp) <=' => $to));
        }
        $this->db->select('d.name,count(Distinct orders.id) as orders_count,sum(bills_orders.discount_remainder) as total_amount');
        $this->db->join('orders', 'orders.driver = d.id');
        $this->db->join('bills_orders', 'bills_orders.id_orders = orders.id');
        $this->db->group_by('d.id');
        return $this->db->get('drivers d')->result();
    }

    function get_driver_orders($driver_id, $delivery_status, $from, $to) {
        if ($from != '' && $to != '') {
            $this->db->where(array('date(orders.timestamp) >=' => $from, 'date(orders.timestamp) <=' => $to));
        }
        $this->db->select('orders.*,sum(bills_orders.discount_remainder) as total_amount,avg(bills_orders.paid) as paid,bills_orders.name as client');
        $this->db->join('bills_orders', 'bills_orders.id_orders = orders.id');
        $this->db->group_by('orders.id');
        return $this->db->get_where('orders', array('driver' => $driver_id, 'order_status' => $delivery_status))->result();
    }

    function get_order_details($id) {
        $this->db->select('bills_user.username,bills_user.phone,bills_user.blocks,bills_user.street,bills_user.jadah,bills_user.building_num'
                . ',bills_user.floor,bills_user.door_no,bills_user.address_link,bills_user.nationality,bills_user.region,avg(bills_orders.paid) as paid,'
                . 'sum(bills_orders.discount_remainder) as total_amount,orders.*');
        $this->db->join('bills_orders', 'bills_orders.id_orders = orders.id');
        $this->db->join('bills_user', 'bills_user.id = bills_orders.id_user');
        $this->db->group_by('orders.id');
        return $this->db->get_where('orders', array('orders.id' => $id, 'orders.driver' => $this->session->userdata('driver_id')))->row();
    }

    function get_order($id) {
        $this->db->select('avg(bills_orders.paid) as paid,orders.*');
        $this->db->join('bills_orders', 'bills_orders.id_orders = orders.id');
        $this->db->group_by('orders.id');
        return $this->db->get_where('orders', array('orders.id' => $id, 'orders.driver' => $this->session->userdata('driver_id')))->row();
    }

}
