<?php

/*
 * e24PaymentPipe
 *
 *
 * e24payment-php is an implementation in PHP of E24PaymentPipe 
 * java classes. It allows to connect to online credit card payment
 * from http://www.aciworldwide.com/.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details at 
 * http://www.gnu.org/copyleft/lgpl.html
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

class E24PaymentPipe {

  var $SUCCESS = 0;
  var $FAILURE = -1;
  var $BUFFER = 2320;
  var $strIDOpen = "291301";
  var $strPasswordOpen = "291301pg";
  var $strWebAddressOpen = "<webaddress>";
  var $strPortOpen = "<port>";
  var $strContextOpen = "<context>";
  var $strIDClose = "</id>";
  var $strPasswordClose = "</password>";
  var $strWebAddressClose = "</webaddress>";
  var $strPortClose = "</port>";
  var $strContextClose = "</context>";
  var $webAddress;
  var $port;
  var $id;
  var $password;
  var $action;
  var $transId;
  var $amt;
  var $responseURL;
  var $trackId;
  var $udf1;
  var $udf2;
  var $udf3;
  var $udf4;
  var $udf5;
  var $paymentPage;
  var $paymentId;
  var $result;
  var $auth;
  var $ref;
  var $avr;
  var $date;
  var $currency;
  var $errorURL;
  var $language;
  var $context;
  var $resourcePath;
  var $alias;
  var $error;
  var $rawResponse;
  var $debugMsg;

  public function __construct() {
    $this->webAddress = "";
    $this->port = "443";
    $this->id = "291301";
    $this->password = "291301pg";
    $this->action = ""; // 1 = purchase
    $this->transId = "";
    $this->amt = "";
    $this->responseURL = "";
    $this->trackId = "";
    $this->udf1 = "";
    $this->udf2 = "";
    $this->udf3 = "";
    $this->udf4 = "";
    $this->udf5 = "";
    $this->paymentPage = "";
    $this->paymentId = "";
    $this->result = 0;
    $this->auth = "";
    $this->ref = "";
    $this->avr = "";
    $this->date = "";
    $this->currency = "";
    $this->errorURL = "";
    $this->language = "";
    $this->context = "";
    $this->resourcePath = "";
    $this->alias = "";
    $this->error = "";
    $this->rawResponse = "";
    $this->debugMsg = "";
  }

  public function getWebAddress() {
    return webAddress;
  }

  public function setWebAddress($s) {
    $this->webAddress = $s;
  }

  public function getPort() {
    return $this->port;
  }

  public function setPort($s) {
    $this->port = $s;
  }

  public function setId($s) {
    $this->id = $s;
  }

  public function getId() {
    return $this->id;
  }

  public function setPassword($s) {
    $this->password = $s;
  }

  public function getPassword() {
    return $this->password;
  }

  public function setAction($s) {
    $this->action = $s;
  }

  public function getAction() {
    return $this->action;
  }

  public function setTransId($s) {
    $this->transId = $s;
  }

  public function getTransId() {
    return $this->transId;
  }

  public function setAmt($s) {
    $this->amt = $s;
  }

  public function getAmt() {
    return $this->amt;
  }

  public function setResponseURL($s) {
    $this->responseURL = $s;
  }

  public function getResponseURL() {
    return $this->responseURL;
  }

  public function setTrackId($s) {
    $this->trackId = $s;
  }

  public function getTrackId() {
    return $this->trackId;
  }

  public function setUdf1($s) {
    $this->udf1 = $s;
  }

  public function getUdf1() {
    return $this->udf1;
  }

  public function setUdf2($s) {
    $this->udf2 = $s;
  }

  public function getUdf2() {
    return $this->udf2;
  }

  public function setUdf3($s) {
    $this->udf3 = $s;
  }

  public function getUdf3() {
    return $this->udf3;
  }

  public function setUdf4($s) {
    $this->udf4 = $s;
  }

  public function getUdf4() {
    return $this->udf4;
  }

  public function setUdf5($s) {
    $this->udf5 = $s;
  }

  public function getUdf5() {
    return $this->udf5;
  }

  public function getPaymentPage() {
    return $this->paymentPage;
  }

  public function getPaymentId() {
    return $this->paymentId;
  }

  public function setPaymentId($s) {
    $this->paymentId = $s;
  }

  public function setPaymentPage($s) {
    $this->paymentPage = $s;
  }

  public function getRedirectContent() {
    return ("Location: " . $this->paymentPage . "?PaymentID=" . $this->paymentId);
  }

  public function getResult() {
    return $this->result;
  }

  public function getAuth() {
    return $this->auth;
  }

  public function getAvr() {
    return $this->avr;
  }

  public function getDate() {
    return $this->date;
  }

  public function getRef() {
    return $this->ref;
  }

  public function getCurrency() {
    return $this->currency;
  }

  public function setCurrency($s) {
    $this->currency = $s;
  }

  public function getLanguage() {
    return $this->language;
  }

  public function setLanguage($s) {
    $this->language = $s;
  }

  public function getErrorURL() {
    return $this->errorURL;
  }

  public function setErrorURL($s) {
    $this->errorURL = $s;
  }

  public function setContext($s) {
    $this->context = $s;
  }

  public function getResourcePath() {
    return $this->resourcePath;
  }

  public function setResourcePath($s) {
    $this->resourcePath = $s;
  }

  public function getAlias() {
    return $this->alias;
  }

  public function setAlias($s) {
    $this->alias = $s;
  }

  public function getErrorMsg() {
    return $this->error;
  }

  public function getRawResponse() {
    return $this->rawResponse;
  }

  public function getDebugMsg() {
    return $this->debugMsg;
  }

  public function performPaymentInitialization() {
    $stringbuffer = "";
    if (!$this->getSecureSettings())
      return -1;
    if (strlen($this->id) > 0)
      $stringbuffer .= ("id=" . $this->id . "&");
    if (strlen($this->password) > 0)
      $stringbuffer .= ("password=" . $this->password . "&");
    if (strlen($this->amt) > 0)
      $stringbuffer.=("amt=" . $this->amt . "&");
    if (strlen($this->currency) > 0)
      $stringbuffer.=("currencycode=" . $this->currency . "&");
    if (strlen($this->action) > 0)
      $stringbuffer.=("action=" . $this->action . "&");
    if (strlen($this->language) > 0)
      $stringbuffer.=("langid=" . $this->language . "&");
    if (strlen($this->responseURL) > 0)
      $stringbuffer.=("responseURL=" . $this->responseURL . "&");
    if (strlen($this->errorURL) > 0)
      $stringbuffer.=("errorURL=" . $this->errorURL . "&");
    if (strlen($this->trackId) > 0)
      $stringbuffer.=("trackid=" . $this->trackId . "&");
    if (strlen($this->udf1) > 0)
      $stringbuffer.=("udf1=" . $this->udf1 . "&");
    if (strlen($this->udf2) > 0)
      $stringbuffer.=("udf2=" . $this->udf2 . "&");
    if (strlen($this->udf3) > 0)
      $stringbuffer.=("udf3=" . $this->udf3 . "&");
    if (strlen($this->udf4) > 0)
      $stringbuffer.=("udf4=" . $this->udf4 . "&");
    if (strlen($this->udf5) > 0)
      $stringbuffer.=("udf5=" . $this->udf5 . "&");
    $s = $this->sendMessage($stringbuffer, "PaymentInitHTTPServlet");
    if ($s == null)
      return -1;
    $i = strpos($s, ":");
    if ($i == -1) {
      $this->error = "Payment Initialization returned an invalid response: " . $s;
      return -1;
    } else {
      $this->paymentId = substr($s, 0, $i);
      $this->paymentPage = substr($s, $i + 1);
      return 0;
    }
  }

  public function performTransaction() {
    $stringbuffer = "";
    if (!$this->getSecureSettings())
      return -1;
    if (strlen($this->id) > 0)
      $stringbuffer.=("id=" . id . "&");
    if (strlen($this->password) > 0)
      $stringbuffer.=("password=" . $this->password . "&");
    if (strlen($this->amt) > 0)
      $stringbuffer.=("amt=" . $this->amt . "&");
    if (strlen($this->action) > 0)
      $stringbuffer.=("action=" . $this->action . "&");
    if (strlen($this->paymentId) > 0)
      $stringbuffer.=("paymentid=" . $this->paymentId . "&");
    if (strlen($this->transId) > 0)
      $stringbuffer.=("transid=" . $this->transId . "&");
    if (strlen($this->trackId) > 0)
      $stringbuffer.=("trackid=" . $this->trackId . "&");
    if (strlen($this->udf1) > 0)
      $stringbuffer.=("udf1=" . $this->udf1 . "&");
    if (strlen($this->udf2) > 0)
      $stringbuffer.=("udf2=" . $this->udf2 . "&");
    if (strlen($this->udf3) > 0)
      $stringbuffer.=("udf3=" . $this->udf3 . "&");
    if (strlen($this->udf4) > 0)
      $stringbuffer.=("udf4=" . $this->udf4 . "&");
    if (strlen($this->udf5) > 0)
      $stringbuffer.=("udf5=" . $this->udf5 . "&");
    $s = sendMessage($stringbuffer, "PaymentTranHTTPServlet");
    if ($s == null)
      return -1;
    $arraylist = parseResults($s);
    if ($arraylist == null) {
      return -1;
    } else {
      $this->result = $arraylist[0];
      $this->auth = $arraylist[1];
      $this->ref = $arraylist[2];
      $this->avr = $arraylist[3];
      $this->date = $arraylist[4];
      $this->transId = $arraylist[5];
      $this->trackId = $arraylist[6];
      $this->udf1 = $arraylist[7];
      $this->udf2 = $arraylist[8];
      $this->udf3 = $arraylist[9];
      $this->udf4 = $arraylist[10];
      $this->udf5 = $arraylist[11];
      return 0;
    }
  }

  public function sendMessage($s, $s1) {
    $stringbuffer = "";
    $error = "";
    $this->debugMsg .= ("\n---------- " . $s1 . ": " . time() . " ----------");
    if ($this->port == "443") {
      if (strlen($this->webAddress) <= 0) {
        $error = "No URL specified.";
        return null;
      }
      if ($this->port == "443")
        $stringbuffer.=("https://");
      else
        $stringbuffer.=("http://");
      $stringbuffer.=($this->webAddress);
      if (strlen($this->port) > 0) {
        $stringbuffer.=(":");
        $stringbuffer.=($this->port);
      }
      if (strlen($this->context) > 0) {
        if (!$this->StartsWith($this->context, "/"))
          $stringbuffer.=("/");
        $stringbuffer.=($this->context);
        if (!$this->EndsWith($this->context, "/"))
          $stringbuffer.=("/");
      } else {
        $stringbuffer.=("/");
      }
      $stringbuffer.=("servlet/");
      $stringbuffer.=($s1);
      $this->debugMsg.=("\nAbout to create the URL to: " . $stringbuffer);
      $url = $stringbuffer;

      $this->debugMsg.=("\nAbout to create http connection");

      $this->debugMsg.=("\nCreated connection");
      if (strlen($s) > 0) {
        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $stringbuffer);
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $s);
        $this->debugMsg.=("\nabout to write DataOutputSteam");

        $this->debugMsg.=("\nafter DataOutputStream");
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        $tmp = curl_exec($c);

        curl_close($c);
        $this->rawResponse = $tmp;
        $this->debugMsg.=("\nReceived RESPONSE: " . $this->rawResponse);
        return $this->rawResponse;
      } else {
        $error = "No Data To Post!";
      }
    } {
      $this->clearFields();
      $this->error = "Failed to make connection:\n". $error;  //. $exception;
      return null;
    }
  }

  public function parseResults($s) {
    $arraylist = array();
    {
      if (StartsWith($s, "!ERROR!")) {
        $this->error = $s;
        return null;
      }

      $tokens = strtok($s, ":\r\n");

      $s1;
      $flag = false;
      foreach ($tokens as $token) {
        $s2 = $token;
        if (!s2 . startsWith(":")) {
          $arraylist[] = ($s2);
          $flag = false;
        } else {
          if (flag)
            $arraylist[] = ("");
          $flag = true;
        }
      }
      return $arraylist;
    }

    $this->error = "Internal Error!";
    return null;
  }

  public function clearFields() {
    $this->error = "";
    $this->paymentPage = "";
    $this->paymentId = "";
  }

  public function getSecureSettings() {
    $s = "";
    if (!$this->createReadableZip())
      return false;
    $s = $this->readZip();
    if ($s == "")
      return false;

    unlink($this->getResourcePath() . "resource.cgz");
    return $this->parseSettings($s);
  }

  public function createReadableZip() { 

      $filenameInput = $this->getResourcePath() . "resource.cgn";
      $handleInput = fopen($filenameInput, "r");
      $contentsInput = fread($handleInput, filesize($filenameInput));

      $filenameOutput = $this->getResourcePath() . "resource.cgz";
      @unlink($filenameOutput);
      $handleOutput = fopen($filenameOutput, "w");

      $inByteArray = $this->getBytes($contentsInput);
      $outByteArray = $this->simpleXOR($inByteArray);
      fwrite($handleOutput, $this->getString($outByteArray));
      fclose($handleInput);
      fclose($handleOutput);

    return true;
  }

  public function readZip() {

    $s = "";
    {

      $filenameInput = $this->getResourcePath() . "resource.cgz";
      $zipentry;
      $i = 0;

      $zip = new ZipArchive;
      if ($zip->open($filenameInput) === TRUE) {
        $zip->extractTo($this->resourcePath);
        $zip->close();
      } else {
        echo 'failed';
        $this->error = "Failed to unzip file";
      }

      if (strlen($this->error) === 0) {
        $xmlNameInput = $this->resourcePath . $this->getAlias() . ".xml";
        $xmlHandleInput = fopen($xmlNameInput, "r");
        $xmlContentsInput = fread($xmlHandleInput, filesize($xmlNameInput));
        fclose($xmlHandleInput);
        unlink($xmlNameInput);
        $s = $xmlContentsInput;

        $s = $this->getString($this->simpleXOR($this->getBytes($s)));
      } else {
        $this->error = "Unable to open resource";
      }
      return $s;
    }
  }

  public function parseSettings($s) {
    $i = 0;
    $j = 0;
    $i = strpos($s, "<id>") + strlen("<id>");
    $j = strpos($s, "</id>");

    $this->setId(substr($s, $i, $j - $i));
    $i = strpos($s, "<password>") + strlen("<password>");
    $j = strpos($s, "</password>");
    $this->setPassword(substr($s, $i, $j - $i));
    $i = strpos($s, "<webaddress>") + strlen("<webaddress>");
    $j = strpos($s, "</webaddress>");
    $this->setWebAddress(substr($s, $i, $j - $i));
    $i = strpos($s, "<port>") + strlen("<port>");
    $j = strpos($s, "</port>");
    $this->setPort(substr($s, $i, $j - $i));
    $i = strpos($s, "<context>") + strlen("<context>");
    $j = strpos($s, "</context>");
    $this->setContext(substr($s, $i, $j - $i));
    return true;
  }

  public function simpleXOR($abyte0) {
    $key = "Those who profess to favour freedom and yet depreciate agitation are men who want rain without thunder and lightning";
    $abyte1 = $this->getBytes($key);

    for ($i = 0; $i < sizeof($abyte0);) {
      for ($j = 0; $j < sizeof($abyte1); $j++) {
        $abyte2[$i] = ($abyte0[$i] ^ $abyte1[$j]);
        if (++$i == sizeof($abyte0))
          break;
      }
    }

    return $abyte2;
  }

  public function getBytes($s) {
    $hex_ary = array();
    $size = strlen($s);
    for ($i = 0; $i < $size; $i++)
      $hex_ary[] = chr(ord($s[$i]));
    return $hex_ary;
  }

  public function getString($byteArray) {
    $s = "";
    foreach ($byteArray as $byte) {
      $s .=$byte;
    }
    return $s;
  }

  public function StartsWith($Haystack, $Needle) {
    // Recommended version, using strpos
    return strpos($Haystack, $Needle) === 0;
  }

  public function EndsWith($Haystack, $Needle) {
    // Recommended version, using strpos
    return strrpos($Haystack, $Needle) === strlen($Haystack) - strlen($Needle);
  }

}

function xor_string($string) {
  $buf = '';
  $size = strlen($string);
  for ($i = 0; $i < $size; $i++)
    $buf .= chr(ord($string[$i]) ^ 255);
  return $buf;
}