<?php

/* function pr($data=""){

  echo "<pre>";

  print_r($data);

  echo "</pre>";

  } */

function get_setting() {

    $CI = & get_instance();

    $CI->db->select('*');

    $CI->db->where('setting_id', 1);

    $query = $CI->db->get('setting');

    return $query->row();
}

function get_percentage($percentage, $totalWidth) {

    $new_width = ($percentage * 100) / $totalWidth;

    return round($new_width);
}

function get_member_alert() {

    $CI = & get_instance();

    $CI->db->select('u.*,o.name as operator_name,count(o.id) as  count_id');

    /* $this->db->order_by('u.id','desc'); */

    $CI->db->join('operator o', 'o.id = u.operator_id', 'left');

    $CI->db->group_by('1');

    $CI->db->having('count_id', 0);

    $query = $CI->db->get('user u');

    return $query->num_rows();
}

function notification() {

    $CI = & get_instance();

    $user_id = $CI->session->userdata('user_id');

    $CI->db->select('notification_status');

    $CI->db->where('notification_status', 0);

    $CI->db->where('user_id', $user_id);

    $CI->db->order_by('id', 'desc');

    $CI->db->limit('10');

    $query = $CI->db->get('task_notification');

    return $query->num_rows();
}

function get_access() {

    $CI = & get_instance();

    $id = $CI->session->userdata('user_id');

    $CI->db->where('u.id', $id);

    $CI->db->select('u.*,o.name as operator_name,o.setting');

    $CI->db->order_by('u.id', 'desc');

    $CI->db->join('operator o', 'o.id = u.operator_id');

    $query = $CI->db->get('user u');

    if ($query->num_rows() > 0) {

        $privileges = $query->row()->setting;

        $privileges_data = array();

        if ($privileges)
            $privileges_data = explode(",", $privileges);

        return $privileges_data;
    } else {

        return false;
    }
}

function get_access_data($permission) {

    $CI = & get_instance();

    $id = $CI->session->userdata('user_id');

    $CI->db->where('u.id', $id);

    $CI->db->select('u.*,o.name as operator_name,o.setting');

    $CI->db->order_by('u.id', 'desc');

    $CI->db->join('operator o', 'o.id = u.operator_id');

    $query = $CI->db->get('user u');

    if ($query->num_rows() > 0) {

        $privileges = $query->row()->setting;

        $privileges_data = array();

        if ($privileges)
            $privileges_data = explode(",", $privileges);

        if (in_array($permission, $privileges_data)) {

            return true;
        } else {

            return false;
        }



        return $privileges_data;
    } else {

        return false;
    }
}

function main_premission($permission_name) {

    $CI = & get_instance();

    $CI->db->where('permission_name', $permission_name);

    $CI->db->select('permission_status');

    $query = $CI->db->get('setting_permission');

    ///echo $CI->db->last_query();

    if ($query->num_rows() > 0) {

        $privileges = $query->row()->permission_status;

        return $privileges;
    } else {

        return false;
    }
}

function get_ap($column_name, $operator_id = "", $opt = "") {

    $CI = & get_instance();

    $id = $CI->session->userdata('user_id');

    $CI->db->where('permission_name', $column_name);

    $CI->db->where('operator_id', $operator_id);

    $CI->db->select('permission_status');

    $query = $CI->db->get('permission');

    if ($query->num_rows() > 0) {

        $ap = $query->row()->permission_status;

        if ($opt)
            $privileges = $ap;
        else
            $privileges = $ap > 1 ? 1 : $ap;

        return $privileges;
    } else {

        return false;
    }
}

function get_ap_2($column_name, $operator_id = "", $opt = "") {

    $CI = & get_instance();

    $id = $CI->session->userdata('');

    $CI->db->where('column_name', $column_name);

    $CI->db->where('operator_id', $operator_id);

    $CI->db->select('access_permission');

    $query = $CI->db->get('roles_list');

    if ($query->num_rows() > 0) {



        $ap = $query->row()->access_permission;

        if ($opt)
            $privileges = $ap;
        else
            $privileges = $ap;

        return $privileges;
    } else {

        return false;
    }
}

function gen_slug($str) {

    # special accents

    $a = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'Ð', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', '?', '?', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', '?', '?', 'L', 'l', 'N', 'n', 'N', 'n', 'N', 'n', '?', 'O', 'o', 'O', 'o', 'O', 'o', 'Œ', 'œ', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'Š', 'š', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Ÿ', 'Z', 'z', 'Z', 'z', 'Ž', 'ž', '?', 'ƒ', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', '?', '?', '?', '?', '?', '?');

    $b = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');

    return strtolower(preg_replace(array('/[^a-zA-Z0-9 -]/', '/[ -]+/', '/^-|-$/'), array('', '_', ''), str_replace($a, $b, $str)));
}

function get_premission($id) {

    $CI = & get_instance();



    $CI->db->where('r.operator_id', $id);

    $query = $CI->db->get('roles_list r');

    if ($query->num_rows() > 0) {

        $privileges_data = $query->result();

        pr($privileges_data);

        return $privileges_data;
    } else {

        return false;
    }
}

function get_priority($prio) {
    $CI = & get_instance();
    $prio_arr = array('high', 'medium', 'low');
    return $CI->lang->line($prio_arr[$prio]);
}

function get_status($status) {
    $CI = & get_instance();
    $status_arr = array('ticket_open', 'in_progress', 'answered', 'on_hold', 'closed');
    return $CI->lang->line($status_arr[$status]);
}

function get_type($type) {
    $CI = & get_instance();
    $types_arr = array('inquiry', 'complaint', 'suggestion', 'other');
    return $CI->lang->line($types_arr[$type]);
}

function send_request($request, $data, $method) {
    if ($method == 'post') {
        $post_data = json_encode($data);
    } else { // get method
        $data_str = '?';
        foreach ($data as $key => $value) {
            if ($key == 'message') {
                $value = urlencode($value);
            }
            $data_str .= $key . '=' . $value . '&';
        }
        $data_str = substr_replace($data_str, "", -1);
        $request .= $data_str;
    }

    // Prepare new cURL resource
    $crl = curl_init($request);
    curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($crl, CURLINFO_HEADER_OUT, true);
    if ($method == 'post') {
        curl_setopt($crl, CURLOPT_POST, true);
        curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);

        // Set HTTP Header for POST request 
        curl_setopt($crl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($post_data))
        );
    }

    // Submit the POST request
    $result = curl_exec($crl);
//    if(isset($data['message'])){
//        print_r($result);die;
//    }
//    if(strpos($request, 'sendSms')!==FALSE){
//        echo $request.'<br/>';
//        print_R($result);
//        die;
//    }
    // handle curl error
    if ($result === false) {
        // throw new Exception('Curl error: ' . curl_error($crl));
        print_r('Curl error: ' . curl_error($crl));
        die;
        return FALSE;
    } else {
        if (substr($result, 0, 5) == "<?xml") {
            $result = simplexml_load_string($result);
        } else {
            $result = json_decode($result);
        }
        return $result;
    }
    // Close cURL session handle
    curl_close($crl);
}

function get_license_per($module) {

    $CI = & get_instance();

    $CI->db->where('permission_name', $module);

    $row = $CI->db->get('setting_permission')->row();

    if ($row && $row->permission_status) {
        return TRUE;
    }
    return FALSE;
}

function get_system_status() {
    $CI = & get_instance();

    $CI->db->select('system_status');

    $row = $CI->db->get('setting')->row();
    if ($row && $row->system_status) {
        return TRUE;
    }
    return FALSE;
}

function set_system_timezone() {
    // date_default_timezone_set('Asia/Kuwait');
    $CI = & get_instance();

    $CI->db->select('timezone');

    $row = $CI->db->get('setting')->row();
    if ($row) {
        if ($row->timezone) {
            date_default_timezone_set($row->timezone);
        } else {
            date_default_timezone_set('Asia/Kuwait');
        }
    }

//    $now = new DateTime();
//    $now->setTimezone(new DateTimeZone('America/Los_Angeles'));
//    echo $now->format('Y-m-d H:i:s');die;
}

function is_payment_available() {
    $CI = & get_instance();
    $row = $CI->db->get('payment_settings')->row();
    if ($row && $row->status) {
        return TRUE;
    }
    return FALSE;
}

function rec_log($action, $user_type = 0, $order_id = 0, $new_status = 0) {
    $CI = & get_instance();
    if ($user_type == 0) {
        $user_id = $CI->session->userdata('admin_id');
    } else {
        $user_id = $CI->session->userdata('driver_id');
    }
    $CI->db->insert('logs', array('action' => $action, 'user_id' => $user_id, 'user_type' => $user_type, 'date' => date('Y-m-d H:i:s'),
        'order_id' => $order_id, 'new_status' => $new_status));
}

function order_was_in_status($order_id, $status) {
    $CI = & get_instance();
    $CI->db->select('user.name,drivers.name as driver_name,logs.*');
    $CI->db->join('user', 'user.id = logs.user_id and user_type = 0', 'left');
    $CI->db->join('drivers', 'drivers.id = logs.user_id and user_type = 1', 'left');
    $row = $CI->db->get_where('logs', array('order_id' => $order_id, 'new_status' => $status))->row();
    return $row;
}

function adjust_timezone($timestamp, $format = 'Y-m-d H:i:s') {
    return date($format, strtotime($timestamp) + 3 * 3600);
//    $date = new DateTime($timestamp, new DateTimeZone('Atlantic/Azores'));
//    $date->setTimezone(new DateTimeZone('Asia/Kuwait'));
//    return $date->format($format);
}
