<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Tickets extends MY_Controller {

    var $thispage;

    public function __construct() {
        parent::__construct();
        if (!get_license_per('support')) {
            redirect("", "refresh");
        }
        $this->thispage = "Tickets";
        $this->load->model('booking');
        $this->operator_id = $this->session->userdata('operator_id');
        if (!get_ap('supp_module', $this->operator_id)) {
            redirect("", "refresh");
        }
        if (!$this->session->userdata('group')) {
            echo "لايمكن الاستخدام ";
            $this->session->set_flashdata('msg', 'لايمكن التعديل عليه');
            redirect($_SERVER['HTTP_REFERER']);
            exit();
        }
        $this->load->model('admin/Tickets_model');
    }

    function index($status = -1) {
        $data['tickets'] = $this->Tickets_model->get_tickets($status);
        $data['status_arr'] = array('ticket_open', 'in_progress', 'answered', 'on_hold', 'closed');
        $data['status_counts'] = $this->Tickets_model->get_status_count();
        $data['title'] = $this->lang->line('support');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/support/all', $data);
    }

    public function add() {
        if (!get_ap('supp_add_ticket', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');
            $this->form_validation->set_rules('dept_id', $this->lang->line('department'), 'trim|required');

            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $add = TRUE;
                $data = $this->input->post();
                unset($data['submit']);
                $data['created_by'] = $this->session->userdata('admin_id');
                $data = $this->security->xss_clean($data);
                $result = $this->db->insert('tickets', $data);
                $this->session->set_flashdata('msg', $this->lang->line('op_success'));
                redirect(base_url('support/tickets'));
            }
        }
        if (!$add) {
            $data['students'] = $this->Tickets_model->get_students();
            $data['depts'] = $this->Tickets_model->get_depts();
            $data['title'] = $this->lang->line('add-a-ticket');
            $data['thispage'] = $this->thispage;
            $this->load->view('site/support/add', $data);
        }
    }

    public function edit($ticket_id) {
        if (!get_ap('supp_edit_ticket', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');
            $this->form_validation->set_rules('dept_id', $this->lang->line('department'), 'trim|required');

            if ($this->form_validation->run() === FALSE) {
                $add = FALSE;
            } else {
                $add = TRUE;
                $data = $this->input->post();
                unset($data['submit']);
                $data = $this->security->xss_clean($data);
                $result = $this->db->update('tickets', $data, array('id' => $ticket_id));
                $this->session->set_flashdata('msg', $this->lang->line('op_success'));
                redirect(base_url('support/tickets'));
            }
        }
        if (!$add) {
            $data['students'] = $this->Tickets_model->get_students();
            $data['depts'] = $this->Tickets_model->get_depts();
            $data['ticket'] = $this->Tickets_model->get_ticket($ticket_id);
            $data['title'] = $this->lang->line('edit_ticket');
            $data['thispage'] = $this->thispage;
            $this->load->view('site/support/edit', $data);
        }
    }

    public function del($ticket_id) {
        if (!get_ap('supp_del_ticket', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->db->delete('tickets', array('id' => $ticket_id));
        $this->session->set_flashdata('msg', $this->lang->line('op_success'));
        redirect(base_url('support/tickets'));
    }

    public function show($ticket_id) {

        $this->form_validation->set_rules('reply', $this->lang->line('add_reply'), 'trim|required');

        if ($this->form_validation->run() != FALSE) {
            $this->db->update('tickets', array('last_reply_time' => date('Y-m-d H:i:s')), array('id' => $ticket_id));
            $data = array('created_by' => $this->session->userdata('admin_id'),
                'reply' => $this->input->post('reply'),
                'ticket_id' => $ticket_id);
            $this->db->insert('tickets_reply', $data);
            $this->session->set_flashdata('msg', $this->lang->line('op_success'));
            redirect(base_url('support/Tickets/show/' . $ticket_id));
        }
        $data['ticket'] = $this->Tickets_model->get_ticket_details($ticket_id);
        $data['replies'] = $this->Tickets_model->get_ticket_replies($ticket_id);
        $data['title'] = $this->lang->line('ticket');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/support/show', $data);
    }

}
