<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Teacher extends MY_Controller {

    var $thispage;
    var $cats;

    public function __construct() {
        parent::__construct();
        if (!get_license_per('quraan_sessions')) {
            redirect("", "refresh");
        }
        $this->thispage = "teacher";
        $this->load->model('booking');
        $this->operator_id = $this->session->userdata('operator_id');
        if (get_ap('quraan_sessions_module', $this->operator_id) == 1 || $this->session->userdata('is_teacher_login')) {
            
        } else {
            redirect("", "refresh");
        }
        if (!$this->session->userdata('group') && !$this->session->userdata('is_teacher_login')) {
            echo "لايمكن الاستخدام ";
            $this->session->set_flashdata('msg', 'لايمكن التعديل عليه');
            // /echo $_SERVER['HTTP_REFERER'];
            redirect($_SERVER['HTTP_REFERER']);
            exit();
        }
    }

    public function index() {
        if (!get_ap('teachers', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->all(1);
    }

    public function all($page = 1) {
        $this->db->select('teachers.*,datas.arabic,datas.english');
        $this->db->join('datas', 'datas.id = teachers.nationality', 'left');
        $data['all_groups'] = $this->db->get('teachers')->result_array();

        $data['title'] = $this->lang->line('teachers');
        // $data['view'] = '../controllers/views/'.$this->thispage.'/show';
        $data['cats'] = $this->cats;
        $data['thispage'] = $this->thispage;
        $this->load->view('site/' . $this->thispage . '/show', $data);
    }

    public function add($cats = 1) {
        if (!get_ap('teacher_add', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('name', $this->lang->line('the-name'), 'trim|required');
            $this->form_validation->set_rules('email', $this->lang->line('e-mail'), 'trim|required|is_unique[teachers.email]');
            $this->form_validation->set_rules('pass', $this->lang->line('password'), 'trim|required');

            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {
                $add = TRUE;
                $post_data = $this->input->post();
                $post_data['pass'] = md5($post_data['pass']);
                $post_data['student_tags'] = implode(',', $post_data['student_tags']);
                // filesss
                $this->load->library('upload');
                $files = $_FILES;
                $cpt = count($_FILES['imageuser']['name']);
                for ($i = 0; $i < $cpt; $i ++) {
                    $_FILES['userfile']['name'] = $files['imageuser']['name'][$i];
                    $_FILES['userfile']['type'] = $files['imageuser']['type'][$i];
                    $_FILES['userfile']['tmp_name'] = $files['imageuser']['tmp_name'][$i];
                    $_FILES['userfile']['error'] = $files['imageuser']['error'][$i];
                    $_FILES['userfile']['size'] = $files['imageuser']['size'][$i];
                    $this->upload->initialize($this->set_upload_options());
                    $this->upload->do_upload();
                    $dataInfo[] = $this->upload->data();
                }
                for ($i = 0; $i < $cpt; $i ++) {
                    $datas[] = $dataInfo[$i]['file_name'];
                }
                $post_data['files'] = implode(',', $datas);
                //End filesss
                unset($post_data['submit']);
                $this->db->insert('teachers', $post_data);

                $this->session->set_flashdata('msg', 'تم اضافة المعلم بفضل الله!');
                redirect(base_url('quraan/teacher'));
            }
        }
        if (!$add) {

            $data['title'] = $this->lang->line('add-a-teacher');

            $this->db->where('lable', 'nationality');
            $data['nationality'] = $this->db->get('datas')->result();

            $this->load->model('points/Tag_Model');
            $data['student_tags'] = $this->Tag_Model->get_tag(2);

            $data['thispage'] = $this->thispage;

            $data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/' . $this->thispage . '/add', $data);
        }
    }

    public function del($id) {
        if (!get_ap('teacher_del', $this->operator_id)) {
            redirect("", "refresh");
        }
        $teacher_files = $this->db->get_where('teachers', array('id' => $id))->row()->files;
        $files = explode(',', $teacher_files);
        foreach ($files as $file) {
            unlink('./uploads/teachers/' . $file);
        }
        $this->db->delete('teachers', array('id' => $id));

        $this->session->set_flashdata('msg', 'تم حذف  المعلم بفضل الله!');
        redirect(base_url('quraan/teacher'));
    }

    public function edit($id) {
        if (!get_ap('teacher_edit', $this->operator_id)) {
            redirect("", "refresh");
        }
        $query = $this->db->get_where('teachers', array(
                    'id' => $id
                ))->row_array();

        $add = FALSE;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('name', $this->lang->line('the-name'), 'trim|required');
            $extra = '';
            if ($query['email'] != $this->input->post('email')) {
                $extra = '|is_unique[teachers.email]';
            }
            $this->form_validation->set_rules('email', $this->lang->line('e-mail'), 'trim|required' . $extra);


            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {

                $add = TRUE;

                $edit_data = $this->input->post();
                if ($this->input->post('new_password') != '') {
                    $edit_data['password'] = md5($this->input->post('new_password'));
                }
                $edit_data['student_tags'] = implode(',', $edit_data['student_tags']);
                
                // filesss
                $this->load->library('upload');
                $files = $_FILES;
                $cpt = count($_FILES['imageuser']['name']);
                for ($i = 0; $i < $cpt; $i ++) {
                    $_FILES['userfile']['name'] = $files['imageuser']['name'][$i];
                    $_FILES['userfile']['type'] = $files['imageuser']['type'][$i];
                    $_FILES['userfile']['tmp_name'] = $files['imageuser']['tmp_name'][$i];
                    $_FILES['userfile']['error'] = $files['imageuser']['error'][$i];
                    $_FILES['userfile']['size'] = $files['imageuser']['size'][$i];
                    $this->upload->initialize($this->set_upload_options());
                    $this->upload->do_upload();
                    $dataInfo[] = $this->upload->data();
                }
                for ($i = 0; $i < $cpt; $i ++) {
                    $datas[] = $dataInfo[$i]['file_name'];
                }
                if ($cpt > 0) {
                    $edit_data['files'] = implode(',', $datas);
                    $edit_data['files'] .= $query['files'] ? ',' . $query['files'] : '';
                }
                //End filesss

                unset($edit_data['submit']);
                unset($edit_data['new_password']);

                $this->db->where('id', $id)->update('teachers', $edit_data);

                $this->session->set_flashdata('msg', 'تم التعديل المعلم بفضل الله!');
                if ($this->session->has_userdata('is_teacher_login')) {
                    $this->session->set_flashdata('success', $this->lang->line('op_success'));
                    redirect(base_url('quraan/teacher/edit/' . $id));
                } else {
                    redirect(base_url('quraan/teacher'));
                }
            }
        }

        if (!$add) {
            $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('teacher');

            $this->db->where('lable', 'nationality');
            $data['nationality'] = $this->db->get('datas')->result();

            $this->load->model('points/Tag_Model');
            $data['student_tags'] = $this->Tag_Model->get_tag(2);

            $data['thispage'] = $this->thispage;
            $data['edit'] = $query;
            // $data['view'] = '../controllers/views/'.$this->thispage.'/edit';
            $this->load->view('site/' . $this->thispage . '/edit', $data);
        }
    }

    private function set_upload_options() {
        // upload an image options
        $config = array();
        $config['upload_path'] = 'uploads/teachers';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|JPEG|pdf|doc|docx|txt';
        $config['max_size'] = '0';
        $config['overwrite'] = FALSE;
        return $config;
    }

    function approve_status($id, $status) {
        if ($status == 1) {
            $data['approve_status'] = 0;
        } else {
            $data['approve_status'] = 1;
        }
        $this->db->where('id', $id)->update('teachers', $data);
        $this->session->set_flashdata('success', 'success');
        redirect('quraan/teacher');
    }

}
