<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Sessions extends MY_Controller {

    var $thispage;
    var $cats;

    public function __construct() {
        parent::__construct();
        if (!get_license_per('quraan_sessions')) {
            redirect("", "refresh");
        }
        $this->thispage = "sessions";
        $this->load->model('booking');
        $this->operator_id = $this->session->userdata('operator_id');
        if (get_ap('quraan_sessions_module', $this->operator_id) == 1 || $this->session->userdata('is_teacher_login')) {
            
        } else {
            redirect("", "refresh");
        }
        if (!$this->session->userdata('group')) {
            echo "لايمكن الاستخدام ";
            $this->session->set_flashdata('msg', 'لايمكن التعديل عليه');
            // /echo $_SERVER['HTTP_REFERER'];
            redirect($_SERVER['HTTP_REFERER']);
            exit();
        }
        $this->load->model('admin/Sessions_model');
    }

    public function index() {
        if (!get_ap('quraan_sessions', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->all(1);
    }

    public function all($page = 1) {

        $data['all_groups'] = $this->Sessions_model->get_all_sessions();

        $data['title'] = $this->lang->line('quraan_sessions');
        // $data['view'] = '../controllers/views/'.$this->thispage.'/show';
        $data['cats'] = $this->cats;
        $data['thispage'] = $this->thispage;
        $this->load->view('site/' . $this->thispage . '/show', $data);
    }

    public function add_students($session_id) {
        if (!get_ap('add_students', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;

        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('students[]', $this->lang->line('title'), 'trim|required');

            // $this->form_validation->set_rules('comment', '', 'trim|required');
            // $this->form_validation->set_rules('comm', '', 'trim|required');
            //
            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {
                $add = TRUE;
                $this->db->delete('quraan_session_students', array('session_id' => $session_id));
                // $teachers =
                // foreach ($teachers as $teacher) {

                $inserted = array('session_id' => $session_id);
                foreach ($this->input->post('students') as $student) {
                    $inserted['student_id'] = $student;
                    $inserted['created_at'] = date('Y-m-d H:i:s');
                    $this->db->insert('quraan_session_students', $inserted);
                }
                // }

                $this->session->set_flashdata('msg', 'تم اضافة الطلاب بفضل الله!');
                redirect(base_url('/quraan/sessions/show_session/' . $session_id));
            }
        }
        if (!$add) {

            // $data['cats_select'] = $this->db->get()->result_array();

            $data['title'] = $this->lang->line('add_students');

            $data['thispage'] = $this->thispage;

            $this->db->select('id,username');
            $data['students'] = $this->db->get_where('bills_user')->result();

            $data['session_students'] = $this->Sessions_model->get_session_students($session_id);

            $this->load->view('site/' . $this->thispage . '/add_students', $data);
        }
    }

    public function add($cats = 1) {
        if (!get_ap('qs_add', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        $this->cats = $cats;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');
            $this->form_validation->set_rules('teachers[]', $this->lang->line('teacher'), 'trim|required');

            // $this->form_validation->set_rules('comment', '', 'trim|required');
            // $this->form_validation->set_rules('comm', '', 'trim|required');
            //
            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {
                $add = TRUE;
                // $teachers =
                // foreach ($teachers as $teacher) {
                $this->db->insert('quraan_sessions', array(
                    'title' => $this->input->post('title')
                ));
                $inserted_id = $this->db->insert_id();
                $inserted = array('session_id' => $inserted_id);
                foreach ($this->input->post('teachers') as $teacher) {
                    $inserted['teacher_id'] = $teacher;
                    $this->db->insert('quraan_session_teachers', $inserted);
                }
                // }

                $this->session->set_flashdata('msg', 'تم اضافة الحلقة بفضل الله!');
                redirect(base_url('quraan/sessions/index/'));
            }
        }
        if (!$add) {

            // $data['cats_select'] = $this->db->get()->result_array();

            $data['title'] = $this->lang->line('add-a-session');

            $data['thispage'] = $this->thispage;

            $data['teachers'] = $this->db->get_where('teachers')->result();
            $data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/' . $this->thispage . '/add', $data);
        }
    }

    public function edit($session_id) {
        if (!get_ap('qs_edit', $this->operator_id)) {
            redirect("", "refresh");
        }
        $add = FALSE;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');
            $this->form_validation->set_rules('teachers[]', $this->lang->line('teacher'), 'trim|required');

            // $this->form_validation->set_rules('comment', '', 'trim|required');
            // $this->form_validation->set_rules('comm', '', 'trim|required');
            //
            if ($this->form_validation->run() === FALSE) {

                $add = FALSE;
            } else {
                $add = TRUE;
                // $teachers =
                // foreach ($teachers as $teacher) {
                $this->db->update('quraan_sessions', array(
                    'title' => $this->input->post('title')
                        ), array('id' => $session_id));

                $this->db->delete('quraan_session_teachers', array('session_id' => $session_id));
                $inserted = array('session_id' => $session_id);
                foreach ($this->input->post('teachers') as $teacher) {
                    $inserted['teacher_id'] = $teacher;
                    $this->db->insert('quraan_session_teachers', $inserted);
                }
                // }

                $this->session->set_flashdata('msg', 'تم تعديل الحلقة بفضل الله!');
                redirect(base_url('quraan/sessions/index/'));
            }
        }
        if (!$add) {

            // $data['cats_select'] = $this->db->get()->result_array();

            $data['title'] = $this->lang->line('edit');

            $data['thispage'] = $this->thispage;

            $data['teachers'] = $this->db->get_where('teachers')->result();
            $data['session_teachers'] = $this->Sessions_model->get_session_teachers($session_id);
            $data['session'] = $this->db->get_where('quraan_sessions', array('id' => $session_id))->row();
            if (!$data['session']) {
                $this->session->set_flashdata('error', 'لم يتم العثور على الحلقة');
                redirect(base_url('quraan/sessions'));
            }
            $data['session_id'] = $session_id;
            $data['view'] = '../controllers/views/' . $this->thispage . '/add';
            $this->load->view('site/' . $this->thispage . '/edit', $data);
        }
    }

    public function del($id) {
        if (!get_ap('qs_del', $this->operator_id)) {
            redirect("", "refresh");
        }

        $this->db->delete('quran_tsme3', array('product_id' => $id));
        $this->db->delete('quraan_session_teachers', array('session_id' => $id));
        $this->db->delete('quraan_session_students', array('session_id' => $id));
        $this->db->delete('quraan_sessions', array('id' => $id));
        if (count($result) > 0) {
            $this->session->set_flashdata('msg', 'تم حذف  الحلقة بفضل الله!');
            redirect(base_url('quraan/sessions/index/'));
        }
    }

    public function show_session($product_id) {
        if (!get_ap('qs_show', $this->operator_id)) {
            redirect("", "refresh");
        }
        //  $this->db->select('id');
//        $orders = $this->db->get_where('quraan_sessions', array(
//                    'id' => $product_id
//                ))->result();
        $join_con = '';
        if ($this->input->post('start_expiry_summary')) {
            $date_arr = explode(' - ', $this->input->post('start_expiry_summary'));
            $from = date('Y-m-d', strtotime($date_arr[0]));
            $to = date('Y-m-d', strtotime($date_arr[1]));
            $join_con = 'AND date(quran_tsme3.timestamp) >= "' . $from . '" AND date(quran_tsme3.timestamp) <= "' . $to . '"';
        }

        //$data['students'] = array();
//        foreach ($orders as $order) {
        $this->db->select('bills_user.username as student_name,
                bills_user.nationality,bills_user.phone,bills_user.id,count(distinct date(quran_tsme3.timestamp)) as attend_days');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 0 THEN quran_tsme3.pages_count ELSE 0 END) AS hfz');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 1 THEN quran_tsme3.pages_count ELSE 0 END) AS mrg3a');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 2 THEN quran_tsme3.pages_count ELSE 0 END) AS srd');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 3 THEN quran_tsme3.pages_count ELSE 0 END) AS tlawa');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 4 THEN quran_tsme3.pages_count ELSE 0 END) AS tlken');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 5 THEN quran_tsme3.pages_count ELSE 0 END) AS test');
        $this->db->join('bills_user', 'bills_user.id = quraan_session_students.student_id');
        $this->db->join('quran_tsme3', 'quran_tsme3.product_id = ' . $product_id . ' and quran_tsme3.student=quraan_session_students.student_id ' . $join_con, 'left');
        $this->db->group_by('quraan_session_students.student_id');
        $data['students'] = $this->db->get_where('quraan_session_students', array(
                    'quraan_session_students.session_id' => $product_id
                ))->result_array();
//        }
        //////////////////////////////////////////////////////////// Expired tab
//        $this->db->select('id');
//        $this->db->where('not (bills_orders.start_date <=', '"' . date('Y-m-d') . '"', FALSE);
//        $this->db->where('bills_orders.expiry_date >=', '"' . date('Y-m-d') . '")', FALSE);
//        $this->db->group_by('id_user');
//        $orders = $this->db->get_where('bills_orders', array(
//                    'bills_orders.id_producer' => $product_id
//                ))->result();
//
//        foreach ($orders as $order) {
//            $this->db->select('bills_orders.id_user,bills_user.username as student_name,bills_orders.start_date,bills_orders.expiry_date,
//                bills_user.nationality,bills_user.phone,bills_user.id');
//            $this->db->select('SUM(CASE WHEN quran_tsme3.type = 0 THEN quran_tsme3.pages_count ELSE 0 END) AS hfz');
//            $this->db->select('SUM(CASE WHEN quran_tsme3.type = 1 THEN quran_tsme3.pages_count ELSE 0 END) AS mrg3a');
//            $this->db->select('SUM(CASE WHEN quran_tsme3.type = 2 THEN quran_tsme3.pages_count ELSE 0 END) AS srd');
//            $this->db->select('SUM(CASE WHEN quran_tsme3.type = 3 THEN quran_tsme3.pages_count ELSE 0 END) AS tlawa');
//            $this->db->select('SUM(CASE WHEN quran_tsme3.type = 4 THEN quran_tsme3.pages_count ELSE 0 END) AS tlken');
//            $this->db->join('bills_user', 'bills_user.id = bills_orders.id_user');
//            $this->db->join('quran_tsme3', 'quran_tsme3.product_id = bills_orders.id_producer and bills_orders.id_user = quran_tsme3.student', 'left');
//            $this->db->group_by('bills_orders.id_user,quran_tsme3.student');
//
//            $data['expired_students'][] = $this->db->get_where('bills_orders', array(
//                        'bills_orders.id' => $order->id
//                    ))->row_array();
//        }
        // print_R($data['expired_students']);die;
        // ///////////////////////////////////////////////////////// attendance tab
        if ($this->input->post('form_2_submit')) {

            if (!empty($this->input->post('username'))) {
                $this->db->where_in('bills_user.username', $this->input->post('username'));
            }
            if (!empty($this->input->post('attend_status'))) {
                $attend_arr = array();
                $attend_status_arr = array(
                    $this->lang->line('absent'),
                    $this->lang->line('present'),
                    $this->lang->line('late')
                );
                foreach ($this->input->post('attend_status') as $attend_s) {
                    $index = array_search($attend_s, $attend_status_arr);
                    if ($index !== FALSE) {
                        $attend_arr[] = $index;
                    }
                }
                if (!empty($attend_arr)) {
                    $this->db->where_in('gyab.present', $attend_arr);
                }
            }
            $data['active_3'] = true;
        }
        $this->db->select('gyab.user_id,bills_user.username,count(gyab.sno) as total_days');
        $this->db->select('SUM(CASE WHEN gyab.present = 1 THEN 1 ELSE 0 END) AS present');
        $this->db->select('SUM(CASE WHEN gyab.present = 0 THEN 1 ELSE 0 END) AS absent');
        $this->db->select('SUM(CASE WHEN gyab.present = 2 THEN 1 ELSE 0 END) AS late');
        $this->db->group_by('gyab.user_id,bills_user.username');
        $this->db->join('bills_user', 'bills_user.id=gyab.user_id');
        $this->db->join('bills_orders', 'bills_orders.id_producer=' . $product_id . ' and bills_orders.id_user = gyab.user_id AND bills_orders.start_date <= "' . date('Y-m-d') . '" AND bills_orders.expiry_date >= "' . date('Y-m-d') . '"');
        $query = $this->db->get_where('gyab', array(
            'gyab.product_id' => $product_id
        ));
        $data['attendance'] = $query->result();

        // /////////////////////////////////////////////////////// inbox messages

        $this->db->select('announcement.*,bills_producer.name as product_name');
        $this->db->join('bills_producer', 'bills_producer.id=announcement.product_id');
        $this->db->order_by('announcement.date_added', 'DESC');
        $this->db->where('product_id', $product_id);
        $data['announcments'] = $this->db->get_where('announcement', array(
                    'announcement.start_date <=' => date('Y-m-d'),
                    'announcement.end_date >=' => date('Y-m-d'),
                    'students!=' => ''
                ))->result();

        ////////////////////////////////////////////////////////////records

        $this->db->select('bills_user.username as student_name,bills_user.id');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 0 THEN quran_tsme3.pages_count ELSE 0 END) AS hfz');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 1 THEN quran_tsme3.pages_count ELSE 0 END) AS mrg3a');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 2 THEN quran_tsme3.pages_count ELSE 0 END) AS srd');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 3 THEN quran_tsme3.pages_count ELSE 0 END) AS tlawa');
        $this->db->select('SUM(CASE WHEN quran_tsme3.type = 4 THEN quran_tsme3.pages_count ELSE 0 END) AS tlken');
        $this->db->group_by('bills_user.id,bills_user.username');
        $this->db->join('bills_user', 'bills_user.id = bills_orders.id_user');
        $this->db->join('quran_tsme3', 'quran_tsme3.product_id = bills_orders.id_producer');
        $data['students_records'] = $this->db->get_where('bills_orders', array(
                    'bills_orders.id_producer' => $product_id,
                    'bills_orders.start_date <=' => date('Y-m-d'),
                    'bills_orders.expiry_date >=' => date('Y-m-d')
                ))->result_array();

        ////////////////////////////////////////////////////////////////
        $data['thispage'] = $this->thispage;
        $data['title'] = $this->lang->line('quraan_session');
        $data['product_id'] = $product_id;
        $this->load->view('site/' . $this->thispage . '/session', $data);
    }

    function add_recite($product_id) {
        if (!get_ap('session_add_recite', $this->operator_id)) {
            redirect("", "refresh");
        }
        //print_R($this->input->post());die;
        $add = true;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('students[]', $this->lang->line('students'), 'trim|required');
            $this->form_validation->set_rules('recite_type[]', $this->lang->line('recite_type'), 'trim|required');
            $this->form_validation->set_rules('from_surah[]', $this->lang->line('from_surah'), 'trim|required');
            $this->form_validation->set_rules('to_surah[]', $this->lang->line('to_surah'), 'trim|required');
            $this->form_validation->set_rules('from_ayah[]', $this->lang->line('from_ayah'), 'trim|required');
            $this->form_validation->set_rules('to_ayah[]', $this->lang->line('to_ayah'), 'trim|required');
            $this->form_validation->set_rules('mark[]', $this->lang->line('evaluation'), 'trim|required');




            if ($this->form_validation->run() !== FALSE && $add) {

                $students = $this->input->post('students');

                for ($i = 0; $i < count($this->input->post('recite_type')); $i++) {
                    if ($this->input->post('from_surah') != '' && $this->input->post('from_ayah') != '' && $this->input->post('to_surah') != '' && $this->input->post('to_ayah') != '') {
//                $page_from = $this->call_curl($this->input->post('from_surah'), $this->input->post('from_ayah'));
//                $page_to = $this->call_curl($this->input->post('to_surah'), $this->input->post('to_ayah'));
//                if (!is_numeric($page_from) || !is_numeric($page_to)) {
//                    $add = FALSE;
//                }
                        $line_count = $this->get_line_count($this->input->post('from_surah')[$i], $this->input->post('from_ayah')[$i], $this->input->post('to_surah')[$i], $this->input->post('to_ayah')[$i]);
                        if (!$line_count) {
                            $add = FALSE;
                            break;
                        }
                    }
                    $inserted_data = array(
                        'type' => $this->input->post('recite_type')[$i],
                        'from_surah' => $this->input->post('from_surah')[$i],
                        'to_surah' => $this->input->post('to_surah')[$i],
                        'from_ayah' => $this->input->post('from_ayah')[$i],
                        'to_ayah' => $this->input->post('to_ayah')[$i],
                        'evaluation' => $this->input->post('mark')[$i],
                        'product_id' => $product_id,
                        'pages_count' => round($line_count / 15, 2),
                        'lines_count' => $line_count,
                        'notes' => $this->input->post('notes')[$i]
                    );
                    foreach ($students as $student) {
                        $student_id = $this->db->get_where('bills_user', array('username' => $student))->row()->id;
                        $inserted_data['student'] = $student_id;
                        $this->db->insert('quran_tsme3', $inserted_data);
                    }
                }
                if ($add) {
                    $this->session->set_flashdata('msg', 1);
                    redirect(base_url('quraan/sessions/show_session/' . $product_id));
                }
            }
        }

        $data['students'] = $this->Sessions_model->get_session_students_with_name($product_id);

        $this->db->select('id,arabic');
        $data['surahs'] = $this->db->get('quran_surah')->result();

        $data['thispage'] = $this->thispage;
        $data['title'] = $this->lang->line('add-a-recite');
        $data['product_id'] = $product_id;
        if (!$add) {
            //$data['msg'] = !is_numeric($page_from) ? $page_from : $page_to;
            if (!$line_count) {
                $data['msg'] = $this->lang->line('make_sure_ayah_surah');
            }
        }
        $this->load->view('site/' . $this->thispage . '/add_recite', $data);
    }

    function show_detailed_recite($product_id, $student_id) {
        $data['student_name'] = $this->db->get_where('bills_user', array('id' => $student_id))->row()->username;
        $data['product_name'] = $this->db->get_where('quraan_sessions', array('id' => $product_id))->row()->title;

        $this->db->select('q1.arabic as from_s,q2.arabic as to_s,quran_tsme3.*');
        $this->db->join('quran_surah q2', 'q2.id =  quran_tsme3.to_surah');
        $this->db->join('quran_surah q1', 'q1.id =  quran_tsme3.from_surah');
        if ($this->input->post()) {
            if ($this->input->post('start_expiry')) {
                $date_arr = explode(' - ', $this->input->post('start_expiry'));
                $from = date('Y-m-d', strtotime($date_arr[0]));
                $to = date('Y-m-d', strtotime($date_arr[1]));
                $this->db->where(array(
                    'quran_tsme3.timestamp >=' => $from,
                    'quran_tsme3.timestamp <=' => $to
                ));
            }
        }
        $data['details'] = $this->db->get_where('quran_tsme3', array('product_id' => $product_id, 'student' => $student_id))->result_array();
        $data['thispage'] = $this->thispage;
        $data['title'] = $this->lang->line('quraan_session');
        $this->load->view('site/' . $this->thispage . '/detailed_recite', $data);
    }

    function call_curl($surah, $ayah) {
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_URL, "https://api.quran.sutanlab.id/surah/" . $surah . "/" . $ayah);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HEADER, 0);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            return "cURL Error #:" . $err;
        } else {
            $res = json_decode($response);
            return $res->data->meta->page;
        }
    }

    function get_line_count($from_surah, $from_ayah, $to_surah, $to_ayah) {
        $this->db->select('id');
        $from_row = $this->db->get_where('quran_ayah', array('surah_id' => $from_surah, 'ayah_num' => $from_ayah))->row();
        $this->db->select('id');
        $to_row = $this->db->get_where('quran_ayah', array('surah_id' => $to_surah, 'ayah_num' => $to_ayah))->row();
        if (!$from_row || !$to_row) {
            return FALSE;
        }
        $lines_count = 0;
        for ($i = $from_row->id; $i <= $to_row->id; $i++) {
            $row = $this->db->get_where('quran_ayah', array('id' => $i))->row();
            if (!$row) {
                return FALSE;
            }
            $lines_count += $row->ayah_percentage;
        }
        return $lines_count;
    }

    function get_to_surah_ayah($from_surah, $from_ayah, $lines_count_target) {
        $this->db->select('id,ayah_percentage,surah_id,ayah_num');
        $from_row = $this->db->get_where('quran_ayah', array('surah_id' => $from_surah, 'ayah_num' => $from_ayah))->row();

        $lines_count = $from_row->ayah_percentage;
        while ($lines_count < $lines_count_target) {
            $this->db->select('id,ayah_percentage,surah_id,ayah_num');
            $from_row = $this->db->get_where('quran_ayah', array('id' => $from_row->id + 1))->row();
            if (!$from_row) {
                return FALSE;
            }
            $lines_count += $from_row->ayah_percentage;
        }
        return array($from_row->surah_id, $from_row->ayah_num);
    }

    function del_student($product_id, $student_id) {
        if (!get_ap('session_delete_student', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->db->delete('quraan_session_students', array('session_id' => $product_id, 'student_id' => $student_id));
        $this->session->set_flashdata('msg', $this->lang->line('op_success'));
        redirect(base_url('quraan/sessions/show_session/' . $product_id));
    }

    function show_session_attendance($product_id, $student_id) {
        if (!get_ap('session_summary', $this->operator_id)) {
            redirect("", "refresh");
        }
        $data['student_name'] = $this->db->get_where('bills_user', array('id' => $student_id))->row()->username;
        $data['product_name'] = $this->db->get_where('quraan_sessions', array('id' => $product_id))->row()->title;

        if ($this->input->post('start_expiry')) {
            $date_arr = explode(' - ', $this->input->post('start_expiry'));
            $from = date('Y-m-d', strtotime($date_arr[0]));
            $to = date('Y-m-d', strtotime($date_arr[1]));
            $this->db->where('date(timestamp)>=', $from);
            $this->db->where('date(timestamp)<=', $to);
        }

        $this->db->select('distinct(date(timestamp)) as day');
        $data['attend'] = $this->db->get_where('quran_tsme3', array('product_id' => $product_id, 'student' => $student_id))->result_array();
        $data['thispage'] = $this->thispage;
        $data['title'] = $this->lang->line('attendance');
        $this->load->view('site/' . $this->thispage . '/detailed_attendance', $data);
    }

    public function plans($session_id, $student_id = 0) {
        if (!get_ap('sessions_plans', $this->operator_id)) {
            redirect("", "refresh");
        }
        $data['session_name'] = $this->Sessions_model->get_session_name($session_id);
        if (!$data['session_name']) {
            $this->session->set_userdata('error', $this->lang->line('data_not_found'));
            redirect("quraan/sessions", "refresh");
        }
        $data['plans'] = $this->Sessions_model->get_sessions_plans($session_id, $student_id);
        $data['session_id'] = $session_id;
        $data['title'] = $this->lang->line('sessions_plans');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/sessions_plans/all', $data);
    }

    public function add_session_plans($session_id) {
        if (!get_ap('qs_plans_add', $this->operator_id)) {
            redirect("", "refresh");
        }

        $add = true;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('students[]', $this->lang->line('students'), 'trim|required');
            $this->form_validation->set_rules('recite_type[]', $this->lang->line('recite_type'), 'trim|required');

            $this->form_validation->set_rules('date_from[]', $this->lang->line('start-date'), 'trim|required');
            $this->form_validation->set_rules('date_to[]', $this->lang->line('end-date'), 'trim|required');
            $this->form_validation->set_rules('from_surah[]', $this->lang->line('from_surah'), 'trim|required');
            $this->form_validation->set_rules('from_ayah[]', $this->lang->line('from_ayah'), 'trim|required');

            $this->form_validation->set_rules('sessions_count_per_week[]', $this->lang->line('sessions_count_per_week'), 'trim|required');
            $this->form_validation->set_rules('lines_count_per_session[]', $this->lang->line('lines_count_per_session'), 'trim|required');


            if ($this->form_validation->run() !== FALSE && $add) {

                $students = $this->input->post('students');

                for ($i = 0; $i < count($this->input->post('recite_type')); $i++) {

                    $weeks_count = $this->Sessions_model->get_weeks_count($this->input->post('date_from')[$i], $this->input->post('date_to')[$i]);
                    $sessions_count = floor($this->input->post('sessions_count_per_week')[$i] * $weeks_count);
                    $lines_count = $this->input->post('lines_count_per_session')[$i] * $sessions_count;

                    $to_surah_ayah = $this->get_to_surah_ayah($this->input->post('from_surah')[$i], $this->input->post('from_ayah')[$i], $lines_count);
                    if (!$to_surah_ayah) {
                        $add = FALSE;
                        break;
                    }

                    $inserted_data = array(
                        'type' => $this->input->post('recite_type')[$i],
                        'date_from' => $this->input->post('date_from')[$i],
                        'date_to' => $this->input->post('date_to')[$i],
                        'from_surah' => $this->input->post('from_surah')[$i],
                        'from_ayah' => $this->input->post('from_ayah')[$i],
                        'sessions_count_per_week' => $this->input->post('sessions_count_per_week')[$i],
                        'lines_count_per_session' => $this->input->post('lines_count_per_session')[$i],
                        'to_surah' => $to_surah_ayah[0],
                        'to_ayah' => $to_surah_ayah[1],
                        'sessions_count' => $sessions_count,
                        'expected_lines_count' => $lines_count,
                        'expected_page_count' => round(($lines_count / 15), 2)
                    );
                    foreach ($students as $student) {
                        $quraan_session_students_id = $this->db->get_where('quraan_session_students', array('student_id' => $student, 'session_id' => $session_id))->row()->id;
                        $inserted_data['quraan_session_students_id'] = $quraan_session_students_id;
                        $this->db->insert('quraan_sessions_plans', $inserted_data);
                    }
                }
                if ($add) {
                    $this->session->set_flashdata('msg', 1);
                    redirect(base_url('quraan/sessions/plans/' . $session_id));
                }
            }
        }
        if (!$add) {
            if (!$to_surah_ayah) {
                $data['msg'] = $this->lang->line('reach_end_quraan');
            }
        }

        $this->db->select('id,arabic');
        $data['surahs'] = $this->db->get('quran_surah')->result();
        $data['students'] = $this->Sessions_model->get_session_students_with_name($session_id);
        $data['title'] = $this->lang->line('add-a-plan');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/sessions_plans/add_plan', $data);
    }

    function edit_session_plan($plan_id, $session_id) {
        if (!get_ap('qs_plans_edit', $this->operator_id)) {
            redirect("", "refresh");
        }

        $add = true;
        if ($this->input->post('submit')) {
            $this->form_validation->set_rules('recite_type', $this->lang->line('recite_type'), 'trim|required');

            $this->form_validation->set_rules('date_from', $this->lang->line('start-date'), 'trim|required');
            $this->form_validation->set_rules('date_to', $this->lang->line('end-date'), 'trim|required');
            $this->form_validation->set_rules('from_surah', $this->lang->line('from_surah'), 'trim|required');
            $this->form_validation->set_rules('from_ayah', $this->lang->line('from_ayah'), 'trim|required');

            $this->form_validation->set_rules('sessions_count_per_week', $this->lang->line('sessions_count_per_week'), 'trim|required');
            $this->form_validation->set_rules('lines_count_per_session', $this->lang->line('lines_count_per_session'), 'trim|required');


            if ($this->form_validation->run() !== FALSE && $add) {

                $weeks_count = $this->Sessions_model->get_weeks_count($this->input->post('date_from'), $this->input->post('date_to'));
                $sessions_count = floor($this->input->post('sessions_count_per_week') * $weeks_count);
                $lines_count = $this->input->post('lines_count_per_session') * $sessions_count;

                $to_surah_ayah = $this->get_to_surah_ayah($this->input->post('from_surah'), $this->input->post('from_ayah'), $lines_count);
                if (!$to_surah_ayah) {
                    $add = FALSE;
                }
                if ($add) {
                    $inserted_data = array(
                        'type' => $this->input->post('recite_type'),
                        'date_from' => $this->input->post('date_from'),
                        'date_to' => $this->input->post('date_to'),
                        'from_surah' => $this->input->post('from_surah'),
                        'from_ayah' => $this->input->post('from_ayah'),
                        'sessions_count_per_week' => $this->input->post('sessions_count_per_week'),
                        'lines_count_per_session' => $this->input->post('lines_count_per_session'),
                        'to_surah' => $to_surah_ayah[0],
                        'to_ayah' => $to_surah_ayah[1],
                        'sessions_count' => $sessions_count,
                        'expected_lines_count' => $lines_count,
                        'expected_page_count' => round(($lines_count / 15), 2)
                    );

                    $this->db->update('quraan_sessions_plans', $inserted_data, array('id' => $plan_id));


                    $this->session->set_flashdata('msg', 1);
                    redirect(base_url('quraan/sessions/plans/' . $session_id));
                }
            }
        }
        if (!$add) {
            if (!$to_surah_ayah) {
                $data['msg'] = $this->lang->line('reach_end_quraan');
            }
        }

        $this->db->select('id,arabic');
        $data['surahs'] = $this->db->get('quran_surah')->result();
        $data['plan'] = $this->Sessions_model->get_plan($plan_id);
        if (!$data['plan']) {
            $this->session->set_userdata('error', $this->lang->line('data_not_found'));
            redirect("quraan/sessions", "refresh");
        }
        $data['title'] = $this->lang->line('edit-a-plan');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/sessions_plans/edit_plan', $data);
    }

    function delete_session_plan($plan_id, $session_id) {
        if (!get_ap('qs_plans_del', $this->operator_id)) {
            redirect("", "refresh");
        }

        $this->db->delete('quraan_sessions_plans', array('id' => $plan_id));
        $this->session->set_flashdata('msg', 1);
        redirect(base_url('quraan/sessions/plans/' . $session_id));
    }

    function view_session_plan($plan_id) {
        if (!get_ap('sessions_plans', $this->operator_id)) {
            redirect("", "refresh");
        }
        $data['plan'] = $this->Sessions_model->get_plan_with_student_name($plan_id);
        if (!$data['plan']) {
            $this->session->set_userdata('error', $this->lang->line('data_not_found'));
            redirect("quraan/sessions", "refresh");
        }

        $data['title'] = $this->lang->line('plan');
        $data['thispage'] = $this->thispage;
        $this->load->view('site/sessions_plans/view_plan', $data);
    }

    

}
