<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

    public $thispage, $operator_id;

    public function __construct() {
        parent::__construct();
        if (!get_system_status()) {
            echo $this->load->view('site/system_off', '', TRUE);
            die();
        }
        if (!get_license_per('points')) {
            redirect("", "refresh");
        }
        set_system_timezone();
        $this->operator_id = $this->session->userdata("operator_id");
        $this->load->model("points/User_Model");
        $this->load->helper('security');
        $this->thispage = "students";
        if (!$this->session->userdata('is_student_login')) {
            redirect(base_url("auth/student_login"));
        }
    }

    public function award() {
        if (!($this->session->userdata('student_id')))
            redirect("", "refresh");
        $data['title'] = $this->lang->line('awards_p');
        $data['result'] = $this->User_Model->get_profile($this->session->userdata('student_id'));
        $data['award'] = $this->User_Model->get_award_history($this->session->userdata('student_id'));
        $data['thispage'] = $this->thispage;
        $this->db->select('bills_user.*,user_image.image');
        $this->db->join('user_image', 'user_image.user_id=bills_user.id and user_image.profile_pic = 1', 'left');
        $data['one'] = $this->db->get_where('bills_user', array('id' => $this->session->userdata('student_id')))->row();
        $data['active'] = 'award';
        $this->load->view('site/' . $this->thispage . '/award', $data);
    }

    public function award_request() {

        if (!($this->session->userdata('student_id')))
            redirect("", "refresh");
        if ($this->input->server("REQUEST_METHOD") == "POST") {

            $data['user_id'] = $this->session->userdata('student_id');
            $award_id = $this->input->post('award_id');
            $award = $this->db->where('id', $award_id)->get('pts_award')->row();
            $award_point = $award->award_point;
            $result = $this->User_Model->get_profile($this->session->userdata('student_id'));
            // pr($award_point); pr($result->total_balance);

            if ($result->total_balance >= $award_point) {
                $data = $this->input->post();

                $award_data = array();
                $award_data['user_id'] = $this->session->userdata('student_id');
                $award_data['award_id'] = $award_id;
                $award_data['award_history_point'] = $award_point;
                $award_data['memo'] = $data['memo'];
                $award_data['award_status'] = 0;
                $this->db->insert('pts_award_history', $award_data);

                $this->session->set_flashdata('message', 'Successfully Updated');
                redirect('points/user/award', 'refresh');
            } else {
                $this->session->set_flashdata('error', 'Sorry you don not have enough point');
                redirect('points/user/award', 'refresh');
            }
        }
        $data['title'] = $this->lang->line('award');
        $data['result'] = $this->User_Model->get_profile($this->session->userdata('student_id'));
        $data['award'] = $this->db->where('award_status', 1)->get('pts_award')->result();
        $data['thispage'] = $this->thispage;
        $this->db->select('bills_user.*,user_image.image');
        $this->db->join('user_image', 'user_image.user_id=bills_user.id and user_image.profile_pic = 1', 'left');
        $data['one'] = $this->db->get_where('bills_user', array('id' => $this->session->userdata('student_id')))->row();
        $data['active'] = 'award';
        $this->load->view('site/' . $this->thispage . '/award_request', $data);
    }

    public function points($code = "") {
        $id = $this->session->userdata('student_id');
        if (!($id)) {
            $this->session->set_flashdata('message', "Please Login");
            redirect(base_url("auth/student_login"), "refresh");
        }
        if ($code == "") {
            $this->session->set_flashdata('message', "Invalid Code");
            redirect("", "refresh");
        }


        $points = $this->User_Model->get_points($code);
        if ($points) {
            if ($points->barcode_status == 0) {

                $this->db->set('total_points', 'total_points+' . $points->student_point, FALSE);
                $this->db->set('total_balance', 'total_balance+' . $points->student_point, FALSE);
                $this->db->where('id', $id);
                $this->db->update('bills_user');

                $this->db->set('barcode_status', 1);
                $this->db->set('student_id', $id);
                $this->db->set('credit_date', date("Y-m-d"));
                $this->db->where('id', $points->id);
                $this->db->update('pts_barcode');

                $data = array(
                    'type' => 1,
                    'balance' => $points->student_point,
                    'points' => $points->student_point,
                    'stud_id' => $id,
                    'barcode_id' => $points->id,
                    'category' => $points->category_id,
                    'notes' => $points->notes_id,
                    'member_id' => $points->member_id,
                );
                $this->db->insert('pts_student_history', $data);

                $this->session->set_flashdata('message', "Points Added Successfully");
            } else {
                $this->session->set_flashdata('message', "Already Used");
            }
        } else {
            $this->session->set_flashdata('message', "Invalid code");
        }
        redirect("points/user/award", "refresh");
    }

}
