<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//error_reporting('E_ALL ^ E_NOTICE'); 
class Tag extends MY_Controller {

    public function __construct() {
        parent::__construct();
        if (!get_license_per('points')) {
            redirect("", "refresh");
        }
        $this->operator_id = $this->session->userdata("operator_id");
        if (!get_ap('points_module', $this->operator_id)) {
            redirect("", "refresh");
        }
        //if(get_ap('task_tag',$this->operator_id) ==1) { } else { redirect("","refresh");}
        $this->load->model("points/Tag_Model");
    }

    function index($type = "") {
        $data['title'] = $this->lang->line('tags');
        $data['results'] = $this->Tag_Model->get_tag($type);
        /* echo $this->db->last_query();
          pr($data['results']);
          die; */
        $this->load->view("points/tag/index", $data);
    }

    function get_list($search = "") {
        $data['results'] = $this->Tag_Model->get_tag($search);
        echo json_encode($data);
    }

    function create_tag() {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('tag_name', 'Tag Name', 'required|trim|is_unique[tags.tag_name]');
            if ($this->form_validation->run() == TRUE) {
                $data = $this->input->post();

                $insert_id = $this->Tag_Model->save($data);
                echo json_encode(array('tag_id' => $insert_id, 'status' => 1));
            } else {
                echo json_encode(array('status' => 0, 'error' => "Already Exits"));
            }
        }
    }

    function create() {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('tag_name', 'Tag Name', 'required|trim|is_unique[pts_tags.tag_name]');
            if ($this->form_validation->run() == TRUE) {
                $data = $this->input->post();

                $insert_id = $this->Tag_Model->save($data);
                /* pr($data);
                  die; */
                $this->session->set_flashdata('message', 'Successfully Created');
                redirect('points/tag', 'refresh');
            }
        }
        $data['title'] = $this->lang->line("add_tag");
        $this->load->view("points/tag/create", $data);
    }

    function edit($id) {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            $this->Tag_Model->update($id, $data);
            $this->session->set_flashdata('message', 'Successfully Saved');
            redirect('points/tag', 'refresh');
        }
        $data['title'] = $this->lang->line('edit_tag');
        $data['result'] = $this->Tag_Model->get_tag_id($id);
        //pr($data);
        $this->load->view("points/tag/edit", $data);
    }

    function delete($id) {
        $this->Tag_Model->delete($id);
        $this->session->set_flashdata('message', 'Successfully Deleted');
        redirect('points/tag', 'refresh');
    }

    function import($type = "") {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $import = $_FILES["import"]["name"];

            if ($import) {
                // print_r($_FILES); die;
                $filename = $_FILES["import"]["name"];
                $filetemp = $_FILES["import"]["tmp_name"];
                $ext = substr($filename, strrpos($filename, "."), (strlen($filename) - strrpos($filename, ".")));

                //we check,file must be have csv extention
                if ($ext == ".csv") {
                    $file = fopen($filetemp, "r");
                    // pr(fgetcsv($file, 10000000, ","));
                    while (($getData = fgetcsv($file, 10000000, ",")) !== FALSE) {

                        $user_type = $getData[0] == "student" ? 1 : 2;
                        if ($getData[1] != "") {
                            $arr = array(
                                'user_type' => $user_type,
                                'tag_name' => $getData[1],
                            );
                            $this->db->insert("tags", $arr);
                        }
                    }
                    fclose($file);
                    $this->session->set_flashdata('message', "CSV File has been successfully Imported.");
                    die;
                    redirect("admin/tag");
                } else {
                    echo "Error: Please Upload only CSV File";
                }
            }
            die;
        }
        $data['title'] = "Import Tag";
        $this->load->view("admin/tag/import", $data);
    }

}
