<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//error_reporting('E_ALL ^ E_NOTICE');
class Student extends MY_Controller {

    var $operator_id;

    public function __construct() {
        parent::__construct();
        if (!get_license_per('points')) {
            redirect("", "refresh");
        }
        $this->operator_id = $this->session->userdata('operator_id');
        if (empty($this->session->userdata("is_admin_login")) || !get_ap('points_module', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->load->model("points/Student_Model");
        $this->load->helper('security');
    }

    public function index($type = 0) {

        $data['title'] = $this->lang->line("points");
        //$data['results'] = $this->Student_Model->get_student($type);
        $data['type'] = $type;
        $this->load->view("points/student/index", $data);
    }

    public function create() {
        if ($this->input->server("REQUEST_METHOD") == "POST") {

            if ($this->input->server("REQUEST_METHOD") == "POST") {

                $this->load->library('form_validation');
                $this->form_validation->set_rules('email', 'Email', 'trim|xss_clean');
                if ($this->form_validation->run() == TRUE) {

                    $data_code = time() . rand();
                    $data = $this->input->post();
                    $image_name = "";
                    if ($_FILES['photo']['name'] != "") {
                        $name = $_FILES['photo']['name'];
                        $size = $_FILES['photo']['size'];
                        $type = $_FILES['photo']['type'];
                        $temp = $_FILES['photo']['tmp_name'];
                        $ext = explode(".", $name);
                        $image_name = "new-" . date("dmY") . "-" . time() . "." . $ext[1];
                        if (main_premission('storage_file') == 1) {
                            $this->load->library('Dropbox');
                            $drop_path = $this->dropbox->upload("profile_images/" . $image_name, $_FILES['photo']);
                            $image_path = $this->dropbox->get_link($drop_path);
                            $image_name = $image_path;
                        } else {
                            move_uploaded_file($temp, "assets/images/student/" . $image_name);
                            $old_path = "assets/images/student/" . $data['old_photo'];
                            if (file_exists($old_path))
                                unlink($old_path);
                        }
                    }
                    $barcode = 'student-' . $data_code . '.png';
                    $this->load->library('ciqrcode');

                    $params['data'] = base_url('user/login/' . $data_code);
                    $params['level'] = 'H';
                    $params['size'] = 10;
                    $params['savename'] = 'assets/images/student/qrcode/' . $barcode;
                    $this->ciqrcode->generate($params);

                    $data['profile_image'] = $image_name;
                    $data['status'] = 1;
                    $data['student_code'] = $data_code;
                    $data['barcode'] = $barcode;
                    $data['password'] = md5($data['password']);
                    $student_tags = $this->input->post('student_tags');
                    if ($student_tags)
                        $data['student_tags'] = implode(",", $student_tags);
                    $this->Student_Model->save($data);
                    //pr($data);die; 
                    $this->session->set_flashdata('message', 'Successfully Created');
                    redirect('admin/student', 'refresh');
                }
            }
        }
        $data['title'] = $this->lang->line("add_student");
        $data['tags'] = $this->Student_Model->get_tables('tags', array('user_type' => 2));
        $this->load->view("student/create", $data);
    }

    public function edit($id) {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            $change_password = $this->input->post();
            $data_code = time() . rand();
            $image_name = $data['old_photo'];

            if ($_FILES['photo']['name'] != "") {
                $name = $_FILES['photo']['name'];
                $size = $_FILES['photo']['size'];
                $type = $_FILES['photo']['type'];
                $temp = $_FILES['photo']['tmp_name'];
                $ext = explode(".", $name);
                $image_name = "new-" . date("dmY") . "-" . time() . "." . $ext[1];
                if (main_premission('storage_file') == 1) {
                    $this->load->library('Dropbox');
                    $drop_path = $this->dropbox->upload("profile_images/" . $image_name, $_FILES['photo']);
                    $image_path = $this->dropbox->get_link($drop_path);
                    $image_name = $image_path;
                } else {
                    move_uploaded_file($temp, "assets/images/student/" . $image_name);
                    $old_path = "assets/images/student/" . $data['old_photo'];
                    if (file_exists($old_path))
                        unlink($old_path);
                }
            }
            $data['profile_image'] = $image_name;

            unset($data['old_photo']);
            unset($data['password']);
            unset($data['new_password']);
            unset($data['confirm_password']);
            $student_tags = $this->input->post('student_tags');
            if ($student_tags)
                $data['student_tags'] = implode(",", $student_tags);
            $this->Student_Model->update($id, $data);

            if ($change_password['new_password'] != "") {
                if ($change_password['new_password'] == $change_password["confirm_password"]) {
                    $data2 = array("password" => md5($change_password['new_password']));
                    $this->Student_Model->update($id, $data2);
                } else {
                    $this->session->set_flashdata('error', 'New Password and Confirm Password Mismatch');
                    redirect('admin/student', 'refresh');
                }
            }

            //echo $this->db->last_query();die;
            $this->session->set_flashdata('message', 'Successfully Updated');
            redirect('admin/student', 'refresh');
        }
        $data['title'] = $this->lang->line("edit_student");
        $data['result'] = $this->Student_Model->get_student_id($id);
        $data['tags'] = $this->Student_Model->get_tables('tags', array('user_type' => 2));
        $this->load->view("student/edit", $data);
    }

    public function view() {

        $operator_id = $this->session->userdata('admin')['operator_id'];
//        $student_premssion = get_ap('student_tag', $operator_id);
//        $email = $this->session->userdata('admin')['email'];
//        $this->db->where('email', $email);
//        $query = $this->db->get('admin');
//        $profile = $query->row();
//        $student_tags = $profile->student_tags ? $profile->student_tags : 0;
//        if ($student_premssion == 0) {
//            $arr = explode(",", $student_tags);
//            $tags = $arr;
//        }
        $tags = 0;

        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data_submit = $this->input->post('print_profile');
            $archived = $this->input->post('archived');
            $unarchived = $this->input->post('unarchived');
            $add_point = $this->input->post('add_point');
            $discount_point = $this->input->post('discount_point');
            $award_point = $this->input->post('award_point');
            $delete = $this->input->post('delete');
            $export = $this->input->post('export');
            $id = $this->input->post('user');
            //pr($this->input->post());die;
            if ($id == "")
                $id = 0;
            if ($data_submit) {
                $data['results'] = $this->Student_Model->get_student_ids($id);
                $data['title'] = "Student Profile";
                $this->load->view("student/profile", $data);
            }
            if ($archived) {
                $data = array('archive_status' => 1);
                $this->db->where_in('id', $id);
                $this->db->update('student', $data);
                $this->session->set_flashdata('message', 'Archived Successfully Updated');
                redirect("admin/student", "refresh");
            }

            if ($unarchived) {
                $data = array('archive_status' => 0);
                $this->db->where_in('id', $id);
                $this->db->update('student', $data);
                $this->session->set_flashdata('message', 'Unarchived Successfully Updated');
                redirect("admin/student", "refresh");
            }

            if ($delete) {
                $this->db->where_in('id', $id);
                $this->db->delete('student');
                $this->session->set_flashdata('message', 'Delete Successfully Updated');
                redirect("admin/student", "refresh");
            }

            if ($add_point) {

                $this->load->model("points/Barcode_Model");
                $data['category'] = $this->Barcode_Model->get_category('category');
                $data['notes'] = $this->Barcode_Model->get_category('notes');
                $data['title'] = $this->lang->line('add_points');
                $data['members'] = $this->Student_Model->get_tables('user');
                $data['student'] = $this->Student_Model->get_all_student($tags);
//                $ids = array();
//                foreach ($id as $key => $value) {
//                    $ids[$value] = $value;
//                }
//                $data['list'] = $ids;
                $this->load->view("points/student/add_point", $data);
            }

            if ($discount_point) {
                //$data['results'] = $this->Student_Model->get_student_ids($id);
                $this->load->model("points/Barcode_Model");
                $data['discount'] = $this->Barcode_Model->get_category('discount');
                $data['members'] = $this->Student_Model->get_tables('user');
                $data['title'] = "Minus Points";
                $data['student'] = $this->Student_Model->get_all_student($tags);
//                $ids = array();
//                foreach ($id as $key => $value) {
//                    $ids[$value] = $value;
//                }
//                $data['list'] = $ids;
                $this->load->view("points/student/minus_point", $data);
            }

            if ($award_point) {
                //$data['results'] = $this->Student_Model->get_student_ids($id);
                $this->load->model("points/Barcode_Model");
                $data['award'] = $this->Barcode_Model->get_award();
                $data['members'] = $this->Student_Model->get_tables('user');
                $data['title'] = "Award Points";
                $data['student'] = $this->Student_Model->get_all_student($tags);
//                $ids = array();
//                foreach ($id as $key => $value) {
//                    $ids[$value] = $value;
//                }
//                $data['list'] = $ids;
                $this->load->view("points/student/award", $data);
            }


            if ($export) {

                $result = $this->Student_Model->get_student_ids($id);
                if ($result) {
                    $array = array();
                    foreach ($result as $key => $result_value) {
                        $array[] = array(
                            'student_id' => $result_value->student_id,
                            'name' => $result_value->name,
                            'email' => $result_value->email,
                            'mobile' => $result_value->mobile,
                            'password' => $result_value->password,
                            'profile_image' => $result_value->profile_image,
                            'total_points' => $result_value->total_points,
                            'total_balance' => $result_value->total_balance,
                            'barcode' => $result_value->barcode,
                            'student_code' => $result_value->student_code,
                        );
                    }
                }
                export_csv($array, "student");
                die;
            }
        }
    }

    public function add_point($id = "") {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            if ($data['stud_id']) {
                foreach ($data['stud_id'] as $key => $value) {
                    $data['type'] = 1;
                    $data['balance'] = $data['points'];
                    $data['stud_id'] = $value;
                    $this->db->insert('pts_student_history', $data);

                    $this->db->set('total_points', 'total_points+' . $data['points'], FALSE);
                    $this->db->set('total_balance', 'total_balance+' . $data['points'], FALSE);
                    $this->db->where('id', $value);
                    $this->db->update('bills_user');
                    // echo $this->db->last_query();
                }
            }
            //die;
            $this->session->set_flashdata('message', 'Successfully Updated');
            redirect('points/student', 'refresh');
        }
        $data['results'] = $this->Student_Model->get_student_ids($id);
        $this->load->model("points/Barcode_Model");
        $data['category'] = $this->Barcode_Model->get_category('category');
        $data['notes'] = $this->Barcode_Model->get_category('notes');
        $data['title'] = $this->lang->line('add_points');
        $this->load->view("points/student/add_point", $data);
    }

    public function minus_point($id = "") {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            /* pr($data);die; */
            $discount = $this->input->post('discount');
            $this->load->model("points/Category_Model");
            $discount_row = $this->Category_Model->get_category_id($discount);
            /* pr($discount_row);
              die; */
            if ($data['stud_id']) {
                foreach ($data['stud_id'] as $key => $value) {


                    if ($_FILES['upload']['name'] != "") {
                        $name = $_FILES['upload']['name'];
                        $size = $_FILES['upload']['size'];
                        $type = $_FILES['upload']['type'];
                        $temp = $_FILES['upload']['tmp_name'];
                        $ext = explode(".", $name);
                        $image_name = "discount-" . date("dmY") . "-" . time() . "." . $ext[1];

                        move_uploaded_file($temp, "uploads/students/" . $image_name);
                        if (isset($data['old_photo'])) {
                            $old_path = "uploads/students/" . $data['old_photo'];
                            if (file_exists($old_path))
                                unlink($old_path);
                        }
                        $data['upload_filename'] = $image_name;
                    }


                    $data['type'] = 2;
                    $points_for = $discount_row->points_for;
                    $data['balance'] = $discount_row->points;
                    if ($points_for == 2)
                        $data['points'] = $data['balance'];
                    $data['stud_id'] = $value;

                    unset($data['points_for']);
                    $this->db->insert('pts_student_history', $data);

                    if ($points_for == 2) {
                        $this->db->set('total_points', 'total_points-' . $data['balance'], FALSE);
                    }
                    $this->db->set('total_balance', 'total_balance-' . $data['balance'], FALSE);
                    $this->db->where('id', $value);
                    $this->db->update('bills_user');
                }
            }

            $this->session->set_flashdata('message', 'Successfully Updated');
            redirect('points/student', 'refresh');
        }
        $data['results'] = $this->Student_Model->get_student_ids($id);
        $this->load->model("points/Barcode_Model");
        $data['discount'] = $this->Barcode_Model->get_category('discount');
        $data['title'] = $this->lang->line('points_deduct');
        $this->load->view("points/student/minus_point", $data);
    }

    public function award($id = "") {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            /* pr($data);die; */
            $award_id = $this->input->post('award_id');
            $this->load->model("points/Award_Model");
            $award = $this->Award_Model->get_award_id($award_id);
            $award_point = $award->award_point;
            if ($data['stud_id']) {
                foreach ($data['stud_id'] as $key => $value) {


                    $data['type'] = 2;
                    $points_for = $award->award_point_type;
                    $data['balance'] = $award_point;
                    /* pr($award);
                      die; */
                    if ($points_for == 2)
                        $history_data['points'] = $data['balance'];


                    $history_data = array();
                    $history_data['stud_id'] = $value;
                    $history_data['type'] = 2;
                    if ($points_for == 2)
                        $history_data['points'] = $award_point;
                    $history_data['balance'] = $award_point;
                    $history_data['award_id'] = $award_id;
                    $history_data['member_id'] = $data['member_id'];
                    $history_data['memo_notes'] = $data['memo'];
                    $this->db->insert('pts_student_history', $history_data);


                    $award_data = array();
                    $award_data['user_id'] = $value;
                    $award_data['award_id'] = $award_id;
                    $award_data['award_history_point'] = $award_point;
                    $award_data['memo'] = $data['memo'];
                    $award_data['member_id'] = $data['member_id'];
                    $award_data['award_status'] = 1;
                    $this->db->insert('pts_award_history', $award_data);

                    if ($points_for == 2) {
                        $this->db->set('total_points', 'total_points-' . $award_point, FALSE);
                    }
                    $this->db->set('total_balance', 'total_balance-' . $award_point, FALSE);
                    $this->db->where('id', $value);
                    $this->db->update('bills_user');
                }
            }

            $this->session->set_flashdata('message', 'Successfully Updated');
            redirect('points/student', 'refresh');
        }
        $data['results'] = $this->Student_Model->get_student_ids($id);
        $this->load->model("points/Barcode_Model");
        $data['discount'] = $this->Barcode_Model->get_category('discount');
        $data['title'] = $this->lang->line('discount_point');
        $this->load->view("points/student/minus_point", $data);
    }

    function import() {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $import = $_FILES["import"]["name"];
            ;
            if ($import) {
                // print_r($_FILES); die;
                $filename = $_FILES["import"]["name"];
                $filetemp = $_FILES["import"]["tmp_name"];
                $ext = substr($filename, strrpos($filename, "."), (strlen($filename) - strrpos($filename, ".")));

                //we check,file must be have csv extention
                if ($ext == ".csv") {
                    $file = fopen($filetemp, "r");
                    while (($getData = fgetcsv($file, 10000000, ",")) !== FALSE) {

                        $data_code = time() . rand();
                        $barcode = $getData[8];
                        $student_code = $getData[9] ? $getData[9] : time() . rand();

                        if ($barcode == "") {

                            $barcode = 'student-' . $data_code . '.png';
                            $this->load->library('ciqrcode');

                            $params['data'] = base_url('user/login/' . $data_code);
                            $params['level'] = 'H';
                            $params['size'] = 10;
                            $params['savename'] = 'assets/images/student/qrcode/' . $barcode;
                            $this->ciqrcode->generate($params);
                        }
                        $student_tags = "";
                        if ($getData[10]) {
                            $this->db->where('tag_name', $getData[10]);
                            $query = $this->db->get('tags');
                            if ($query->num_rows() > 0) {
                                $student_tags = $query->row()->tag_id;
                            } else {

                                $tags_data = array(
                                    'user_type' => 2,
                                    'tag_name' => $getData[10],
                                );
                                $this->db->insert('tags', $tags_data);
                                $student_tags = $this->db->insert_id();
                            }
                        }

                        //pr($student_tags);die;
                        $arr = array(
                            'student_id' => $getData[0],
                            'name' => $getData[1],
                            'mobile' => $getData[3],
                            'email' => $getData[2],
                            'password' => $getData[4] ? $getData[4] : md5("123"),
                            'profile_image' => $getData[5],
                            'total_points' => $getData[6] ? $getData[6] : 0,
                            'total_balance' => $getData[7] ? $getData[7] : 0,
                            'student_tags' => $student_tags,
                            'barcode' => $barcode,
                            'student_code' => $student_code,
                            'status' => 1,
                            'time' => date("Y-m-d h:i:sa"),
                        );
                        $this->db->insert("student", $arr);
                    }
                    fclose($file);
                    $this->session->set_flashdata('message', "CSV File has been successfully Imported.");
                    redirect("admin/student/import");
                } else {
                    echo "Error: Please Upload only CSV File";
                }
            }
            die;
        }
        $data['title'] = "Import";
        $this->load->view("student/import", $data);
    }

    public function remove_points($id = '', $red = "") {
        $history = $this->Student_Model->get_history_id($id);
        //pr($history);
        if ($history) {
            $user_id = $history->stud_id;
            if ($history->type == 1) {

                if ($history->barcode_id) {
                    $barcode_data = array(
                        'barcode_status' => 0,
                    );
                    $this->db->set('student_id', 'NULL', false);
                    $this->db->where('id', $history->barcode_id);
                    $this->db->update('barcode', $barcode_data);
                    //echo $this->db->last_query();
                }
                if ($history->points) {
                    $this->db->set('total_points', 'total_points-' . $history->points, FALSE);
                }
                if ($history->balance) {
                    $this->db->set('total_balance', 'total_balance-' . $history->balance, FALSE);
                }

                //die;
                $this->db->where('id', $user_id);
                $this->db->update('student');
                $this->db->where('history_id', $history->history_id);
                $this->db->delete('student_history');
            }
            if ($history->type == 2) {
                if ($history->points) {
                    $this->db->set('total_points', 'total_points+' . $history->points, FALSE);
                }
                if ($history->balance) {
                    $this->db->set('total_balance', 'total_balance+' . $history->balance, FALSE);
                }
                $this->db->where('id', $user_id);
                $this->db->update('student');
                $this->db->where('history_id', $history->history_id);
                $this->db->delete('student_history');
            }
        }
        if ($red) {
            redirect('admin/student/transaction', 'refresh');
        }
        redirect('admin/student/history/' . $user_id, 'refresh');
    }

    public function transaction() {

//        $student_premssion = get_ap('student_tag', $this->operator_id);
//        $operator_id = $this->operator_id;
//        $admin_id = $this->session->userdata('admin_id');
//        $this->db->where('id', $admin_id);
//        $query = $this->db->get('user');
//        $profile = $query->row();

        $action = array();
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $action = $this->input->post();
        }
        $data['title'] = $this->lang->line('transaction');
        $data['students'] = $this->Student_Model->get_tables('bills_user');
        $data['members'] = $this->Student_Model->get_tables('user');
        $data['categorys'] = $this->Student_Model->get_tables('pts_category', array('category_type' => 'category'));
        $data['notes'] = $this->Student_Model->get_tables('pts_category', array('category_type' => 'notes'));
        $data['discounts'] = $this->Student_Model->get_tables('pts_category', array('category_type' => 'discount'));
        $data['student_tags'] = $this->Student_Model->get_tables('pts_tags', array('user_type' => 2), array());
        $data['members_tags'] = $this->Student_Model->get_tables('pts_tags', array('user_type' => 1));
        $data['history'] = $this->Student_Model->get_transaction($action);
        //pr($data);die;
        $this->load->view("points/student/transaction", $data);
    }

    public function export() {
        $result = $this->Student_Model->get_student();
        if ($result) {
            $array = array();
            foreach ($result as $key => $result_value) {
                $array[] = array(
                    'student_id' => $result_value->student_id,
                    'name' => $result_value->name,
                    'email' => $result_value->email,
                    'mobile' => $result_value->mobile,
                    'password' => $result_value->password,
                    'profile_image' => $result_value->profile_image,
                    'total_points' => $result_value->total_points,
                    'total_balance' => $result_value->total_balance,
                    'barcode' => $result_value->barcode,
                    'student_code' => $result_value->student_code,
                );
            }
        }
        export_csv($array, "student");
        die;
    }

    public function archived($id, $status) {
        $data = array('archive_status' => $status);
        $this->db->where('id', $id);
        $this->db->update('student', $data);
        redirect('admin/student', 'refresh');
    }

    public function profile($id) {
        $data['results'] = $this->Student_Model->get_student_ids($id);
        $data['title'] = $this->lang->line('student_profile');
        $this->load->view("student/profile", $data);
    }

    public function history($id) {
        $data['result'] = $this->Student_Model->get_student_id($id);
        $data['history'] = $this->Student_Model->get_student_history_id($id);

        $from_date = $this->config->item('from_date');
        $to_date = $this->config->item('end_date');

        $from = date("Y-m-d", strtotime($from_date)) . "  00:00:00";
        $to = date("Y-m-d", strtotime($to_date)) . "  23:59:59    ";

        $data['score_history'] = $this->Student_Model->get_student_history_id($id, $from, $to);

        $data['title'] = $this->lang->line('history') . ' ' . $this->lang->line('points');
        $this->load->view("points/student/history", $data);
    }

    public function change_password($id) {

        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            if ($data['new_password'] == $data['confirm_password']) {
                $data = array('password' => md5($data['new_password']));
                $this->Student_Model->update($id, $data);
                $this->session->set_flashdata('message', 'Password Successfully Updated');
                redirect('admin/student', 'refresh');
            } else {
                $this->session->set_flashdata('message', 'New and confirm Password is wrong');
                redirect('admin/edit/' . $id, 'refresh');
            }
        }
    }

    public function delete($id) {
        $profile = $this->Student_Model->get_student_id($id);
        $profile_path = "assets/images/student/profile/" . $profile->profile_image;
        $qrpath = "assets/images/student/qrcode/" . $profile->barcode;
        if (file_exists($profile_path))
            unlink($profile_path);
        if (file_exists($qrpath))
            unlink($qrpath);

        $this->Student_Model->delete($id);
        $this->session->set_flashdata('message', 'Successfully Deleted');
        redirect('admin/student', 'refresh');
    }

    public function get_student_ajax($type = "") {

        $operator_id = $this->session->userdata('operator_id');

        $draw = intval($this->input->post("draw"));
        $start = intval($this->input->post("start"));
        $length = intval($this->input->post("length"));
        $order = $this->input->post("order");
        $search = $this->input->post("search");
        $search = $search['value'];
        $col = 0;
        $dir = "";
        if (!empty($order)) {
            foreach ($order as $o) {
                $col = $o['column'];
                $dir = $o['dir'];
            }
        }

        if ($dir != "asc" && $dir != "desc") {
            $dir = "desc";
        }

        /* $rows->barcode,
          $rows->name,
          $rows->profile_image,
          $rows->email,
          $rows->mobile,
          $rows->total_points,
          $rows->total_balance,
         */
//        $valid_columns = array(
//            'id',
//           // 'barcode',
//            'name',
////            'student_id',
//         //   'mobile',
//            'total_points',
//            'total_balance',
//        );
        $valid_columns = array(
            '',
            'username',
            'phone',
            'tag_name',
            'total_points',
            'total_balance',
        );
        if (!isset($valid_columns[$col])) {
            $order = null;
        } else {
            $order = $valid_columns[$col];
        }
        if ($order != null) {
            $this->db->order_by($order, $dir);
        }

        if (!empty($search)) {
            $x = 0;
            $this->db->group_start();
            foreach ($valid_columns as $sterm) {
                if ($x == 0) {
                    $x++;
                    continue;
                }
                if ($x == 1) {
                    $this->db->like($sterm, $search);
                } else {
                    $this->db->or_like($sterm, $search);
                }
                $x++;
            }
            $this->db->group_end();
        }
        // $student_tags= $profile->student_tags ? $profile->student_tags : 0;


        $this->db->limit($length, $start);
        $this->db->select('student.*,group_concat(`tags`.`tag_name` separator ",") as tag_name2');
        $this->db->join('pts_tags tags', 'FIND_IN_SET(tags.tag_id, student.student_tags) > 0', 'LEFT');
        $this->db->group_by('student.id');
        $employees = $this->db->get("bills_user student");
//        echo $this->db->last_query();
//        die;
        /* echo $this->db->last_query();

          pr($employees->result());die; */
        $data = array();
        $confrim_opt = "return  confirm('are you sure?');";
        foreach ($employees->result() as $result) {
            $history = "";


            $history .= '<a href="' . base_url() . 'points/student/history/' . $result->id . '" class="btn btn-success btn-sm"><i class="fa fa-list"></i></a> ';



//             if(get_ap('student_edit',$operator_id) ==1) {
//                 $history .= '<a href="'.base_url().'admin/student/edit/'.$result->id.'" class="btn btn-icon btn-primary btn-sm"><i class="la la-edit"></i></a> ';
//                 }
//            if(get_ap('student_delete',$operator_id) ==1) {
//                 $history .= '<a href="'.base_url().'admin/student/delete/'.$result->id.'" class="btn btn-icon btn-danger btn-sm" onclick="'.$confrim_opt.'"><i class="la la-trash"></i></a> ';
//             }


            /* if($result->profile_image){
              if (strpos($result->profile_image, 'http') !== false) {
              $profile   = $result->profile_image;
              }
              else{
              $profile = base_url('assets/images/student/'.$result->profile_image);
              }
              }
              else{
              $profile = base_url('assets/images/student/user.png');
              } */
//                  $attachment = "";
//                  if($result->profile_image){
//                    $attachment = "<a href='#'><i class='fa fa-paperclip'></i></a>";
//                  }

            $data[] = array(
                '<input type="checkbox" name="user[]" class="user_id" value="' . $result->id . '">',
                '<a href="' . base_url('user/show/' . $result->id) . '">' . $result->username . '</a>', //." ".$attachment,
                $result->phone,
                $result->tag_name2,
                $result->total_points,
                $result->total_balance,
                $history
            );
        }
        $total_employees = $this->totalEmployees();
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $total_employees,
            "recordsFiltered" => $total_employees,
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function totalEmployees() {
//        if($student_premssion == 0 ) {
//            $arr = explode(",", $student_tags);
//            $this->db->group_start();
//            if($arr){
//                foreach ($arr as $key => $value) {
//                   
//                    if($key ==0)
//                        $this->db->where('find_in_set("'.$value.'", `student_tags`) <> 0');
//                    else 
//                        $this->db->or_where('find_in_set("'.$value.'", `student_tags`) <> 0');
//                    
//
//                }
//            }
//            else{
//                 $this->db->where('find_in_set(0, `student_tags`) <> 0');
//            }
//            $this->db->group_end();
//        }
        // $this->db->where('archive_status',$type);
        $query = $this->db->select("COUNT(*) as num")->get("bills_user");
        $result = $query->row();
        //echo $this->db->last_query();
        if (isset($result))
            return $result->num;
        return 0;
    }

}
