<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//error_reporting('E_ALL ^ E_NOTICE');
class Category extends MY_Controller {

    public function __construct() {
        parent::__construct();
        if (!get_license_per('points')) {
            redirect("", "refresh");
        }
        $this->operator_id = $this->session->userdata('operator_id');
        if (empty($this->session->userdata("is_admin_login")) || !get_ap('points_module', $this->operator_id)) {
            redirect("", "refresh");
        }
        $this->load->model("points/Category_Model");
        $this->load->helper('security');
    }

    public function index($type = "") {
        $data['title'] = $this->lang->line('setting');
        if ($type == "category")
            $data['title'] = $this->lang->line('category');
        if ($type == "notes")
            $data['title'] = $this->lang->line('notes');
        if ($type == "discount")
            $data['title'] = $this->lang->line('discount');

        $data['results'] = $this->Category_Model->get_category($type);
        //pr($data);
        $data['category_type'] = $type;
        $this->load->view("points/category/index", $data);
    }

    public function create($category_type = "") {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            $data['category_slug'] = slug($data['category_name']);
            $data['category_status'] = 1;
            $this->Category_Model->save($data);
            $this->session->set_flashdata('message', 'Successfully Created');
            redirect('points/category/index/' . $data['category_type'], 'refresh');
        }
        $data['category_type'] = $category_type;
        $data['title'] = "Add Category";
        $this->load->view("points/category/create", $data);
    }

    public function edit($id) {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            $this->Category_Model->update($id, $data);
            $this->session->set_flashdata('message', 'Successfully Updated');
            redirect('points/category/index/' . $data['category_type'], 'refresh');
        }
        $data['title'] = "Edit Category";
        $data['result'] = $this->Category_Model->get_category_id($id);
        $data['category_type'] = $data['result']->category_type;
        $this->load->view("points/category/edit", $data);
    }

    public function status($id, $status) {
        $data = array(
            'category_status' => $status
        );
        $this->Category_Model->update($id, $data);
    }

    public function delete($id) {
        $this->Category_Model->delete($id);
        $this->session->set_flashdata('message', 'Successfully Deleted');
        redirect('points/category', 'refresh');
    }

}
