<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

//error_reporting('E_ALL ^ E_NOTICE');
class Award extends MY_Controller {

    public function __construct() {
        parent::__construct();
        if (!get_license_per('points')) {
            redirect("", "refresh");
        }
        $this->operator_id = $this->session->userdata('operator_id');
        if (empty($this->session->userdata("is_admin_login")) || !get_ap('points_module', $this->operator_id)) {
            redirect("", "refresh");
        }

        $this->load->model("points/Award_Model");
        $this->load->helper('security');
    }

    public function index() {
        $data['results'] = $this->Award_Model->get_award();
        //pr($data);
        $data['title'] = $this->lang->line('award');
        $this->load->view("points/award/index", $data);
    }

    public function history() {
        $data['results'] = $this->Award_Model->get_history();
        //pr($data);
        $data['title'] = $this->lang->line('award_history');
        $this->load->view("points/award/history", $data);
    }

    public function accpect($id) {
        $result = $this->Award_Model->get_history_id($id);
        $award = $this->Award_Model->get_award_id($result->award_id);
        $member_id = $this->session->userdata("admin_id");
        if ($result->award_status == 0) {

            $points_for = $award->award_point_type;

            $award_point = $result->award_history_point;
            $history_data = array();
            $history_data['stud_id'] = $result->user_id;
            $history_data['type'] = 2;
            if ($points_for == 2)
                $history_data['points'] = $award_point;
            $history_data['balance'] = $award_point;
            $history_data['award_id'] = $result->award_id;
            $history_data['member_id'] = $member_id;
            $history_data['memo_notes'] = $result->memo;
            $this->db->insert('pts_student_history', $history_data);
            //pr($history_data);die;


            $award_data = array();
            $award_data['award_status'] = 1;
            $award_data['member_id'] = $member_id;
            $this->db->where('id', $id);
            $this->db->update('pts_award_history', $award_data);

            if ($points_for == 2)
                $this->db->set('total_points', 'total_points-' . $award_point, FALSE);
            $this->db->set('total_balance', 'total_balance-' . $award_point, FALSE);
            $this->db->where('id', $result->user_id);
            $this->db->update('bills_user');
        }
        $this->session->set_flashdata('message', 'Successfully Updated');
        redirect('points/award/history', 'refresh');
    }

    public function reject($id) {
        $member_id = $this->session->userdata("admin_id");
        $award_data = array();
        $award_data['award_status'] = 2;
        $award_data['member_id'] = $member_id;
        $this->db->where('id', $id);
        $this->db->update('pts_award_history', $award_data);
        $this->session->set_flashdata('message', 'Successfully Updated');
        redirect('points/award/history', 'refresh');
    }

    public function create() {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            $data['award_status'] = 1;
            $this->Award_Model->save($data);
            $this->session->set_flashdata('message', 'Successfully Created');
            redirect('points/award/', 'refresh');
        }
        $data['title'] = $this->lang->line('add_award');
        $this->load->view("points/award/create", $data);
    }

    public function edit($id) {
        if ($this->input->server("REQUEST_METHOD") == "POST") {
            $data = $this->input->post();
            $this->Award_Model->update($id, $data);
            $this->session->set_flashdata('message', 'Successfully Updated');
            redirect('points/award', 'refresh');
        }
        $data['title'] = $this->lang->line('edit_award');
        $data['result'] = $this->Award_Model->get_award_id($id);
        $this->load->view("points/award/edit", $data);
    }

    public function status($id, $status) {
        $data = array(
            'award_status' => $status
        );
        $this->Award_Model->update($id, $data);
    }

    public function delete($id) {
        $this->Award_Model->delete($id);
        $this->session->set_flashdata('message', 'Successfully Deleted');
        redirect('points/award', 'refresh');
    }

}
