<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

    function __construct() {
        parent::__construct();
        if (!get_system_status()) {
            echo $this->load->view('site/system_off', '', TRUE);
            die();
        }
        if (!get_license_per('knowledge_base')) {
            redirect("", "refresh");
        }
        set_system_timezone();
        $this->load->model('booking');
//        $this->operator_id = $this->session->userdata('operator_id');
//        if (!get_ap('drivers_module', $this->operator_id)) {
//            redirect("", "refresh");
//        }


        $this->load->model('admin/knowledge_base_model');
    }

    public function index() {

        $data['settings'] = $this->knowledge_base_model->getRows('setting');
        $this->db->select('id,name');
        $result11 = $this->db->get_where('kw_parent_categories', array('primary_dalel' => 'نعم'))->result();
        if (!empty($result11)) {
            $data['homepage'] = $this->knowledge_base_model->getHomepage($result11[0]->id);
            $data['dalel_name'] = $result11[0]->name;
            $data['comments'] = $this->knowledge_base_model->getArticleComments($data['homepage'][0]->id);
        }
        if (!$this->session->has_userdata('is_admin_login')) {
            $data['logged'] = 'no';
        } else {
            $data['logged'] = 'yes';
            $data['rate'] = !empty($result11) ? $this->knowledge_base_model->getUserArticleRate($this->session->userdata('admin_id'), $data['homepage'][0]->id) : array();
        }


        $data['categories'] = !empty($result11) ? $this->knowledge_base_model->getDalelCategories($result11[0]->id) : array();
        $data['cont'] = $this;
        $data['header_title'] = 'الرئيسية';
        /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
          $result = $this->db->query($sql)->result();
          $data['cat_id'] = $result[0]->id; */

        $this->loadView('home', $data);
    }

    public function getReply($id) {
        $reply = $this->home_model->getCommentReply($id);
        return $reply;
    }

    public function delete($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';

                redirect('home');
            } else {
                $data['logged'] = 'yes';
                $this->home_model->deleteArticle($id);
                redirect('home');
            }
        } else {
            redirect('underconstruction');
        }
    }

    public function deleteComment($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';

                redirect('home');
            } else {
                $data['logged'] = 'yes';
                $this->home_model->deleteComment($id);
                redirect('home');
            }
        } else {
            redirect('underconstruction');
        }
    }

    public function deleteReply($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';

                redirect('home');
            } else {
                $data['logged'] = 'yes';
                $this->home_model->deleteReply($id);
                redirect('home');
            }
        } else {
            redirect('underconstruction');
        }
    }

    function setArticleRate() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';
                //save rate into session

                $article_id = $this->input->post("article_id");
                $rate = $this->input->post("rate");
                if ($rate == "Yes") {
                    $r = "نعم";
                    /* update */
                    $this->db->where('id', $article_id);
                    $this->db->set('yes_rate', 'yes_rate+1', FALSE);
                    $this->db->update('articles');
                } else if ($rate == "No") {
                    $r = "لا";
                    /* update */
                    $this->db->where('id', $article_id);
                    $this->db->set('no_rate', 'no_rate+1', FALSE);
                    $this->db->update('articles');
                }
                $article_rate = $this->session->userdata('article' . $article_id);
                //if(!isset($article_rate) || $article_rate == '') {
                $this->session->set_userdata('article' . $article_id, $r);
                //}
                $output = json_encode(array(//create JSON data
                    'type' => 'msg',
                    'text' => 'true'
                ));
                die($output);
            } else {
                $data['logged'] = 'yes';
                $user = $this->ion_auth->user()->row();
                $article_id = $this->input->post("article_id");
                $rate = $this->input->post("rate");
                if ($rate == "Yes") {
                    $r = "نعم";
                } else if ($rate == "No") {
                    $r = "لا";
                }
                $article_arr = array(
                    'article_id' => $article_id,
                    'user_id' => $user->id,
                    'rate' => $r
                );
                $c = 'nothing';
                $this->db->where('user_id', $user->id);
                $this->db->where('article_id', $article_id);
                $check_rate = $this->db->get('article_rate')->num_rows();
                if ($check_rate == 0) {
                    $c = 'insert';
                    $this->home_model->insertRow('article_rate', $article_arr);
                    $rate_arr = $this->home_model->getUserArticleRate($user->id, $article_id);
                    $rate_id = $rate_arr[0]->id;
                    $output = json_encode(array(//create JSON data
                        'type' => 'msg',
                        'text' => 'true'
                    ));
                    die($output);
                } else {
                    $c = 'update';
                    $rate_arr = $this->home_model->getUserArticleRate($user->id, $article_id);
                    $rate_id = $rate_arr[0]->id;
                    $this->home_model->updateUserArticleRate($rate_id, $article_arr);
                    $output = json_encode(array(//create JSON data
                        'type' => 'msg',
                        'text' => 'true'
                    ));
                    die($output);
                }
            }
        } else {
            redirect('underconstruction');
        }
    }

    public function addReaderComment() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            $r_name = $this->input->post("r_name");
            $r_email = $this->input->post("r_email");
            $r_comment = $this->input->post("r_comment");
            $article_id = $this->input->post("article_id");
            if ($data['settings'][0]->open_comments == 'نعم') {
                $comment_status = 'منشور';
            } else {
                $comment_status = 'معلق';
            }
            $d = date("Y-m-d");
            $comment = array(
                'article_id' => $article_id,
                'comment_text' => $r_comment,
                'c_date' => $d,
                'user_type' => 'nonlogged',
                'user_name' => $r_name,
                'user_email' => $r_email,
                'comment_status' => $comment_status
            );

            $comment_id = $this->home_model->insertRow('article_comments', $comment);
            $p = '<div id="comment_' . $comment_id . '" class="comment">
						
						<div class="di avatar-div">
							<img class="avatar di" src="' . base_url("assets/img/users.png") . '">
						</div>
						<div class="di">
		
							<div class="media-body">
								<div class="comment_info">
									<h3>' . $r_name .
                    '&nbsp;&nbsp;<span class="date">' . $d . '</span>
									</h3>
								</div>
							</div>
							<p>' .
                    $r_comment
                    . '</p>
							
						</div>
					</div>';

            $output = json_encode(array(//create JSON data
                'text' => $p,
                'id' => $comment_id,
                'status' => $comment_status
            ));
            die($output);
        } else {
            redirect('underconstruction');
        }
    }

    public function addUserComment() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            $u_comment = $this->input->post("u_comment");
            $u_name = $this->ion_auth->user()->row()->first_name . ' ' . $this->ion_auth->user()->row()->last_name;
            $u_email = $this->ion_auth->user()->row()->email;
            $u_id = $this->ion_auth->user()->row()->id;
            $article_id = $this->input->post("article_id");
            if ($data['settings'][0]->open_comments == 'نعم') {
                $comment_status = 'منشور';
            } else {
                $comment_status = 'معلق';
            }
            $d = date("Y-m-d");
            $comment = array(
                'article_id' => $article_id,
                'comment_text' => $u_comment,
                'c_date' => $d,
                'user_type' => 'logged',
                'user_id' => $u_id,
                'user_name' => $u_name,
                'user_email' => $u_email,
                'comment_status' => $comment_status
            );

            $comment_id = $this->home_model->insertRow('article_comments', $comment);
            $p = '<div id="comment_' . $comment_id . '" class="comment">
						
						<div class="di avatar-div">
							<img class="avatar di" src="' . base_url("assets/img/users.png") . '">
						</div>
						<div class="di">
		
							<div class="media-body">
								<div class="comment_info">
									<h3>' . $u_name .
                    '&nbsp;&nbsp;<span class="date">' . $d . '</span>
									</h3>
								</div>
							</div>
							<p>' .
                    $u_comment
                    . '</p>
							
						</div>
					</div>';

            $output = json_encode(array(//create JSON data
                'text' => $p,
                'id' => $comment_id,
                'status' => $comment_status
            ));
            die($output);
        } else {
            redirect('underconstruction');
        }
    }

    public function addReply() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            $reply = $this->input->post("reply");
            $comment_id = $this->input->post("comment_id");
            if ($this->ion_auth->logged_in() === FALSE) {
                $logged = 'nonlogged';
                $name = $this->input->post("reply_name");
                $email = $this->input->post("reply_email");
                $user_id = 0;
            } else {
                $logged = 'logged';
                $name = $this->ion_auth->user()->row()->first_name . ' ' . $this->ion_auth->user()->row()->last_name;
                $email = $this->ion_auth->user()->row()->email;
                $user_id = $this->ion_auth->user()->row()->id;
            }
            $article_id = $this->input->post("article_id");
            $d = date("Y-m-d");
            if ($data['settings'][0]->open_comments == 'نعم') {
                $comment_status = 'منشور';
            } else {
                $comment_status = 'معلق';
            }
            $reply_arr = array(
                'article_id' => $article_id,
                'comment_id' => $comment_id,
                'reply_text' => $reply,
                'r_date' => $d,
                'user_type' => $logged,
                'user_id' => $user_id,
                'user_name' => $name,
                'user_email' => $email,
                'reply_status' => $comment_status
            );

            $reply_id = $this->home_model->insertRow('article_reply', $reply_arr);
            $p = '<div id="replay_' . $comment_id . $reply_id . '" class="replay">
						   
								<div class="di avatar-div">
									<img class="avatar di" src="' . base_url('assets/img/users.png') . '">
								</div>
								<div class="di">
	
									<div class="media-body">
										<div class="comment_info">
											<h3>' . $name .
                    '&nbsp;&nbsp;<span class="date">' . $d . '</span>
											</h3>
										</div>
									</div>
									<p>' .
                    $reply .
                    '</p>
									
								</div>
							</div>';

            $output = json_encode(array(//create JSON data
                'text' => $p,
                'id' => $reply_id,
                'status' => $comment_status
            ));
            die($output);
        } else {
            redirect('underconstruction');
        }
    }

    public function search() {

        $data['settings'] = $this->knowledge_base_model->getRows('setting');
        if (!$this->session->has_userdata('is_admin_login')) {
            $data['logged'] = 'no';
        } else {
            $data['logged'] = 'yes';
        }
        $this->db->select('id,name');
        $result11 = $this->db->get_where('kw_parent_categories', array('primary_dalel' => 'نعم'))->result();
        //$data['dalel_name'] = $result11[0]->name;

        $data['categories'] = isset($result11[0]) ? $this->knowledge_base_model->getDalelCategories($result11[0]->id) : array();
        $data['cont'] = $this;
        $data['header_title'] = 'الرئيسية';
        /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
          $result = $this->db->query($sql)->result();
          $data['cat_id'] = $result[0]->id; */
        $data['homepage'] = isset($result11[0]) ? $this->knowledge_base_model->getHomepage($result11[0]->id) : array();

        $word = $this->input->post('word');
        $data['word'] = $word;
        $data['results'] = $this->knowledge_base_model->search($word);
        $this->loadView('search_results', $data);
    }

    public function getArticles($cat_id) {
        $articles = $this->knowledge_base_model->getArticles($cat_id);
        return $articles;
    }

    public function loadView($view, $data = array()) {
        $this->load->view('site/knoweldge_base/shared/header', $data);
        $this->load->view('site/knoweldge_base/shared/main_banner', $data);
        $this->load->view('site/knoweldge_base/shared/sidemenu');
        $this->load->view('site/knoweldge_base/front/' . $view);
        $this->load->view('site/knoweldge_base/shared/footer');
    }

}
