<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends MY_Controller {

    function __construct() {
        parent::__construct();
        if (!get_license_per('knowledge_base')) {
            redirect("", "refresh");
        }
        $this->load->model('booking');
        $this->operator_id = $this->session->userdata('operator_id');
        if (!get_ap('knowledge_base_module', $this->operator_id)) {
            redirect("", "refresh");
        }

        if (!$this->session->userdata('group')) {
            echo "لايمكن الاستخدام ";
            $this->session->set_flashdata('msg', 'لايمكن التعديل عليه');
            redirect($_SERVER['HTTP_REFERER']);
            exit();
        }
        $this->load->model('admin/knowledge_base_model');
//        $this->load->library('ion_auth');
//        $this->load->model('ion_auth_model');
//        $this->load->model('home_model');
        //$this->load->library('grocery_CRUD');
    }

    /*     * Dalel* */

    public function dalel() {
        $data['logged'] = 'yes';
        $data['page'] = 'dalel';

        $data['title'] = $this->lang->line('guides');
        $data['controller'] = "dashboard";
        $data['dalel'] = $this->knowledge_base_model->getRows('kw_parent_categories');
        $this->load->view('site/knoweldge_base/dalel', $data);
    }

    public function adddalel() {
        if (!get_ap('kw_add_guide', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('add-a-guide');
        $data['controller'] = "dashboard";
        $data['page'] = 'dalel';

        $data['logged'] = 'yes';

        $this->load->view('site/knoweldge_base/add_dalel', $data);
    }

    public function postadddalel() {
        if (!get_ap('kw_add_guide', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title_page'] = $this->lang->line('add-a-guide');
        $data['controller'] = "dashboard";

        $data['page'] = 'dalel';
        $data['logged'] = 'yes';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('title', $this->lang->line('guide_title'), 'trim|required');

        $this->form_validation->set_rules('name', $this->lang->line('link_title'), 'trim|required|is_unique[kw_parent_categories.name]');

        if ($this->form_validation->run() === FALSE) {
            $this->load->helper('form');
            $this->load->view('site/knoweldge_base/add_dalel', $data);
        } else {
            $name = $this->input->post('name');
            $title = $this->input->post('title');
            $privacy_type = $this->input->post('privacy_type');
            if ($privacy_type == 'عام') {
                $privacy_data = '';
            }
            if ($privacy_type == 'كلمة مرور') {
                $privacy_arr = array(
                    'password' => MD5($this->input->post('password'))
                );
                $privacy_data = json_encode($privacy_arr);
            }
            if ($privacy_type == 'مستخدمين') {
                $privacy_arr = array(
                    'users' => $this->input->post('usersfrom')
                );
                $privacy_data = json_encode($privacy_arr);
            }
            if ($privacy_type == 'مجموعات') {
                $privacy_arr = array(
                    'groups' => $this->input->post('groupsfrom')
                );
                $privacy_data = json_encode($privacy_arr);
            }

            $d = date("Y-m-d H:i:s");

            $add_data = array(
                'name' => $name,
                'title' => $title,
                'privacy_type' => $privacy_type,
                'privacy_data' => $privacy_data,
                'primary_dalel' => 'لا',
                'created_at' => $d
            );

            if ($this->knowledge_base_model->insertRow('kw_parent_categories', $add_data)) {
                $this->session->set_flashdata('success', $this->lang->line('op_success'));
                redirect('knowledge_base/dalel');
            } else {
                $this->session->set_flashdata('success', $this->lang->line('op_success'));
                redirect('knowledge_base/adddalel');
            }
        }
    }

    //delete
    public function deletedalel($id) {
        if (!get_ap('kw_delete_guide', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $this->knowledge_base_model->deleteRow($id, 'kw_parent_categories');
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/dalel');
    }

    //update
    public function editdalel($id) {
        if (!get_ap('kw_edit_guide', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('guide');
        $data['controller'] = "settings";
        $data['page'] = "dalel";

        $data['logged'] = 'yes';

        $data['dalel'] = $this->knowledge_base_model->getDalel($id);
        $this->load->view('site/knoweldge_base/edit_dalel', $data);
    }

    public function updatedalel() {
        if (!get_ap('kw_edit_guide', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('guide');
        $data['controller'] = "settings";
        $data['page'] = "dalel";


        $data['logged'] = 'yes';

        $data['dalel'] = $this->knowledge_base_model->getDalel($this->input->post('dalel_id'));

        if ($this->input->post('name') != $this->input->post('name1')) {
            $is_unique = '|is_unique[kw_parent_categories.name]';
        } else {
            $is_unique = '';
        }
        $this->load->library('form_validation');
        $this->form_validation->set_rules('title', $this->lang->line('guide_title'), 'trim|required');

        $this->form_validation->set_rules('name', $this->lang->line('link_title'), 'trim|required' . $is_unique);


        if ($this->form_validation->run() === FALSE) {
            $this->load->helper('form');
            $this->load->view('site/knoweldge_base/edit_dalel', $data);
            //$this->loadView('تسجيل جديد','signup');
            //redirect('signup');
        } else {

            $name = $this->input->post('name');
            $title = $this->input->post('title');
            $dalel_id = $this->input->post('dalel_id');
            $privacy_type = $this->input->post('privacy_type');
            if ($privacy_type == 'عام') {
                $privacy_data = '';
            }
            if ($privacy_type == 'كلمة مرور') {
                $privacy_arr = array(
                    'password' => MD5($this->input->post('password'))
                );
                $privacy_data = json_encode($privacy_arr);
            }
            if ($privacy_type == 'مستخدمين') {
                $privacy_arr = array(
                    'users' => $this->input->post('usersfrom')
                );
                $privacy_data = json_encode($privacy_arr);
            }
            if ($privacy_type == 'مجموعات') {
                $privacy_arr = array(
                    'groups' => $this->input->post('groupsfrom')
                );
                $privacy_data = json_encode($privacy_arr);
            }
            $daleldata = array(
                'name' => $name,
                'title' => $title,
                'privacy_type' => $privacy_type,
                'privacy_data' => $privacy_data
            );

            $this->knowledge_base_model->updateRow($dalel_id, 'kw_parent_categories', $daleldata);
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/dalel');
        }
    }

    //end of Dalel

    /*     * Categories* */
    public function categories($dalel_id = 0) {
        if (!get_ap('guide_categories', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['logged'] = 'yes';
        $data['page'] = 'category';

        $data['title'] = $this->lang->line('categories');
        $data['controller'] = "dashboard";
        $data['dalel_id'] = $dalel_id;
        if ($dalel_id != 0) {
            $this->db->select('name');
            $result33 = $this->db->get_where('kw_parent_categories', array('id' => $dalel_id))->row();
            if (!$result33) {
                $this->session->set_flashdata('error', $this->lang->line('data_not_found'));
                redirect('knowledge_base/dalel');
            }
            $data['dalel_name'] = $result33->name;
        }
        $data['categories'] = $this->knowledge_base_model->getAllCategory($dalel_id);

        $this->load->view('site/knoweldge_base/categories', $data);
    }

    public function reorderallcategories() {
        if (!get_ap('guide_categories', $this->operator_id)) {
            redirect('', 'refresh');
        }
        //updating
        $cat_json = $this->input->post('cat_json');
        $dalel_id = $this->input->post('dalel_id');
        $obj1 = json_decode($cat_json);
        if (isset($obj1)) {
            foreach ($obj1 as $key => $value) {
                $catdata = array(
                    'category_order' => $value
                );
                $this->knowledge_base_model->updateRow($key, 'kw_categories', $catdata);
            }

            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/categories/' . $dalel_id);
        } else {
            $this->session->set_flashdata('error', 'Something Went Wrong');
            redirect('knowledge_base/categories/' . $dalel_id);
        }
    }

    public function getDalel($id) {
        return $this->home_model->getDalel($id);
    }

    public function addcategory($dalel_id) {
        if (!get_ap('kw_add_category', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('add-a-category');
        $data['controller'] = "dashboard";
        $data['page'] = 'category';

        $data['logged'] = 'yes';
        $data['dalel_id'] = $dalel_id;
        $data['page_type'] = 'add';
        $data['dalel'] = $this->knowledge_base_model->getRows('kw_parent_categories');
        $this->load->view('site/knoweldge_base/category_form', $data);
    }

    public function postaddcategories() {
        if (!get_ap('kw_add_category', $this->operator_id)) {
            redirect('', 'refresh');
        }

        $data['title'] = $this->lang->line('add-a-category');
        $data['controller'] = "dashboard";
        $data['page'] = 'category';
        $data['page_type'] = 'add';
        $data['dalel'] = $this->knowledge_base_model->getRows('kw_parent_categories');
        $data['logged'] = 'yes';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', $this->lang->line('title'), 'trim|required');


        if ($this->form_validation->run() === FALSE) {
            $this->load->helper('form');
            $this->load->view('site/knoweldge_base/category_form', $data);
        } else {
            $name = $this->input->post('name');
            $parent_id = $this->input->post('parent_id');
            $d = date("Y-m-d H:i:s");
            $add_data = array(
                'name' => $name,
                'parent_id' => $parent_id,
                'created_at' => $d
            );

            $this->knowledge_base_model->insertRow('kw_categories', $add_data);
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/categories/' . $parent_id);
        }
    }

    //delete
    public function deletecategories($id, $dalel_id) {
        if (!get_ap('kw_delete_category', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $this->knowledge_base_model->deleteRow($id, 'kw_categories');
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/categories/' . $dalel_id);
    }

    //update
    public function editcategories($id, $dalel_id) {
        if (!get_ap('kw_edit_category', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('category');
        $data['controller'] = "settings";
        $data['page'] = "category";

        $data['logged'] = 'yes';
        $data['page_type'] = 'edit';
        $data['dalel'] = $this->knowledge_base_model->getRows('kw_parent_categories');
        $data['category'] = $this->knowledge_base_model->getCategory($id);
        $data['dalel_id'] = $dalel_id;
        $this->load->view('site/knoweldge_base/category_form', $data);
    }

    public function updatecategories() {
        if (!get_ap('kw_edit_category', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title_page'] = $this->lang->line('edit') . ' ' . $this->lang->line('category');
        $data['controller'] = "settings";
        $data['page'] = "category";

        $data['logged'] = 'yes';

        $cat_id = $this->input->post('cat_id');

        $this->load->library('form_validation');
        $this->form_validation->set_rules('name', $this->lang->line('title'), 'trim|required');

        if ($this->form_validation->run() === FALSE) {
            $this->load->helper('form');
            $this->load->view('site/knoweldge_base/category_form', $data);
        } else {

            $name = $this->input->post('name');
            $dalel_id = $this->input->post('parent_id');

            $catdata = array(
                'name' => $name,
                'parent_id' => $dalel_id
            );

            $this->knowledge_base_model->updateRow($cat_id, 'kw_categories', $catdata);
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/categories/' . $dalel_id);
        }
    }

    //end of Categories

    public function getPermissions($id) {
        return $this->home_model->getGroupPermissions($id);
    }

    /*     * Articles* */

    public function articles($dalel_id = 0) {
        if (!get_ap('kw_articles', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['logged'] = 'yes';
        $data['page'] = 'articles';

        $data['title'] = $this->lang->line('articles');
        $data['controller'] = "dashboard";
        $data['dalel_id'] = $dalel_id;
        $data['cont'] = $this;
        if ($dalel_id != 0) {
            $this->db->select('name');
            $result33 = $this->db->get_where('kw_parent_categories', array('id' => $dalel_id))->row();
            if (!$result33) {
                $this->session->set_flashdata('error', $this->lang->line('data_not_found'));
                redirect('knowledge_base/dalel');
            }
            $data['dalel_name'] = $result33->name;
        }

        $data['articles'] = $this->knowledge_base_model->getAllDalelArticles($dalel_id);

        $this->load->view('site/knoweldge_base/articles', $data);
    }

    public function dalelofcat($cat_id) {
        $dalelname = $this->knowledge_base_model->getDalelByCategory($cat_id);
        if (isset($dalelname) && $dalelname != null) {
            return $dalelname[0]->name;
        } else {
            return 'غير مرتبط';
        }
    }

    public function getsinglecategory($cat_id) {
        $cat = $this->knowledge_base_model->getCategory($cat_id);
        if (isset($cat) && $cat != null) {
            return $cat[0]->name;
        } else {
            return 'غير مرتبط';
        }
    }

    public function reorderallarticles() {

        //updating
        $art_json = $this->input->post('art_json');
        $dalel_id = $this->input->post('dalel_id');
        $obj1 = json_decode($art_json);
        if (isset($obj1)) {
            foreach ($obj1 as $key => $value) {
                $artdata = array(
                    'article_order' => $value
                );
                $this->knowledge_base_model->updateRow($key, 'kw_articles', $artdata);
            }

            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/articles/' . $dalel_id);
        } else {
            $this->session->set_flashdata('error', 'Something Went wrong');
            redirect('knowledge_base/articles/' . $dalel_id);
        }
    }

    public function getRateNum($id, $type) {
        return $this->knowledge_base_model->getArticleRateNum($id, $type);
    }

    public function addarticle($dalel_id) {
        if (!get_ap('kw_add_article', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('add') . ' ' . $this->lang->line('article');
        $data['controller'] = "dashboard";
        $data['page'] = 'articles';

        $data['logged'] = 'yes';
        $data['page_type'] = 'add';
        $data['dalel_id'] = $dalel_id;
        $data['categories'] = $this->knowledge_base_model->getAllDalelCategories($dalel_id);
        $data['dalels'] = $this->knowledge_base_model->getRows('kw_parent_categories');
        $data['cont'] = $this;
        $this->load->view('site/knoweldge_base/article_form', $data);
    }

    public function dalelinfo($cat_id) {
        $dalelinfo = $this->home_model->getDalelinfoByCategory($cat_id);
        return $dalelinfo;
    }

    public function postaddarticle() {
        if (!get_ap('kw_add_article', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('add') . ' ' . $this->lang->line('article');
        $data['controller'] = "dashboard";

        $data['page'] = 'articles';
        $data['page_type'] = 'add';
        $data['categories'] = $this->knowledge_base_model->getAllDalelCategories($this->input->post('dalel_id'));
        $data['logged'] = 'yes';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');

        $this->form_validation->set_rules('desc', $this->lang->line('article_text'), 'trim|required');

        if ($this->form_validation->run() === FALSE) {
            $this->load->view('site/knoweldge_base/article_form', $data);
        } else {
            $title = $this->input->post('title');
            $desc = $this->input->post('desc');
            $creator_id = $this->input->post('creator_id');
            $cat_id = $this->input->post('cat_id');
            $comments = $this->input->post('comments');
            $rate = $this->input->post('rate');
            $d = date("Y-m-d H:i:s");
            $dalel_id = $this->input->post('dalel_id');

            $add_data = array(
                'title' => $title,
                'text' => $desc,
                'creator_id' => $creator_id,
                'category_id' => $cat_id,
                'check_comment' => $comments,
                'check_rate' => $rate,
                'created_at' => $d
            );
            $this->knowledge_base_model->insertRow('kw_articles', $add_data);
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/articles/' . $dalel_id);
        }
    }

    //delete
    public function deletearticle($id, $dalel_id) {
        if (!get_ap('kw_delete_article', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $this->knowledge_base_model->deleteRow($id, 'articles');
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/articles/' . $dalel_id);
    }

    //update
    public function editarticle($id, $dalel_id) {
        if (!get_ap('kw_edit_article', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('article');
        $data['controller'] = "settings";
        $data['page'] = "articles";

        $data['logged'] = 'yes';
        $data['page_type'] = 'edit';
        $data['categories'] = $this->knowledge_base_model->getAllDalelCategories($dalel_id);
        $data['dalel_id'] = $dalel_id;
        $data['article'] = $this->knowledge_base_model->getArticle($id);

        $data['dalels'] = $this->knowledge_base_model->getRows('kw_parent_categories');
        $data['cont'] = $this;
        $this->load->view('site/knoweldge_base/article_form', $data);
    }

    public function updatearticle() {
        if (!get_ap('kw_edit_article', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('article');
        $data['controller'] = "settings";
        $data['page'] = "articles";

        $data['logged'] = 'yes';

        $article_id = $this->input->post('article_id');
        $data['categories'] = $this->knowledge_base_model->getAllDalelCategories($this->input->post('dalel_id'));
        $data['article'] = $this->knowledge_base_model->getArticle($article_id);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');

        $this->form_validation->set_rules('desc', $this->lang->line('article_text'), 'trim|required');


        if ($this->form_validation->run() === FALSE) {
            $this->load->view('site/knoweldge_base/article_form', $data);
        } else {

            $title = $this->input->post('title');
            $desc = $this->input->post('desc');
            $creator_id = $this->input->post('creator_id');
            $cat_id = $this->input->post('cat_id');
            $comments = $this->input->post('comments');
            $rate = $this->input->post('rate');
            $dalel_id = $this->input->post('dalel_id');

            $art_data = array(
                'title' => $title,
                'text' => $desc,
                'category_id' => $cat_id,
                'check_comment' => $comments,
                'check_rate' => $rate
            );
            $this->knowledge_base_model->updateRow($article_id, 'kw_articles', $art_data);
            $this->session->set_flashdata('success', $this->lang->line('success'));
            redirect('knowledge_base/articles/' . $dalel_id);
        }
    }

    //end of Articles

    /*     * Comments* */
    public function comments($article_id = 0) {
        if (!get_ap('kw_comments', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $data['logged'] = 'yes';
        $data['page'] = 'comments';
        $data['article_id'] = $article_id;
        if ($article_id != 0) {
            $data['article_title'] = $this->knowledge_base_model->getArticleName($article_id);
        }
        $data['title'] = $this->lang->line('comments');
        $data['controller'] = "dashboard";
        $data['comments'] = $this->knowledge_base_model->getComments($article_id);

        $data['cont'] = $this;
        $this->load->view('site/knoweldge_base/comments', $data);
    }

    public function getCommentReplies($comment_id) {
        if (!get_ap('kw_comments', $this->operator_id)) {
            redirect('', 'refresh');
        }
        return $this->home_model->getCommentReply($comment_id);
    }

    public function addcomment() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);

        $data['title_page'] = "إضافة تعليق";
        $data['controller'] = "dashboard";
        $data['page'] = 'comments';
        if ($this->ion_auth->logged_in() === FALSE) {
            $data['logged'] = 'no';
            redirect('login');
        } else {
            //add cat groups
            /* $add_cat_group = array();
              $result = $this->home_model->getPermissionGroups(1);
              if(isset($result)&& $result!=null) {
              for ($i = 0; $i < count($result); ++$i) {
              array_push($add_cat_group, $result[$i]->group_id);
              }
              } */
            //if ($this->ion_auth->in_group($add_cat_group)) {
            $data['logged'] = 'yes';
            $data['page_type'] = 'add';
            $data['articles'] = $this->home_model->getCommentsArticles();
            $this->load->view('dash/comment_form', $data);
            /* }
              else {
              $_SESSION['auth_message'] = '<p>ليس لديك الصلاحية لزيارة هذه الصفحة</p>';
              $this->session->mark_as_flash('auth_message');
              redirect('home');
              } */
        }
    }

    public function postaddcomment() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);

        $data['title_page'] = "إضافة تعليق";
        $data['controller'] = "dashboard";
        if ($this->ion_auth->logged_in() === FALSE) {
            $data['logged'] = 'no';
            redirect('login');
        } else {
            //add dalel groups
            /* $add_dalel_group = array();
              $result = $this->home_model->getPermissionGroups(1);
              if(isset($result)&& $result!=null) {
              for ($i = 0; $i < count($result); ++$i) {
              array_push($add_dalel_group, $result[$i]->group_id);
              }
              } */
            //if ($this->ion_auth->in_group($add_dalel_group)) {
            $data['page'] = 'comments';
            $data['page_type'] = 'add';
            $data['articles'] = $this->home_model->getRows('articles');
            $data['logged'] = 'yes';
            $this->load->library('form_validation');
            $this->form_validation->set_rules('comment', 'Comment', 'trim|required', array('required' => 'يجب إدخال التعليق')
            );

            if ($this->form_validation->run() === FALSE) {
                $this->load->helper('form');
                $this->load->view('dash/comment_form', $data);
                //$this->loadView('تسجيل جديد','signup');
                //redirect('signup');
            } else {
                $comment = $this->input->post('comment');
                $u_name = $this->ion_auth->user()->row()->first_name . ' ' . $this->ion_auth->user()->row()->last_name;
                $u_email = $this->ion_auth->user()->row()->email;
                $u_id = $this->ion_auth->user()->row()->id;
                $article_id = $this->input->post("article_id");
                $d = date("Y-m-d");
                $comment = array(
                    'article_id' => $article_id,
                    'comment_text' => $comment,
                    'c_date' => $d,
                    'user_type' => 'logged',
                    'user_id' => $u_id,
                    'user_name' => $u_name,
                    'user_email' => $u_email
                );

                if ($this->home_model->insertRow('article_comments', $comment)) {
                    $_SESSION['auth_message'] = '<p>تم إضافة التعليق</p>';
                    $this->session->mark_as_flash('auth_message');
                    redirect('dashboard/comments');
                } else {
                    $_SESSION['auth_message'] = '<p>لم تتم إضافة التعليق</p>';
                    $this->session->mark_as_flash('auth_message');
                    redirect('dashboard/comments');
                }
            }
            /* } else {
              $_SESSION['auth_message'] = '<p>ليس لديك الصلاحية لزيارة هذه الصفحة</p>';
              $this->session->mark_as_flash('auth_message');
              redirect('dashboard');
              } */
        }
    }

    //delete
    public function deletecomment($id) {
        if (!get_ap('kw_delete_comment', $this->operator_id)) {
            redirect('', 'refresh');
        }
        $this->home_model->deleteRow($id, 'kw_article_comments');
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/comments');
    }

    //update
    public function editcomment($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);

        $data['title_page'] = "تعديل تعليق";
        $data['controller'] = "settings";
        $data['page'] = "comments";

        if ($this->ion_auth->logged_in() === FALSE) {
            $data['logged'] = 'no';
            redirect('login');
        } else {
            //edit user groups
            /* $edit_dalel_group = array();
              $result = $this->home_model->getPermissionGroups(2);
              if(isset($result)&& $result!=null) {
              for ($i = 0; $i < count($result); ++$i) {
              array_push($edit_dalel_group, $result[$i]->group_id);
              }
              } */
            //if ($this->ion_auth->in_group($edit_user_group)) {
            $data['logged'] = 'yes';
            $data['page_type'] = 'edit';
            $data['articles'] = $this->home_model->getCommentsArticles();
            $data['comment'] = $this->home_model->getComment($id);
            $this->load->view('dash/comment_form', $data);
            /* }
              else {
              $_SESSION['auth_message'] = '<p>ليس لديك الصلاحية لزيارة هذه الصفحة</p>';
              $this->session->mark_as_flash('auth_message');
              redirect('dashboard');
              } */
        }
    }

    public function updatecomment() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);

        $data['title_page'] = "تعديل تعليق";
        $data['controller'] = "settings";
        $data['page'] = "comments";

        if ($this->ion_auth->logged_in() === FALSE) {
            $data['logged'] = 'no';
            redirect('login');
        } else {
            //edit dalel groups
            /* $edit_dalel_group = array();
              $result = $this->home_model->getPermissionGroups(2);
              if(isset($result)&& $result!=null) {
              for ($i = 0; $i < count($result); ++$i) {
              array_push($edit_dalel_group, $result[$i]->group_id);
              }
              } */
            //if ($this->ion_auth->in_group($edit_user_group)) {
            $data['logged'] = 'yes';

            $comment_id = $this->input->post('comment_id');
            $data['articles'] = $this->home_model->getCommentsArticles();
            $data['comment'] = $this->home_model->getComment($comment_id);

            $this->load->library('form_validation');
            $this->form_validation->set_rules('comment', 'comment', 'trim|required', array('required' => 'يجب إدخال التعليق')
            );


            if ($this->form_validation->run() === FALSE) {

                $this->load->helper('form');
                $this->load->view('dash/comment_form', $data);
            } else {

                $comment = $this->input->post('comment');
                $article_id = $this->input->post("article_id");
                $comment = array(
                    'article_id' => $article_id,
                    'comment_text' => $comment
                );
                if ($this->home_model->updateRow($comment_id, 'article_comments', $comment)) {

                    $_SESSION['auth_message'] = '<p>تم تعديل التعليق</p>';
                    $this->session->mark_as_flash('auth_message');
                    redirect('dashboard/comments');
                } else {
                    $_SESSION['auth_message'] = '<p>لم يتم تعديل التعليق</p>';
                    $this->session->mark_as_flash('auth_message');
                    redirect('dashboard/comments');
                }
            }
            /* }
              else {
              $_SESSION['auth_message'] = '<p>ليس لديك الصلاحية لزيارة هذه الصفحة</p>';
              $this->session->mark_as_flash('auth_message');
              redirect('dashboard');
              } */
        }
    }

    public function changeCommentStatus($status) {

        $comment_id = $this->input->post('comment_id');

        $article_id = $this->input->post('article_id');
        if ($status == 0) {
            $comment = array(
                'comment_status' => 'معلق'
            );
        } else {
            $comment = array(
                'comment_status' => 'منشور'
            );
        }
        $this->knowledge_base_model->updateRow($comment_id, 'kw_article_comments', $comment);
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/comments/' . $article_id);
    }

    //end of Comments

    /*     * Replies* */
    public function commentreplies($comment_id) {

        $data['title'] = $this->lang->line('replies');
        $data['controller'] = "dashboard";
        $data['comment'] = $this->knowledge_base_model->getComment($comment_id);
        $data['replies'] = $this->knowledge_base_model->getAllCommentReply($comment_id);

        $data['cont'] = $this;
        $this->load->view('site/knoweldge_base/replies', $data);
    }

    public function changeReplyStatus($status) {


        $reply_id = $this->input->post('reply_id');


        $comment_id = $this->input->post('comment_id');
        if ($status == 0) {
            $reply = array(
                'reply_status' => 'معلق'
            );
        } else {
            $reply = array(
                'reply_status' => 'منشور'
            );
        }
        $this->knowledge_base_model->updateRow($reply_id, 'kw_article_reply', $reply);
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/commentreplies/' . $comment_id);
    }

    public function addreply($comment_id) {

        $data['title'] = $this->lang->line('add_reply');
        $data['controller'] = "dashboard";
        $data['page'] = 'comments';

        $data['logged'] = 'yes';
        $data['page_type'] = 'add';
        $data['comment'] = $this->knowledge_base_model->getComment($comment_id);
        $this->load->view('site/knoweldge_base/reply_form', $data);
    }

    public function postaddreply() {


        $data['title'] = $this->lang->line('add_reply');
        $data['controller'] = "dashboard";

        $data['page'] = 'comments';
        $data['page_type'] = 'add';
        $comment_id = $this->input->post('comment_id');
        $data['comment'] = $this->knowledge_base_model->getComment($comment_id);
        $data['logged'] = 'yes';
        $this->load->library('form_validation');
        $this->form_validation->set_rules('reply', $this->lang->line('reply'), 'trim|required');

        if ($this->form_validation->run() === FALSE) {
            $this->load->view('site/knoweldge_base/reply_form', $data);
            //$this->loadView('تسجيل جديد','signup');
            //redirect('signup');
        } else {
            $reply = $this->input->post('reply');
            $u_name = $this->session->userdata('name');
            $u_email = $this->session->userdata('email');
            $u_id = $this->session->userdata('admin_id');
            $d = date("Y-m-d");
            $reply_arr = array(
                'article_id' => $data['comment'][0]->article_id,
                'comment_id' => $comment_id,
                'reply_text' => $reply,
                'r_date' => $d,
                'user_type' => 'logged',
                'user_id' => $u_id,
                'user_name' => $u_name,
                'user_email' => $u_email
            );

            $this->knowledge_base_model->insertRow('kw_article_reply', $reply_arr);
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/commentreplies/' . $comment_id);
        }
    }

    //delete
    public function deletereply($id, $comment_id) {

        $this->knowledge_base_model->deleteRow($id, 'kw_article_reply');
        $this->session->set_flashdata('success', $this->lang->line('op_success'));
        redirect('knowledge_base/commentreplies/' . $comment_id);
    }

    //update
    public function editreply($id, $comment_id) {

        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('reply');
        $data['controller'] = "settings";
        $data['page'] = "comments";

        $data['logged'] = 'yes';
        $data['page_type'] = 'edit';
        $data['comment'] = $this->knowledge_base_model->getComment($comment_id);
        $data['reply'] = $this->knowledge_base_model->getReply($id);
        $this->load->view('site/knoweldge_base/reply_form', $data);
    }

    public function updatereply() {

        $data['title'] = $this->lang->line('edit') . ' ' . $this->lang->line('reply');
        $data['controller'] = "settings";
        $data['page'] = "comments";

        $data['logged'] = 'yes';

        $comment_id = $this->input->post('comment_id');
        $reply_id = $this->input->post('reply_id');
        $data['reply'] = $this->knowledge_base_model->getReply($reply_id);
        $data['comment'] = $this->knowledge_base_model->getComment($comment_id);

        $this->load->library('form_validation');
        $this->form_validation->set_rules('reply', $this->lang->line('reply'), 'trim|required');

        if ($this->form_validation->run() === FALSE) {

            $this->load->view('site/knoweldge_base/reply_form', $data);
        } else {

            $reply = $this->input->post('reply');
            $u_name = $this->session->userdata('name');
            $u_email = $this->session->userdata('email');
            $u_id = $this->session->userdata('admin_id');
            $d = date("Y-m-d");
            $reply_arr = array(
                'article_id' => $data['comment'][0]->article_id,
                'comment_id' => $comment_id,
                'reply_text' => $reply,
                'r_date' => $d,
                'user_type' => 'logged',
                'user_id' => $u_id,
                'user_name' => $u_name,
                'user_email' => $u_email
            );
            $this->knowledge_base_model->updateRow($reply_id, 'kw_article_reply', $reply_arr);
            $this->session->set_flashdata('success', $this->lang->line('op_success'));
            redirect('knowledge_base/commentreplies/' . $comment_id);
        }
    }

    //end of Replies
}
