<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dalel extends CI_Controller {

    function __construct() {
        parent::__construct();
        if (!get_system_status()) {
            echo $this->load->view('site/system_off', '', TRUE);
            die();
        }
        if (!get_license_per('knowledge_base')) {
            redirect("", "refresh");
        }
        set_system_timezone();
        $this->load->model('booking');
//        $this->operator_id = $this->session->userdata('operator_id');
//        if (!get_ap('drivers_module', $this->operator_id)) {
//            redirect("", "refresh");
//        }


        $this->load->model('admin/knowledge_base_model');
    }

    public function index($dalel) {

        $data['dalel'] = $this->knowledge_base_model->getDalelbyName($dalel);
        //Dalel Privacy
        $privacy = $data['dalel'][0]->privacy_type;
        if ($privacy == 'عام') {
            $data['settings'] = $this->knowledge_base_model->getRows('setting');
            //if ($data['settings'][0]->open_site == 'نعم') {
            $data['homepage'] = $this->knowledge_base_model->getHomepage($data['dalel'][0]->id);
            if (isset($data['homepage']) && $data['homepage']) {
                $data['comments'] = $this->knowledge_base_model->getArticleComments($data['homepage'][0]->id);
            }
            if (!$this->session->has_userdata('is_admin_login')) {
                $data['logged'] = 'no';
            } else {
                $data['logged'] = 'yes';
                if (isset($data['homepage']) && $data['homepage']) {
                    $data['rate'] = $this->knowledge_base_model->getUserArticleRate($this->session->userdata('admin_id'), $data['homepage'][0]->id);
                }
            }

            $data['categories'] = $this->knowledge_base_model->getDalelCategories($data['dalel'][0]->id);
            $data['cont'] = $this;
            $data['header_title'] = 'الرئيسية';
            $data['dalel_name'] = $dalel;
            /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
              $result = $this->db->query($sql)->result();
              $data['cat_id'] = $result[0]->id; */


            $this->loadView('home', $data);
//            } else {
//                redirect('underconstruction');
//            }
        }//end of Public privacy
        else if ($privacy == 'مستخدمين') {
            $privacy_data = $data['dalel'][0]->privacy_data;
            $privacy_arr = json_decode($privacy_data, true);
            $users_arr = $privacy_arr['users'];
            if ($this->session->userdata('admin_id') && in_array($this->session->userdata('admin_id'), $users_arr)) {
                $data['settings'] = $this->knowledge_base_model->getRows('setting');
                $data['homepage'] = $this->knowledge_base_model->getHomepage($data['dalel'][0]->id);
                if (isset($data['homepage']) && $data['homepage']) {
                    $data['comments'] = $this->knowledge_base_model->getArticleComments($data['homepage'][0]->id);
                }
                if (!$this->session->has_userdata('is_admin_login')) {
                    $data['logged'] = 'no';
                } else {
                    $data['logged'] = 'yes';

                    if (isset($data['homepage']) && $data['homepage']) {
                        $data['rate'] = $this->knowledge_base_model->getUserArticleRate($this->session->userdata('admin_id'), $data['homepage'][0]->id);
                    }
                }

                $data['categories'] = $this->knowledge_base_model->getDalelCategories($data['dalel'][0]->id);
                $data['cont'] = $this;
                $data['header_title'] = 'الرئيسية';
                $data['dalel_name'] = $dalel;
                /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
                  $result = $this->db->query($sql)->result();
                  $data['cat_id'] = $result[0]->id; */


                $this->loadView('home', $data);
            }//end of Users privacy (check in_array)
            else {
                redirect("", "refresh");
            }
        }//end else if Users privacy
        //privacy of groups
        else if ($privacy == 'مجموعات') {
            $privacy_data = $data['dalel'][0]->privacy_data;
            $privacy_arr = json_decode($privacy_data, true);
            $groups_arr = $privacy_arr['groups'];
            $data['homepage'] = $this->knowledge_base_model->getHomepage($data['dalel'][0]->id);
            if (isset($data['homepage']) && $data['homepage']) {
                $data['comments'] = $this->knowledge_base_model->getArticleComments($data['homepage'][0]->id);
            }
            if (in_array($this->session->userdata('access_level_group'), $groups_arr)) {
                $data['settings'] = $this->knowledge_base_model->getRows('setting');
                if (!$this->session->has_userdata('is_admin_login')) {
                    $data['logged'] = 'no';
                } else {
                    $data['logged'] = 'yes';

                    if (isset($data['homepage']) && $data['homepage']) {
                        $data['rate'] = $this->knowledge_base_model->getUserArticleRate($this->session->userdata('admin_id'), $data['homepage'][0]->id);
                    }
                }

                $data['categories'] = $this->knowledge_base_model->getDalelCategories($data['dalel'][0]->id);
                $data['cont'] = $this;
                $data['header_title'] = 'الرئيسية';
                $data['dalel_name'] = $dalel;
                /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
                  $result = $this->db->query($sql)->result();
                  $data['cat_id'] = $result[0]->id; */

                $this->loadView('home', $data);
            }//end of Groups privacy (check in_array)
            else {
                redirect("", "refresh");
            }
        }//end else if Groups privacy
        //privacy of Password
        else if ($privacy == 'كلمة مرور') {
            $privacy_data = $data['dalel'][0]->privacy_data;
            $privacy_arr = json_decode($privacy_data, true);
            $password = $privacy_arr['password'];
            $saved_password = $this->session->userdata('dalel_' . $data['dalel'][0]->id);
            if (isset($saved_password) && $saved_password != null) {
                if ($password == $saved_password) {
                    $data['settings'] = $this->knowledge_base_model->getRows('setting');
                    $data['homepage'] = $this->knowledge_base_model->getHomepage($data['dalel'][0]->id);
                    if (isset($data['homepage']) && $data['homepage']) {
                        $data['comments'] = $this->knowledge_base_model->getArticleComments($data['homepage'][0]->id);
                    }
                    if (!$this->session->has_userdata('is_admin_login')) {
                        $data['logged'] = 'no';
                    } else {
                        $data['logged'] = 'yes';

                        if (isset($data['homepage']) && $data['homepage']) {
                            $data['rate'] = $this->knowledge_base_model->getUserArticleRate($this->session->userdata('admin_id'), $data['homepage'][0]->id);
                        }
                    }

                    $data['categories'] = $this->knowledge_base_model->getDalelCategories($data['dalel'][0]->id);
                    $data['cont'] = $this;
                    $data['header_title'] = 'الرئيسية';
                    $data['dalel_name'] = $dalel;
                    /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
                      $result = $this->db->query($sql)->result();
                      $data['cat_id'] = $result[0]->id; */

                    $this->loadView('home', $data);
                }//end of Password privacy (check Equals)
                else {
                    //redirect('home');
                    $_SESSION['auth_message'] = '<p>كلمة المرور خاطئة، يرجى إعادة المحاولة</p>';
                    $this->session->mark_as_flash('auth_message');
                    $data['password'] = $password;
                    $this->load->view('site/knoweldge_base/front/check_password', $data);
                }
            }//session check
            else {
                $data['password'] = $password;
                $this->load->view('site/knoweldge_base/front/check_password', $data);
            }
        }//end else if Password privacy
    }

    public function check_password() {
        $inserted_pass = MD5($this->input->post("password"));
        
        $pass = $this->input->post("password1");
        $dalel_id = $this->input->post("dalel_id");
        $dalel = $this->input->post("dalel");
        if ($inserted_pass == $pass) {
            $this->session->set_userdata('dalel_' . $dalel_id, $inserted_pass);
            redirect('dalel/index/' . $dalel);
            //redirect('dashboard');
        } else {
            //redirect('home');
            $this->session->set_flashdata('auth_message','<p>كلمة المرور خاطئة، يرجى إعادة المحاولة</p>');
            $data['password'] = $pass;
            $data['dalel'] = $this->knowledge_base_model->getDalelbyName($dalel);
            $this->load->view('site/knoweldge_base/front/check_password', $data);
        }
    }

    public function getReply($id) {
        $reply = $this->home_model->getCommentReply($id);
        return $reply;
    }

    public function delete($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';

                redirect('home');
            } else {
                $data['logged'] = 'yes';
                $this->home_model->deleteArticle($id);
                redirect('home');
            }
        } else {
            redirect('underconstruction');
        }
    }

    public function deleteComment($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';

                redirect('home');
            } else {
                $data['logged'] = 'yes';
                $this->home_model->deleteComment($id);
                redirect('home');
            }
        } else {
            redirect('underconstruction');
        }
    }

    public function deleteReply($id) {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';

                redirect('home');
            } else {
                $data['logged'] = 'yes';
                $this->home_model->deleteReply($id);
                redirect('home');
            }
        } else {
            redirect('underconstruction');
        }
    }

    function setArticleRate() {

        $data['settings'] = $this->knowledge_base_model->getRows('setting');
        if (!$this->session->has_userdata('is_admin_login')) {
            $data['logged'] = 'no';
            //save rate into session

            $article_id = $this->input->post("article_id");
            $rate = $this->input->post("rate");
            if ($rate == "Yes") {
                $r = "نعم";
                /* update */
                $this->db->where('id', $article_id);
                $this->db->set('yes_rate', 'yes_rate+1', FALSE);
                $this->db->update('kw_articles');
            } else if ($rate == "No") {
                $r = "لا";
                /* update */
                $this->db->where('id', $article_id);
                $this->db->set('no_rate', 'no_rate+1', FALSE);
                $this->db->update('kw_articles');
            }
            $article_rate = $this->session->userdata('article' . $article_id);
            //if(!isset($article_rate) || $article_rate == '') {
            $this->session->set_userdata('article' . $article_id, $r);
            //}
            $output = json_encode(array(//create JSON data
                'type' => 'msg',
                'text' => 'true'
            ));
            die($output);
        } else {
            $data['logged'] = 'yes';
            $user = $this->session->userdata('admin_id');
            $article_id = $this->input->post("article_id");
            $rate = $this->input->post("rate");
            if ($rate == "Yes") {
                $r = "نعم";
            } else if ($rate == "No") {
                $r = "لا";
            }
            $article_arr = array(
                'article_id' => $article_id,
                'user_id' => $user,
                'rate' => $r
            );
            $c = 'nothing';
            $this->db->where('user_id', $user);
            $this->db->where('article_id', $article_id);
            $check_rate = $this->db->get('kw_article_rate')->num_rows();
            if ($check_rate == 0) {
                $c = 'insert';
                $this->knowledge_base_model->insertRow('kw_article_rate', $article_arr);
                $rate_arr = $this->knowledge_base_model->getUserArticleRate($user, $article_id);
                $rate_id = $rate_arr[0]->id;
                $output = json_encode(array(//create JSON data
                    'type' => 'msg',
                    'text' => 'true'
                ));
                die($output);
            } else {
                $c = 'update';
                $rate_arr = $this->knowledge_base_model->getUserArticleRate($user, $article_id);
                $rate_id = $rate_arr[0]->id;
                $this->knowledge_base_model->updateUserArticleRate($rate_id, $article_arr);
                $output = json_encode(array(//create JSON data
                    'type' => 'msg',
                    'text' => 'true'
                ));
                die($output);
            }
        }
    }

    public function addReaderComment() {
        
        $data['settings'] = $this->knowledge_base_model->getRows('setting');
            $r_name = $this->input->post("r_name");
            $r_email = $this->input->post("r_email");
            $r_comment = $this->input->post("r_comment");
            $article_id = $this->input->post("article_id");
            //if ($data['settings'][0]->open_comments == 'نعم') {
                $comment_status = 'منشور';
            //} else {
            //    $comment_status = 'معلق';
            //}
            $d = date("Y-m-d");
            $comment = array(
                'article_id' => $article_id,
                'comment_text' => $r_comment,
                'c_date' => $d,
                'user_type' => 'nonlogged',
                'user_name' => $r_name,
                'user_email' => $r_email,
                'comment_status' => $comment_status
            );

            $comment_id = $this->knowledge_base_model->insertRow('kw_article_comments', $comment);
            $p = '<div id="comment_' . $comment_id . '" class="comment">
						
						<div class="di avatar-div">
							<img class="avatar di" src="' . base_url("assets/knowledge_base/img/users.png") . '">
						</div>
						<div class="di">
		
							<div class="media-body">
								<div class="comment_info">
									<h3>' . $r_name .
                    '&nbsp;&nbsp;<span class="date">' . $d . '</span>
									</h3>
								</div>
							</div>
							<p>' .
                    $r_comment
                    . '</p>
							
						</div>
					</div>';

            $output = json_encode(array(//create JSON data
                'text' => $p,
                'id' => $comment_id,
                'status' => $comment_status
            ));
            die($output);
        
    }

    public function addUserComment() {

        $data['settings'] = $this->knowledge_base_model->getRows('setting');
        $u_comment = $this->input->post("u_comment");
        $u_name = $this->session->userdata('name');
        $u_email = $this->session->userdata('email');
        $u_id = $this->session->userdata('admin_id');
        $article_id = $this->input->post("article_id");
//            if ($data['settings'][0]->open_comments == 'نعم') {
        $comment_status = 'منشور';
//            } else {
//                $comment_status = 'معلق';
//            }
        $d = date("Y-m-d");
        $comment = array(
            'article_id' => $article_id,
            'comment_text' => $u_comment,
            'c_date' => $d,
            'user_type' => 'logged',
            'user_id' => $u_id,
            'user_name' => $u_name,
            'user_email' => $u_email,
            'comment_status' => $comment_status
        );

        $comment_id = $this->knowledge_base_model->insertRow('kw_article_comments', $comment);
        $p = '<div id="comment_' . $comment_id . '" class="comment">
						
						<div class="di avatar-div">
							<img class="avatar di" src="' . base_url("assets/knowledge_base/img/users.png") . '">
						</div>
						<div class="di">
		
							<div class="media-body">
								<div class="comment_info">
									<h3>' . $u_name .
                '&nbsp;&nbsp;<span class="date">' . $d . '</span>
									</h3>
								</div>
							</div>
							<p>' .
                $u_comment
                . '</p>
							
						</div>
					</div>';

        $output = json_encode(array(//create JSON data
            'text' => $p,
            'id' => $comment_id,
            'status' => $comment_status
        ));
        die($output);
    }

    public function addReply() {

        $data['settings'] = $this->knowledge_base_model->getRows('setting');
        $reply = $this->input->post("reply");
        $comment_id = $this->input->post("comment_id");
        if (!$this->session->has_userdata('is_admin_login')) {
            $logged = 'nonlogged';
            $name = $this->input->post("reply_name");
            $email = $this->input->post("reply_email");
            $user_id = 0;
        } else {
            $logged = 'logged';
            $name = $this->session->userdata('name');
            $email = $this->session->userdata('email');
            $user_id = $this->session->userdata('admin_id');
        }
        $article_id = $this->input->post("article_id");
        $d = date("Y-m-d");
        //if ($data['settings'][0]->open_comments == 'نعم') {
        $comment_status = 'منشور';
        // } else {
        //    $comment_status = 'معلق';
        //}
        $reply_arr = array(
            'article_id' => $article_id,
            'comment_id' => $comment_id,
            'reply_text' => $reply,
            'r_date' => $d,
            'user_type' => $logged,
            'user_id' => $user_id,
            'user_name' => $name,
            'user_email' => $email,
            'reply_status' => $comment_status
        );

        $reply_id = $this->knowledge_base_model->insertRow('kw_article_reply', $reply_arr);
        $p = '<div id="replay_' . $comment_id . $reply_id . '" class="replay">
						   
								<div class="di avatar-div">
									<img class="avatar di" src="' . base_url('assets/knowledge_base/img/users.png') . '">
								</div>
								<div class="di">
	
									<div class="media-body">
										<div class="comment_info">
											<h3>' . $name .
                '&nbsp;&nbsp;<span class="date">' . $d . '</span>
											</h3>
										</div>
									</div>
									<p>' .
                $reply .
                '</p>
									
								</div>
							</div>';

        $output = json_encode(array(//create JSON data
            'text' => $p,
            'id' => $reply_id,
            'status' => $comment_status
        ));
        die($output);
    }

    public function search() {
        $sql33 = "SELECT site_timezone FROM settings";
        $result33 = $this->db->query($sql33)->result();
        date_default_timezone_set($result33[0]->site_timezone);
        $data['settings'] = $this->home_model->getRows('settings');
        if ($data['settings'][0]->open_site == 'نعم') {
            if ($this->ion_auth->logged_in() === FALSE) {
                $data['logged'] = 'no';
            } else {
                $data['logged'] = 'yes';
            }
            $data['categories'] = $this->home_model->getDalelCategories(0);
            $data['cont'] = $this;
            $data['header_title'] = 'الرئيسية';
            /* $sql = "SELECT id FROM categories WHERE name = 'بلا تصنيف'";
              $result = $this->db->query($sql)->result();
              $data['cat_id'] = $result[0]->id; */
            //$data['homepage'] = $this->home_model->getHomepage();

            $word = $this->input->post('word');
            $data['word'] = $word;
            $data['results'] = $this->home_model->search($word);
            $this->loadView('search_dalel', $data);
        } else {
            redirect('underconstruction');
        }
    }

    public function getArticles($cat_id) {
        $articles = $this->knowledge_base_model->getArticles($cat_id);
        return $articles;
    }

    public function loadView($view, $data = array()) {
        $this->load->view('site/knoweldge_base/shared/header', $data);
        $this->load->view('site/knoweldge_base/shared/main_banner', $data);
        $this->load->view('site/knoweldge_base/shared/sidemenu');
        $this->load->view('site/knoweldge_base/front/' . $view);
        $this->load->view('site/knoweldge_base/shared/footer');
    }

}
